mod Mclsyntax

rem 
  \para \bf  Bounded formulas.  \end 

rem 
  \para \bf  [CL] Syntax.  \end Examples: 
  \items 
   \item \para atomic formulas: \ft x = y \end, \ft x < y \end, \ft x <= y \end, 
         \ft x > y \end, \ft x >= y \end, and \ft R(x) \end, 
   \item \para propositional connectives: \ft \t \end, \ft \f \end, \ft ~R \end, 
         \ft R & Q \end, \ft R \/ Q \end, \ft R -> Q \end, and \ft R <-> Q \end, 
   \item \para bounded quantification: \ft \eb y y <= x: R \end, 
         \ft \eb y y < x: R \end, \ft \ab y y <= x: R \end, and 
         \ft \ab y y < x: R \end. 
  \end
  \para \it  Remark.  \end Notation for inequalities: \ft x != y \end. 

rem 
  \para \bf  Explicit definitions of predicates with bounded formulas.  \end 

rem 
  \para \bf  [CL] Syntax.  \end \header* pred/2 Q  \end Examples: 
  \def 
    pred R 
    R(x) <-> \eb y y <= x: Q(x,y)
  \end
  \def 
    pred R 
    R(x) <-> \eb y y < x: Q(x,y)
  \end
  \def 
    pred R 
    R(x) <-> 
      \ab y y <= x: Q(x,y)
  \end
  \def 
    pred R 
    R(x) <-> 
      \ab y y < x: Q(x,y)
  \end

rem 
  \para \bf  Definitions of functions with bounded minimalization.  \end 

rem 
  \para \bf  [CL] Syntax.  \end \header* pred/2 Q  \end Examples: 
  \def 
    fun F 
    F(x) = \m y <= x [ Q(x,y) ]
  \end
  \def 
    fun F 
    F(x) = \m y < x [ Q(x,y) ]
  \end

rem 
  \para \bf  Definitions of functions with regular minimalization.  \end 

rem 
  \para \bf  [CL] Syntax.  \end \header* pred/2 Q  \end Examples: 
  \def 
    fun F 
    F(x) = \m y [ Q(x,y) ]
  \end

