mod Mterm logic: 'cl'

incl Mtex

incl Mtexgr

incl Maux

rem 
  \para \bf  Arithmetization of recursive terms.  \end 

fun Vt 'Tex_f1_gr_vt'
  Vt(i) = 0,i

fun/0 Zt 'Tex_f0_gr_zt'
  Zt = 1,0

fun St 'Tex_f1_gr_st'
  St(t) = 2,t

fun Pt 'Tex_f1_gr_pt'
  Pt(t) = 3,t

fun/3 Dt 'Tex_f3_gr_dt'
  Dt(t1,t2,t3) = 4,t1,t2,t3

fun/2 Act 'Tex_f2_gr_act'
  Act(t1,t2) = 5,t1,t2

fun/2 Apt 'Tex_f2_gr_apt'
  Apt(e,ts) = 6,e,ts

rem 
  \para \bf  Arithmetization of recursive function symbols.  \end 

fun Fs 'Tex_f2_gr_fs'
  Fs(n) = 0,n

fun/2 Ls 'Tex_f2_gr_ls'
  Ls(n,t) = 1,n,t

rem 
  \para \bf  Codes of numerals.  \end 

pred Nm 
  Nm(Zt)
  Nm St(t) <- Nm(t)

pred Nms 
  Nms(0)
  Nms(t,ts) <- Nm(t) & Nms(ts)

rem 
  \para \bf  Contraction function.  \end 

pred Is_apt 
  Is_apt Apt(e,ts)

rem 
  \para Note that the auxiliary predicate \ft Is_apt(t) \end has the following 
  basic property: 
  \eq* 
    Is_apt(t) <-> \e e\e ts t = Apt(e,ts)
  \end

fun/2 Cntr 'Tex_f2_gr_cntr'
  Cntr(t1,t2) = Apt(e,ts++(t2,0)) <- Is_apt(t1) & Nm(t2) & t1 = Apt(e,ts)
  Cntr(t1,t2) = Act(t1,t2) <- Is_apt(t1) & ~Nm(t2)
  Cntr(t1,t2) = Act(t1,t2) <- ~Is_apt(t1)

rem 
  \para \bf  Well-formed recursive indices.  \end 
  \header* pred/2 Cdf 'Tex_p2_gr_cdf' \end The predicate \ft Cdf(n,e) \end holds 
  if the number \ft e \end is a well-formed recursive index of arity 
  \ft n >= 1 \end, ie it is the code of some \ft n \end-ary defined recursive 
  function symbol. 

pred/3 Tm 
  Tm(n,Vt(i),0) <- 1 <= i & i <= n
  Tm(n,Zt,0)
  Tm(n,St(t),0) <- Tm(n,t,0)
  Tm(n,Pt(t),0) <- Tm(n,t,0)
  Tm(n,Dt(t1,t2,t3),0) <- Tm(n,t1,0) & Tm(n,t2,0) & Tm(n,t3,0)
  Tm(n,Act(t1,t2),rs) <- Tm(n,t1,t2,rs) & Tm(n,t2,0) & Is_apt(t1) & ~Nm(t2)
  Tm(n,Act(t1,t2),rs) <- Tm(n,t1,t2,rs) & Tm(n,t2,0) & ~Is_apt(t1)
  Tm(n,Apt(Fs(m),ts),rs) <- m = n & Nms(ts) & L(ts)+L(rs) = m
  Tm(n,Apt(Ls(m,t),ts),rs) <- m >= 1 & Nms(ts) & L(ts)+L(rs) = m & Tm(m,t,0)

pred/2 Cdf 'Tex_p2_gr_cdf'
  Cdf(n,Ls(n1,t)) <- n >= 1 & n1 = n & Tm(n,t,0)

rem 
  \para \bf  Closed recursive terms.  \end The predicate \ft Ctm(t) \end holds 
  if the number \ft t \end is the code of a closed recursive term. 

pred Ctm 
  Ctm(t) <-> Tm(0,t,0)

rem 
  \para \bf  [CL] Formats.  \end The predicate \ft Ftm \end is the union format 
  and it can be used to control the display of the codes of recursive terms and 
  of recursive function symbols in queries. 

pred Ff4 
  Ff4 Fs(n) <- N(n)
  Ff4 Ls(n,t) <- N(n) & M(t)

pred Ftm4 
  Ftm4 Vt(i) <- N(i)
  Ftm4(Zt)
  Ftm4 St(t) <- Ftm4(t)
  Ftm4 Pt(t) <- Ftm4(t)
  Ftm4 Dt(t1,t2,t3) <- Ftm4(t1) & Ftm4(t2) & Ftm4(t3)
  Ftm4 Act(t1,t2) <- Ftm4(t1) & Ftm4(t2)
  Ftm4 Apt(e,ts) <- Ff4(e) & Nms(ts)

pred Ff3 
  Ff3 Fs(n) <- N(n)
  Ff3 Ls(n,t) <- N(n) & Ftm4(t)

pred Ftm3 
  Ftm3 Vt(i) <- N(i)
  Ftm3(Zt)
  Ftm3 St(t) <- Ftm3(t)
  Ftm3 Pt(t) <- Ftm3(t)
  Ftm3 Dt(t1,t2,t3) <- Ftm3(t1) & Ftm3(t2) & Ftm3(t3)
  Ftm3 Act(t1,t2) <- Ftm3(t1) & Ftm3(t2)
  Ftm3 Apt(e,ts) <- Ff3(e) & Nms(ts)

pred Ff2 
  Ff2 Fs(n) <- N(n)
  Ff2 Ls(n,t) <- N(n) & Ftm3(t)

pred Ftm2 
  Ftm2 Vt(i) <- N(i)
  Ftm2(Zt)
  Ftm2 St(t) <- Ftm2(t)
  Ftm2 Pt(t) <- Ftm2(t)
  Ftm2 Dt(t1,t2,t3) <- Ftm2(t1) & Ftm2(t2) & Ftm2(t3)
  Ftm2 Act(t1,t2) <- Ftm2(t1) & Ftm2(t2)
  Ftm2 Apt(e,ts) <- Ff2(e) & Nms(ts)

pred Ff1 
  Ff1 Fs(n) <- N(n)
  Ff1 Ls(n,t) <- N(n) & Ftm2(t)

pred Ftm1 
  Ftm1 Vt(i) <- N(i)
  Ftm1(Zt)
  Ftm1 St(t) <- Ftm1(t)
  Ftm1 Pt(t) <- Ftm1(t)
  Ftm1 Dt(t1,t2,t3) <- Ftm1(t1) & Ftm1(t2) & Ftm1(t3)
  Ftm1 Act(t1,t2) <- Ftm1(t1) & Ftm1(t2)
  Ftm1 Apt(e,ts) <- Ff1(e) & Nms(ts)

pred Ff 
  Ff Fs(n) <- N(n)
  Ff Ls(n,t) <- N(n) & Ftm1(t)

pred Ftm 
  Ftm Vt(i) <- N(i)
  Ftm(Zt)
  Ftm St(t) <- Ftm(t)
  Ftm Pt(t) <- Ftm(t)
  Ftm Dt(t1,t2,t3) <- Ftm(t1) & Ftm(t2) & Ftm(t3)
  Ftm Act(t1,t2) <- Ftm(t1) & Ftm(t2)
  Ftm Apt(e,ts) <- Ff(e) & Nms(ts)

