mod Mxprt

incl Mtex

incl Mtexrc

incl Mtexxpr

incl Mxprf

rem 
  \para \bf  Primitive Recursive Terms.  \end 

rem 
  \para \bf  Arithmetization of primitive recursive terms.  \end 

fun Vt 'Tex_f1_xpr_vt'
  Vt(i) = 0,i

fun Ct 'Tex_f1_xpr_ct'
  Ct(m) = 1,m

fun/2 Pt 'Tex_f2_xpr_pt'
  Pt(t,ts) = 2,t,ts

fun/2 At 'Tex_f2_xpr_at'
  At(f,ts) = 3,f,ts

rem 
  \para \bf  Codes of primitive recursive terms.  \end \header* pred/2 Prt  \end 
  The predicate \ft Prt(n,t) \end holds if the number \ft t \end is the code of 
  some primitive recursive term containing only the variables 
  \ft x1,Tex0_dotsc,Tex2_sub(x,n) \end. 

pred/3 Prt1 
  Prt1(n,Vt(i),k) <- k = 1 & 1 <= i & i <= n
  Prt1(n,Ct(m),k) <- k = 1
  Prt1(n,Pt(t,ts),k) <- k > 1 & Prt1(n,t,1) & Prt1(n,ts,k-1)
  Prt1(n,At(f,ts),k) <- k = 1 & Prf(Ar(f),f) & Prt1(n,ts,Ar(f))

pred/2 Prt 
  Prt(n,t) <-> Prt1(n,t,1)

rem 
  \para \bf  [CL] Display of the codes of primitive recursive terms.  \end The 
  unary predicate \ft Ft \end is the union format and it can be used to control 
  the display of the codes of primitive recursive terms. 

pred Ft 
  Ft Vt(i) <- N(i)
  Ft Ct(m) <- M(m)
  Ft Pt(t,ts) <- Ft(t) & Ft(ts)
  Ft At(f,ts) <- Ff(f) & Ft(ts)

