mod Mxprf

incl Mtex

incl Mtexrc

incl Mtexxpr

incl Maux

rem 
  \para \bf  Primitive Recursive Indices.  \end 

rem 
  \para \bf  Arithmetization of primitive recursive function symbols.  \end 

fun/0 Zx 'Tex_f0_xpr_zx'
  Zx = 0,0

fun/0 Sx 'Tex_f0_xpr_sx'
  Sx = 1,0

fun/2 Ix 'Tex_f2_xpr_ix'
  Ix(n,i) = 2,n,i

fun/2 Px 'Tex_f2_xpr_px'
  Px(g,gs) = 3,g,gs

fun/4 Cx 'Tex_f4_xpr_cx'
  Cx(n,m,h,gs) = 4,n,m,h,gs

fun/3 Rx 'Tex_f3_xpr_rx'
  Rx(n,g,h) = 5,n,g,h

rem 
  \para \bf  Arity of primitive recursive function symbols.  \end 

fun Ar 
  Ar(Zx) = 1
  Ar(Sx) = 1
  Ar Ix(n,i) = n
  Ar Cx(n,m,h,gs) = n
  Ar Rx(n,g,h) = n

rem 
  \para \bf  Well-formed primitive recursive indices.  \end 
  \header* pred/2 Prf  \end The binary predicate \ft Prf(n,e) \end holds if the 
  number \ft e \end is the code of some \ft n \end-ary primitive recursive 
  function symbol. We say that the number \ft e \end is a \it  well-formed 
  primitive recursive index  \end. 

pred/3 Prf1 
  Prf1(n,Zx,k) <- n = 1 & k = 1
  Prf1(n,Sx,k) <- n = 1 & k = 1
  Prf1(n,Ix(n1,i),k) <- n >= 1 & k = 1 & n1 = n & 1 <= i & i <= n
  Prf1(n,Px(g,gs),k) <- k > 1 & Prf1(n,g,1) & Prf1(n,gs,k-1)
  Prf1(n,Cx(n1,m,h,gs),k) <- 
    n >= 1 & k = 1 & n1 = n & m >= 1 & Prf1(m,h,1) & Prf1(n,gs,m)
  Prf1(n,Rx(n1,g,h),k) <- 
    n >= 2 & k = 1 & n1 = n & Prf1(n-1,g,1) & Prf1(n+1,h,1)

pred/2 Prf 
  Prf(n,e) <-> Prf1(n,e,1)

rem 
  \para \bf  [CL] Display of well-formed primitive recursive indices.  \end The 
  unary predicate \ft Ff \end is the union format and it can be used to control 
  the display of well-formed primitive recursive indices. 

pred Ff 
  Ff(Zx)
  Ff(Sx)
  Ff Ix(n,i) <- N(n) & N(i)
  Ff Px(g,gs) <- Ff(g) & Ff(gs)
  Ff Cx(n,m,h,gs) <- N(n) & N(m) & Ff(h) & Ff(gs)
  Ff Rx(n,g,h) <- N(n) & Ff(g) & Ff(h)

rem 
  \para \bf  Interpreter of primitive recursive function symbols.  \end 

fun/2 Interpreter 'Tex_f2_xpr_interpreter'
  Interpreter(Zx,x) = 0
  Interpreter(Sx,x) = x+1
  Interpreter(Ix(n,i),x) = Proj(n,x,i)
  Interpreter(Px(g,gs),x) = Interpreter(g,x),Interpreter(gs,x)
  Interpreter(Cx(n,m,h,gs),x) = Interpreter(h,Interpreter(gs,x))
  Interpreter(Rx(n,g,h),0,y) = Interpreter(g,y)
  Interpreter(Rx(n,g,h),x+1,y) = Interpreter(h,x,Interpreter(Rx(n,g,h),x,y),y)

