mod Maux

incl Mtex

incl Mtexrc

rem 
  \para \bf  Case discrimination function.  \end 

fun/3 D1 'Tex_f3_rec_d1'
  D1(0,y,z) = z
  D1(x+1,y,z) = y

rem 
  \para \it  [CL] Remark.  \end Note that the above function with the prefix 
  name \it  D1  \end is different from from the `function' \it  D  \end defined 
  in the module \it  Standard  \end. The pre-defined function plays the role of 
  if-then-else construct. 

rem 
  \para \bf  Characteristic functions.  \end 

fun/2 Eqf 'Tex_f2_char_eqf'
  Eqf(x,y) = 1 <- x = y
  Eqf(x,y) = 0 <- x != y

fun/2 Nef 'Tex_f2_char_nef'
  Nef(x,y) = 1 <- x != y
  Nef(x,y) = 0 <- x = y

fun/2 Lef 'Tex_f2_char_lef'
  Lef(x,y) = 1 <- x <= y
  Lef(x,y) = 0 <- x > y

fun/2 Ltf 'Tex_f2_char_ltf'
  Ltf(x,y) = 1 <- x < y
  Ltf(x,y) = 0 <- x >= y

fun/2 Gef 'Tex_f2_char_gef'
  Gef(x,y) = 1 <- x >= y
  Gef(x,y) = 0 <- x < y

fun/2 Gtf 'Tex_f2_char_gtf'
  Gtf(x,y) = 1 <- x > y
  Gtf(x,y) = 0 <- x <= y

rem 
  \para \bf  Boolean functions.  \end 

fun Notf 'Tex_f1_bool_notf'
  Notf(x) = D1(x,0,1)

fun/2 Andf 'Tex_f2_bool_andf'
  Andf(x,y) = D1(x,D1(y,1,0),0)

fun/2 Orf 'Tex_f2_bool_orf'
  Orf(x,y) = Notf Andf(Notf(x),Notf(y))

fun/2 Impf 'Tex_f2_bool_impf'
  Impf(x,y) = Orf(Notf(x),y)

fun/2 Ifff 'Tex_f2_bool_ifff'
  Ifff(x,y) = Andf(Impf(x,y),Impf(y,x))

