mod Mauxb

incl Mtex

incl Mtexrc

incl Mauxa

rem 
  \para \bf  Auxiliary Functions and Predicates.  \end 

rem 
  \para \bf  Dyadic arithmetic.  \end 

rem 
  \para \it  Dyadic size.  \end 

fun Dsz 'Tex_f1_n2_sz'
  Dsz(0) = 0
  Dsz S1(x) = Dsz(x)+1
  Dsz S2(x) = Dsz(x)+1

rem 
  \para \it  Dyadic concatenation.  \end 

fun/2 Dconc 'Tex_f2_n2_conc'
  Dconc(x,0) = x
  Dconc(x,S1(y)) = S1 Dconc(x,y)
  Dconc(x,S2(y)) = S2 Dconc(x,y)

rem 
  \para \it  Dyadic reversal.  \end 

fun Drev 'Tex_f1_n2_rev'
  Drev(0) = 0
  Drev S1(x) = Dconc(1,Drev(x))
  Drev S2(x) = Dconc(2,Drev(x))

rem 
  \para \bf  Binary Trees.  \end 

rem 
  \para \it  Binary trees.  \end 

pred Bt 
  Bt(0)
  Bt(x,l,r) <- Bt(l) & Bt(r)

rem 
  \para \it  Size.  \end 

fun Sz 'Tex_f1_rec_nsr_bt_sz'
  Sz(0) = 0
  Sz(x,l,r) = Sz(l)+Sz(r)+1

rem 
  \para \it  Depth.  \end 

fun Dp 'Tex_f1_rec_nsr_bt_dp'
  Dp(0) = 0
  Dp(x,l,r) = Max(Dp(l),Dp(r))+1

rem 
  \para \bf  Full binary trees.  \end 

rem 
  \para \it  Full binary trees.  \end 

pred Full 
  Full(t) <-> Bt(t) & Sz(t)+1 = Exp(2,Dp(t))

rem 
  \para \it  New full binary tree.  \end 

fun New 
  New(0) = 0
  New(n+1) = 0,New(n),New(n)

rem 
  \para \bf  Postorder traversal of binary trees.  \end 

rem 
  \para \it  Tree indexing.  \end 

fun/2 Plookup 'Tex_f2_rec_nsr_bt_postorder_lookup'
  Plookup((x,l,r),i) = Plookup(l,i) <- i < Sz(l)
  Plookup((x,l,r),i) = Plookup(r,i-Sz(l)) <- i >= Sz(l) & i < Sz(l)+Sz(r)
  Plookup((x,l,r),i) = x <- i >= Sz(l) & i >= Sz(l)+Sz(r)

rem 
  \para \it  Tree modification.  \end 

fun/3 Pupdate 'Tex_f3_rec_nsr_bt_postorder_update'
  Pupdate((y,l,r),i,x) = y,Pupdate(l,i,x),r <- i < Sz(l)
  Pupdate((y,l,r),i,x) = y,l,Pupdate(r,i-Sz(l),x) <- 
    i >= Sz(l) & i < Sz(l)+Sz(r)
  Pupdate((y,l,r),i,x) = x,l,r <- i >= Sz(l) & i >= Sz(l)+Sz(r)

rem 
  \para \bf  Dyadic traversal of binary trees.  \end 

rem 
  \para \it  Tree indexing.  \end 

fun/2 Dlookup 'Tex_f2_rec_nsr_bt_dyadic_lookup'
  Dlookup((x,l,r),0) = x
  Dlookup((x,l,r),S1(i)) = Dlookup(l,i)
  Dlookup((x,l,r),S2(i)) = Dlookup(r,i)

