mod Mauxa

incl Mtex

incl Mtexrc

rem 
  \para \bf  Minimum and maximum.  \end 

fun/2 Min 'Tex_f2_n_min'
  Min(x,y) = x <- x <= y
  Min(x,y) = y <- x > y

fun/2 Max 'Tex_f2_n_max'
  Max(x,y) = x <- x >= y
  Max(x,y) = y <- x < y

rem 
  \para \bf  Exponentiation.  \end 

fun/2 Exp 'Tex_f2_n_exp'
  Exp(x,0) = 1
  Exp(x,y+1) = x*Exp(x,y)

rem 
  \para \bf  Case discrimination function.  \end 

fun/3 D1 'Tex_f3_rec_d1'
  D1(0,y,z) = z
  D1(x+1,y,z) = y

rem 
  \para \it  [CL] Remark.  \end Note that the above function with the prefix 
  name \it  D1  \end is different from from the `function' \it  D  \end defined 
  in the module \it  Standard  \end. The pre-defined function plays the role of 
  if-then-else construct. 

rem 
  \para \bf  Characteristic functions.  \end 

fun/2 Eqf 'Tex_f2_char_eqf'
  Eqf(x,y) = 1 <- x = y
  Eqf(x,y) = 0 <- x != y

fun/2 Nef 'Tex_f2_char_nef'
  Nef(x,y) = 1 <- x != y
  Nef(x,y) = 0 <- x = y

fun/2 Lef 'Tex_f2_char_lef'
  Lef(x,y) = 1 <- x <= y
  Lef(x,y) = 0 <- x > y

fun/2 Ltf 'Tex_f2_char_ltf'
  Ltf(x,y) = 1 <- x < y
  Ltf(x,y) = 0 <- x >= y

fun/2 Gef 'Tex_f2_char_gef'
  Gef(x,y) = 1 <- x >= y
  Gef(x,y) = 0 <- x < y

fun/2 Gtf 'Tex_f2_char_gtf'
  Gtf(x,y) = 1 <- x > y
  Gtf(x,y) = 0 <- x <= y

rem 
  \para \bf  Boolean functions.  \end 

fun Notf 'Tex_f1_bool_notf'
  Notf(x) = D1(x,0,1)

fun/2 Andf 'Tex_f2_bool_andf'
  Andf(x,y) = D1(x,D1(y,1,0),0)

fun/2 Orf 'Tex_f2_bool_orf'
  Orf(x,y) = Notf Andf(Notf(x),Notf(y))

fun/2 Impf 'Tex_f2_bool_impf'
  Impf(x,y) = Orf(Notf(x),y)

fun/2 Ifff 'Tex_f2_bool_ifff'
  Ifff(x,y) = Andf(Impf(x,y),Impf(y,x))

rem 
  \para \bf  Catalan pairing function.  \end 

rem 
  \para \it  Projection functions.  \end 

fun Proj1 'Tex_f1_pp_proj1'
  Proj1(0) = 0
  Proj1(v,w) = v

fun Proj2 'Tex_f1_pp_proj2'
  Proj2(0) = 0
  Proj2(v,w) = w

rem 
  \para \it  Unary iteration of the second projection.  \end 

fun/2 Iproj2 'Tex_f2_pp_iproj2'
  Iproj2(0,x) = x
  Iproj2(n+1,x) = Iproj2(n,Proj2(x))

rem 
  \para \bf  N-tuples.  \end 

pred/2 Tuple 
  Tuple(n,x) <-> n = 0 & x = 0 \/ n = 1 \/ n >= 2 & Iproj2(n-2,x) != 0

fun/3 Proj 'Tex_f3_pp_proj'
  Proj(n,x,i) = Proj1 Iproj2(i-1,x) <- i < n
  Proj(n,x,i) = Iproj2(n-1,x) <- i >= n

appldisp/2 Tex_f2_tm_pp_tuplef
  Prefix(100,2,Subsup(Id(0,'Tuple',0),75,Op('*',0),None),
         Fenced(Op('(',0),Infix(Arg(0),30,2,Op(',',0),Arg(1)),Op(')',0)))

fun/2 Tuplef 'Tex_f2_tm_pp_tuplef'
  Tuplef(n,x) = 1 <- Tuple(n,x)
  Tuplef(n,x) = 0 <- ~Tuple(n,x)

rem 
  \para \bf  Finite sequences.  \end 

rem 
  \para \it  Length of sequences.  \end 

fun L 
  L(0) = 0
  L(v,w) = L(w)+1

rem 
  \para \it  Indexing function.  \end 

fun/2 Sub 'Tex_f2_ln_sub'
  Sub((v,w),0) = v
  Sub((v,w),i+1) = Sub(w,i)

