mod Maux

incl Mtex

incl Mtexrc

rem 
  \para \bf  Exponentiation.  \end 

fun/2 Exp 'Tex_f2_n_exp'
  Exp(x,0) = 1
  Exp(x,y+1) = x*Exp(x,y)

rem 
  \para \bf  Case discrimination function.  \end 

fun/3 D1 'Tex_f3_rec_d1'
  D1(0,y,z) = z
  D1(x+1,y,z) = y

rem 
  \para \it  [CL] Remark.  \end Note that the above function with the prefix 
  name \it  D1  \end is different from from the `function' \it  D  \end defined 
  in the module \it  Standard  \end. The pre-defined function plays the role of 
  if-then-else construct. 

rem 
  \para \bf  Characteristic functions.  \end 

fun/2 Eqf 'Tex_f2_char_eqf'
  Eqf(x,y) = 1 <- x = y
  Eqf(x,y) = 0 <- x != y

fun/2 Nef 'Tex_f2_char_nef'
  Nef(x,y) = 1 <- x != y
  Nef(x,y) = 0 <- x = y

fun/2 Lef 'Tex_f2_char_lef'
  Lef(x,y) = 1 <- x <= y
  Lef(x,y) = 0 <- x > y

fun/2 Ltf 'Tex_f2_char_ltf'
  Ltf(x,y) = 1 <- x < y
  Ltf(x,y) = 0 <- x >= y

fun/2 Gef 'Tex_f2_char_gef'
  Gef(x,y) = 1 <- x >= y
  Gef(x,y) = 0 <- x < y

fun/2 Gtf 'Tex_f2_char_gtf'
  Gtf(x,y) = 1 <- x > y
  Gtf(x,y) = 0 <- x <= y

rem 
  \para \bf  Catalan pairing function.  \end 

rem 
  \para \it  Projection functions.  \end 

fun Proj1 'Tex_f1_pp_proj1'
  Proj1(0) = 0
  Proj1(v,w) = v

fun Proj2 'Tex_f1_pp_proj2'
  Proj2(0) = 0
  Proj2(v,w) = w

rem 
  \para \it  Unary iteration of the second projection.  \end 

fun/2 Iproj2 'Tex_f2_pp_iproj2'
  Iproj2(0,x) = x
  Iproj2(n+1,x) = Iproj2(n,Proj2(x))

rem 
  \para \bf  N-tuples.  \end 

pred/2 Tuple 
  Tuple(n,x) <-> n = 0 & x = 0 \/ n = 1 \/ n >= 2 & Iproj2(n-2,x) != 0

fun/3 Proj 'Tex_f3_pp_proj'
  Proj(n,x,i) = Proj1 Iproj2(i-1,x) <- i < n
  Proj(n,x,i) = Iproj2(n-1,x) <- i >= n

rem 
  \para \bf  Finite sequences.  \end 

rem 
  \para \it  Length of sequences.  \end 

fun L 
  L(0) = 0
  L(v,w) = L(w)+1

rem 
  \para \it  Indexing function.  \end 

fun/2 Sub 'Tex_f2_ln_sub'
  Sub((v,w),0) = v
  Sub((v,w),i+1) = Sub(w,i)

