mod Ex10


loc rem 
  \para \bf  10. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2014/2015  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex10.zip 

rem 
  \para* \it  Dátum:  \end 6. 5. 2015 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.21  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované postfixovému 
  stroju a kompilácii aritmetických výrazov. 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2014/2015. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2015.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 


incl Maux10

incl Mtesting10

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  17. POSTFIXOVÝ STROJ A KOMPILÁCIA  \end 

rem 
  \para \bf  17.1. Postfixový stroj  \end 
  \para* \bf  17.3. Podmienené výrazy  \end 

rem 
  \para Na prednáške sme opísali postfixový stroj, ktorý vykonáva program 
  (postupnosť inštrukcií) modifikáciou zásobníka čísel. 

rem 
  \para \bf  \it  Inštrukcie postfixového stroja.  \end  \end Nasledujúce 
  konštruktory kódujú inštrukcie postfixového stroja. Predikát 
  \ft Instr \end platí pre kódy inštrukcií. 
  \para* Všimnite si skutočné mená konštruktorov ( \ft Pushi \end, 
  \ft Loadi \end, \ft Addi \end, \ft Muli \end, \ft Subi \end, \ft Jzi \end). 

fun Pushi 'Tex1_ci'
  Pushi(n) = 0,n

fun Loadi 'Tex1_vi'
  Loadi(i) = 1,i

fun/0 Addi 'Tex0_ai'
  Addi = 2,0

fun/0 Muli 'Tex0_mi'
  Muli = 3,0

fun/0 Subi 'Tex0_si'
  Subi = 4,0

fun Jzi 'Tex0_jzi'
  Jzi(n) = 5,n

pred Instr 
  Instr Pushi(n) <- N(n)
  Instr Loadi(i) <- N(i)
  Instr(Addi)
  Instr(Muli)
  Instr(Subi)
  Instr Jzi(n) <- N(n)

rem 
  \para \bf  \it  Programy postfixového stroja.  \end  \end Program 
  postfixového stroja je postupnosť inštrukcií. 

rem 
  \para \bf  Úloha.  \end Zadefinujte predikát \ft Program(is) \end, ktorý 
  platí, ak \ft is \end je kódom programu, teda zoznamom kódov inštrukcií. 

pred Program 
  Program(is) <- Quux

rem 
  \para \bf  \it  Zásobník postfixového stroja.  \end  \end Postfixový stroj 
  má zásobník čísel, ktorý sa mení počas behu programu. Inštrukcie 
  pridávajú čísla na vrch zásobníka, alebo čísla z vrchu zásobníka 
  odoberajú. 
  \para Zásobník zakódujeme zoznamom prirodzených čísel, pričom hodnota 
  na vrchu zásobníka je prvým prvkom zoznamu. 

rem 
  \para \bf  \it  Beh postfixového stroja.  \end  \end Postfixový stroj 
  postupne vykonáva inštrukcie v programe. Inštrukcie menia zásobník 
  nasledovným spôsobom (viď tiež ilustráciu v prednáškach [1, §17.1, 
  str. 119 a §17.3, str. 127]): 
  \items 
   \item \para \ft Pushi(n) \end pridá číslo \ft n \end na vrch zásobníka. 
   \item \para \ft Loadi(i) \end pridá na vrch zásobníka kópiu čísla, 
         ktoré sa nachádza v zásobníku na \ft i \end-tom mieste 
         (počítajúc od 0). 
   \item \para \ft Addi \end odoberie zo zásobníka vrchnú hodnotu \ft a \end 
         a hodnotu pod ňou \ft b \end a namiesto nich pridá na vrch 
         zásobníka hodnotu \ft b+a \end. 
   \item \para \ft Muli \end odoberie zo zásobníka vrchnú hodnotu \ft a \end 
         a hodnotu pod ňou \ft b \end a namiesto nich pridá na vrch 
         zásobníka hodnotu \ft b*a \end. 
   \item \para \ft Subi \end odoberie zo zásobníka vrchnú hodnotu \ft a \end 
         a hodnotu pod ňou \ft b \end a namiesto nich pridá na vrch 
         zásobníka hodnotu \ft b-a \end ( \bf  \it  pozor na poradie 
         argumentov  \end  \end). 
   \item \para \ft Jzi(n) \end odoberie zo zásobníka vrchnú hodnotu 
         \ft a \end. Ak \ft a = 0 \end, stroj preskočí nasledujúcich 
         \ft n \end inštrukcií programu a pokračuje vykonávaním 
         \ft Paren(n+1) \end-ej inštrukcie. Ak \ft a != 0 \end, stroj 
         pokračuje vykonávaním nasledujúcej inštrukcie. 
  \end

rem 
  \para \bf  Úloha.  \end Odkrokujte na papieri beh nasledujúcich dvoch 
  programov, ak začiatočný stav zásobníka je \ft 3,5,7,0 \end. 

fun/0 Prog1 
  Prog1 = Pushi(4),Pushi(6),Addi,Loadi(3),Muli,0

fun/0 Prog2 
  Prog2 = 
  Loadi(0),Loadi(1),Muli,Pushi(2),Loadi(2),Loadi(4),Muli,Muli,Addi,Loadi(3),
  Loadi(4),Muli,Addi,0

rem 
  \para \bf  Úloha.  \end Zjednodušte program \ft Prog1 \end na 
  3 inštrukcie, teda napíšte program \ft Prog11 \end, ktorý vypočíta na 
  vrch zásobníka rovnaký výsledok ako \ft Prog1 \end, ale 
  \ft L(Prog11) = 3 \end. 

fun/0 Prog11 
  Prog11 = Foo

rem 
  \para \bf  Úloha.  \end Napíšte program \ft Prog3 \end pre postfixový 
  stroj, ktorý zmení zásobník zo stavu \ft n,vs \end do stavu 
  \ft n*(n+1),n,vs \end. 

fun/0 Prog3 
  Prog3 = Foo

rem 
  \para \bf  Úloha.  \end Odkrokujte na papieri beh nasledujúceho programu 
  \ft Dprog1 \end, pre tri začiatočné stavy zásobníka: 
  \ft vs1 = 3,5,7,0 \end, \ft vs2 = 8,4,2,0 \end a \ft vs3 = 1,1,1,0 \end. 

fun/0 Dprog1 
  Dprog1 = Loadi(0),Loadi(2),Subi,Jzi(3),Loadi(0),Pushi(0),Jzi(1),Loadi(1),0

rem 
  \para \bf  Úloha.  \end Napíšte program \ft Dprog2 \end pre postfixový 
  stroj, ktorý zmení zásobník zo stavu \ft x,y,vs \end do stavu 
  \ft Tex2_abs_sub(x,y),x,y,vs \end, teda vypočíta na vrch zásobníka 
  absolútnu hodnotu rozdielu dvoch čísel na vrchu zásobníka. 

fun/0 Dprog2 
  Dprog2 = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Run  \end Zadefinujte funkciu 
  \ft Run(is,vs) \end, ktorá simuluje beh postfixového stroja s programom 
  \ft is \end na zásobníku \ft vs \end. 
  \para* Po skončení programu vráti funkcia \ft Run \end hodnotu z vrchu 
  zásobníka. 
  \para* Použite funkcie \ft Sub(xs,i) \end ( \header* fun/2 Sub  \end 
  \ft Sub(xs,i) \end) a \ft Drop(n,xs) \end z modulu \ft Maux11 \end. 
  \para Testovanie: 
  \verbatim 
      Run_test = rs:Results_run
  \end

fun/2 Run 
  Run(is,vs) = Foo

rem 
  \para \bf  \it  Testovač funkcie \ft Run \end.  \end  \end 

fun/2 Map_run 
  Map_run(p,0) = 0
  Map_run(p,vs,vss) = Run(p,vs),Map_run(p,vss)

fun/3 Check_run 
  Check_run(0,0,vss) = 0
  Check_run((p,ps),(rs,rss),vss) = 
  Test_case2(p,Check(Map_run(p,vss),rs)),Check_run(ps,rss,vss)

fun/0 Simple_programs 
  Simple_programs = 
  (Pushi(55),0),(Loadi(0),0),(Loadi(5),0),(Loadi(55),0),(Addi,0),(Muli,0),
  (Subi,0),(Jzi(2),Pushi(2),Pushi(4),Pushi(8),0),
  (Jzi(3),Pushi(2),Pushi(4),Pushi(8),0),0

fun/0 Complex_programs 
  Complex_programs = 
  Prog1,Prog2,Dprog1,(Loadi(1),Pushi(7),Addi,Loadi(1),Muli,0),
  (Loadi(0),Loadi(0),Muli,Loadi(0),Pushi(1),Addi,Muli,0),
  (Loadi(0),Pushi(3),Subi,Jzi(5),Loadi(0),Pushi(3),Subi,Pushi(0),Jzi(1),
   Loadi(0),0),
  (Loadi(0),Loadi(2),Jzi(3),Loadi(2),Pushi(1),Addi,Loadi(2),Muli,0),0

fun/0 Run_test 
  Run_test = Check_run(Simple_programs++Complex_programs,rss,Valuations) <- 
    (55,55,55,55,0),(101,0,256,256,0),(127,113,113,109,0),0 = simplerss1 & 
    (0,0,0,0,0),(204,101,357,256,0),(10403,0,25856,0,0),0 = simplerss2 & 
    (2,101,0,0,0),(8,8,8,8,0),(8,101,8,8,0),0 = simplerss3 & 
    (1070,1030,1030,1010,0),(42456,10609,127857,75737,0),(103,101,256,256,0),
    0 = complexrss1 & 
    (11110,0,27648,1792,0),(104070602,0,65536*(65536+1),65536*(65536+1),0),0 = 
    complexrss2 & (98,0,253,253,0),(10504,0,26112,0,0),0 = complexrss3 & 
    simplerss1++simplerss2++simplerss3++complexrss1++complexrss2++complexrss3 = 
    rss

rem 
  \para \bf  Úloha.  \end Spustite programy \ft Prog1 \end, \ft Prog2 \end a 
  \ft Dprog1 \end funkciou \ft Run \end a overte, či ste ich správne 
  odkrokovali. 

rem 
  \para \bf  Úloha.  \end Otestujte svoje programy \ft Prog11 \end, 
  \ft Prog3 \end a \ft Dprog2 \end dopytmi: 
  \para Pomocou funkcie \ft Run \end môžeme presnejšie vyjadriť požadované 
  vlastnosti programov \ft Prog11 \end, \ft Prog3 \end a \ft Dprog2 \end: 
  \eq* 
    Run(Prog11,vs) = Run(Prog1,vs)
  \end
  \eq* 
    Run(Prog3,Paren(n,vs)) = n*(n+1)
  \end
  \eq* 
    x >= y -> Run(Dprog2,Paren(x,y,vs)) = x-y
  \end
  \eq* 
    x <= y -> Run(Dprog2,Paren(x,y,vs)) = y-x
  \end
  \para a tieto programy aj otestovať: 
  \verbatim 
      Progs_test = rs:Results_run
  \end

fun/0 Progs_test 
  Progs_test = Check_run((Prog11,Prog3,Dprog2,0),rss,vss) <- 
    (7,3,0),(2,7,0),(0,7,0),(6,0,0),0 = vss & 
    Map_run(Prog1,vss),(7*(7+1),2*(2+1),0*(0+1),6*(6+1),0),(4,5,7,6,0),0 = rss

rem 
  \para \bf  16.1. Aritmetické výrazy  \end 
  \para* \bf  17.3. Podmienené výrazy  \end 

rem 
  \para \bf  \it  Aritmetické výrazy s premennými, rozdielom a podmienkami. 
   \end  \end \header* fun/2 St  \end \header* fun/3 D  \end 
  \header* fun/3 Dt  \end Aritmetické výrazy z minulého cvičenia 
  rozšírime na tomto cvičení o nasledujúce dva typy: 
  \items 
   \item \para \it  rozdielový výraz  \end \ft x-y \end, ktorý zakódujeme 
         konštruktorom \ft Tex2_equiv(St(x,y),Tex2_st(x,y)) \end; 
   \item \para \it  podmienený výraz  \end \ft D(x,y,z) \end, ktorý 
         zakódujeme konštruktorom 
         \ft Tex2_equiv(Dt(t1,t2,t3),Tex3_dt(t1,t2,t3)) \end. 
  \end
  \para Predikát \ft Term \end uvedený nižšie platí pre kódy 
  aritmetických výrazov, ktoré môžu obsahovať aj rozdielové 
  a podmienené výrazy. 
  \para* Ďalej budeme kódy výrazov nazývať trocha nepresne iba výrazmi. 

fun/2 St 'Tex2_st'
  St(t1,t2) = 4,t1,t2

fun/3 Dt 'Tex3_dt'
  Dt(t1,t2,t3) = 5,t1,t2,t3

pred Term 
  Term Ct(n) <- N(n)
  Term Vt(i) <- N(i)
  Term At(t1,t2) <- Term(t1) & Term(t2)
  Term Mt(t1,t2) <- Term(t1) & Term(t2)
  Term St(t1,t2) <- Term(t1) & Term(t2)
  Term Dt(t1,t2,t3) <- Term(t1) & Term(t2) & Term(t3)

rem 
  \para \bf  \it  Príklady výrazov.  \end  \end V module \ft Maux11 \end sú 
  zadefinované konštanty \ft Term1 \end až \ft Term7 \end kódujúce 
  príklady aritmetických výrazov bez rozdielových a podmienených výrazov. 

rem 
  \para \bf  \it  Ohodnotenie a hodnota premenných.  \end  \end Ohodnotenie 
  a hodnota premenných sú definované rovnako ako v 10. cvičení 
  [1, §16.1, def. 39]. 

rem 
  \para \bf  \it  Hodnota výrazov.  \end  \end 
  \para \it  Hodnotou rozdielového výrazu  \end \ft St(t1,t2) \end je 
  modifikovaný rozdiel hodnôt výrazov \ft t1 \end a \ft t2 \end. 
  \para \it  Hodnotou podmieneného výrazu  \end \ft Dt(t1,t2,t3) \end je 
  hodnota podvýrazu \ft t2 \end, ak je hodnota podvýrazu \ft t1 \end 
  nenulová. Inak je hodnotou podmieneného výrazu hodnota podvýrazu 
  \ft t3 \end. 
  \para Výraz \ft Dt(t1,t2,t3) \end teda interpretujeme ako \bf  if  \end 
  \ft t1 != 0 \end \bf  then  \end \ft t2 \end \bf  else  \end \ft t3 \end. 
  Podmienené výrazy sa vyskytujú vo viacerých programovacích jazykoch, 
  napríklad v Pythone môžeme napísať 
  \verbatim 
      t2 if t1 else t3
  \end
  \para a v C, C++, PHP, Jave zase 
  \verbatim 
      t1 ? t2 : t3
  \end

rem 
  \para \bf  Úloha.  \end Vypočítajte hodnotu výrazu s kódom 
  \ft Dterm1 \end pre nasledujúce tri ohodnotenia: \ft vs1 = 3,5,7,0 \end, 
  \ft vs2 = 8,4,2,0 \end, and \ft vs3 = 1,1,1,0 \end. 
  \para* Hodnota tohto výrazu je všeobecne známou funkciou hodnôt 
  premenných \ft Tex2_varidx(x,Tex0_z) \end a \ft x1 \end? Ktorou? 

fun/0 Dterm1 
  Dterm1 = Dt(St(Vt(0),Vt(1)),Vt(0),Vt(1))

rem 
  \para \bf  Úloha.  \end Zakódujte do nasledujúcej konštanty 
  \ft Dterm2 \end aritmetický výraz, ktorého hodnotou je absolútna hodnota 
  rozdielu hodnôt premenných \ft Tex2_varidx(x,Tex0_z) \end a \ft x1 \end. 

fun/0 Dterm2 
  Dterm2 = Foo

rem 
  \para \bf  \it  Ďalšie testovacie podmienené výrazy.  \end  \end 

fun/0 Dterm3 
  Dterm3 = 
  Dt(St(Vt(0),Vt(1)),Dt(St(Vt(0),Vt(2)),Vt(0),Vt(2)),
     Dt(St(Vt(1),Vt(2)),Vt(1),Vt(2)))

fun/0 Dterm4 
  Dterm4 = 
  Dt(Dt(St(Ct(1),Vt(0)),St(Ct(1),Vt(1)),Vt(2)),At(Vt(3),Vt(4)),Mt(Vt(3),Vt(4)))

fun/0 Simple_terms1 
  Simple_terms1 = Simple_terms++(St(Vt(0),Vt(2)),Dt(Vt(0),Vt(1),Vt(2)),0)

fun/0 Complex_terms1 
  Complex_terms1 = Complex_terms++(Dterm1,Dterm3,Dterm4,0)

rem 
  \para \bf  Úloha.  \end \header* fun/2 Den  \end Zadefinujte \it  denotačnú 
   \end funkciu \ft Tex2_equiv(Den(t,vs),Tex2_den(t,vs)) \end, ktorá vypočíta 
  hodnotu aritmetického výrazu \ft t \end pri ohodnotení premenných 
  \ft vs \end. 
  \para Testovanie: 
  \verbatim 
      Den_test = rs:Results_den
  \end

fun/2 Den 'Tex2_den'
  Den(Ct(n),vs) = n
  Den(Vt(i),vs) = Sub(vs,i)
  Den(At(t1,t2),vs) = Den(t1,vs)+Den(t2,vs)
  Den(Mt(t1,t2),vs) = Den(t1,vs)*Den(t2,vs)
  Den(St(t1,t2),vs) = Foo
  Den(Dt(t1,t2,t3),vs) = Foo <- Quux

rem 
  \para \bf  \it  Testovač funkcie \ft Den \end.  \end  \end 

fun/2 Map_den 
  Map_den(t,0) = 0
  Map_den(t,vs,vss) = Den(t,vs),Map_den(t,vss)

fun/3 Check_den 
  Check_den(0,0,vss) = 0
  Check_den((t,ts),(rs,rss),vss) = 
  Test_case2(t,Check(Map_den(t,vss),rs)),Check_den(ts,rss,vss)

fun/0 Den_test 
  Den_test = Check_den(Simple_terms1++Complex_terms1,rs,Valuations) <- 
    (7,7,7,7,0),(107,103,103,101,0),(204,101,357,256,0),(10403,0,25856,0,0),0 = 
    simplers & (0,0,153,155,0),(103,103,101,0,0),0 = simplers1 & 
    (1070,1030,1030,1010,0),(42456,10609,127857,75737,0),
    (10302,0,65792,65792,0),0 = complexrs1 & 
    (2050,1515,2795,1280,0),(42436,808,104232,0,0),(1725,404,3732,3328,0),0 = 
    complexrs2 & (43680,21218,73954,1428,0),0 = complexrs3 & 
    (103,101,256,256,0),(107,103,256,256,0),(222,11663,216,210,0),0 = complexdrs & 
    simplers++simplers1++complexrs1++complexrs2++complexrs3++complexdrs = rs

rem 
  \para \bf  Úloha.  \end Pomocou denotačnej funkcie môžeme špecifikovať 
  a testovať výraz \ft Dterm2 \end, ktorý ste mali definovať 
  v pred-predchádzajúcej úlohe. 
  \eq* 
    x >= y -> Den(Dterm2,x,y,vs) = x-y
  \end
  \eq* 
    x < y -> Den(Dterm2,x,y,vs) = y-x
  \end
  \para Testovanie: 
  \verbatim 
      Dterm2_test = rs:Results_den
  \end

fun/0 Dterm2_test 
  Dterm2_test = 
  Check_den((Dterm2,0),((4,5,7,6,0),0),(7,3,0),(2,7,0),(0,7,0),(6,0,0),0)

rem 
  \para \bf  17.2. Kompilácia aritmetických výrazov  \end 
  \para* \bf  17.3. Podmienené výrazy  \end 

rem 
  \para \bf  \it  Programy počítajúce aritmetické výrazy.  \end  \end 
  Všimnite si, že ak spustíme program \ft Prog1 \end so zásobníkom 
  \ft vs \end, na vrch zásobníka sa vypočíta hodnota výrazu \ft Term1 \end 
  (z modulu \ft Maux11 \end) pri ohodnotení premenných \ft vs \end. Teda: 
  \eq* 
    Run(Prog1,vs) = Den(Term1,vs)
  \end
  \para Podobný vzťah je medzi \ft Prog2 \end a \ft Term2 \end, medzi 
  \ft Dprog1 \end a \ft Dterm1 \end i medzi \ft Dprog2 \end a \ft Dterm2 \end. 

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Comp(t) \end, ktorá 
  skompiluje aritmetický výraz \ft t \end do programu pre postfixový stroj 
  tak, aby platilo 
  \eq* 
    Term(t) -> Program Comp(t)
  \end
  \eq* 
    Term(t) -> Run(Comp(t),vs) = Den(t,vs)
  \end
  \para \header* fun/2 Comp1  \end Ako sme ukázali na prednáške, musíme 
  použiť pomocnú funkciu \ft Comp1(t,j) \end, ktorá skompiluje výraz 
  \ft t \end do programu, ktorý vypočíta hodnotu výrazu \ft t \end, keď sa 
  na zásobníku nad ohodnotením \ft vs \end nachádza \ft j \end 
  medzivýsledkov \ft ms \end: 
  \eq* 
    Term(t) -> Program Comp1(t,j)
  \end
  \eq* 
    Term(t) & L(ms) = j -> 
    Run(Comp1(t,j)++p,ms++vs) = Run(p,Paren(Den(t,vs),ms++vs))
  \end
  \para Testovanie: 
  \verbatim 
      Comp1_test = rs:Results_comp
  \end
  \verbatim 
      Comp_test = rs:Results_comp
  \end

fun/2 Comp1 
  Comp1(Ct(n),j) = Pushi(n),0
  Comp1(Vt(i),j) = Foo
  Comp1(At(t1,t2),j) = Foo
  Comp1(Mt(t1,t2),j) = Foo
  Comp1(St(t1,t2),j) = Foo
  Comp1(Dt(t1,t2,t3),j) = Foo

fun Comp 
  Comp(t) = Foo

rem 
  \para \bf  \it  Testovače funkcií \ft Comp1 \end a \ft Comp \end.  \end 
   \end 

fun/2 Check_comp1 
  Check_comp1(0,vss) = 0
  Check_comp1((t,ts),vss) = 
  Test_case3(t,p,Check(Map_run(p,Map_conc((2,4,8,0),vss)),Map_den(t,vss))),
  Check_comp1(ts,vss) <- 
    Comp1(t,3) = p

fun/0 Comp1_test 
  Comp1_test = Check_comp1(Simple_terms1++Complex_terms1,Valuations)

fun/2 Check_comp 
  Check_comp(0,vss) = 0
  Check_comp((t,ts),vss) = 
  Test_case3(t,p,Check(Map_run(p,vss),Map_den(t,vss))),Check_comp(ts,vss) <- 
    Comp(t) = p

fun/0 Comp_test 
  Comp_test = Check_comp(Simple_terms1++Complex_terms1,Valuations)

rem 
  \para \bf  Úloha.  \end Nájdite výrazy, ktorých hodnoty počítajú 
  nasledujúce programy, teda pre daný \ft p \end nájdite taký \ft t \end, 
  že platí 
  \eq* 
    \a vs Den(t,vs) = Run(p,vs)
  \end
  \para Táto úloha je opakom kompilácie, nazýva sa \it  dekompilácia  \end. 
  \para Programy \ft Prog8 \end a \ft Dprog5 \end sa dajú dekompilovať do 
  výrazov \ft Term8 \end a \ft Dterm5 \end tak, aby platilo 
  \ft Comp(Term8) = Prog8 \end a \ft Comp(Dterm5) = Dprog5 \end. Pre programy 
  \ft Prog9 \end a \ft Dprog6 \end to ale neplatí. Výrazy \ft Term9 \end a 
  \ft Dterm6 \end, ktoré nájdete, budú počítať rovnaké hodnoty, ale ich 
  kompiláciou dostanete iné programy ako \ft Prog9 \end a \ft Dprog6 \end. 
  \para Testovanie: 
  \verbatim 
      Decomp_test = rs:Results_decomp
  \end

fun/0 Prog8 
  Prog8 = Loadi(1),Pushi(7),Addi,Loadi(1),Muli,0

fun/0 Term8 
  Term8 = Foo

fun/0 Prog9 
  Prog9 = Loadi(0),Loadi(0),Muli,Loadi(0),Pushi(1),Addi,Muli,0

fun/0 Term9 
  Term9 = Foo

fun/0 Dprog5 
  Dprog5 = 
  Loadi(0),Pushi(3),Subi,Jzi(5),Loadi(0),Pushi(3),Subi,Pushi(0),Jzi(1),Loadi(0),
  0

fun/0 Dterm5 
  Dterm5 = Foo

fun/0 Dprog6 
  Dprog6 = Loadi(0),Loadi(2),Jzi(3),Loadi(2),Pushi(1),Addi,Loadi(2),Muli,0

fun/0 Dterm6 
  Dterm6 = Foo

rem 
  \para \bf  \it  Testovač dekompilácie.  \end  \end 

fun/2 Check_decomp 
  Check_decomp(0,vss) = 0
  Check_decomp(((p,t),pts),vss) = 
  Test_case2((p,t),Check(Map_den(t,vss),Map_run(p,vss))),Check_decomp(pts,vss)

fun/0 Decomp_test 
  Decomp_test = Check_decomp(pts,Valuations) <- 
    (Prog8,Term8),(Prog9,Term9),(Dprog5,Dterm5),(Dprog6,Dterm6),0 = pts

