mod Ex09a


loc rem 
  \para \bf  9. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2014/2015  \end 
  \para* \bf  ČASŤ A  \end
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex09.zip 

loc rem 
  \para* \it  Dátum:  \end 29. 4. 2015 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.21  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované postfixovému
  stroju a numerickým výrazom.

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2014/2015. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2015.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 


incl Maux09

incl Mtesting09

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  16. ARITMETICKÉ VÝRAZY A VÝROKOVÉ FORMULY  \end 

rem 
  \para \bf  16.1. Aritmetické výrazy  \end 

rem 
  \para \bf  \it  Definícia.  \end  \end \it  Aritmetickým výrazom 
  s premennými  \end (skrátene \it  aritmetickým výrazom  \end alebo len 
  \it  výrazom  \end) je: 
  \items 
   \item \para číselná konštanta \ft 0 \end, \ft 1 \end, \ft 2 \end, …, 
         \ft n \end, …, 
   \item \para premenná \ft Tex2_varidx(x,Tex0_z) \end, \ft x1 \end, 
         \ft x2 \end, …, \ft Tex2_varidx(x,i) \end, …, 
   \item \para súčtový výraz \ft t1+t2 \end, ak \ft t1 \end a \ft t2 \end 
         sú aritmetickými výrazmi, 
   \item \para súčinový výraz \ft Tex2_times(t1,t2) \end, ak \ft t1 \end a 
         \ft t2 \end sú aritmetickými výrazmi. 
  \end
  \para Nič iné nie je aritmetickým výrazom. 

rem 
  \para \bf  \it  Kódovanie aritmetických výrazov s premennými.  \end  \end 
  Aritmetické výrazy majú stromovú štruktúru. Môžeme ich zakódovať 
  podobne ako binárne stromy. Použijeme nasledujúce konštruktory: 

fun Ct 'Tex1_ct'
  Ct(n) = 0,n

fun Vt 'Tex1_vt'
  Vt(i) = 1,i

fun/2 At 'Tex2_at'
  At(t1,t2) = 2,t1,t2

fun/2 Mt 'Tex2_mt'
  Mt(t1,t2) = 3,t1,t2

rem 
  \items 
   \item \para \ft Ct(n) \end kóduje číselnú konštantu \ft n \end, 
   \item \para \ft Vt(i) \end kóduje premennú \ft Tex2_varidx(x,i) \end, 
   \item \para \ft At(t1,t2) \end kóduje súčtový výraz, ktorého podvýrazy 
         sú zakódované číslami \ft t1 \end a \ft t2 \end, 
   \item \para \ft Mt(t1,t2) \end kóduje súčinový výraz, ktorého 
         podvýrazy sú zakódované číslami \ft t1 \end a \ft t2 \end. 
  \end
  \para Predikát \ft Term(t) \end platí, ak \ft t \end je kódom 
  aritmetického výrazu. 

pred Term 
  Term Ct(n) <- N(n)
  Term Vt(i) <- N(i)
  Term At(t1,t2) <- Term(t1) & Term(t2)
  Term Mt(t1,t2) <- Term(t1) & Term(t2)

rem 
  \para \bf  Úloha.  \end Vypočítajte hodnotu výrazov s kódmi 
  \ft Term1 \end a \ft Term2 \end, ak premenná \ft Tex2_varidx(x,Tex0_z) \end 
  má hodnotu \ft 3 \end, premenná \ft x1 \end má hodnotu \ft 5 \end 
  a premenná \ft x2 \end má hodnotu \ft 7 \end. 

fun/0 Term1 
  Term1 = Mt(At(Ct(4),Ct(6)),Vt(2))

rem 
  Hodnota Term1 ak x0 = 3, x1 = 5, x2 = 7 je: ___

fun/0 Term2 
  Term2 = At(At(Mt(Vt(0),Vt(0)),Mt(Ct(2),Mt(Vt(0),Vt(1)))),Mt(Vt(2),Vt(2)))

rem 
  Hodnota Term2 ak x0 = 3, x1 = 5, x2 = 7 je: ___

rem 
  \para \bf  Úloha.  \end Zjednodušte výraz s kódom \ft Term1 \end tak, že 
  súčet konštánt nahradíte jedinou konštantou. Zapíšte \it  kód  \end 
  zjednodušeného výrazu pomocou konštruktorov \ft Vt \end, \ft Ct \end, 
  \ft At \end, \ft Mt \end do nasledujúceho komponentu. 

fun/0 Term11 
  Term11 = Foo

rem 
  \para \bf  Úloha.  \end Zapíšte kód aritmetického výrazu 
  \ft Tex2_times(Tex2_varidx(x,Tex0_z),Tex2_varidx(x,Tex0_z)+1) \end do 
  nasledujúceho komponentu. 

fun/0 Term3 
  Term3 = Foo

rem 
  \para \bf  Úloha. Veľkosť výrazu.  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Sz(t),Tex1_sz(t)) \end, ktorej hodnotou je veľkosť výrazu 
  s kódom \ft t \end, teda počet uzlov jeho aritmetického stromu, čiže 
  počet aplikácií konštruktorov potrebných na jeho zakódovanie. 
  \para Testovanie: 
  \verbatim 
      Sz_test = rs:Results
  \end

fun Sz 'Tex1_sz'
  Sz(t) = Foo

fun/0 Sz_test 
  Sz_test = 
  Check(Sz Ct(12),1),Check(Sz Vt(7),1),Check(Sz At(Ct(12),Vt(7)),3),
  Check(Sz Mt(Ct(12),Vt(7)),3),Check(Sz(Term1),5),Check(Sz(Term2),13),0

rem 
  \para \bf  Úloha. Premenné výrazu.  \end Zadefinujte funkciu 
  \ft Vars(t) \end, ktorej hodnotou je zoznam indexov premenných vyskytujúcich 
  sa vo výraze \ft t \end v poradí zľava doprava aj s prípadnými 
  opakovaniami. 
  \para Testovanie: 
  \verbatim 
      Vars_test = rs:Results
  \end

fun Vars 
  Vars(t) = Foo

fun/0 Vars_test 
  Vars_test = 
  Check(Vars Ct(12),0),Check(Vars Vt(7),Paren(7,0)),
  Check(Vars At(Ct(12),Vt(7)),Paren(7,0)),
  Check(Vars Mt(Ct(12),Vt(7)),Paren(7,0)),
  Check(Vars At(Vt(12),Mt(At(Vt(7),Vt(3)),Vt(7))),Paren(12,7,3,7,0)),
  Check(Vars(Term1),Paren(2,0)),Check(Vars(Term2),Paren(0,0,0,1,2,2,0)),0

rem 
  \para \bf  \it  Definícia.  \end  \end \it  Ohodnotením (valuáciou) 
  premenných  \end nazveme ľubovoľný zoznam. 
  \para \it  Hodnotou premennej \ft Tex2_varidx(x,i) \end pri ohodnotení 
  \ft vs \end  \end je číslo \ft Sub(vs,i) \end ( \ft Paren(i+1) \end-ý prvok 
  zoznamu \ft vs \end). 
  \para (Funkcia \ft Sub(vs,i) \end ( \ft Sub \end) je definovaná v module 
  \ft Maux09 \end.) 

rem 
  \para \bf  Úloha.  \end \header* fun/2 Den  \end Zadefinujte \it  denotačnú 
   \end funkciu \ft Tex2_equiv(Den(t,vs),Tex2_den(t,vs)) \end, ktorá vypočíta 
  hodnotu aritmetického výrazu \ft t \end pri ohodnotení premenných 
  \ft vs \end. 
  \para Testovanie: 
  \verbatim 
      Den_test = rss:Results_den
  \end

fun/2 Den 'Tex2_den'
  Den(t,vs) = Foo

fun/3 Check_den 
  Check_den(t,0,0) = 0
  Check_den(t,(vs,vss),expden,expdens) = 
  Check(Den(t,vs),expden),Check_den(t,vss,expdens)

fun/0 Den_test 
  Den_test = 
  Test_case2(Ct(8),Check_den(Ct(8),vss,Paren(8,8,8,8,8,8,8,8,0))),
  Test_case2(Vt(0),Check_den(Vt(0),vss,Paren(0,2,2,5,2,5,0,0,0))),
  Test_case2(Vt(2),Check_den(Vt(2),vss,Paren(0,0,0,0,5,2,5,2,0))),
  Test_case2(Vt(7),Check_den(Vt(7),vss,Paren(0,0,0,0,0,0,0,0,0))),
  Test_case2(At(Ct(2),Ct(3)),
             Check_den(At(Ct(2),Ct(3)),vss,Paren(5,5,5,5,5,5,5,5,0))),
  Test_case2(Mt(Ct(2),Ct(3)),
             Check_den(Mt(Ct(2),Ct(3)),vss,Paren(6,6,6,6,6,6,6,6,0))),
  Test_case2(At(Vt(2),Vt(1)),
             Check_den(At(Vt(2),Vt(1)),vss,Paren(0,0,5,2,5,2,7,7,0))),
  Test_case2(Mt(Vt(2),Vt(1)),
             Check_den(Mt(Vt(2),Vt(1)),vss,Paren(0,0,0,0,0,0,10,10,0))),
  Test_case2(Term1,Check_den(Term1,vss,Paren(0,0,0,0,50,20,50,20,0))),
  Test_case2(Term2,Check_den(Term2,vss,Paren(0,4,24,45,29,29,25,4,0))),0 <- 
    Paren(0),Paren(2,0),Paren(2,5,0,0),Paren(5,2,0,0),Paren(2,0,5,0),
    Paren(5,0,2,0),Paren(0,2,5,0),Paren(0,5,2,0),0 = vss

rem 
  \para \bf  Úloha.  \end Vypočítajte hodnotu výrazov s kódmi 
  \ft Term1 \end a \ft Term2 \end pomocou funkcie \ft Den(t,vs) \end pri 
  ohodnotení premenných \ft 3,5,7,0 \end. 

rem 
  \para \bf  Úloha.  \end Výpočtami pri rôznych ohodnoteniach otestujte, či 
  ste správne určili \ft Term11 \end: 
  \verbatim 
      3,5,7,0 = vs & Den(Term1,vs) = dt1 & Den(Term11,vs) = dt11
  \end
  \para* a \ft Term3 \end: 
  \verbatim 
      7 = n & n,0 = vs & Den(Term3,vs) = dt3 & n*(n+1) = dt31
  \end
  \para Pomocou denotačnej funkcie môžeme presnejšie vyjadriť požadované 
  vlastnosti výrazov \ft Term11 \end a \ft Term3 \end: 
  \eq* 
    \a vs Den(Term11,vs) = Den(Term1,vs)
  \end
  \eq* 
    \a n\a vs Den(Term3,n,vs) = n*(n+1)
  \end

rem 
  \para \bf  16.2. Transformácia aritmetických výrazov  \end 

rem 
  \para \bf  16.2.1. Súčtový normálny tvar  \end 

rem 
  \para \bf  \it  Definícia.  \end  \end \it  Súčinový výraz  \end je 
  aritmetický výraz tvorený iba konštantami, premennými a násobením. 
  \para Tento pojem na kódoch výrazov formálne vyjadruje nasledujúci 
  predikát \ft Mterm \end. 

pred Mterm 
  Mterm Ct(n)
  Mterm Vt(i)
  Mterm Mt(t1,t2) <- Mterm(t1) & Mterm(t2)

rem 
  \para \bf  \it  Definícia.  \end  \end Aritmetický výraz je v \it  
  súčtovom normálnom tvare  \end práve vtedy, keď je súčinovým výrazom, 
  alebo súčtom výrazov v súčtovom normálnom tvare. 
  \para Tento pojem na kódoch výrazov formálne vyjadruje nasledujúci 
  predikát \ft Anf \end. 

pred Anf 
  Anf(t) <- Mterm(t)
  Anf(t) <- ~Mterm(t) & t = At(t1,t2) & Anf(t1) & Anf(t2)

rem 
  \para \bf  \it  Poznámka.  \end  \end Všimnite si, že súčinové výrazy 
  aj výrazy v súčtovom normálnom tvare sú určite výrazmi: 
  \eq* 
    Mterm(t) -> Term(t)
  \end
  \eq* 
    Anf(t) -> Term(t)
  \end

rem 
  \para \bf  \it  Prevod do súčtového normálneho tvaru.  \end  \end 
  \header* fun/2 Mul_aa  \end \header* fun/2 Mul_ma  \end Cieľom nasledujúcich 
  úloh je naprogramovať funkciu \ft Anf_from(t) \end, ktorá ľubovoľný 
  výraz \ft t \end prevedie do súčtového normálneho tvaru. 
  \para Ako sme videli na prednáške [1, §16.2.1, str. 109], na tento prevod 
  potrebujeme pomocnú funkciu \ft Mul_aa \end, ktorá „roznásobí“ dva 
  výrazy v súčtovom normálnom tvare (zátvorkovanie nie je dôležité) 
  \eq* 
    as = 
    At(Tex2_varidx(s,1),
       At(Tex2_varidx(s,2),
          At(Tex0_cdots,Tex1_cdots_after At(Tex2_varidx(s,m-1),Tex2_varidx(s,m)))))
  \end
  \eq* 
    at = 
    At(Tex2_varidx(t,1),
       At(Tex2_varidx(t,2),
          At(Tex0_cdots,Tex1_cdots_after At(Tex2_varidx(t,n-1),Tex2_varidx(t,n)))))
  \end
  \para teda skonštruuje súčet všetkých možných súčinov 
  \ft Mt(Tex2_varidx(s,i),Tex2_varidx(t,j)) \end. Tento výraz bude 
  v súčtovom normálnom tvare a jeho denotácia bude rovnaká ako denotácia 
  \ft Mt(as,at) \end. 
  \para Keďže chceme vynásobiť \it  každý  \end súčinový podvýraz 
  \ft Tex2_varidx(s,i) \end v \ft as \end s \it  každým  \end súčinovým 
  podvýrazom \ft Tex2_varidx(t,j) \end v \ft at \end, vo funkcii 
  \ft Mul_aa \end budeme prechádzať iba výrazom \ft as \end. Keď narazíme 
  na niektorý súčinový podvýraz \ft Tex2_varidx(s,i) \end, zavoláme 
  pomocnú funkciu \ft Mul_ma(Tex2_varidx(s,i),at) \end. Tá prejde výrazom 
  \ft at \end a vynásobí \it  jeden  \end podvýraz \ft Tex2_varidx(s,i) \end 
  \it  každým  \end súčinovým podvýrazom \ft Tex2_varidx(t,j) \end v 
  \ft at \end. 
  \para V imperatívnom jazyku by sme tento postup naprogramovali dvoma 
  vnorenými cyklami. V deklaratívnom jazyku použijeme dve vnorené 
  rekurzívne funkcie. 

rem 
  \para \bf  Úloha.  \end \header* fun/2 Mul_ma  \end Naprogramujte funkciu 
  \ft Mul_ma \end spĺňajúcu špecifikáciu: 
  \eq* 
    Term Tex2_varidx(s,i) & Term(at) -> Term Mul_ma(Tex2_varidx(s,i),at)
  \end
  \eq* 
    Term Tex2_varidx(s,i) & Term(at) -> 
    Den(Mul_ma(Tex2_varidx(s,i),at),vs) = Den(Mt(Tex2_varidx(s,i),at),vs)
  \end
  \eq* 
    Mterm Tex2_varidx(s,i) & Anf(at) -> Anf Mul_ma(Tex2_varidx(s,i),at)
  \end
  \para \it  Návod.  \end Predpokladajte (ale netestujte), že 
  \ft Tex2_varidx(s,i) \end je súčinový výraz a \ft at \end je výraz v 
  súčtovom normálnom tvare, teda napríklad 
  \eq* 
    at = 
    At(At(Tex2_varidx(t,1),Tex2_varidx(t,2)),
       At(Tex2_varidx(t,3),Tex2_varidx(t,4)))
  \end
  \para pre nejaké súčinové výrazy \ft Tex2_varidx(t,1) \end, …, 
  \ft Tex2_varidx(t,4) \end (premenné, konštanty, súčiny). Hodnotou 
  \ft Mul_ma(Tex2_varidx(s,i),at) \end je potom súčet súčinov výrazu 
  \ft Tex2_varidx(s,i) \end s každým súčinovým podvýrazom v \ft at \end, 
  čiže v našom prípade 
  \eq* 
    Mul_ma(Tex2_varidx(s,i),at) = 
    At(At(Mt(Tex2_varidx(s,i),Tex2_varidx(t,1)),
          Mt(Tex2_varidx(s,i),Tex2_varidx(t,2))),
       At(Mt(Tex2_varidx(s,i),Tex2_varidx(t,3)),
          Mt(Tex2_varidx(s,i),Tex2_varidx(t,4))))
  \end
  \para Tento výraz je v súčtovom normálnom tvare. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Mul_ma_test = rs:Results_mul
  \end
  \para \it  Poznámka.  \end Test tentoraz nepredpisuje presne požadovaný 
  tvar výsledku, ale kontroluje platnosť \ft Anf \end a rovnosť denotácií 
  na konkrétnych hodnotách \ft t \end a \ft vs \end. Test závisí od 
  správnosti funkcie \ft Den \end. 

fun/2 Mul_ma 
  Mul_ma(si,at) = Foo

fun Check_mul_ma 
  Check_mul_ma(0) = 0
  Check_mul_ma((si,at),tts) = 
  Test_case3((si,at),Check_anf(ast),
             Check(Den(Mt(si,at),Vs_primes),Den(ast,Vs_primes))),
  Check_mul_ma(tts) <- 
    Mul_ma(si,at) = ast

fun/0 Mul_ma_test 
  Mul_ma_test = 
  Check_mul_ma((Vt(5),at1),(Vt(6),at2),(Vt(7),at3),(Mt(Ct(8),Vt(1)),at3),
               (Vt(8),at4),(Vt(9),at5),(Vt(10),at6),0) <- 
    Ct(4) = at1 & At(Vt(2),Ct(4)) = at2 & 
    At(At(Mt(Ct(3),Vt(3)),Vt(2)),Ct(4)) = at3 & 
    At(At(Mt(Ct(3),Vt(3)),Vt(2)),At(Vt(1),Ct(4))) = at4 & 
    At(Mt(Ct(3),Vt(3)),At(Vt(2),At(Vt(1),Ct(4)))) = at5 & 
    At(Mt(Ct(3),Vt(3)),At(At(Vt(2),Vt(1)),Ct(4))) = at6

rem 
  \para \bf  Úloha.  \end \header* fun/2 Mul_aa  \end Naprogramujte funkciu 
  \ft Mul_aa \end spĺňajúcu špecifikáciu: 
  \eq* 
    Term(as) & Term(at) -> Term Mul_aa(as,at)
  \end
  \eq* 
    Term(as) & Term(at) -> Den(Mul_aa(as,at),vs) = Den(Mt(as,at),vs)
  \end
  \eq* 
    Anf(as) & Anf(at) -> Anf Mul_aa(as,at)
  \end
  \para \it  Návod.  \end Predpokladajte, že \ft as \end a \ft at \end sú 
  výrazy v súčtovom normálnom tvare, teda napríklad 
  \eq* 
    as = 
    At(Tex2_varidx(s,1),
       At(At(Tex2_varidx(s,2),Tex2_varidx(s,3)),Tex2_varidx(s,4)))
  \end
  \eq* 
    at = 
    At(At(Tex2_varidx(t,1),Tex2_varidx(t,2)),
       At(Tex2_varidx(t,3),Tex2_varidx(t,4)))
  \end
  \para pre nejaké súčinové výrazy \ft Tex2_varidx(s,1) \end, …, 
  \ft Tex2_varidx(s,4) \end, \ft Tex2_varidx(t,1) \end, …, 
  \ft Tex2_varidx(t,4) \end. Hodnotou \ft Mul_aa(as,at) \end je potom súčet 
  výrazov, z ktorých každý je súčtom súčinov niektorého súčinového 
  podvýrazu \ft Tex2_varidx(s,i) \end vo výraze  \ft as \end s každým 
  súčinovým podvýrazom v \ft at \end. Tieto vnútorné výrazy skonštruuje 
  funkcia \ft Mul_ma \end, čiže 
  \eq* 
    Mul_aa(as,at) = 
    At(Mul_ma(Tex2_varidx(s,1),at),
       At(At(Mul_ma(Tex2_varidx(s,2),at),Mul_ma(Tex2_varidx(s,3),at)),
          Mul_ma(Tex2_varidx(s,4),at)))
  \end
  \eq* 
    Tex1_eq_before Tex1_at_after At(At(Mt(Tex2_varidx(s,1),Tex2_varidx(t,1)),
                                       Mt(Tex2_varidx(s,1),Tex2_varidx(t,2))),
                                    At(Mt(Tex2_varidx(s,1),Tex2_varidx(t,3)),
                                       Mt(Tex2_varidx(s,1),Tex2_varidx(t,4))))
  \end
  \eq* 
    Paren At(Tex0_cdots,
             At(At(Mt(Tex2_varidx(s,4),Tex2_varidx(t,1)),
                   Mt(Tex2_varidx(s,4),Tex2_varidx(t,2))),
                At(Mt(Tex2_varidx(s,4),Tex2_varidx(t,3)),
                   Mt(Tex2_varidx(s,4),Tex2_varidx(t,4)))))
  \end
  \para Skonštruovaný výraz je v súčtovom normálnom tvare. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Mul_aa_test = rs:Results_mul
  \end

fun/2 Mul_aa 
  Mul_aa(as,at) = Foo

fun Check_mul_aa 
  Check_mul_aa(0) = 0
  Check_mul_aa((as,at),tts) = 
  Test_case3((as,at),Check_anf(ast),
             Check(Den(Mt(as,at),Vs_primes),Den(ast,Vs_primes))),
  Check_mul_aa(tts) <- 
    Mul_aa(as,at) = ast

fun/0 Mul_aa_test 
  Mul_aa_test = 
  Check_mul_aa((Vt(10),Ct(4)),(Vt(10),at1),(At(Vt(10),Ct(10)),at1),(at1,at1),
               (at2,at1),(at1,at2),(at3,at1),0) <- 
    At(At(Mt(Ct(3),Vt(3)),Vt(2)),Ct(4)) = at1 & 
    At(Ct(10),At(Mt(Vt(1),Vt(0)),Vt(7))) = at2 & 
    At(At(Mt(Ct(2),Vt(7)),At(Ct(11),Mt(Vt(1),Vt(0)))),Ct(10)) = at3

rem 
  \para \bf  Úloha.  \end Naprogramujte funkciu \ft Anf_from \end spĺňajúcu 
  špecifikáciu: 
  \eq* 
    Term(t) -> Term Anf_from(t)
  \end
  \eq* 
    Term(t) -> Anf Anf_from(t)
  \end
  \eq* 
    Term(t) -> Den(Anf_from(t),vs) = Den(t,vs)
  \end
  \para \it  Návod.  \end Funkciu stačí naprogramovať jednoduchou 
  štrukturálnou rekurziou na výrazoch. Do súčtového normálneho tvaru 
  prevedieme podvýrazy, ktoré potom spojíme do výrazu v súčtovom 
  normálnom tvare. V prípade súčtu je spojenie triviálne, v prípade 
  súčinu využite predchádzajúce funkcie. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Anf_from_test = rs:Results_anf
  \end

fun Anf_from 
  Anf_from(t) = Foo

fun Check_anf_from 
  Check_anf_from(0) = 0
  Check_anf_from(t,ts) = 
  Test_case3(t,Check_anf(at),Check(Den(t,Vs_primes),Den(at,Vs_primes))),
  Check_anf_from(ts) <- 
    Anf_from(t) = at

fun/0 Anf_from_test 
  Anf_from_test = Check_anf_from(t1,t2,t3,t4,t5,t6,t7,0) <- 
    Vt(2) = t1 & Ct(2) = t2 & At(Ct(2),Vt(2)) = t3 & Mt(Ct(2),Vt(2)) = t4 & 
    Mt(At(Vt(0),Vt(1)),At(Vt(1),Vt(2))) = t5 & 
    Mt(Vt(0),Mt(Ct(2),At(Vt(0),Vt(1)))) = t6 & 
    Mt(At(Mt(Vt(1),Vt(0)),At(Vt(2),Ct(10))),
       At(Mt(Ct(3),Vt(3)),At(Vt(4),Ct(4)))) = t7

rem 
  \para \bf  16.2.2. Zátvorkovanie doľava  \end 

rem 
  \para \bf  \it  Definícia.  \end  \end \it  Výraz s doľava asociovaným 
  sčítaním  \end je aritmetický výraz, v ktorom \it  pravý  \end argument 
  žiadneho sčítania (ktoré nie je potomkom násobenia) \it  nie je  \end 
  sčítanie. 
  \para Tento pojem na kódoch výrazov formálne vyjadruje nasledujúci 
  predikát \ft Lassoc \end. 

pred Lassoc 
  Lassoc Ct(n)
  Lassoc Vt(i)
  Lassoc At(t,Ct(n)) <- Lassoc(t)
  Lassoc At(t,Vt(i)) <- Lassoc(t)
  Lassoc At(t,Mt(t1,t2)) <- Lassoc(t)
  Lassoc Mt(t1,t2)

rem 
  \para \bf  Úloha.  \end Všimnite si, že hodnota, ktorá vyhovuje predikátu 
  \ft Lassoc \end nemusí byť nutne výrazom, teda 
  \eq* 
    \e x(Lassoc(x) & ~Term(x))
  \end
  \para (na rozdiel od predikátov \ft Mterm \end a \ft Anf \end vyššie). 
  \para Zapíšte takú hodnotu do nasledujúcej konštanty 
  \ft Lassoc_not_term \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Lassoc_not_term = t & Lassoc(t) & ~Term(t)
  \end

fun/0 Lassoc_not_term 
  Lassoc_not_term = Foo

rem 
  \para \bf  Úloha.  \end Naprogramujte funkciu \ft Lassoc_from(t) \end, ktorá 
  vráti výraz s doľava asociovaným sčítaním, ktorého veľkosť 
  a hodnoty pri všetkých ohodnoteniach premenných sú rovnaké ako pre 
  výraz \ft t \end. 
  \eq* 
    Term(t) -> Term Lassoc_from(t) & Lassoc Lassoc_from(t)
  \end
  \eq* 
    Term(t) -> Den(Lassoc_from(t),v) = Den(t,vs)
  \end
  \eq* 
    Term(t) -> Sz Lassoc_from(t) = Sz(t)
  \end
  \para* \it  Návod.  \end Transformácia výrazu 
  \ft At(a,At(At(b,c),At(d,e))) \end, kde \ft a \end, …, \ft e \end nie sú 
  súčty, by mala prebehnúť v nasledujúcich krokoch: 
  \para \ft Lassoc_from At(a,At(At(b,c),At(d,e))) \end 
  \ft Tex1_eq_before Lassoc_from At(At(a,At(b,c)),At(d,e)) \end 
  \ft Tex1_eq_before Lassoc_from At(At(At(a,At(b,c)),d),e) \end 
  \ft Tex1_eq_before At(Lassoc_from At(At(a,At(b,c)),d),e) \end 
  \ft Tex1_eq_before At(At(Lassoc_from At(a,At(b,c)),d),e) \end 
  \ft Tex1_eq_before At(At(At(Lassoc_from At(a,b),c),d),e) \end 
  \ft Tex1_eq_before At(At(At(At(a,b),c),d),e) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Lassoc_from_test = rs:Results_lassoc
  \end
  \para \it  Poznámka.  \end Test tentoraz nepredpisuje presne požadovaný 
  tvar výsledku, ale kontroluje splnenie jednotlivých bodov špecifikácie 
  (platnosť \ft Lassoc \end, rovnosť denotácií a veľkostí) na 
  konkrétnych hodnotách \ft t \end a \ft vs \end. Test závisí od správnosti 
  funkcie \ft Den \end. 

fun Lassoc_from 
  Lassoc_from(t) = Foo

fun Check_lassoc_from 
  Check_lassoc_from(0) = 0
  Check_lassoc_from(t,ts) = 
  Test_case4(t,Check_lassoc(lat),Check(Den(t,Vs_primes),Den(lat,Vs_primes)),
             Check(Sz(t),Sz(lat))),Check_lassoc_from(ts) <- 
    Lassoc_from(t) = lat

fun/0 Lassoc_from_test 
  Lassoc_from_test = Check_lassoc_from(t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11,0) <- 
    Vt(5) = t1 & Ct(15) = t2 & At(Vt(3),Vt(1)) = t3 & Mt(Vt(3),Vt(1)) = t4 & 
    At(Vt(2),At(Ct(3),Vt(1))) = t5 & At(At(Vt(1),Vt(2)),At(Ct(3),Vt(4))) = t6 & 
    At(At(Vt(1),Vt(2)),At(Ct(3),At(Vt(4),Vt(5)))) = t7 & 
    At(Vt(1),At(At(Vt(3),Ct(3)),Vt(4))) = t8 & 
    At(At(Vt(1),At(Vt(2),At(Vt(3),Vt(4)))),
       At(Vt(5),At(Vt(6),At(Vt(7),Vt(8))))) = t9 & Mt(Vt(3),t5) = t10 & 
    At(t5,Vt(3)) = t11

rem 
  \para \bf  Prémiová domáca úloha \it  du09  \end.  \end (2 body) 
  \para Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp/#pdu  \end. 
  \para \bf  Termín odovzdania:  \end nedeľa 10. 5. 2015 23:59:59 
  \para* \it  Zadanie.  \end \header* fun/3 Subst  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Subst(s,k,t),Tex3_subst(s,k,t)) \end, ktorá za každý výskyt 
  premennej \ft Vt(k) \end vo výraze \ft s \end dosadí výraz \ft t \end. 
  \para* \it  Špecifikácia.  \end \header* fun/3 Subst 'Tex3_subst' \end 
  \eq* 
    Term(s) & Term(t) -> Term Subst(s,k,t)
  \end
  \eq* 
    Term(s) & Term(t) -> k in Vars Subst(s,k,t) <-> k in Vars(t)
  \end
  \eq* 
    Term(s) & Term(t) -> Sz Subst(s,k,t) = Sz(s)+Count(k,Vars(t))*(Sz(t)-1)
  \end
  \eq* 
    Term(s) & Term(t) & vs1 = Msub(vs,k,Den(t,vs)) -> 
    Den(Subst(s,k,t),vs) = Den(s,vs1)
  \end
  \para* \it  Príklady.  \end 
  \eq* 
    Subst(Vt(5),5,At(Mt(Ct(2),Vt(0)),Ct(3))) = At(Mt(Ct(2),Vt(0)),Ct(3))
  \end
  \eq* 
    Subst(Mt(At(Ct(7),Vt(5)),At(Vt(5),Vt(3))),5,At(Mt(Ct(2),Vt(0)),Ct(3))) = 
    Mt(At(Ct(7),At(Mt(Ct(2),Vt(0)),Ct(3))),At(At(Mt(Ct(2),Vt(0)),Ct(3)),Vt(3)))
  \end
  \eq* 
    Subst(Mt(At(Ct(7),Vt(5)),At(Vt(5),Vt(3))),1,At(Mt(Ct(2),Vt(0)),Ct(3))) = 
    Mt(At(Ct(7),Vt(5)),At(Vt(5),Vt(3)))
  \end
  \para \it  Testovanie.  \end 
  \verbatim 
      Subst_test = r:Results_subst
  \end

fun/3 Subst 'Tex3_subst'
  Subst(s,k,t) = Foo

fun Check_subst 
  Check_subst(0) = 0
  Check_subst((s,k,t),skts) = 
  Test_case4((s,k,t),s1,
             Check(Den(s,Msub(Vs_primes,k,Den(t,Vs_primes))),Den(s1,Vs_primes)),
             Check(Sz(s1),Sz(s)+Count(k,Vars(s))*(Sz(t)-1))),Check_subst(skts) <- 
    Subst(s,k,t) = s1

fun/0 Subst_test 
  Subst_test = Check_subst(skts1++skts2++skts3++skts4++skts5) <- 
    Vt(5) = t1 & Ct(15) = t2 & At(Vt(3),Vt(1)) = t3 & Mt(Vt(3),Vt(1)) = t4 & 
    At(Mt(At(Ct(3),Vt(2)),At(Ct(5),Vt(1))),
       Mt(At(Vt(2),Ct(3)),At(Vt(2),Vt(1)))) = t5 & At(t5,Vt(3)) = t11 & 
    (t1,0,t3),(t1,5,t3),0 = skts1 & (t2,0,t3),(t2,15,t3),0 = skts2 & 
    (t3,1,t1),(t3,1,t2),(t3,1,t3),(t3,1,t4),(t3,3,t1),(t3,3,t2),(t3,3,t3),
    (t3,3,t4),0 = skts3 & 
    (t4,1,t1),(t4,1,t2),(t4,1,t3),(t4,1,t4),(t4,3,t1),(t4,3,t2),(t4,3,t3),
    (t4,3,t4),0 = skts4 & 
    (t5,2,t1),(t5,2,t2),(t5,2,t3),(t5,2,t4),(t5,2,t5),0 = skts5

