mod Ex08b


loc rem 
  \para \bf  8. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2014/2015  \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex08.zip 

loc rem 
  \para* \it  Dátum:  \end 22. 4. 2015 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.21  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované binárnym
  stromom (ex08a), binárnym vyhľadávacím stromom (ex08b) a číslovaniu
  vrcholov v binárnych stromoch (ex08c).

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2014/2015. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2015.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 


incl Maux08

incl Mtesting08

incl Maux08bc

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  15.4. Binárne vyhľadávacie stromy  \end 

rem 
  \para \bf  \it  Definícia.  \end  \end Binárny strom \ft t \end je \it  
  vyhľadávací  \end, ak pre každý jeho podstrom \ft Nd(x,l,r) \end platí, 
  že prvky nachádzajúce sa v ľavom dieťati \ft l \end sú menšie ako 
  \ft x \end a prvky nachádzajúce sa v pravom dieťati \ft r \end sú 
  väčšie ako \ft x \end. 
  \para Vlastnosť „ \ft t \end je binárnym vyhľadávacím stromom“ budeme 
  označovať predikátom \ft Bst(t) \end. Výsledkom nasledujúcich dvoch úloh 
  je rekurzívna definícia tohto predikátu. 

rem 
  \para \bf  \it  Príklad.  \end  \end Nasledujúci binárny strom \ft T1 \end 
  je vyhľadávací. 

fun/0 T1 
  T1 = 
  Nd(12,Nd(5,Nd(2,Nd(0,E,E),Nd(4,Nd(3,E,E),E)),Nd(7,E,Nd(9,E,E))),
     Nd(20,Nd(15,E,E),Nd(25,Nd(22,E,E),E)))

rem 
  \para \bf  Úloha.  \end \header* pred/2 Lt  \end \header* pred/2 Gt  \end 
  Rekurziou na binárnych stromoch zadefinujte predikáty 
  \ft Tex2_equiv(Lt(a,t),Tex2_lt(a,t)) \end a 
  \ft Tex2_equiv(Gt(a,t),Tex2_gt(a,t)) \end. \header* pred/2 Lt 'Tex2_lt' \end 
  \header* pred/2 Gt 'Tex2_gt' \end Predikát \ft Lt(a,t) \end platí, ak 
  \ft a \end je menšie ako všetky hodnoty uložené v strome \ft t \end. 
  Predikát \ft Gt(a,t) \end platí, ak \ft a \end je väčšie ako všetky 
  hodnoty uložené v strome \ft t \end. 
  \para Špecifikácia: 
  \eq* 
    Bt(t) -> Lt(a,t) <-> \a x(Inbt(x,t) -> a < x)
  \end
  \eq* 
    Bt(t) -> Gt(a,t) <-> \a x(Inbt(x,t) -> a > x)
  \end
  \para* Testovanie: 
  \verbatim 
      Lt_test = r:Results
      Gt_test = r:Results
  \end

pred/2 Lt 'Tex2_lt'
  Lt(a,t) <- Quux

pred/2 Gt 'Tex2_gt'
  Gt(a,t) <- Quux

fun/2 Lt_ 'Tex2_lt_'
  Lt_(a,t) = 0 <- ~Lt(a,t)
  Lt_(a,t) = 1 <- Lt(a,t)

fun/2 Gt_ 'Tex2_gt_'
  Gt_(a,t) = 0 <- ~Gt(a,t)
  Gt_(a,t) = 1 <- Gt(a,t)

fun/0 Lt_test 
  Lt_test = 
  Check(Lt_(0,E),1),Check(Lt_(5,E),1),Check(Lt_(1,t3),1),Check(Lt_(3,t3),0),
  Check(Lt_(5,t3),0),Check(Lt_(0,t4),1),Check(Lt_(1,t4),1),Check(Lt_(2,t4),0),
  Check(Lt_(3,t4),0),Check(Lt_(4,t4),0),Check(Lt_(5,t4),0),0 <- 
    Nd(3,E,E) = t3 & Nd(4,Nd(3,E,E),Nd(3,Nd(2,E,E),E)) = t4

fun/0 Gt_test 
  Gt_test = 
  Check(Gt_(0,E),1),Check(Gt_(5,E),1),Check(Gt_(1,t3),0),Check(Gt_(3,t3),0),
  Check(Gt_(5,t3),1),Check(Gt_(0,t4),0),Check(Gt_(2,t4),0),Check(Gt_(4,t4),0),
  Check(Gt_(5,t4),1),Check(Gt_(6,t4),1),0 <- 
    Nd(3,E,E) = t3 & Nd(1,Nd(2,E,E),Nd(3,Nd(4,E,E),E)) = t4

rem 
  \para \bf  Úloha.  \end Zadefinujte predikát \ft Bst(t) \end, ktorý platí, 
  keď \ft t \end je binárnym vyhľadávacím stromom. Predikát pomocou 
  rekurzie na binárnych stromoch overí vyhľadávaciu vlastnosť v každom 
  podstrome stromu \ft t \end. Použite predikáty \ft Lt(a,t) \end a 
  \ft Gt(a,t) \end z predchádzajúcej úlohy. 
  \para Pozitívne príklady: \ft Bst(E) \end, \ft Bst Nd(5,E,E) \end, 
  \ft Bst(T1) \end. 
  \para Negatívne príklady: \ft ~Bst Nd(2,Nd(2,E,E),Nd(4,E,E)) \end, 
  \ft ~Bst Nd(6,Nd(2,Nd(3,E,E),Nd(5,E,E)),Nd(9,Nd(7,E,E),Nd(8,E,E))) \end. 
  \para* Testovanie: 
  \verbatim 
      Bst_test = r:Results
  \end

pred Bst 
  Bst(t) <- Quux

fun Bst_ 
  Bst_(t) = 0 <- ~Bst(t)
  Bst_(t) = 1 <- Bst(t)

fun/0 Bst_test 
  Bst_test = 
  Check(Bst_(E),1),Check(Bst_ Nd(7,E,E),1),Check(Bst_(t2),0),Check(Bst_(t3),1),
  Check(Bst_ Nd(3,Nd(1,E,E),E),1),
  Check(Bst_ Nd(6,t2,Nd(9,Nd(7,E,E),Nd(8,E,E))),0),
  Check(Bst_ Nd(6,t3,Nd(8,Nd(7,E,E),Nd(9,E,E))),1),
  Check(Bst_ Nd(6,t3,Nd(8,Nd(4,E,E),Nd(9,E,E))),0),0 <- 
    Nd(2,Nd(3,E,E),Nd(5,E,E)) = t2 & Nd(3,Nd(2,E,E),Nd(5,E,E)) = t3

rem 
  \para \bf  Úloha.  \end \header* pred/2 Inbst  \end Zadefinujte predikát 
  \ft Tex2_equiv(Inbst(a,t),Tex2_inbst(a,t)) \end, ktorý platí, ak \ft a \end 
  je hodnotou uloženou v binárnom vyhľadávacom strome. 
  \para \header* pred/2 Inbst 'Tex2_inbst' \end Napríklad \ft Inbst(4,T1) \end 
  a \ft ~Inbst(6,T1) \end. 
  \para Špecifikácia: 
  \eq* 
    Bst(t) -> Inbst(a,t) <-> Inbt(a,t)
  \end
  \para Využite (ale netestujte ani nijak nezabezpečujte), že \ft t \end je 
  vyhľadávací strom. Pri vyhľadávaní prvku stačí prejsť jedinú cestu 
  v strome, na ktorej sa môže nachádzať. 
  \para* Testovanie: 
  \verbatim 
      Inbst_test = r:Results
  \end

pred/2 Inbst 'Tex2_inbst'
  Inbst(a,t) <- Quux

fun/2 Inbst_ 'Tex2_inbst_'
  Inbst_(a,t) = 0 <- ~Inbst(a,t)
  Inbst_(a,t) = 1 <- Inbst(a,t)

fun/0 Inbst_test 
  Inbst_test = 
  Check(Inbst_(6,E),0),Check(Inbst_(0,E),0),Check(Inbst_(6,Nd(5,E,E)),0),
  Check(Inbst_(6,Nd(6,E,E)),1),Check(Inbst_(6,Nd(7,E,E)),0),
  Check(Inbst_(0,Nd(7,Nd(0,E,E),E)),1),Check(Inbst_(6,t6),1),
  Check(Inbst_(2,t6),1),Check(Inbst_(5,t6),1),Check(Inbst_(8,t6),1),
  Check(Inbst_(9,t6),1),Check(Inbst_(0,t6),0),Check(Inbst_(4,t6),0),
  Check(Inbst_(10,t6),0),0 <- 
    Nd(6,Nd(3,Nd(2,E,E),Nd(5,E,E)),Nd(8,Nd(7,E,E),Nd(9,E,E))) = t6

rem 
  \para \bf  Úloha.  \end \header* fun/2 Insert  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Insert(t,a),Tex2_insert(t,a)) \end, ktorá vloží hodnotu 
  \ft a \end do binárneho vyhľadávacieho stromu \ft t \end. 
  \para Špecifikácia: \header* fun/2 Insert 'Tex2_insert' \end 
  \eq* 
    Bst(t) -> Bst Insert(t,a)
  \end
  \eq* 
    Bst(t) -> Inbst(x,Insert(t,a)) <-> x = a \/ Inbst(x,t)
  \end
  \para Nepoužite žiadne pomocné funkcie ani predikáty (ani \ft Bst(t) \end 
  a \ft Inbst(a,t) \end). Pri vynáraní z rekurzie je potrebné strom 
  zrekonštruovať. 
  \para* Testovanie: 
  \verbatim 
      Insert_test = r:Results_bt
  \end

fun/2 Insert 'Tex2_insert'
  Insert(t,a) = Foo

fun/0 Insert_test 
  Insert_test = 
  Check(Insert(E,6),Nd(6,E,E)),Check(Insert(Nd(6,E,E),6),Nd(6,E,E)),
  Check(Insert(Nd(6,E,E),5),Nd(6,Nd(5,E,E),E)),
  Check(Insert(Nd(6,E,E),7),Nd(6,E,Nd(7,E,E))),Check(Insert(t60,80),t60),
  Check(Insert(t60,0),
        Nd(60,Nd(30,Nd(20,Nd(0,E,E),E),Nd(50,E,E)),Nd(80,Nd(70,E,E),Nd(90,E,E)))),
  Check(Insert(t60,75),
        Nd(60,Nd(30,Nd(20,E,E),Nd(50,E,E)),Nd(80,Nd(70,E,Nd(75,E,E)),Nd(90,E,E)))),
  Check(Insert(t60,100),
        Nd(60,Nd(30,Nd(20,E,E),Nd(50,E,E)),
           Nd(80,Nd(70,E,E),Nd(90,E,Nd(100,E,E))))),0 <- 
    Nd(60,Nd(30,Nd(20,E,E),Nd(50,E,E)),Nd(80,Nd(70,E,E),Nd(90,E,E))) = t60

rem 
  \para \bf  \it  Zmazanie prvku z binárneho vyhľadávacieho stromu.  \end 
   \end \header* fun/2 Delete  \end \header* fun/2 Join  \end Proces 
  vymazávania hodnoty \ft a \end z binárneho vyhľadávacieho stromu 
  \ft t \end sme opísali na prednáške. V nasledujúcich úlohách ho 
  naprogramujeme ako rekurzívnu funkciu 
  \ft Tex2_equiv(Delete(t,a),Tex2_delete(t,a)) \end. Použijeme pri tom dve 
  pomocné funkcie: 
  \items 
   \item \para Funkcia \ft Extract_max(t) \end vyberie z binárneho 
         vyhľadávacieho stromu jeho maximum. 
   \item \para Funkcia \ft Tex2_equiv(Join(s,t),Tex2_join(s,t)) \end spojí 
         stromy \ft s \end a \ft t \end, ktoré sú ľavým a pravým dieťaťom 
         vymazávaného uzla, do nového binárneho vyhľadávacieho stromu. 
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Extract_max(t) \end, ktorá 
  pre neprázdny binárny vyhľadávací strom \ft t \end vráti dvojicu 
  \ft m,t1 \end, kde 
  \items 
   \item \para \ft m \end je maximálna hodnota uložená v strome \ft t \end, 
   \item \para \ft t1 \end je binárny vyhľadávací strom, ktorý obsahuje 
         rovnaké hodnoty ako \ft t \end okrem \ft m \end. 
  \end
  \para Špecifikácia: 
  \eq* 
    Bst(t) & t != E -> \e m\e t1(Extract_max(t) = m,t1 & Inbst(m,t) & Bst(t1))
  \end
  \eq* 
    Bst(t) & Extract_max(t) = m,t1 & Inbst(x,t) -> x <= m
  \end
  \eq* 
    Bst(t) & Extract_max(t) = m,t1 -> Inbst(x,t1) <-> x != m & Inbst(x,t)
  \end
  \para Nepoužite žiadne pomocné funkcie. Výsledok rekurzívneho volania je 
  pred použitím potrebné rozdeliť na zložky \ft m \end a \ft t1 \end 
  podobne ako pri tuplingových funkciách v predchádzajúcich cvičeniach. 
  \para* Testovanie: 
  \verbatim 
      Extract_max_test = r:Results_n_bt
  \end

fun Extract_max 
  Extract_max(t) = Foo,Foo

fun/0 Extract_max_test 
  Extract_max_test = 
  Check(Extract_max Nd(6,E,E),6,E),
  Check(Extract_max Nd(7,Nd(6,E,E),E),7,Nd(6,E,E)),
  Check(Extract_max Nd(1,E,Nd(2,E,E)),2,Nd(1,E,E)),
  Check(Extract_max Nd(5,Nd(2,E,E),Nd(8,E,E)),8,Nd(5,Nd(2,E,E),E)),
  Check(Extract_max(T1),25,
        Nd(12,Nd(5,Nd(2,Nd(0,E,E),Nd(4,Nd(3,E,E),E)),Nd(7,E,Nd(9,E,E))),
           Nd(20,Nd(15,E,E),Nd(22,E,E)))),0

rem 
  \para \bf  \it  Porovnanie všetkých hodnôt v dvoch binárnych stromoch. 
   \end  \end Nasledujúci predikát platí, ak sú všetky hodnoty v binárnom 
  strome \ft s \end menšie ako všetky hodnoty v binárnom strome \ft t \end. 
  Definícia s kvantifikátormi sa nedá vyhodnotiť, predikát slúži iba na 
  špecifikáciu nasledujúcej funkcie \ft Join \end. 

pred/2 Ltb 'Tex2_ltb'
  Ltb(s,t) <-> \a x\a y(Inbt(x,s) & Inbt(y,t) -> x < y)

rem 
  \para Všimite si, že platí 
  \eq* 
    Bst Nd(x,l,r) -> Ltb(l,r)
  \end

rem 
  \para \bf  Úloha.  \end \header* fun/2 Join  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Join(s,t),Tex2_join(s,t)) \end, ktorá spojí dve bývalé deti 
  uzla v binárnom vyhľadávacom strome do jedného binárneho 
  vyhľadávacieho stromu. 
  \para Ak sú \it  oba  \end stromy neprázdne, funkcia vytvorí nový strom 
  využitím výsledkov funkcie \ft Extract_max \end. 
  \para Ak je \ft s \end prázdny funkcia vráti \ft t \end. Ak je \ft s \end 
  neprázdny a \ft t \end prázdny, funkcia vráti \ft s \end. 
  \para \header* fun/2 Join 'Tex2_join' \end Špecifikácia: 
  \eq* 
    Bst(s) & Bst(t) & Ltb(s,t) -> Bst Join(s,t)
  \end
  \eq* 
    Bst(s) & Bst(t) & Ltb(s,t) -> 
    \a x(Inbst(x,Join(s,t)) <-> Inbst(x,s) \/ Inbst(x,t))
  \end
  \para Použite iba funkciu \ft Extract_max \end. Nie je potrebná rekurzia. 
  \para* Testovanie: 
  \verbatim 
      Join_test = r:Results_bt
  \end

fun/2 Join 'Tex2_join'
  Join(s,t) = Foo

fun/0 Join_test 
  Join_test = 
  Check(Join(E,Nd(5,E,E)),Nd(5,E,E)),Check(Join(Nd(5,E,E),E),Nd(5,E,E)),
  Check(Join(Nd(4,E,E),Nd(5,E,E)),Nd(4,E,Nd(5,E,E))),
  Check(Join(Nd(1,Nd(0,E,E),Nd(2,E,Nd(4,Nd(3,E,E),E))),Nd(5,E,E)),
        Nd(4,Nd(1,Nd(0,E,E),Nd(2,E,Nd(3,E,E))),Nd(5,E,E))),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Delete  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Delete(t,a),Tex2_delete(t,a)) \end, ktorá zmaže hodnotu 
  \ft a \end z binárneho vyhľadávacieho stromu \ft t \end. 
  \para \header* fun/2 Delete 'Tex2_delete' \end Špecifikácia: 
  \eq* 
    Bst(t) -> Bst Delete(t,a)
  \end
  \eq* 
    Bst(t) -> Inbst(x,Delete(t,a)) <-> x != a & Inbst(x,t)
  \end
  \para Použite iba rekurziu a funkciu \ft Join(s,t) \end. 
  \para* Testovanie: 
  \verbatim 
      Delete_test = r:Results_bt
  \end

fun/2 Delete 'Tex2_delete'
  Delete(t,a) = Foo

fun/0 Delete_test 
  Delete_test = 
  Check(Delete(E,6),E),Check(Delete(Nd(6,E,E),6),E),
  Check(Delete(Nd(5,E,E),6),Nd(5,E,E)),Check(Delete(Nd(7,E,E),6),Nd(7,E,E)),
  Check(Delete(Nd(2,Nd(1,E,E),Nd(3,E,E)),2),Nd(1,E,Nd(3,E,E))),
  Check(Delete(Nd(7,Nd(6,Nd(5,E,E),E),E),5),Nd(7,Nd(6,E,E),E)),
  Check(Delete(Nd(7,Nd(6,Nd(5,E,E),E),E),6),Nd(7,Nd(5,E,E),E)),
  Check(Delete(Nd(1,E,Nd(2,E,Nd(3,E,E))),3),Nd(1,E,Nd(2,E,E))),
  Check(Delete(Nd(1,E,Nd(2,E,Nd(3,E,E))),2),Nd(1,E,Nd(3,E,E))),
  Check(Delete(T1,5),
        Nd(12,Nd(4,Nd(2,Nd(0,E,E),Nd(3,E,E)),Nd(7,E,Nd(9,E,E))),
           Nd(20,Nd(15,E,E),Nd(25,Nd(22,E,E),E)))),0

