mod Ex07b


loc rem 
  \para \bf  7. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2014/2015  \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex07.zip 

loc rem 
  \para* \it  Dátum:  \end 15. 4. 2015 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.21  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované 
  kombinatorickým úlohám na zoznamoch, teda rôznym druhom podzoznamov 
  daného zoznamu a generovaniu všetkých podzoznamov daného druhu. 
  Preskúmame súvislé úseky ( \it  ex07a  \end) a podpostupnosti 
  a permutácie ( \it  ex07b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2014/2015. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2015.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 


incl Maux07

incl Mtesting07

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  14. KOMBINATORICKÉ FUNKCIE NA ZOZNAMOCH  \end 

rem 
  \para \bf  \it  Pridanie znaku na začiatok viacerých reťazcov.  \end  \end 
  \header* fun/2 Map_pair  \end Funkcia \ft Map_pair(a,xss) \end z časti A 
  pridá prvok \ft a \end na začiatok každého zoznamu v zozname zoznamov 
  \ft xss \end (znak \ft a \end na začiatok každého reťazca v zozname 
  reťazcov \ft xss \end). 
  \eq* 
    ys in Map_pair(a,xss) <-> \e xs(ys = Paren(a,xs) & xs in xss)
  \end
  \eq* 
    Ch(a) & Lstr(xss) -> Lstr Map_pair(a,xss)
  \end

fun/2 Map_pair 
  Map_pair(a,0) = 0
  Map_pair(a,xs,xss) = (a,xs),Map_pair(a,xss)

rem 
  \para \bf  14.2. Vybrané podpostupnosti  \end 

rem 
  \para \bf  \it  Vybraná podpostupnosť.  \end  \end 
  \header* pred/2 Subseq  \end Predikát 
  \ft Tex2_equiv(Subseq(ys,xs),Tex2_subseq(ys,xs)) \end platí práve vtedy, 
  keď zoznam \ft ys \end je \it  vybranou podpostupnosťou  \end zoznamu 
  \ft xs \end. To znamená, že \ft ys \end vznikne vynechaním niektorých 
  prvkov zo zoznamu \ft xs \end (aj žiadnych alebo všetkých). Vzájomné 
  poradie zostávajúcich prvkov sa nezmení. 
  \para Presnejšie, zoznam \ft ys \end je vybranou podpostupnosťou zoznamu 
  \ft xs = x1,x2,Tex0_ldots,Tex2_varidx(x,n),0 \end, ak 
  \eq* 
    ys = Tex2_varidx(x,i1),Tex0_ldots,Tex2_varidx(x,Tex2_varidx(i,k)),0
  \end
  \para pre nejakú rastúcu postupnosť \ft i1 \end, \ft i2 \end, 
  \ft Tex0_ldots \end, \ft Tex2_varidx(i,k) \end indexov prvkov zoznamu 
  \ft xs \end, teda 
  \ft Tex2_le(1,
              Tex2_lt(i1,Tex2_lt(i2,Tex2_lt(Tex0_cdots,Tex2_le(Tex2_varidx(i,k),n))))) \end. 
  \para Formálne sa vzťah vybranej podpostupnosti k pôvodnému zoznamu dá 
  vyjadriť pomocou funkcií dĺžka zoznamu ( \ft L(xs) \end) a indexovania ( 
  \ft Sub(xs,i) \end) z 5. cvičenia a predikátu \ft Set \end zo 
  6. cvičenia nasledovne: 

pred/2 Subseq 'Tex2_subseq'
  Subseq(ys,xs) <-> 
    \e is(Set(is) & L(ys) = L(is) & 
          \a i(i < L(is) -> Sub(is,i) < L(xs) & Sub(ys,i) = Sub(xs,Sub(is,i))))

rem 
  \para Napríklad 
  \eq* 
    Subseq('','vsetko')
  \end
  \eq* 
    Subseq('veko','vsetko')
  \end
  \eq* 
    Subseq('vsetko','vsetko')
  \end
  \eq* 
    ~Subseq('svet','vsetko')
  \end
  \eq* 
    ~Subseq('sito','vsetko')
  \end
  \para Iné vyjadrenie využíva zreťazenie a rekurziu: 
  \eq* 
    Subseq(ys,xs) <-> 
    \a xs1\a a\a xs2(xs = xs1++(a,xs2) -> 
                     \e ys1\e ys2(Subseq(ys1,xs1) & Subseq(ys2,xs2) & 
                                  (ys = ys1++(a,ys2) \/ ys = ys1++ys2))) & 
    (xs = 0 -> ys = 0)
  \end
  \para Neformálne: Pre každý prvok \ft a \end v \ft xs \end, pred ktorým sa 
  nachádzajú prvky \ft xs1 \end a za ktorým sa nachádzajú prvky 
  \ft xs2 \end, sa podpostupnosť \ft ys \end dá rozdeliť na začiatočný 
  úsek \ft ys1 \end, ktorý je podpostuposťou \ft xs1 \end, a koncový úsek 
  \ft ys2 \end, ktorý je podpostuposťou \ft xs2 \end, pričom medzi týmito 
  úsekmi sa môže nachádzať \ft a \end. Ak je \ft xs \end prázdny, je 
  prázdna aj jeho podpostupnosť \ft ys \end. 
  \para Toto vyjadrenie síce nie je vypočítateľné, ale môžeme z neho 
  ľahšie odvodiť pomôcku pre nájdenie funkcie vytvárajúcej zoznam 
  všetkých vybraných podpostupností. 
  \para Konkrétne, v nasledujúcej úlohe využijeme, že 
  \items 
   \item \para jedinou vybranou podpostupnosťou prázdneho zoznamu je prázdny 
         zoznam: 
         \eq (Subseq_zero)
           Subseq(ys,0) <-> ys = 0
         \end
   \item \para vybranými podpostupnosťami neprázdneho zoznamu \ft x,xs \end 
         sú 
         \para a) všetky zoznamy \ft x,zs \end, kde \ft zs \end je vybranou 
         podpostupnosťou zoznamu \ft xs \end, 
         \para b) všetky podpostupnosti zoznamu \ft xs \end, 
         \para* teda 
         \eq (Subseq_pair)
           Subseq(ys,Paren(x,xs)) <-> 
           \e zs(ys = Paren(x,zs) & Subseq(zs,xs)) \/ Subseq(ys,xs)
         \end
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Subseqs(xs) \end, ktorej 
  hodnotou je \it  zoznam všetkých vybraných podpostupností  \end zoznamu 
  (reťazca) \ft xs \end. Funkciu zadefinujte zoznamovou rekurziou. Využite 
  vlastnosti vybraných podpostupností z predchádzajúcej poznámky 
  a funkciu \ft Map_pair \end. 
  \para* Špecifikácia: 
  \eq* 
    ys in Subseqs(xs) <-> Subseq(ys,xs)
  \end
  \eq* 
    Str(xs) -> Lstr Subseqs(xs)
  \end
  \para* Napríklad: 
  \def* 
    Subseqs('ak') = 'ak','a','k','',0
    Subseqs('tak') = 'tak','ta','tk','t','ak','a','k','',0
  \end
  \para Na poradí reťazcov vo výslednom zozname nezáleží. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Subseqs_test = r:Results_lstr
  \end

fun Subseqs 
  Subseqs(xs) = Foo

fun/0 Subseqs_test 
  Subseqs_test = 
  Check_lext(Subseqs(''),'',0),Check_lext(Subseqs('y'),'y','',0),
  Check_lext(Subseqs('ak'),'ak','a','k','',0),
  Check_lext(Subseqs('tak'),'tak','ta','tk','t','ak','a','k','',0),0

rem 
  \para \bf  14.3. Permutácie  \end 

rem 
  \para \bf  \it  Permutácia.  \end  \end \header* pred/2 Perm 'Tex2_perm' \end 
  Predikát \ft Perm(xs,ys) \end ([1, 6. prednáška], cvičenie ex06a) platí 
  práve vtedy, keď zoznam \ft xs \end je permutáciou zoznamu \ft ys \end. 

pred/2 Perm 'Tex2_perm'
  Perm(xs,ys) <-> \a a Count(a,xs) = Count(a,ys)

rem 
  \para Cieľom nasledujúcich úloh je zadefinovať funkciu \ft Perms(xs) \end, 
  ktorej hodnotou je zoznam všetkých permutácií zoznamu \ft xs \end. Aby sme 
  našli definíciu \ft Perms(xs) \end zoznamovou rekurziou, potrebujeme 
  vyjadriť permutácie zoznamu \ft x,xs \end pomocou permutácií zoznamu 
  \ft xs \end. 

rem 
  \para \bf  \it  Vsunutie prvku do zoznamu.  \end  \end 
  \header* pred/3 Insertion  \end Predikát 
  \ft Tex2_equiv(Insertion(ys,xs,a),Tex3_insertion(ys,xs,a)) \end platí práve 
  vtedy, keď zoznam \ft ys \end vznikne vsunutím prvku \ft a \end do zoznamu 
  \ft xs \end: 

pred/3 Insertion 'Tex3_insertion'
  Insertion(ys,xs,a) <-> \e us\e vs(xs = us++vs & ys = us++(a,vs))

rem 
  \para Vlastnosti predikátu \ft Insertion \end: 
  \items 
   \item \para Vsunutím \ft a \end do prázdneho zoznamu vznikne práve jeden 
         jednoprvkový zoznam \ft Paren(a,0) \end: 
         \eq (Insertion_zero)
           Insertion(ys,0,a) <-> ys = Paren(a,0)
         \end
   \item \para Vsunutím \ft a \end do zoznamu \ft Paren(x,xs) \end vznikne 
         zoznam \ft Paren(a,x,xs) \end (vsunutie na začiatok), alebo zoznam 
         začínajúci prvkom \ft x \end a pokračujúci niektorým vsunutím 
         \ft a \end do \ft xs \end: 
         \eq (Insertion_pair)
           Insertion(ys,Paren(x,xs),a) <-> 
           ys = Paren(a,x,xs) \/ \e zs(ys = Paren(x,zs) & Insertion(zs,xs,a))
         \end
  \end

rem 
  \para \bf  Úloha.  \end \header* fun/2 Interleave  \end Zadefinujte funkciu 
  \ft Interleave(a,xs) \end, ktorej hodnotou je zoznam všetkých vsunutí prvku 
  (znaku) \ft a \end do zoznamu (reťazca) \ft xs \end. Využite vlastnosti 
  (Insertion_zero) a (Insertion_pair). 
  \para* Špecifikácia: 
  \eq* 
    ys in Interleave(a,xs) <-> Insertion(ys,xs,a)
  \end
  \eq* 
    Ch(a) & Str(xs) -> Lstr Interleave(a,xs)
  \end
  \para* Napríklad: 
  \def* 
    Interleave("#",'') = '#',0
    Interleave("#",'ak') = '#ak','a#k','ak#',0
    Interleave("#",'tak') = '#tak','t#ak','ta#k','tak#',0
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Interleave_test = r:Results_lstr
  \end

fun/2 Interleave 
  Interleave(a,xs) = Foo

fun/0 Interleave_test 
  Interleave_test = 
  Check_lext(Interleave("#",''),'#',0),Check_lext(Interleave("#",'y'),'#y','y#',0),
  Check_lext(Interleave("#",'ak'),'#ak','a#k','ak#',0),
  Check_lext(Interleave("#",'tak'),'#tak','t#ak','ta#k','tak#',0),0

rem 
  \para \bf  Úloha. Vsunutie prvku do viacerých zoznamov.  \end 
  \header* fun/2 Conc_map_i  \end Zadefinujte funkciu 
  \ft Conc_map_i(a,xss) \end, ktorej hodnotou je zoznam všetkých vsunutí 
  prvku (znaku) \ft a \end do všetkých zoznamov (reťazcov) v \ft xss \end. 
  Použite funkciu \ft Interleave \end a zreťazenie. 
  \para Špecifikácia: 
  \eq* 
    ys in Conc_map_i(a,xss) <-> \e xs(xs in xss & Insertion(ys,xs,a))
  \end
  \eq* 
    Ch(a) & Lstr(xss) -> Lstr Conc_map_i(a,xss)
  \end
  \para* Napríklad: 
  \eq* 
    Tex2_eq(Conc_map_i("#",Paren('tak','','@',0)),
            Tex2_eq(('#tak','t#ak','ta#k','tak#',0)++('#',0)++('#@','@#',0),'#tak','t#ak','ta#k',
                    'tak#','#','#@','@#',0))
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Conc_map_i_test = r:Results_lstr
  \end

fun/2 Conc_map_i 
  Conc_map_i(a,xss) = Foo

fun/0 Conc_map_i_test 
  Conc_map_i_test = 
  Check_lext(Conc_map_i("#",0),0),
  Check_lext(Conc_map_i("*",Paren('2x',0)),'*2x','2*x','2x*',0),
  Check_lext(Conc_map_i("#",Paren('tak','','@',0)),'#tak','t#ak','ta#k','tak#','#','#@','@#',0),0

rem 
  \para \bf  \it  Rekurzívne vlastnosti permutácií.  \end  \end Pomocou 
  predikátu \ft Insertion \end môžeme vyjadriť vlastnosti permutácií, 
  ktoré nám pomôžu pri rekurzívnej definícii funkcie, ktorá vytvorí ich 
  zoznam. Platí: 
  \items 
   \item \para jedinou permutáciou prázdneho zoznamu je prázdny zoznam: 
         \eq (Perm_zero)
           Perm(ys,0) <-> ys = 0
         \end
   \item \para každá permutácia neprázdneho zoznamu \ft x,xs \end vznikne 
         vsunutím prvku \ft x \end do niektorej permutácie zoznamu 
         \ft xs \end: 
         \eq (Perm_pair)
           Perm(ys,Paren(x,xs)) <-> \e zs(Insertion(ys,zs,x) & Perm(zs,xs))
         \end
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Perms(xs) \end, ktorej 
  hodnotou je zoznam všetkých permutácií zoznamu (reťazca) \ft xs \end. 
  Funkciu zadefinujte zoznamovou rekurziou. Využite vlastnosti 
  permutácií z predchádzajúcej poznámky a funkciu \ft Conc_map_i \end. 
  \para* Napríklad: 
  \def* 
    Perms('ak') = 'ak','ka',0
    Perms('tak') = 'tak','atk','akt','tka','kta','kat',0
  \end
  \para Na poradí reťazcov vo výslednom zozname nezáleží. 
  \para* Špecifikácia: 
  \eq* 
    ys in Perms(xs) <-> Perm(ys,xs)
  \end
  \eq* 
    Str(xs) -> Lstr Perms(xs)
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Perms_test = r:Results_lstr
      Perms('Perms') = pss:Lstr & L(pss) = n
  \end

fun Perms 
  Perms(xs) = Foo

fun/0 Perms_test 
  Perms_test = 
  Check_lext(Perms(''),'',0),Check_lext(Perms('k'),'k',0),Check_lext(Perms('ak'),'ak','ka',0),
  Check_lext(Perms('tak'),'tak','atk','akt','tka','kta','kat',0),0

