mod Ex06b


rem 
  \para \bf  6. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2014/2015  \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex06.zip 

loc rem 
  \para* \it  Dátum:  \end 8. 4. 2015 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.21  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované triedeniu 
  zoznamov ( \it  ex06a  \end) a reprezentácii konečných množín 
  usporiadanými zoznamami bez opakovania ( \it  ex06b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2014/2015. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2015.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 


incl Mtesting06

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

pred/0 Quux 'Tex0_foo'
  Quux <-> \f

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/2 Tex2_cdots
  Op(Ent('ctdot'),0)

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,0,Op(Ent('equiv'),0),Arg(1))

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

appldisp/2 Tex2_member
  Infix(Arg(0),15,0,Op(Ent('isin'),0),Arg(1))

appldisp/2 Tex2_member_
  Infix(Arg(0),25,0,Subsup(Op(Ent('isin'),0),75,Op(Ent('ast'),0),None),Arg(1))

appldisp/2 Tex2_insert
  Infix(Arg(0),35,1,Op(Ent('cup'),0),Fenced(Op('{',0),Arg(1),Op('}',0)))

appldisp/2 Tex2_delete
  Infix(Arg(0),35,1,Op(Ent('setmn'),0),Fenced(Op('{',0),Arg(1),Op('}',0)))

appldisp/2 Tex2_union
  Infix(Arg(0),35,1,Op(Ent('cup'),0),Arg(1))

appldisp/2 Tex2_inter
  Infix(Arg(0),35,1,Op(Ent('cap'),0),Arg(1))

appldisp/2 Tex2_diff
  Infix(Arg(0),35,1,Op(Ent('setmn'),0),Arg(1))

appldisp/2 Tex2_sdiff
  Infix(Arg(0),35,1,Op(Ent('triangle'),0),Arg(1))

appldisp/2 Tex2_subset
  Infix(Arg(0),15,0,Op(Ent('sube'),0),Arg(1))

appldisp/2 Tex2_subset_
  Infix(Arg(0),25,0,Subsup(Op(Ent('sube'),0),75,Op(Ent('ast'),0),None),Arg(1))

appldisp/2 Tex2_image
  Prefix(89,0,Arg(0),Fenced(Op('[',0),Arg(1),Op(']',0)))

appldisp/2 Tex2_composition
  Infix(Arg(0),45,0,Op(Ent('compfn'),0),Arg(1))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  13. ZOZNAMOVÁ REPREZENTÁCIA KONEČNÝCH MNOŽÍN  \end 

rem 
  \para \bf  \it  Reprezentácia množín usporiadanými zoznamami bez 
  opakovania.  \end  \end Konečné množiny môžeme jednoducho reprezentovať 
  zoznamami. Pri množinách je dôležitá iba príslušnosť prvku do 
  množiny. Počet výskytov prvku ani poradie prvkov nie sú podstatné. 
  Množiny môžeme preto reprezentovať usporiadanými zoznamami bez opakovania 
  prvkov. Operácie na dvoch množinách potom dokážeme naprogramovať tak, 
  aby počet krokov potrebných na ich vykonanie lineárne závisel od súčtu 
  počtu prvkov v množinách. 

rem 
  \para \bf  \it  [CL] Trichotomická diskriminácia.  \end  \end 
  V nasledujúcich úlohách využijeme \it  trichotomickú  \end 
  diskrimináciu: 
  \def* 
    Tex2_cdots(s,t) <- s < t
    Tex2_cdots(s,t) <- s = t
    Tex2_cdots(s,t) <- s > t
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte predikát \ft Set(xs) \end, ktorý 
  platí, ak \ft xs \end je zoznam, ktorý reprezentuje množinu, teda 
  usporiadaný a bez opakovania. 
  \para* Definícia je podobná predikátu \ft Ord \end z ex08a. 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) <-> \a ys\a a\a b\a zs(xs = ys++(a,b,zs) -> a < b)
  \end
  \para* Testovanie: 
  \verbatim 
      Set_test = r:Results
  \end

pred Set 
  Set(xs) <- Quux

fun Set_ 
  Set_(xs) = 1 <- Set(xs)
  Set_(xs) = 0 <- ~Set(xs)

fun/0 Set_test 
  Set_test = 
  Check(Set_(0),1),Check(Set_(0,0),1),Check(Set_(0,1,0),1),Check(Set_(1,1,0),0),
  Check(Set_(0,0,1,0),0),Check(Set_(0,1,1,0),0),Check(Set_(0,1,2,0),1),
  Check(Set_(4,5,4,0),0),Check(Set_(0,2,3,4,0),1),Check(Set_(4,3,2,0,0),0),
  Check(Set_(0,2,1,3,0),0),0

rem 
  \para \bf  Úloha.  \end \header* pred/2 Member  \end Zadefinujte predikát 
  \ft Tex2_equiv(Member(a,xs),Tex2_member(a,xs)) \end, ktorý platí, ak je 
  \ft a \end prvkom množiny \ft xs \end. 
  \para* \header* pred/2 Member 'Tex2_member' \end Napríklad 
  \ft Member(4,2,4,6,8,0) \end a \ft ~Member(5,2,4,6,8,0) \end. 
  \para* Využite (ale netestujte!), že \ft xs \end je množina. Ani v jednom 
  z uvedených príkladov výpočet nesmie prejsť celý zoznam 
  \ft 2,4,6,8,0 \end. 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) -> Member(a,xs) <-> a in xs
  \end
  \para* Testovanie: 
  \verbatim 
      Member_test = r:Results
  \end

pred/2 Member 'Tex2_member'
  Member(a,xs) <- Quux

fun/2 Member_ 'Tex2_member_'
  Member_(a,xs) = 1 <- Member(a,xs)
  Member_(a,xs) = 0 <- ~Member(a,xs)

fun/0 Member_test 
  Member_test = 
  Check(Member_(0,0),0),Check(Member_(1,0),0),Check(Member_(0,0,0),1),
  Check(Member_(1,0,0),0),Check(Member_(0,0,2,0),1),Check(Member_(1,0,2,0),0),
  Check(Member_(2,0,2,0),1),Check(Member_(3,0,2,0),0),
  Check(Member_(4,2,4,6,8,0),1),Check(Member_(5,2,4,6,8,0),0),0

rem 
  \para \bf  \it  Extenzionalita.  \end  \end Všimnite si, že reprezentácia 
  množín usporiadanými zoznamami bez opakovania je jednoznačná a teda má 
  vlastnosť extenzionality: Množiny sú si rovné práve vtedy, keď majú tie 
  isté prvky. 
  \eq* 
    Set(xs) & Set(ys) -> xs = ys <-> \a a(a in xs <-> a in ys)
  \end

rem 
  \para \bf  Úloha.  \end \header* fun/2 Insert  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Insert(xs,a),Tex2_insert(xs,a)) \end, ktorá vloží prvok 
  \ft a \end do množiny \ft xs \end, teda vráti množinu, ktorá obsahuje 
  všetky prvky \ft xs \end a prvok \ft a \end. 
  \para* \header* fun/2 Insert 'Tex2_insert' \end Napríklad 
  \ft Insert((2,4,6,8,0),5) = 2,4,5,6,8,0 \end a 
  \ft Insert((2,4,6,8,0),6) = 2,4,6,8,0 \end. 
  \para* Pozor na poradie argumentov a na fakt, že v množinách sa prvky 
  neopakujú a sú usporiadané. Nepoužite žiadne pomocné funkcie ani 
  predikáty (vrátane \ft Set \end a \ft Member \end). 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) -> Set Insert(xs,a)
  \end
  \eq* 
    Set(xs) -> \a b(b in Insert(xs,a) <-> b = a \/ b in xs)
  \end
  \para* Testovanie: 
  \verbatim 
      Insert_test = r:Results
  \end

fun/2 Insert 'Tex2_insert'
  Insert(xs,a) = Foo

fun/0 Insert_test 
  Insert_test = 
  Check(Insert(0,0),0,0),Check(Insert((1,0),0),0,1,0),
  Check(Insert((1,0),2),1,2,0),Check(Insert((2,0),2),2,0),
  Check(Insert((2,4,6,8,0),5),2,4,5,6,8,0),
  Check(Insert((2,4,6,8,0),6),2,4,6,8,0),
  Check(Insert((2,4,6,8,0),10),2,4,6,8,10,0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Delete  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Delete(xs,a),Tex2_delete(xs,a)) \end, ktorá odstráni prvok 
  \ft a \end z množiny \ft xs \end, teda vráti množinu obsahujúcu všetky 
  prvky \ft xs \end okrem \ft a \end. 
  \para* \header* fun/2 Delete 'Tex2_delete' \end Napríklad 
  \ft Delete((2,4,6,8,0),6) = 2,4,8,0 \end a 
  \ft Delete((2,4,6,8,0),5) = 2,4,6,8,0 \end. 
  \para* Pozor na poradie argumentov a na fakt, že v množinách sa prvky 
  neopakujú a sú usporiadané. Nepoužite žiadne pomocné funkcie ani 
  predikáty (vrátane \ft Set \end a \ft Member \end). Ani v jednom 
  z uvedených príkladov výpočet nesmie prejsť celý zoznam 
  \ft 2,4,6,8,0 \end. 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) -> Set Delete(xs,a)
  \end
  \eq* 
    Set(xs) -> \a b(b in Delete(xs,a) <-> b != a & b in xs)
  \end
  \para* Testovanie: 
  \verbatim 
      Delete_test = r:Results
  \end

fun/2 Delete 'Tex2_delete'
  Delete(xs,a) = Foo

fun/0 Delete_test 
  Delete_test = 
  Check(Delete(0,0),0),Check(Delete((1,0),0),1,0),Check(Delete((1,0),2),1,0),
  Check(Delete((2,4,6,8,0),2),4,6,8,0),Check(Delete((2,4,6,8,0),6),2,4,8,0),
  Check(Delete((2,4,6,8,0),5),2,4,6,8,0),
  Check(Delete((2,4,6,8,0),10),2,4,6,8,0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Union  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Union(xs,ys),Tex2_union(xs,ys)) \end, ktorá zjednotí množiny 
  \ft xs \end a \ft ys \end. 
  \para* \header* fun/2 Union 'Tex2_union' \end Napríklad 
  \ft Union((2,4,8,9,10,0),1,2,3,5,6,7,9,0) = 1,2,3,4,5,6,7,8,9,10,0 \end. 
  \para* Využite (ale netestujte!), že \ft xs \end a \ft ys \end sú množiny. 
  Algoritmus pre zjednotenie je podobný zlúčeniu utriedených zoznamov, vo 
  výsledku sa však žiadny prvok nesmie opakovať. Nepoužite žiadne pomocné 
  funkcie ani predikáty (vrátane \ft Set \end a \ft Member \end). 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Set Union(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> \a a(a in Union(xs,ys) <-> a in xs \/ a in ys)
  \end
  \para* Testovanie: 
  \verbatim 
      Union_test = r:Results
  \end

fun/2 Union 'Tex2_union'
  Union(xs,ys) = Foo

fun/0 Union_test 
  Union_test = 
  Check(Union(0,3,6,0),3,6,0),Check(Union((0,9,0),0),0,9,0),
  Check(Union((4,6,0),4,5,0),4,5,6,0),Check(Union((4,5,0),4,6,0),4,5,6,0),
  Check(Union((0,9,0),3,6,0),0,3,6,9,0),Check(Union((3,6,0),0,9,0),0,3,6,9,0),
  Check(Union((2,4,8,9,10,0),1,2,3,5,6,7,9,0),1,2,3,4,5,6,7,8,9,10,0),
  Check(Union((1,2,3,5,6,7,9,0),2,4,8,9,10,0),1,2,3,4,5,6,7,8,9,10,0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Inter  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Inter(xs,ys),Tex2_inter(xs,ys)) \end, ktorá vypočíta prienik 
  množín \ft xs \end a \ft ys \end. 
  \para* \header* fun/2 Inter 'Tex2_inter' \end Napríklad 
  \ft Inter((2,4,8,9,10,0),1,2,3,5,6,7,9,0) = 2,9,0 \end. 
  \para* Využite (ale netestujte!), že \ft xs \end a \ft ys \end sú množiny. 
  Použite podobný algoritmus ako pre zjednotenie. Nepoužite žiadne pomocné 
  funkcie ani predikáty (vrátane \ft Set \end a \ft Member \end). 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Set Inter(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> \a a(a in Inter(xs,ys) <-> a in xs & a in ys)
  \end
  \para* Testovanie: 
  \verbatim 
      Inter_test = r:Results
  \end

fun/2 Inter 'Tex2_inter'
  Inter(xs,ys) = Foo

fun/0 Inter_test 
  Inter_test = 
  Check(Inter(0,3,6,0),0),Check(Inter((0,9,0),0),0),
  Check(Inter((4,6,0),4,5,0),4,0),Check(Inter((4,5,0),4,6,0),4,0),
  Check(Inter((0,1,9,0),0,3,6,9,0),0,9,0),
  Check(Inter((0,3,6,9,0),0,1,9,0),0,9,0),
  Check(Inter((2,4,8,9,10,0),1,2,3,5,6,7,9,0),2,9,0),
  Check(Inter((1,2,3,5,6,7,9,0),2,4,8,9,10,0),2,9,0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Diff  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Diff(xs,ys),Tex2_diff(xs,ys)) \end, ktorá vypočíta rozdiel 
  množín \ft xs \end a \ft ys \end. 
  \para* \header* fun/2 Diff 'Tex2_diff' \end Napríklad 
  \ft Diff((2,4,8,9,10,0),1,2,3,5,6,7,9,0) = 4,8,10,0 \end. 
  \para* Platia rovnaké obmedzenia a odporúčania ako v predošlých 
  úlohách. 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Set Diff(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> \a a(a in Diff(xs,ys) <-> a in xs & a !in ys)
  \end
  \para* Testovanie: 
  \verbatim 
      Diff_test = r:Results
  \end

fun/2 Diff 'Tex2_diff'
  Diff(xs,ys) = Foo

fun/0 Diff_test 
  Diff_test = 
  Check(Diff(0,3,6,0),0),Check(Diff((0,9,0),0),0,9,0),
  Check(Diff((4,6,0),4,5,0),6,0),Check(Diff((4,5,0),4,6,0),5,0),
  Check(Diff((0,1,9,0),0,3,6,9,0),1,0),Check(Diff((0,3,6,9,0),0,1,9,0),3,6,0),
  Check(Diff((2,4,8,9,10,0),1,2,3,5,6,7,9,0),4,8,10,0),
  Check(Diff((1,2,3,5,6,7,9,0),2,4,8,9,10,0),1,3,5,6,7,0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Sdiff  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Sdiff(xs,ys),Tex2_sdiff(xs,ys)) \end, ktorá vypočíta 
  symetrický rozdiel množín \ft xs \end a \ft ys \end. 
  \para* \header* fun/2 Sdiff 'Tex2_sdiff' \end Napríklad 
  \ft Sdiff((2,4,8,9,10,0),1,2,3,5,6,7,9,0) = 1,3,4,5,6,7,8,10,0 \end. 
  \para* Platia rovnaké obmedzenia a odporúčania ako v predošlých 
  úlohách. 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Set Sdiff(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> 
    \a a(a in Sdiff(xs,ys) <-> a in xs & a !in ys \/ a !in xs & a in ys)
  \end
  \para* Testovanie: 
  \verbatim 
      Sdiff_test = r:Results
  \end

fun/2 Sdiff 'Tex2_sdiff'
  Sdiff(xs,ys) = Foo

fun/0 Sdiff_test 
  Sdiff_test = 
  Check(Sdiff(0,3,6,0),3,6,0),Check(Sdiff((0,9,0),0),0,9,0),
  Check(Sdiff((4,6,0),4,5,0),5,6,0),Check(Sdiff((4,5,0),4,6,0),5,6,0),
  Check(Sdiff((0,1,9,0),0,3,6,9,0),1,3,6,0),
  Check(Sdiff((0,3,6,9,0),0,1,9,0),1,3,6,0),
  Check(Sdiff((2,4,8,9,10,0),1,2,3,5,6,7,9,0),1,3,4,5,6,7,8,10,0),
  Check(Sdiff((1,2,3,5,6,7,9,0),2,4,8,9,10,0),1,3,4,5,6,7,8,10,0),0

rem 
  \para \bf  Úloha.  \end \header* pred/2 Subset  \end Zadefinujte predikát 
  \ft Tex2_equiv(Subset(xs,ys),Tex2_subset(xs,ys)) \end, ktorý platí, ak 
  \ft xs \end je podmnožinou \ft ys \end. 
  \para* \header* pred/2 Subset 'Tex2_subset' \end Napríklad 
  \ft Subset((2,4,8,9,10,0),1,2,3,4,5,6,7,8,9,10,0) \end a 
  \ft ~Subset((2,4,8,9,10,0),2,4,6,8,10,0) \end. 
  \para* Platia rovnaké obmedzenia a odporúčania ako v predošlých 
  úlohách. 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Subset(xs,ys) <-> \a a(a in xs -> a in ys)
  \end
  \para* Testovanie: 
  \verbatim 
      Subset_test = r:Results
  \end

pred/2 Subset 'Tex2_subset'
  Subset(xs,ys) <- Quux

fun/2 Subset_ 'Tex2_subset_'
  Subset_(a,xs) = 1 <- Subset(a,xs)
  Subset_(a,xs) = 0 <- ~Subset(a,xs)

fun/0 Subset_test 
  Subset_test = 
  Check(Subset_(0,0),1),Check(Subset_(0,1,3,5,0),1),Check(Subset_((0,0),0),0),
  Check(Subset_((5,0),0),0),Check(Subset_((5,0),3,5,7,0),1),
  Check(Subset_((6,0),3,5,7,0),0),
  Check(Subset_((2,4,8,9,10,0),1,2,3,4,5,6,7,8,9,10,0),1),
  Check(Subset_((1,2,3,4,5,6,7,8,9,10,0),2,4,8,9,10,0),0),
  Check(Subset_((2,4,8,9,10,0),2,4,6,8,10,0),0),
  Check(Subset_((2,4,6,8,10,0),2,4,8,9,10,0),0),
  Check(Subset_((2,4,6,8,10,0),2,4,6,8,10,0),1),0

rem 
  \para \bf  Prémiová domáca úloha \it  du06  \end.  \end (7 bodov) 
  \para Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp/#pdu  \end 
  \para Jednotlivé časti úlohy budeme hodnotiť samostatne. 
  \para Časti a) a b) sa nachádzajú v súbore \it  ex06a  \end. 
  \para* \bf  \it  Definícia.  \end  \end \it  Konečné čiastočné 
  zobrazenie  \end je zoznam dvojíc, ktoré sú ostro usporiadané podľa 
  prvých zložiek. 
  \eq* 
    Pmap(f) <-> 
    \a p(p in f -> \e x\e y p = Paren(x,y)) & 
    \a g\a u\a v\a x\a y\a h(f = g++((u,v),(x,y),h) -> u < x)
  \end
  \para Všimnite si, že z ostrého usporiadania vyplýva, že v konečnom 
  čiastočnom zobrazení sa nevyskytujú dve rôzne dvojice s rovnakou prvou 
  zložkou. 
  \eq* 
    Pmap(f) & Paren(x,y) in f & Paren(x,z) in f -> y = z
  \end
  \para Napríklad \ft F1 = (0,3),(1,2),(2,7),(4,13),(5,11),0 \end je konečným 
  čiastočným zobrazením, ale zoznamy 
  \ft xs = (0,3),(1,2),(2,7),0,(4,12),(5,11),0 \end, 
  \ft ys = (0,3),(2,7),(1,2),(3,5),0 \end ani 
  \ft zs = (0,3),(1,2),(1,7),(2,13),0 \end z rôznych dôvodov (akých?) nie 
  sú konečnými čiastočnými zobrazeniami. 
  \para Konečné čiastočné zobrazenia sú špeciálnym typom asociatívnych 
  zoznamov z prémiovej domácej úlohy du05 c) z cvičenia \ft Ex05a \end. 
  \para* \bf  c)  \end (1 bod) Zadefinujte predikát \ft Pmap(f) \end, ktorý 
  platí práve vtedy, keď \ft f \end je konečným čiastočným zobrazením. 

pred Pmap 
  Pmap(f) <- Quux

fun/0 F1 
  F1 = (0,3),(1,2),(2,7),(4,13),(5,11),0

rem 
  \para* \bf  \it  Definícia.  \end  \end Ak dvojica \ft Paren(x,y) \end patrí 
  do konečného čiastočného zobrazenia \ft f \end, tak hodnotu \ft y \end 
  nazývame \it  obrazom  \end hodnoty \ft x \end v zobrazení \ft f \end 
  a hodnotu \ft x \end nazývame \it  vzorom  \end hodnoty \ft y \end 
  v zobrazení \ft f \end. 
  \para Napríklad obrazom hodnoty \ft 2 \end vo vyššie uvedenom zobrazení 
  \ft F1 \end je \ft 7 \end. Obraz hodnoty \ft 3 \end v zobrazení \ft F1 \end 
  neexistuje. 
  \para* \bf  d)  \end (1 bod) \header* fun/2 Apply  \end Zadefinujte funkciu 
  \ft Apply(f,x) \end, ktorej hodnotou je \ft y,0 \end ak \ft y \end je obrazom 
  hodnoty \ft x \end v zobrazení \ft f \end. Ak obraz \ft x \end neexistuje, 
  hodnotou \ft Apply(f,x) \end je \ft 0 \end. 
  \para Využite, ale netestujte, že \ft f \end je konečným čiastočným 
  zobrazením! 
  \para Špecifikácia 
  \eq* 
    Pmap(f) -> Paren(x,y) in f <-> Apply(f,x) = y,0
  \end
  \eq* 
    Pmap(f) -> ~\e yParen In(Paren(x,y),f) <-> Apply(f,x) = 0
  \end
  \para alebo ekvivalentne 
  \eq* 
    Pmap(f) -> Set Apply(f,x)
  \end
  \eq* 
    Pmap(f) -> Paren(x,y) in f <-> y in Apply(f,x)
  \end

fun/2 Apply 
  Apply(f,x) = Foo

rem 
  \para* \bf  \it  Definícia.  \end  \end \it  Definičným oborom  \end 
  konečného čiastočného zobrazenia \ft f \end nazývame množinu ( 
  \ft Set \end) všetkých vzorov v zobrazení \ft f \end. 
  \para Napríklad definičným oborom vyššie uvedeného zobrazenia 
  \ft F1 = (0,3),(1,2),(2,7),(4,13),(5,11),0 \end je \ft 0,1,2,4,5,0 \end. 
  \para* \bf  e)  \end (1 bod) Zadefinujte funkciu \ft Domain(f) \end, ktorej 
  hodnotou je definičný obor k. č. zobrazenia \ft f \end. 
  \para Využite, ale netestujte, že \ft f \end je konečným čiastočným 
  zobrazením! 
  \eq* 
    Pmap(f) -> Set Domain(f)
  \end
  \eq* 
    Pmap(f) -> x in Domain(f) <-> Apply(f,x) != 0
  \end

fun Domain 
  Domain(f) = Foo

rem 
  \para* \header* fun/2 Image 'Tex2_image' \end \bf  \it  Definícia.  \end 
   \end \it  Obrazom konečnej množiny  \end \ft xs \end v konečnom 
  čiastočnom zobrazení \ft f \end nazývame konečnú množinu 
  \ft Image(f,xs) \end všetkých obrazov jednotlivých prvkov množiny 
  \ft xs \end v zobrazení \ft f \end. 
  \eq* 
    Pmap(f) & Set(xs) -> Set Image(f,xs)
  \end
  \eq* 
    Pmap(f) & Set(xs) -> y in Image(f,xs) <-> \e x(x in xs & Paren(x,y) in f)
  \end
  \para Napríklad obrazom množiny \ft 2,3,4,5,7,0 \end vo vyššie uvedenom 
  zobrazení \ft F1 = (0,3),(1,2),(2,7),(4,13),(5,11),0 \end je 
  \ft 7,11,13,0 \end. 
  \para* \bf  f)  \end (1 body) \header* fun/2 Image  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Image(f,xs),Tex2_image(f,xs)) \end, ktorej hodnotou je obraz 
  konečnej množiny \ft xs \end v k. č. zobrazení \ft f \end. 
  \para Využite, ale netestujte, že \ft f \end je konečným čiastočným 
  zobrazením a  \ft xs \end je konečnou množinou! Výsledkom musí byť 
  konečná množina. 
  \para \bf  \it  Nepoužite  \end  \end predchádzajúce funkcie \it  okrem 
   \end \ft Insert \end. 

fun/2 Image 'Tex2_image'
  Image(f,xs) = Foo

rem 
  \para* \bf  \it  Definícia.  \end  \end \it  Zložením  \end konečných 
  čiastočných zobrazení \ft f \end a \ft g \end je konečné čiastočné 
  zobrazenie \ft Tex2_composition(f,g) \end, pre ktoré platí 
  \eq* 
    Paren(x,z) in Tex2_composition(f,g) <-> 
    \e y(Paren(x,y) in g & Paren(y,z) in f)
  \end
  \para alebo ekvivalentne pomocou \ft Apply \end: 
  \eq* 
    Apply(g,x) = y,0 -> Apply(Tex2_composition(f,g),x) = Apply(f,y)
  \end
  \eq* 
    Apply(g,x) = 0 -> Apply(Tex2_composition(f,g),x) = 0
  \end
  \para Napríklad 
  \eq* 
    F1 = (0,3),(1,2),(2,7),(4,13),(5,11),0
  \end
  \eq* 
    F2 = (0,1),(1,0),(2,3),(3,2),(4,5),(5,4),(6,7),(7,6),0
  \end
  \eq* 
    Tex2_composition(F1,F2) = (0,2),(1,3),(3,7),(4,11),(5,13),0
  \end
  \para* \bf  g)  \end (1 bod) \header* fun/2 Composition  \end Zadefinujte 
  funkciu \ft Tex2_equiv(Composition(f,g),Tex2_composition(f,g)) \end, ktorej 
  hodnotou je zloženie k. č. zobrazení \ft f \end a \ft g \end. 
  \header* fun/2 Composition 'Tex2_composition' \end 
  \eq* 
    Pmap(f) & Pmap(g) -> Pmap Composition(f,g)
  \end
  \eq* 
    Pmap(f) & Pmap(g) -> Paren(x,z) in Composition(f,g) <-> 
    \e y(Paren(x,y) in g & Paren(y,z) in f)
  \end
  \para Využite, ale netestujte, že \ft f \end a \ft g \end sú konečnými 
  čiastočnými zobrazeniami. Využite predchádzajúce funkcie podľa potreby. 

fun/2 Composition 'Tex2_composition'
  Composition(f,g) = Foo

fun/0 F2 
  F2 = (0,1),(1,0),(2,3),(3,2),(4,5),(5,4),(6,7),(7,6),0

