mod Ex05c


loc rem 
  \para \bf  5. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2014/2015   \end 
  \para* \bf  ČASŤ C  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex05.zip 

loc rem 
  \para* \it  Dátum:  \end 25. 3. 2015 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.21  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované funkciám 
  operujúcim na zoznamoch ( \it  ex05a  \end), chvostovej rekurzii na zoznamoch 
  ( \it  ex05b  \end) a tuplingu zoznamových operácií ( \it  ex05c  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2014/2015. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2015.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 


incl Mtesting05

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/1 Tex1_f
  Prefix(90,2,Id(1,'F',0),Arg(0))

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

appldisp/0 Tex0_ldots
  Op(Ent('hellip'),0)

appldisp/2 Tex2_varidx
  Subsup(Arg(0),75,Arg(1),None)

appldisp/0 Tex0_z
  Id(0,'0',0)

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  10. ZOZNAMY  \end 

rem 
  \para \bf  10.4 Tupling na zoznamoch  \end 

rem 
  \para \bf  \it  Tupling  \end  \end je technika, pri ktorej funkcia vráti 
  \ft n \end-ticu (po anglicky \ft n \end-tuple) výsledkov. Takáto funkcia 
  spravidla vzniká spojením niekoľkých funkcií, ktoré majú rovnaké 
  argumenty, používajú rovnaký typ rekurzie a ich výsledky sú potrebné 
  súčasne. [1, IV. prednáška, §9.2.3] 
  \para \ft n \end-tice vytvárame pomocou párovania. Pretože vieme, že 
  funkcia vždy vráti \ft n \end hodnôt, nemusíme vytvárať zoznam (napr. 
  \ft x,y,z,0 \end), stačí hodnoty jednoducho pospájať párovaním ( 
  \ft x,y,z \end). 
  \para Ak hodnotou funkcie \ft Tex1_f(x) \end je \ft n \end-tica, k zložkám 
  tejto \ft n \end-tice pristupujeme využitím párovej diskriminácie 
  nasledovne: 
  \def* 
    Tex1_cdots(w) <- Tex1_f(Tex0_cdots) = x,y,z
  \end

rem 
  \para \bf  Úloha.  \end \header* fun/2 Split  \end Zadefinujte funkciu 
  \ft Split(i,xs) \end, ktorá rozdelí zoznam \ft xs \end na dvojicu zoznamov 
  \ft ys,zs \end. Zoznam \ft ys \end obsahuje prvých \ft i \end prvkov zoznamu 
  \ft xs \end, zoznam \ft zs \end obsahuje zvyšné prvky \ft xs \end. 
  \eq* 
    Split(i,
          Tex1_paren(x1,x2,Tex0_ldots,Tex2_varidx(x,i),Tex2_varidx(x,i+1),
                     Tex0_ldots,Tex2_varidx(x,n),0)) = 
    (x1,x2,Tex0_ldots,Tex2_varidx(x,i),0),
    Tex1_paren(Tex2_varidx(x,i+1),Tex0_ldots,Tex2_varidx(x,n),0)
  \end
  \para* Napr. \ft Split(3,Paren(2,4,6,8,10,0)) = (2,4,6,0),Paren(8,10,0) \end 
  \para* Špecifikácia: 
  \eq* 
    i <= L(xs) -> Split(i,xs) = ys,zs <-> L(ys) = i & xs = ys++zs
  \end
  \eq* 
    i > L(xs) -> Split(i,xs) = xs,0
  \end
  \para* Využite tupling. Funkciu \ft Split \end si môžete predstaviť ako 
  tuplingové spojenie funkcií \ft Take \end a \ft Drop \end z \it  ex05a 
   \end, podobne ako bola funkcia \ft Divmod \end z cvičenia \it  ex04b  \end 
  spojením funkcií \ft Div \end a \ft Mod \end z  \it  ex02b  \end. Chceme, 
  aby platilo: \header* fun/2 Take  \end \header* fun/2 Drop  \end 
  \eq* 
    Split(i,xs) = Take(i,xs),Drop(i,xs)
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Split_test = r:Results
  \end

fun/2 Split 
  Split(i,xs) = Foo,Foo

fun/0 Split_test 
  Split_test = 
  Check(Split(0,0),0,0),Check(Split(0,Paren(8,10,0)),0,Paren(8,10,0)),
  Check(Split(1,0),0,0),Check(Split(2,Paren(3,0)),(3,0),0),
  Check(Split(3,Paren(2,5,1,0)),(2,5,1,0),0),
  Check(Split(3,Paren(2,4,6,8,10,0)),(2,4,6,0),Paren(8,10,0)),0

rem 
  \para \bf  DOMÁCA ÚLOHA  \end 

rem 
  \para \it  Odporúčanie.  \end K nasledujúcim úlohám sa vráťte po 
  vypracovaní domácich úloh z časti \it  ex05a  \end. 

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Even_odd(xs) \end, ktorá 
  rozdelí zoznam \ft xs \end na dvojicu zoznamov \ft evens,odds \end. Zoznam 
  \ft evens \end obsahuje párne prvky zoznamu \ft xs \end, zoznam \ft odds \end 
  obsahuje nepárne prvky \ft xs \end. 
  \eq* 
    \e evens\e odds Even_odd(xs) = evens,odds
  \end
  \eq* 
    Even_odd(xs) = evens,odds -> x in xs <-> 
    x in evens & \e y x = S0(y) \/ x in odds & \e y x = S1(y)
  \end
  \eq* 
    Even_odd(xs++ys) = exs++eys,oxs++oys <-> 
    Even_odd(xs) = exs,oxs & Even_odd(ys) = eys,oys
  \end
  \para* Napr. 
  \ft Even_odd(2,3,5,4,3,6,8,1,0) = (2,4,6,8,0),Paren(3,5,3,1,0) \end 
  \para* Využite techniky z predchádzajúcich úloh, nepoužite pomocné 
  funkcie. Funkciu \ft Even_odd \end si môžete predstaviť ako tuplingové 
  spojenie funkcie \ft Filter_even \end z \it  ex05a  \end a analogickej funkcie 
  \ft Filter_odd \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Even_odd_test = r:Results
  \end

fun Even_odd 
  Even_odd(xs) = Foo,Foo

fun/0 Even_odd_test 
  Even_odd_test = 
  Check(Even_odd(0),0,0),Check(Even_odd(0,0),(0,0),0),
  Check(Even_odd(1,0),0,Paren(1,0)),Check(Even_odd(1,3,1,0),0,Paren(1,3,1,0)),
  Check(Even_odd(4,6,0,4,0),(4,6,0,4,0),0),
  Check(Even_odd(2,3,5,4,3,6,8,1,0),(2,4,6,8,0),Paren(3,5,3,1,0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Unzip(xys) \end, ktorá 
  rozdelí \it  zoznam dvojíc  \end \ft xys \end na dvojicu zoznamov 
  \ft xs,ys \end. Zoznam \ft xs \end obsahuje prvé zložky dvojíc zo zoznamu 
  \ft xys \end, zoznam \ft ys \end obsahuje druhé zložky dvojíc z 
  \ft xys \end. 
  \para* Napr. 
  \ft Unzip((9,1),(8,2),(7,3),(6,4),(5,5),0) = (9,8,7,6,5,0),Paren(1,2,3,4,5,0) \end 
  \para* \header* fun/2 Zip  \end Funkcia \ft Unzip \end je inverzná k funkcii 
  \ft Zip \end z \it  ex05a  \end. Chceme, aby platilo 
  \eq* 
    L(xs) = L(ys) -> Unzip Zip(xs,ys) = xs,ys
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Unzip_test = r:Results
  \end

fun Unzip 
  Unzip(xys) = Foo,Foo

fun/0 Unzip_test 
  Unzip_test = 
  Check(Unzip(0),0,0),Check(Unzip((1,2),0),(1,0),Paren(2,0)),
  Check(Unzip((0,0),(0,0),0),(0,0,0),Paren(0,0,0)),
  Check(Unzip((0,1),(2,3),0),(0,2,0),Paren(1,3,0)),
  Check(Unzip((9,1),(8,2),(7,3),(6,4),(5,5),0),(9,8,7,6,5,0),Paren(1,2,3,4,5,0)),
  0

rem 
  \para \bf  Prémiová domáca úloha \it  du05  \end.  \end (1 + 1 + 2 + 1 
  bod) 
  \para Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp/#pdu  \end 
  \para Časti a) – c) sa nachádzajú v ex05a. 
  \para* \bf  d)  \end (1 bod) \header* fun Split3  \end Naprogramujte funkciu 
  \ft Split3(xs) \end, ktorej hodnotou je trojica zoznamov \ft ys,ys1,ys2 \end. 
  Zoznamy \ft ys \end, \ft ys1 \end a \ft ys2 \end obsahujú prvky zoznamu 
  \ft xs \end, ktoré po delení číslom \ft 3 \end majú zvyšok \ft 0 \end, 
  \ft 1 \end respektíve \ft 2 \end v uvedenom poradí: 
  \eq* 
    \e ys30\e ys31\e ys32 Split3(xs) = ys30,ys31,ys32
  \end
  \eq* 
    Split3(xs) = ys30,ys31,ys32 -> x in xs <-> 
    x mod 3 = 0 & x in ys30 \/ x mod 3 = 1 & x in ys31 \/ 
    x mod 3 = 2 & x in ys32
  \end
  \para Zachovajte poradie prvkov zo zoznamu \ft xs \end vo výstupných 
  zoznamoch. 
  \para Napríklad \ft Split3(32,23,15,7,6,1,2,5,12,21,121,0) = 
                       (15,6,12,21,0),(7,1,121,0),Paren(32,23,2,5,0) \end. 
  \para \it  Testovanie.  \end 
  \verbatim 
      Split3_test = r:Results
  \end

fun Split3 
  Split3(xs) = Foo,Foo,Foo

fun/0 Split3_test 
  Split3_test = 
  Check(Split3(0),0,0,0),Check(Split3(0,0),(0,0),0,0),
  Check(Split3(1,0),0,(1,0),0),Check(Split3(2,0),0,0,Paren(2,0)),
  Check(Split3(0,1,2,0),(0,0),(1,0),Paren(2,0)),
  Check(Split3(8,0,1,2,0),(0,0),(1,0),Paren(8,2,0)),
  Check(Split3(9,8,0,1,2,0),(9,0,0),(1,0),Paren(8,2,0)),
  Check(Split3(10,9,8,0,1,2,0),(9,0,0),(10,1,0),Paren(8,2,0)),
  Check(Split3(32,23,15,7,6,1,2,5,12,21,121,0),(15,6,12,21,0),(7,1,121,0),
        Paren(32,23,2,5,0)),0

