mod Ex10a

loc rem 
  \para \bf  10. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2011/2012  \end 
  \para* \bf  ČASŤ A  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex10.zip 

loc rem 
  \para* \it  Dátum:  \end 16. 4. 2012 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované kombinatorickým
  úlohám na zoznamoch – rozpoznávaniu rôznych druhov podzoznamov
  a generovaniu zoznamov všetkých týchto podzoznamov. Budeme študovať súvislé
  úseky ( \it  ex10a  \end) a podpostupnosti a permutácie ( \it  ex10b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2011/2012. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2012.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Maux10

incl Mtesting10

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  14. KOMBINATORICKÉ PREDIKÁTY A FUNKCIE NA ZOZNAMOCH  \end 

rem 
  \para \bf  [CL] Reťazce  \end 

rem 
  \para \bf  \it  Znaky a reťazce.  \end  \end \it  Reťazec  \end je v CL 
  zoznamom \it  znakov  \end (viď definície predikátov – formátov 
  \ft Ch \end a \ft Str \end v module \ft Standard \end). Znaky sú uzavreté 
  v úvodzovkách (napr. "a"), reťazce v apostrofoch (napr. 'abc efg 123'). 
  Čísla zobrazíme ako znaky pomocou formátu \ft Ch \end. Zoznamy zobrazíme 
  ako reťazce pomocou formátu \ft Str \end. 

rem 
  \para \bf  Úloha.  \end Vyhodnoťte query: 
  \verbatim 
      90 = c:Ch & 72,101,108,108,111,33,0 = xs:Str &
      ("l","a",0) = ys:Str & 'tra'++ys++ys = zs:Str
  \end

rem 
  \para \bf  \it  Zoznamy reťazcov.  \end  \end Doteraz sme väčšinou 
  pracovali s jednoduchými zoznamami čísel, občas s dvojicami zoznamov 
  alebo zoznamami dvojíc. Hodnotami väčšiny funkcií v tomto cvičení 
  budú \it  zoznamy zoznamov  \end. Prehľadnejšie je pozerať sa na ne ako na 
  \it  zoznamy reťazcov  \end. 
  \para Predikát – formát \ft Lstr \end (z modulu \ft Maux10 \end) platí 
  pre zoznamy reťazcov a umožňuje takto zobrazovať hodnoty premenných 
  v query: 
  \def 
    pred Lstr 
    Lstr(0)
    Lstr(xs,xss) <- Str(xs) & Lstr(xss)
  \end

rem 
  \para \bf  Úloha.  \end Vyhodnoťte query: 
  \verbatim 
      (97,98,99,0),0,(100,101,0),0 = xss:Lstr
  \end

rem 
  \para \bf  14.1. Súvislé úseky  \end 

rem 
  \para \bf  Sufixy  \end 

rem 
  \para \bf  \it  Sufix.  \end  \end \header* pred/2 Suffix  \end Predikát 
  \ft Tex2_equiv(Suffix(xs,zs),Tex2_suffix(xs,zs)) \end platí práve vtedy, 
  keď zoznam \ft zs \end je \it  sufixom  \end (súvislým koncovým úsekom) 
  zoznamu \ft xs \end: \header* pred/2 Suffix 'Tex2_suffix' \end 
  \eq* 
    Suffix(xs,zs) <-> \e ys xs = ys++zs
  \end
  \para Napríklad: 
  \eq* 
    Suffix((5,7,11,0),5,7,11,0)
  \end
  \eq* 
    Suffix((2,3,5,7,11,0),5,7,11,0)
  \end
  \eq* 
    ~Suffix(0,5,7,11,0)
  \end
  \eq* 
    ~Suffix((2,3,5,7,11,13,0),5,7,11,0)
  \end
  \para V nasledujúcich úlohách využijeme, že 
  \items 
   \item \para jediným sufixom prázdneho zoznamu je iba prázdny zoznam: 
         \eq (Suffix_zero)
           Suffix(0,zs) <-> zs = 0
         \end
   \item \para sufixami neprázdneho zoznamu \ft Paren(x,xs) \end sú 
         \para a) zoznam \ft Paren(x,xs) \end sám, 
         \para b) všetky sufixy zoznamu \ft xs \end, 
         \para* teda: 
         \eq (Suffix_pair)
           Suffix(Paren(x,xs),zs) <-> zs = Paren(x,xs) \/ Suffix(xs,zs)
         \end
  \end

rem 
  \para \bf  Úloha.  \end \header* pred/2 Suffix  \end Naprogramujte predikát 
  \ft Tex2_equiv(Suffix(xs,zs),Tex2_suffix(xs,zs)) \end podľa predchádzajúcej 
  poznámky zoznamovou rekurziou. Využite vlastnosti (Suffix_zero) 
  a (Suffix_pair). 
  \para* Testovanie: 
  \verbatim 
      Suffix_test = r:Results
  \end

pred/2 Suffix 'Tex2_suffix'
  Suffix(xs,zs) <- Quux

fun/2 Suffix_ 'Tex2_suffix_'
  Suffix_(xs,zs) = 1 <- Suffix(xs,zs)
  Suffix_(xs,zs) = 0 <- ~Suffix(xs,zs)

fun/0 Suffix_test 
  Suffix_test = 
  Check(Suffix_(0,0),1),Check(Suffix_(0,0,0),0),Check(Suffix_((0,0),0),1),
  Check(Suffix_((0,0),0,0),1),Check(Suffix_((0,0),1,0),0),
  Check(Suffix_((5,7,11,0),5,7,11,0),1),Check(Suffix_((5,7,11,0),5,11,0),0),
  Check(Suffix_((5,7,11,0),7,5,11,0),0),
  Check(Suffix_((2,3,5,7,11,0),5,7,11,0),1),Check(Suffix_(0,5,7,11,0),0),
  Check(Suffix_((2,3,5,7,11,13,0),5,7,11,0),0),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Suffixes(xs) \end, ktorej 
  hodnotou je \it  zoznam všetkých sufixov  \end zoznamu (reťazca) 
  \ft xs \end. Funkciu zadefinujte zoznamovou rekurziou. Využite vlastnosti 
  (Suffix_zero) a (Suffix_pair). 
  \para* Špecifikácia: 
  \eq* 
    zs in Suffixes(xs) <-> Suffix(xs,zs)
  \end
  \eq* 
    Str(xs) -> Lstr Suffixes(xs)
  \end
  \para* Napríklad: 
  \eq* 
    Suffixes(1,2,3,0) = (1,2,3,0),(2,3,0),(3,0),0,0
  \end
  \eq* 
    Suffixes('aky') = 'aky','ky','y','',0
  \end
  \eq* 
    Suffixes('taky') = 'taky','aky','ky','y','',0
  \end
  \para Výsledok v druhom a treťom príklade zobrazujte formátom 
  \ft Lstr \end (viď vyššie). 
  \para* Môžete tiež použiť predpripravený test: 
  \verbatim 
      Suffixes_test = r:Results_lstr
  \end

fun Suffixes 
  Suffixes(xs) = Foo

fun/0 Suffixes_test 
  Suffixes_test = 
  Check_lext(Suffixes(''),'',0),Check_lext(Suffixes('y'),'y','',0),
  Check_lext(Suffixes('aky'),'aky','ky','y','',0),
  Check_lext(Suffixes('taky'),'taky','aky','ky','y','',0),0

rem 
  \para \bf  Prefixy  \end 

rem 
  \para \bf  \it  Prefix.  \end  \end \header* pred/2 Prefix  \end Predikát 
  \ft Tex2_equiv(Prefix(ys,xs),Tex2_prefix(ys,xs)) \end platí práve vtedy, 
  keď \ft ys \end je \it  prefixom  \end (súvislým začiatočným úsekom) 
  zoznamu \ft xs \end: \header* pred/2 Prefix 'Tex2_prefix' \end 
  \eq* 
    Prefix(ys,xs) <-> \e zs xs = ys++zs
  \end
  \para Napríklad: 
  \eq* 
    Prefix(0,2,3,5,7,11,0)
  \end
  \eq* 
    Prefix((2,3,5,0),2,3,5,7,11,0)
  \end
  \eq* 
    ~Prefix((2,3,5,0),0)
  \end
  \eq* 
    ~Prefix((1,2,3,0),2,3,5,7,11,0)
  \end
  \para V nasledujúcich úlohách využijeme, že 
  \items 
   \item \para jediným prefixom prázdneho zoznamu je prázdny zoznam: 
         \eq (Prefix_zero)
           Prefix(ys,0) <-> ys = 0
         \end
   \item \para prefixami neprázdneho zoznamu \ft (x,xs) \end sú 
         \para a) prázdny zoznam, 
         \para b) všetky zoznamy \ft (x,vs) \end, kde \ft vs \end je prefixom 
         zoznamu \ft xs \end, 
         \para* teda: 
         \eq (Prefix_pair)
           Prefix(ys,Paren(x,xs)) <-> 
           ys = 0 \/ \e vs(ys = Paren(x,vs) & Prefix(vs,xs))
         \end
  \end

rem 
  \para \bf  Úloha.  \end \header* pred/2 Prefix  \end Naprogramujte predikát 
  \ft Tex2_equiv(Prefix(ys,xs),Tex2_prefix(ys,xs)) \end podľa predchádzajúcej 
  poznámky zoznamovou rekurziou. Využite vlastnosti (Prefix_zero) 
  a (Prefix_pair). 
  \para* Testovanie: 
  \verbatim 
      Prefix_test = r:Results
  \end

pred/2 Prefix 'Tex2_prefix'
  Prefix(ys,xs) <- Quux

fun/2 Prefix_ 'Tex2_prefix_'
  Prefix_(ys,xs) = 1 <- Prefix(ys,xs)
  Prefix_(ys,xs) = 0 <- ~Prefix(ys,xs)

fun/0 Prefix_test 
  Prefix_test = 
  Check(Prefix_(0,0),1),Check(Prefix_((0,0),0),0),Check(Prefix_(0,0,0),1),
  Check(Prefix_((0,0),0,0),1),Check(Prefix_((1,0),0,0),0),
  Check(Prefix_((0,0,0),0,0),0),Check(Prefix_(0,2,3,5,7,11,0),1),
  Check(Prefix_((2,3,5,0),2,3,5,7,11,0),1),Check(Prefix_((2,3,5,0),0),0),
  Check(Prefix_((1,2,3,0),2,3,5,7,11,0),0),0

rem 
  \para \bf  Úloha. Pridanie znaku na začiatok viacerých reťazcov.  \end 
  \header* fun/2 Map_pair  \end Zadefinujte funkciu \ft Map_pair(a,xss) \end, 
  ktorá pridá prvok \ft a \end na začiatok každého zoznamu v zozname 
  zoznamov \ft xss \end (znak \ft a \end na začiatok každého reťazca 
  v zozname reťazcov \ft xss \end). 
  \para* Špecifikácia: 
  \eq* 
    ys in Map_pair(a,xss) <-> \e xs(ys = Paren(a,xs) & xs in xss)
  \end
  \eq* 
    Ch(a) & Lstr(xss) -> Lstr Map_pair(a,xss)
  \end
  \para* Napríklad: 
  \eq* 
    Map_pair(99,Paren((50,30,20,0),(1,2,0),0,(7,0),0)) = 
    (99,50,30,20,0),(99,1,2,0),(99,0),(99,7,0),0
  \end
  \eq* 
    Map_pair("#",Paren('abcde','','123','@',0)) = '#abcde','#','#123','#@',0
  \end
  \para Všimnite si, že vstupný a výstupný zoznam zoznamov majú rovnaký 
  počet prvkov. 
  \para* Môžete použiť predpripravený test: 
  \verbatim 
      Map_pair_test = r:Results_lstr
  \end

fun/2 Map_pair 
  Map_pair(a,xss) = Foo

fun/0 Map_pair_test 
  Map_pair_test = 
  Check_lext(Map_pair("#",0),0),Check_lext(Map_pair("#",'',0),'#',0),
  Check_lext(Map_pair("#",'abc',0),'#abc',0),
  Check_lext(Map_pair("#",Paren('abcde','','123','@',0)),'#abcde','#','#123','#@',0),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Prefixes(xs) \end, ktorej 
  hodnotou je \it  zoznam všetkých prefixov  \end zoznamu (reťazca) 
  \ft xs \end. Funkciu zadefinujte zoznamovou rekurziou. Využite vlastnosti 
  prefixov (Prefix_zero) a (Prefix_pair) a funkciu \ft Map_pair \end. 
  \para* Špecifikácia: 
  \eq* 
    ys in Prefixes(xs) <-> Prefix(ys,xs)
  \end
  \eq* 
    Str(xs) -> Lstr Prefixes(xs)
  \end
  \para* Napríklad: 
  \eq* 
    Prefixes(2,3,5,0) = 0,(2,0),(2,3,0),(2,3,5,0),0
  \end
  \eq* 
    Prefixes('aky') = '','a','ak','aky',0
  \end
  \eq* 
    Prefixes('taky') = '','t','ta','tak','taky',0
  \end
  \para* Môžete použiť predpripravený test: 
  \verbatim 
      Prefixes_test = r:Results_lstr
  \end

fun Prefixes 
  Prefixes(xs) = Foo

fun/0 Prefixes_test 
  Prefixes_test = 
  Check_lext(Prefixes(''),'',0),Check_lext(Prefixes('ky'),'','k','ky',0),
  Check_lext(Prefixes('aky'),'','a','ak','aky',0),
  Check_lext(Prefixes('taky'),'','t','ta','tak','taky',0),0

rem 
  \para \bf  Segmenty  \end 

rem 
  \para \bf  \it  Segment.  \end  \end 
  \header* pred/2 Segment  \end Predikát 
  \ft Tex2_equiv(Segment(us,xs),Tex2_segment(us,xs)) \end platí práve vtedy, 
  keď \ft us \end je \it  segmentom  \end (podreťazcom, všeobecným súvislým
  úsekom) zoznamu \ft xs \end: \header* pred/2 Segment 'Tex2_segment' \end 
  \eq* 
    Segment(us,xs) <-> \e ys\e zs xs = ys++us++zs
  \end
  \para* Napríklad 
  \eq* 
    Segment((5,7,0),5,7,11,13,0)
  \end
  \eq* 
    Segment((5,7,0),2,3,5,7,11,13,0)
  \end
  \eq* 
    ~Segment((5,7,0),0)
  \end
  \eq* 
    ~Segment((5,7,0),3,5,6,7,11,0)
  \end

rem 
  \para \bf  Úloha.  \end Sformulujte (na papier) vlastnosti predikátu 
  \ft Tex2_segment(us,xs) \end pre prázdny a neprázdny zoznam \ft xs \end 
  podobne, ako sme to urobili pre \ft Tex2_suffix(xs,zs) \end a 
  \ft Tex2_prefix(ys,xs) \end. Využite pritom jeden z týchto predikátov. 
  \eq (Segment_zero)
    Segment(us,0) <-> Quux
  \end
  \eq (Segment_pair)
    Segment(us,Paren(x,xs)) <-> Quux
  \end

rem 
  \para \bf  Úloha.  \end \header* pred/2 Segment  \end Naprogramujte predikát 
  \ft Tex2_equiv(Segment(us,xs),Tex2_segment(us,xs)) \end zoznamovou rekurziou. 
  Využite pritom vlastnosti, ktoré ste sformulovali v predchádzajúcej 
  úlohe. 
  \para* Testovanie: 
  \verbatim 
      Segment_test = r:Results
  \end

pred/2 Segment 'Tex2_segment'
  Segment(us,xs) <- Quux

fun/2 Segment_ 'Tex2_segment_'
  Segment_(us,xs) = 1 <- Segment(us,xs)
  Segment_(us,xs) = 0 <- ~Segment(us,xs)

fun/0 Segment_test 
  Segment_test = 
  Check(Segment_(0,0),1),Check(Segment_((0,0),0),0),Check(Segment_(0,0,0),1),
  Check(Segment_((0,0),0,0),1),Check(Segment_((1,0),0,0),0),
  Check(Segment_((0,0,0),0,0),0),Check(Segment_((5,7,0),5,7,11,13,0),1),
  Check(Segment_((5,7,0),2,3,5,7,11,13,0),1),Check(Segment_((5,7,0),0),0),
  Check(Segment_((5,7,0),3,5,6,7,11,0),0),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Segments(xs) \end, ktorej 
  hodnotou je \it  zoznam všetkých súvislých úsekov  \end zoznamu 
  (reťazca) \ft xs \end. Funkciu \ft Segments \end zadefinujte zoznamovou 
  rekurziou. Využite niektorú z funkcií \ft Suffixes \end, 
  \ft Prefixes \end. 
  \para* Špecifikácia: 
  \eq* 
    us in Segments(xs) <-> Segment(us,xs)
  \end
  \eq* 
    Str(xs) -> Lstr Segments(xs)
  \end
  \para* Napríklad: 
  \eq* 
    Segments('ky') = 'k','ky','y','',0
  \end
  \eq* 
    Segments('aky') = 'a','ak','aky','k','ky','y','',0
  \end
  \eq* 
    Segments('taky') = 't','ta','tak','taky','a','ak','aky','k','ky','y','',0
  \end
  \para Snažte sa zadefinovať funkciu \ft Segments \end tak, aby sa zoznamy 
  v jej výslednej hodnote neopakovali. Predpripravený test túto vlastnosť 
  nekontroluje. 
  \para* Testovanie: 
  \verbatim 
      Segments_test = r:Results_lstr
  \end

fun Segments 
  Segments(xs) = Foo

fun/0 Segments_test 
  Segments_test = 
  Check_lext(Segments(''),'',0),Check_lext(Segments('ky'),'k','ky','y','',0),
  Check_lext(Segments('aky'),'a','ak','aky','k','ky','y','',0),
  Check_lext(Segments('taky'),'t','ta','tak','taky','a','ak','aky','k','ky','y','',0),0

