mod Ex07a

loc rem 
  \para \bf  7. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2011/2012  \end 
  \para* \bf  ČASŤ A  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex07.zip 

loc rem 
  \para* \it  Dátum:  \end 26. 3. 2012 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované funkciám 
  operujúcim na zoznamoch ( \it  ex07a  \end), chvostovej rekurzii na zoznamoch 
  ( \it  ex07b  \end) a tuplingu zoznamových operácií ( \it  ex07c  \end). 

rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2011/2012. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2012.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Mtesting7

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,3,Op(Ent('equiv'),0),Arg(1))

appldisp/0 Tex0_ldots
  Op(Ent('hellip'),0)

appldisp/2 Tex2_varidx
  Subsup(Arg(0),75,Arg(1),None)

appldisp/2 Tex2_sub
  Prefix(70,2,Arg(0),Fenced(Op('[',0),Arg(1),Op(']',0)))

appldisp/3 Tex3_msub
  Prefix(70,2,Arg(0),
         Fenced(Op('[',0),Infix(Arg(1),25,3,Op(Ent('colone'),0),Arg(2)),Op(']',0)))

appldisp/2 Tex2_min
  Std('min',0)

fun/2 Min 'Tex2_min'
  Min(x,y) = x <- x <= y
  Min(x,y) = y <- x > y

appldisp/2 Tex2_max
  Std('max',0)

fun/2 Max 'Tex2_max'
  Max(x,y) = y <- x <= y
  Max(x,y) = x <- x > y

appldisp/1 Tex1_fib
  Subsup(Id(0,'fib',0),75,Arg(0),None)

fun Fib 'Tex1_fib'
  Fib(0) = 0
  Fib(1) = 1
  Fib(n+2) = Fib(n+1)+Fib(n)

appldisp/1 Tex1_f
  Std('f',0)

appldisp/2 Tex2_interval_co
  Fenced(Op('[',0),Infix(Arg(0),25,3,Id(0,'  .. ',0),Arg(1)),Op(')',0))

appldisp/2 Tex2_realinterval_co
  Fenced(Op(Ent('lang'),0),Infix(Arg(0),30,0,Op(',',0),Arg(1)),Op(')',0))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  11. ZOZNAMY  \end 

rem 
  \para \bf  11.1. Kódovanie konečných postupností  \end 

rem 
  \para \it  Kódovanie konečných postupností párovaním.  \end Pomocou 
  párovacej funkcie môžeme zakódovať konečné postupnosti čísel 
  ľubovoľnej dĺžky nasledovne: 
  \items 
   \item \para \ft 0 \end kóduje prázdnu postupnosť, 
   \item \para \ft x,xs \end kóduje postupnosť, ktorej prvým prvkom je 
         číslo \ft x \end a zvyšok postupnosti je zakódovaný číslom 
         \ft xs \end. 
  \end
  \para Inak povedané, postupnosť čísel \ft x1 \end, \ft x2 \end, …, 
  \ft Tex2_varidx(x,n) \end zakódujeme ako 
  \eq* 
    x1,x2,Tex0_ldots,Tex2_varidx(x,n),0
  \end
  \para Koncová \ft 0 \end nie je prvkom postupnosti. Jej význam je podobný 
  smerníku \it  nil  \end v Pascale. 
  \para Kód konečnej postupnosti nazývame \it  zoznam  \end. 
  \para Napríklad šesťprvkovú postupnosť 2, 3, 5, 7, 11, 13 zakódujeme 
  zoznamom 
  \eq* 
    2,3,5,7,11,13,0
  \end

rem 
  \para \it  Konvencia.  \end Na označenie zoznamov budeme používať 
  premenné s príponou \it  -s  \end (množné číslo v angličtine), 
  napríklad \ft xs \end, \ft ys \end, \ft zs \end. 

rem 
  \para \bf  11.2. Programovanie so zoznamami  \end 

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft L(xs) \end, ktorej hodnotou 
  je dĺžka zoznamu \ft xs \end: 
  \eq* 
    L(x1,x2,Tex0_ldots,Tex2_varidx(x,n),0) = n
  \end
  \para Napr. \ft L(2,3,5,7,11,13,0) = 6 \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      L_test = r:Results
  \end

fun L 
  L(xs) = Foo

fun/0 L_test 
  L_test = Check(L(0),0),Check(L(0,0),1),Check(L(2,3,5,7,11,13,0),6),0

rem 
  \para \bf  Úloha.  \end Zistite, koľko prvkov má zoznam 
  \eq* 
    1,(2,3),0,4,(5,6,0),((7,8),9),0
  \end
  \para Čo je piatym prvkom tohto zoznamu (ak poradie počítame od 1)? 

rem 
  \para \bf  Úloha.  \end \header* fun/2 Conc  \end Zadefinujte funkciu 
  \ft Conc(xs,ys) \end, ktorá zreťazí zoznamy \ft xs \end a \ft ys \end, teda 
  \eq* 
    Conc((x1,x2,Tex0_ldots,Tex2_varidx(x,n),0),
         Tex1_paren(y1,y2,Tex0_ldots,Tex2_varidx(y,m),0)) = 
    x1,x2,Tex0_ldots,Tex2_varidx(x,n),y1,y2,Tex0_ldots,Tex2_varidx(y,m),0
  \end
  \para Napr. \ft Conc((1,2,3,0),Paren(4,5,6,0)) = 1,2,3,4,5,6,0 \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Conc_test = r:Results
  \end

fun/2 Conc 
  Conc(xs,ys) = Foo

fun/0 Conc_test 
  Conc_test = 
  Check(Conc(0,0),0),Check(Conc(0,Paren(1,0)),1,0),Check(Conc((1,0),0),1,0),
  Check(Conc((1,0),Paren(1,0)),1,1,0),
  Check(Conc((1,2,3,0),Paren(4,5,6,0)),1,2,3,4,5,6,0),0

rem 
  \para \it  [CL] Zabudované zreťazenie.  \end Zreťazenie je zabudované ako 
  binárny infixový operátor. Zapisuje sa \ft xs \end ++ \ft ys \end 
  a zobrazuje sa \ft xs++ys \end. 
  \para* Zreťazenie je \it  asociatívne  \end, teda 
  \eq* 
    Paren(xs++ys)++zs = xs++Paren(ys++zs)
  \end
  \para Automaticky sa \it  zátvorkuje vľavo  \end, teda 
  \eq* 
    Tex2_equiv(xs++ys++zs,Paren(xs++ys)++zs)
  \end
  \para Zreťazenie má \it  vyššiu prioritu ako párovanie  \end, preto 
  \eq* 
    Tex2_equiv((a,xs++ys),a,Paren(xs++ys))
  \end
  \para \it  [CL] Upozornenie.  \end Aby ste spojili zoznam \ft xs \end, prvok 
  \ft a \end a zoznam \ft ys \end v tomto poradí, musíte napísať 
  \eq* 
    xs++(a,ys)
  \end
  \para Ak napíšete \ft xs++a,ys \end bez zátvoriek, znamená to 
  \ft Paren(xs++a),ys \end! 

rem 
  \para \bf  Úloha.  \end Aj keď sú hodnoty výrazov 
  \ft Paren(xs++ys)++zs \end a \ft xs++Paren(ys++zs) \end rovnaké, výpočty 
  prebiehajú rôzne. 
  \para Na ktorý z týchto výpočtov je potrebný menší počet krokov? 

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Rev(xs) \end, ktorá obráti 
  zoznam \ft xs \end: 
  \eq* 
    Rev(x1,x2,Tex0_ldots,Tex2_varidx(x,n),0) = 
    Tex2_varidx(x,n),Tex0_ldots,x2,x1,0
  \end
  \para Napr. \ft Rev(2,3,5,7,11,0) = 11,7,5,3,2,0 \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Rev_test = r:Results
  \end

fun Rev 
  Rev(xs) = Foo

fun/0 Rev_test 
  Rev_test = 
  Check(Rev(0),0),Check(Rev(2,0),2,0),Check(Rev(2,3,0),3,2,0),
  Check(Rev(2,3,5,7,11,0),11,7,5,3,2,0),Check(Rev(0,(0,2,0),2,0),2,(0,2,0),0,0),
  0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Delall  \end Zadefinujte funkciu 
  \ft Delall(a,xs) \end, ktorá odstráni všetky výskyty prvku \ft a \end zo 
  zoznamu \ft xs \end. Presnejšie: Hodnotou \ft Delall(a,xs) \end je \it  nový 
   \end zoznam, ktorý obsahuje všetky prvky zoznamu \ft xs \end, ktoré sú 
  rôzne od \ft a \end, v pôvodnom vzájomnom poradí. 
  \para* Napr. \ft Delall(3,Paren(1,3,2,3,3,3,4,3,0)) = 1,2,4,0 \end. 
  \para* Uvedomte si, že musíte vytvoriť celý výstupný zoznam. Funkcia 
  nemôže meniť vstupný zoznam. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Delall_test = r:Results
  \end

fun/2 Delall 
  Delall(a,xs) = Foo

fun/0 Delall_test 
  Delall_test = 
  Check(Delall(3,0),0),Check(Delall(3,Paren(3,0)),0),
  Check(Delall(3,Paren(1,0)),1,0),Check(Delall(3,Paren(3,2,3,3,3,4,3,0)),2,4,0),
  Check(Delall(3,Paren(1,3,2,3,3,3,4,0)),1,2,4,0),
  Check(Delall(3,Paren(1,3,2,3,3,3,4,3,0)),1,2,4,0),
  Check(Delall(3,Paren(1,3,2,3,3,3,4,3,2,0)),1,2,4,2,0),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Last(xs) \end, ktorej 
  hodnotou je posledný prvok zoznamu \ft xs \end, ak existuje, alebo 
  \ft 0 \end, ak je \ft xs \end prázdny. 
  \para* Napr. \ft Last(9,1,7,3,5,0) = 5 \end. 
  \para* Nájdite verziu bez pomocných funkcií. Ak má zoznam \it  aspoň 
   \end jeden prvok, ako zistíte, či má \it  práve  \end jeden prvok? 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Last_test = r:Results
  \end

fun Last 
  Last(xs) = Foo

fun/0 Last_test 
  Last_test = 
  Check(Last(0),0),Check(Last(5,0),5),Check(Last(3,5,0),5),
  Check(Last(1,7,3,5,0),5),Check(Last(9,1,7,3,5,0),5),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Sub  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Sub(xs,i),Tex2_sub(xs,i)) \end, ktorej hodnotou je 
  \ft Tex1_paren(i+1) \end-ý prvok zoznamu \ft xs \end: 
  \header* fun/2 Sub 'Tex2_sub' \end 
  \eq* 
    Sub((x1,x2,Tex0_ldots,Tex2_varidx(x,i),Tex2_varidx(x,i+1),
         Tex2_varidx(x,i+2),Tex0_ldots,Tex2_varidx(x,n),0),i) = 
    Tex2_varidx(x,i+1)
  \end
  \para Napr. \ft Sub((2,3,5,7,11,0),2) = 5 \end. 
  \para* Špecifikácia 
  \eq* 
    i < L(xs) -> Sub(xs,i) = a <-> \e ys\e zs(L(ys) = i & xs = ys++(a,zs))
  \end
  \eq* 
    i >= L(xs) -> Sub(xs,i) = 0
  \end
  \para* Nepoužite žiadne pomocné funkcie. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Sub_test = r:Results
  \end

fun/2 Sub 'Tex2_sub'
  Sub(xs,i) = Foo

fun/0 Sub_test 
  Sub_test = 
  Check(Sub((5,7,11,0),0),5),Check(Sub((3,5,7,11,0),1),5),
  Check(Sub((3,5,7,11,0),2),7),Check(Sub((2,3,5,7,11,0),1),3),
  Check(Sub((2,3,5,7,11,0),2),5),Check(Sub((2,3,5,7,11,0),9),0),0

rem 
  \para \it  Poznámka.  \end Všimnite si, že (na rozdiel od polí) na 
  zoznamoch je indexovanie pomerne výpočtovo náročné: Na prístup k prvku 
  na \ft i \end-tom mieste zoznamu potrebujeme \ft i \end krokov. 
  \para* Indexovaniu sa preto budeme pri programovaní vyhýbať. Budeme ho 
  však používať na špecifikáciu. 

rem 
  \para \bf  Úloha.  \end \header* fun/2 Take  \end Zadefinujte funkciu 
  \ft Take(i,xs) \end, ktorej hodnotou je zoznam pozostávajúci z prvých 
  \ft i \end prvkov zoznamu \ft xs \end, teda 
  \eq* 
    Take(i,
         Paren(a1,a2,Tex0_ldots,Tex2_varidx(a,i),Tex0_ldots,Tex2_varidx(a,n),
               0)) = a1,a2,Tex0_ldots,Tex2_varidx(a,i),0
  \end
  \para Napr. \ft Take(2,Paren(9,8,7,6,5,0)) = 9,8,0 \end. 
  \para* Špecifikácia 
  \eq* 
    i <= L(xs) -> Take(i,xs) = ys <-> L(ys) = i & \e zs xs = ys++zs
  \end
  \eq* 
    i > L(xs) -> Take(i,xs) = xs
  \end
  \para* Nepoužite žiadne pomocné funkcie. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Take_test = r:Results
  \end

fun/2 Take 
  Take(i,xs) = Foo

fun/0 Take_test 
  Take_test = 
  Check(Take(0,0),0),Check(Take(2,0),0),Check(Take(0,Paren(8,7,6,5,0)),0),
  Check(Take(1,Paren(8,7,6,5,0)),8,0),Check(Take(2,Paren(8,7,6,5,0)),8,7,0),
  Check(Take(0,Paren(9,8,7,6,5,0)),0),Check(Take(1,Paren(9,8,7,6,5,0)),9,0),
  Check(Take(2,Paren(9,8,7,6,5,0)),9,8,0),
  Check(Take(4,Paren(9,8,7,6,5,0)),9,8,7,6,0),
  Check(Take(9,Paren(9,8,7,6,5,0)),9,8,7,6,5,0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Drop  \end \header* fun/2 Take  \end 
  Zadefinujte funkciu \ft Drop(i,xs) \end, ktorá odstráni prvých \ft i \end 
  prvkov zo zoznamu \ft xs \end, teda 
  \eq* 
    Drop(i,
         Paren(a1,a2,Tex0_ldots,Tex2_varidx(a,i),Tex2_varidx(a,i+1),
               Tex0_ldots,Tex2_varidx(a,n),0)) = 
    Tex2_varidx(a,i+1),Tex0_ldots,Tex2_varidx(a,n),0
  \end
  \para Napr. \ft Drop(2,Paren(9,8,7,6,5,0)) = 7,6,5,0 \end. 
  \para* Špecifikácia 
  \eq* 
    i <= L(xs) -> Drop(i,xs) = zs <-> \e ys(L(ys) = i & xs = ys++zs)
  \end
  \eq* 
    i > L(xs) -> Drop(i,xs) = 0
  \end
  \para* Nepoužite žiadne pomocné funkcie. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Drop_test = r:Results
  \end

fun/2 Drop 
  Drop(i,xs) = Foo

fun/0 Drop_test 
  Drop_test = 
  Check(Drop(0,0),0),Check(Drop(2,0),0),
  Check(Drop(0,Paren(8,7,6,5,0)),8,7,6,5,0),
  Check(Drop(1,Paren(8,7,6,5,0)),7,6,5,0),Check(Drop(2,Paren(8,7,6,5,0)),6,5,0),
  Check(Drop(0,Paren(9,8,7,6,5,0)),9,8,7,6,5,0),
  Check(Drop(1,Paren(9,8,7,6,5,0)),8,7,6,5,0),
  Check(Drop(2,Paren(9,8,7,6,5,0)),7,6,5,0),
  Check(Drop(4,Paren(9,8,7,6,5,0)),5,0),Check(Drop(9,Paren(9,8,7,6,5,0)),0),0

rem 
  \para \it  Poznámka.  \end Všimnite si, že platí 
  \eq* 
    xs = Take(i,xs)++Drop(i,xs)
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Minl(xs) \end, ktorej 
  hodnotou je najmenší prvok zoznamu \ft xs \end. Napr. 
  \ft Minl(3,2,1,5,2,1,6,4,0) = 1 \end. 
  \para* Pre prázdny zoznam funkcia vráti 0. 
  \para* \it  Nepoužite  \end žiadne konštanty ako horné ohraničenia (99999 
  a podobne). Počas výpočtu nevytvárajte nové zoznamy. 
  \para* \it  Návod.  \end Zistite, či má neprázdny zoznam práve jeden 
  prvok (podobne ako pri \ft Last \end). \header* fun/2 Min  \end Ak nie, 
  použite vhodnú kombináciu rekurzívneho volania a funkcie 
  \ft Tex2_equiv(Min(x,y),Tex2_min(x,y)) \end definovanej na začiatku tohto 
  súboru. 
  \para* Iná možnosť: Použite pomocnú funkciu, ktorá si pamätá 
  priebežné minimum v ďalšom argumente. Argument pri spustení správne 
  inicializujte (nie konštantou!). 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Minl_test = r:Results_n
  \end

fun Minl 
  Minl(xs) = Foo

fun/0 Minl_test 
  Minl_test = 
  Check(Minl(0),0),Check(Minl(0,0),0),Check(Minl(4,0),4),Check(Minl(6,4,0),4),
  Check(Minl(2,6,4,0),2),Check(Minl(5,2,6,4,0),2),Check(Minl(1,5,2,6,4,0),1),
  Check(Minl(2,1,5,2,1,5,2,6,4,0),1),Check(Minl(3,2,1,5,2,1,5,2,6,4,0),1),
  Check(Minl(3,2,1,5,0,2,1,5,2,6,4,0),0),
  Check(Minl(Sq(200000000),Sq(100000000),100000000*200000000,0),Sq(100000000)),0

rem 
  \para \bf  DOMÁCA ÚLOHA  \end 

rem 
  \para \it  Odporúčanie.  \end Na cvičeniach pokračujte riešením úloh 
  z častí B a C. K nasledujúcim úlohám sa vráťte, ak Vám ostane čas, 
  alebo v rámci domácej prípravy. 

rem 
  \para \bf  Úloha.  \end \header* fun/3 Msub  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Msub(xs,i,a),Tex3_msub(xs,i,a)) \end, ktorá zmení hodnotu 
  \ft Tex1_paren(i+1) \end-ého prvku zoznamu \ft xs \end na \ft a \end, ak 
  \ft i < L(xs) \end: \header* fun/3 Msub 'Tex3_msub' \end 
  \eq* 
    Msub((x1,x2,Tex0_ldots,Tex2_varidx(x,i),Tex2_varidx(x,i+1),
          Tex2_varidx(x,i+2),Tex0_ldots,Tex2_varidx(x,n),0),i,a) = 
    x1,Tex0_ldots,Tex2_varidx(x,i),a,Tex2_varidx(x,i+2),Tex0_ldots,
    Tex2_varidx(x,n),0
  \end
  \para Ak \ft i >= L(xs) \end, funkcia vráti nezmenený zoznam. 
  \para* Napr. \ft Msub((2,3,5,7,11,0),2,999) = 2,3,999,7,11,0 \end. 
  \para* Špecifikácia 
  \eq* 
    i < L(xs) -> Sub(Msub(xs,i,a),i) = a
  \end
  \eq* 
    i < L(xs) -> \a j(i != j -> Sub(Msub(xs,i,a),j) = Sub(xs,j))
  \end
  \eq* 
    i >= L(xs) -> Msub(xs,i,a) = xs
  \end
  \para* Nepoužite žiadne pomocné funkcie. 

fun/3 Msub 'Tex3_msub'
  Msub(xs,i,a) = Foo

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Filter_even(xs) \end, ktorej 
  hodnotou je zoznam párnych čísel zo zoznamu \ft xs \end v pôvodnom 
  vzájomnom poradí. Napr. \ft Filter_even(1,2,6,5,0,1,4,0) = 2,6,0,4,0 \end. 

fun Filter_even 
  Filter_even(xs) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Zip  \end Zadefinujte funkciu 
  \ft Zip(xs,ys) \end, ktorej hodnotou pre zoznamy \ft xs \end a \ft ys \end 
  rovnakej dĺžky je zoznam \it  dvojíc  \end prvkov zoznamov \ft xs \end a 
  \ft ys \end: 
  \eq* 
    Zip((x1,x2,Tex0_ldots,Tex2_varidx(x,n),0),
        Tex1_paren(y1,y2,Tex0_ldots,Tex2_varidx(y,n),0)) = 
    (x1,y1),(x2,y2),Tex0_ldots,(Tex2_varidx(x,n),Tex2_varidx(y,n)),0
  \end
  \para Napr. 
  \ft Zip((9,8,7,6,5,0),Paren(1,2,3,4,5,0)) = (9,1),(8,2),(7,3),(6,4),(5,5),0 \end. 

fun/2 Zip 
  Zip(xs,ys) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Interval  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Interval(m,n),Tex2_interval_co(m,n)) \end, ktorej hodnotou je 
  zoznam prirodzených v polouzavretom intervale 
  \ft Tex2_realinterval_co(m,n) \end. 
  \header* fun/2 Interval 'Tex2_interval_co' \end 
  \para* Napr. \ft Interval(4,8) = 4,5,6,7,0 \end. 
  \para* Špecifikácia 
  \eq* 
    m <= n -> L Interval(m,n) = n-m
  \end
  \eq* 
    m+i < n -> Sub(Interval(m,n),i) = m+i
  \end
  \para Nepoužite zreťazenie. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Interval_test = r:Results
  \end

fun/2 Interval 'Tex2_interval_co'
  Interval(m,n) = Foo

fun/0 Interval_test 
  Interval_test = 
  Check(Interval(0,0),0),Check(Interval(4,4),0),Check(Interval(0,1),0,0),
  Check(Interval(4,5),4,0),Check(Interval(0,4),0,1,2,3,0),
  Check(Interval(4,8),4,5,6,7,0),Check(Interval(8,4),0),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Map_fib(xs) \end, ktorá 
  aplikuje Fibonacciho funkciu na všetky prvky zoznamu \ft xs \end a vráti 
  zoznam výsledkov: 
  \eq* 
    Map_fib(a1,a2,Tex0_ldots,Tex2_varidx(a,n),0) = 
    Fib(a1),Fib(a2),Tex0_ldots,Fib Tex2_varidx(a,n),0
  \end
  \para* Špecifikácia 
  \eq* 
    L Map_fib(x) = L(x)
  \end
  \eq* 
    i < L(x) -> Sub(Map_fib(x),i) = Fib Sub(x,i)
  \end
  \para Použite funkciu \ft Fib(n) \end je zadefinovanú na začiatku tohto 
  súboru. 
  \para* Funkciu \ft Map_fib \end naprogramujte tak, aby sa dala použiť 
  s akoukoľvek funkciou \ft Tex1_f(n) \end namiesto \ft Fib(n) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Map_fib_test = r:Results
  \end

fun Map_fib 
  Map_fib(xs) = Foo

fun/0 Map_fib_test 
  Map_fib_test = 
  Check(Map_fib(0),0),Check(Map_fib(0,0),0,0),Check(Map_fib(6,0),8,0),
  Check(Map_fib(6,0,3,0),8,0,2,0),
  Check(Map_fib(0,1,2,3,4,5,6,7,8,9,10,0),0,1,1,2,3,5,8,13,21,34,55,0),
  Check(Map_fib(0,9,2,7,4,6,5,3,8,1,10,0),0,34,1,13,3,8,5,2,21,1,55,0),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Table_fib(n) \end, ktorá 
  vypočíta zoznam prvých \ft n \end prvkov Fibonacciho postupnosti, teda 
  \eq* 
    Table_fib(0) = 0
  \end
  \eq* 
    Table_fib(n+1) = Fib(0),Fib(1),Tex0_ldots,Fib(n),0
  \end
  \para* Funkciu \ft Table_fib \end naprogramujte tak, aby sa dala použiť 
  s akoukoľvek funkciou \ft Tex1_f(n) \end namiesto \ft Fib(n) \end. 
  \para* Nájdite \it  explicitnú  \end (t.j., nie rekurzívnu) definíciu 
  využívajúcu predchádzajúce funkcie. Nepoužite zreťazenie. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Table_fib_test = r:Results
  \end

fun Table_fib 
  Table_fib(n) = Foo

fun/0 Table_fib_test 
  Table_fib_test = 
  Check(Table_fib(0),0),Check(Table_fib(1),0,0),Check(Table_fib(2),0,1,0),
  Check(Table_fib(3),0,1,1,0),Check(Table_fib(4),0,1,1,2,0),
  Check(Table_fib(11),0,1,1,2,3,5,8,13,21,34,55,0),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Maxl(xs) \end, ktorej 
  hodnotou je najväčší prvok zoznamu \ft xs \end. Pre prázdny zoznam 
  funkcia vráti 0. 
  \para* \header* fun/2 Max  \end Postupujte podobne ako pri funkcii 
  \ft Minl(xs) \end a využite funkciu 
  \ft Tex2_equiv(Max(x,y),Tex2_max(x,y)) \end definovanú na začiatku tohto 
  súboru. 
  \para* Napr. \ft Maxl(3,2,5,1,5,4,0) = 5 \end. 
  \verbatim 
      Maxl_test = r:Results_n
  \end

fun Maxl 
  Maxl(xs) = Foo

fun/0 Maxl_test 
  Maxl_test = 
  Check(Maxl(0),0),Check(Maxl(0,0),0),Check(Maxl(4,0),4),Check(Maxl(5,4,0),5),
  Check(Maxl(1,5,4,0),5),Check(Maxl(5,1,5,4,0),5),Check(Maxl(3,2,5,1,5,4,0),5),
  Check(Maxl(3,2,0,5,1,5,4,0),5),
  Check(Maxl(3,2,5,Sq(100000000),1,5,4,0),Sq(100000000)),
  Check(Maxl(Sq(100000000),Sq(200000000),100000000*200000000,0),Sq(200000000)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Suml(xs) \end, ktorej 
  hodnotou je súčet všetkých prvkov zoznamu \ft xs \end: 
  \eq* 
    Suml(0) = 0
  \end
  \eq* 
    Suml(a1,a2,Tex0_ldots,Tex2_varidx(a,n),0) = 
    a1+a2+Tex0_ldots+Tex2_varidx(a,n)
  \end
  \para Napr. \ft Suml(2,3,5,7,11,0) = 28 \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Suml_test = r:Results
  \end

fun Suml 
  Suml(xs) = Foo

fun/0 Suml_test 
  Suml_test = 
  Check(Suml(0),0),Check(Suml(6,0),6),Check(Suml(1,2,3,0),6),
  Check(Suml(0,0,0,0),0),Check(Suml(0,0,6,0),6),
  Check(Suml(10,2,8,4,6,5,7,3,9,1,0),55),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Rotl(xs) \end, ktorá zrotuje 
  neprázdny zoznam \ft xs \end doľava: 
  \eq* 
    Rotl(a1,a2,Tex0_ldots,Tex2_varidx(a,n),0) = 
    a2,Tex0_ldots,Tex2_varidx(a,n),a1,0
  \end
  \para Napr. \ft Rotl(2,4,6,8,0) = 4,6,8,2,0 \end. Pokúste sa o definíciu bez 
  pomocných funkcií a bez zreťazenia. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Rotl_test = r:Results
  \end

fun Rotl 
  Rotl(xs) = Foo

fun/0 Rotl_test 
  Rotl_test = 
  Check(Rotl(6,0),6,0),Check(Rotl(2,4,0),4,2,0),Check(Rotl(2,4,6,0),4,6,2,0),
  Check(Rotl(4,6,8,0),6,8,4,0),Check(Rotl(2,6,8,0),6,8,2,0),
  Check(Rotl(2,4,6,8,0),4,6,8,2,0),
  Check(Rotl(1,2,3,4,5,6,7,8,9,0),2,3,4,5,6,7,8,9,1,0),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Rotr(xs) \end, ktorá zrotuje 
  neprázdny zoznam \ft xs \end doprava: 
  \eq* 
    Rotr(a1,a2,Tex0_ldots,Tex2_varidx(a,n),Tex2_varidx(a,n+1),0) = 
    Tex2_varidx(a,n+1),a1,a2,Tex0_ldots,Tex2_varidx(a,n),0
  \end
  \para Napr. \ft Rotr(2,4,6,8,0) = 8,2,4,6,0 \end. Pokúste sa o definíciu bez 
  pomocných funkcií a bez zreťazenia. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Rotr_test = r:Results
  \end

fun Rotr 
  Rotr(xs) = Foo

fun/0 Rotr_test 
  Rotr_test = 
  Check(Rotr(6,0),6,0),Check(Rotr(2,4,0),4,2,0),Check(Rotr(2,4,6,0),6,2,4,0),
  Check(Rotr(4,6,8,0),8,4,6,0),Check(Rotr(2,4,6,8,0),8,2,4,6,0),
  Check(Rotr(1,2,3,4,5,6,7,8,9,0),9,1,2,3,4,5,6,7,8,0),0

rem 
  \para \bf  Prémiová domáca úloha \it  du07a  \end.  \end (2×3 body) 
  Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp/#pdu  \end 
  \para Naprogramujte funkciu \ft Rotl \end alebo \ft Rotr \end podľa vyššie 
  uvedeného zadania \it  bez  \end použitia pomocných funkcií a bez 
  zreťazenia. Každá funkcia má hodnotu 3 body. 

