mod Ex05a

loc rem 
  \para \bf  5. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2011/2012  \end 
  \para* \bf  ČASŤ A  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex05.zip 

loc rem 
  \para* \it  Dátum:  \end 12. 3. 2012 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované párovaniu
  ( \it  ex05a  \end) a reprezentácii celých čísel ( \it  ex05b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2011/2012. 
  \para http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1112ls/udp-screen.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,3,Op(Ent('equiv'),0),Arg(1))

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

appldisp/1 Tex1_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_fib
  Subsup(Id(0,'fib',0),75,Arg(0),None)

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  9. PÁROVANIE  \end 

rem 
  \para \bf  9.2. Párovacie funkcie  \end 

rem 
  \para \bf  9.2.1. Párovacia funkcia CL  \end 

rem 
  \para \it  [CL] Zabudovaná párovacia funkcia.  \end Párovacia funkcia 
  zabudovaná do CL je založená na enumerácii (očíslovaní) binárnych 
  stromov. Zapisuje sa binárnym infixovým operátorom “ \bf  ,  \end ” 
  (čiarka), napríklad 
  \eq* 
    1,3
  \end
  \para Operátor “,” má veľmi nízku prioritu a implicitne sa zátvorkuje 
  doprava: 
  \eq* 
    Tex2_equiv((1+2,3+4),Tex1_paren(Tex1_paren(1+2),Tex1_paren(3+4)))
  \end
  \eq* 
    Tex2_equiv((1,2,3,4),Tex1_paren(1,Tex1_paren(2,Tex1_paren(3,4))))
  \end

rem 
  \para \it  Vlastnosti párovacej funkcie CL.  \end Podobne ako pre iné 
  párovacie funkcie, aj funkcia \ft Paren(x,y) \end má párovacie vlastnosti: 
  \items 
   \item \para ak sa dva páry rovnajú, rovnajú sa po zložkách: 
         \eq (1)
           Paren(x,y) = Paren(u,v) -> x = u & y = v
         \end
   \item \para zložky páru sú menšie ako pár: 
         \eq (2)
           x < Paren(x,y) & y < Paren(x,y)
         \end
   \item \para každé nenulové číslo je pár: 
         \eq (3)
           x = 0 \/ \e y\e z x = Paren(y,z)
         \end
  \end
  \para Z vlastnosti (2) vyplýva: 
  \eq (4)
    0 != Paren(x,y)
  \end

rem 
  \para \bf  [CL] Úloha.  \end CL nepočíta číselnú hodnotu párovacej 
  funkcie, pokiaľ nie je priamo potrebná. Vyskúšajte napríklad dopyt 
  (query): 
  \verbatim 
      1+1,2+2 = x
  \end
  \para Ak chcete poznať hodnotu párovacej funkcie pre nejaké čísla, 
  môžete využiť napríklad formát \ft N \end, ktorý každé číslo (aj 
  výsledok párovania) zobrazí v desiatkovom zápise: 
  \verbatim 
      1+1,2+2 = x:N
  \end
  \para alebo použiť párovanie ako argument aritmetickej operácie: 
  \verbatim 
      (1+1,2+2)+0 = x
  \end
  \para Pri bežnom programovaní nie je vyčíslenie párovacej funkcie 
  potrebné. 

rem 
  \para \bf  9.2.2. Programovanie s párovacou funkciou  \end 

rem 
  \para \it  [CL] Párová diskriminácia.  \end Na definovanie funkcií, ktoré 
  spracúvajú vstup vytvorený párovaním budeme používať párovú 
  diskrimináciu: 
  \def* 
    Tex1_cdots(t) <- t = 0
    Tex1_cdots(t) <- t = x,y
  \end
  \para kde \ft x \end a \ft y \end sú nové premenné. 
  \para Párovú diskrimináciu umožňujú vlastnosti (3) a (4) 
  z predchádzajúceho odseku. 

rem 
  \para \bf  [CL] Úloha.  \end Porovnávania so vzorom z dyadickej 
  diskriminácie môžete použiť aj v dopytoch (queries). Vyskúšajte 
  napríklad: 
  \verbatim 
      0 = x & x = 0
      0 = x & x = u,v
      8,3 = x & x = 0
      8,3 = x & x = u,v
      126 = x & x = 0
      126 = x & x = u,v
  \end

rem 
  \para \it  Fibonacciho postupnosť.  \end 

fun Fib 'Tex1_fib'
  Fib(0) = 0
  Fib(1) = 1
  Fib(n+2) = Fib(n+1)+Fib(n)

rem 
  \para \bf  Úloha.  \end Zadefinujte primitívnou rekurziou funkciu 
  \eq* 
    Twofib(n) = Paren(Fib(n),Fib(n+1))
  \end
  \para \bf  bez použitia  \end funkcie \ft Fib(n) \end. 

fun Twofib 
  Twofib(n) = Foo

rem 
  \para \bf  9.2.3. Tupling  \end 

rem 
  \para \it  Celočíselné delenie a zvyšok všeobecnou rekurziou.  \end 

fun/2 Div 
  Div(x,y) = 0 <- y = 0
  Div(x,y) = 0 <- y != 0 & x < y
  Div(x,y) = Div(x-y,y)+1 <- y != 0 & x >= y

fun/2 Mod 
  Mod(x,y) = 0 <- y = 0
  Mod(x,y) = x <- y != 0 & x < y
  Mod(x,y) = Mod(x-y,y) <- y != 0 & x >= y

rem 
  \para \bf  Úloha.  \end \header* fun/2 Divmod  \end Zadefinujte všeobecnou 
  rekurziou funkciu 
  \eq* 
    Divmod(x,y) = Paren(Div(x,y),Mod(x,y))
  \end
  \para \bf  bez použitia  \end funkcií \ft Div \end, \ft Mod \end 
  a operátorov / a mod. 

fun/2 Divmod 
  Divmod(x,y) = Foo

rem 
  \para \it  Prvý symbol a zvyšok dyadického reťazca.  \end 

fun First 
  First(0) = 0
  First S1(x) = 1 <- x = 0
  First S1(x) = First(x) <- x != 0
  First S2(x) = 2 <- x = 0
  First S2(x) = First(x) <- x != 0

fun Rest 
  Rest(0) = 0
  Rest S1(x) = 0 <- x = 0
  Rest S1(x) = S1 Rest(x) <- x != 0
  Rest S2(x) = 0 <- x = 0
  Rest S2(x) = S2 Rest(x) <- x != 0

rem 
  \para \bf  Úloha.  \end Zadefinujte dyadickou rekurziou funkciu 
  \eq* 
    Firstrest(x) = Paren(First(x),Rest(x))
  \end
  \para \bf  bez použitia  \end funkcií \ft First \end a \ft Rest \end. 

fun Firstrest 
  Firstrest(x) = Foo

