mod Ex05b

incl Mtesting

loc rem 
  \para \bf  5. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2011/2012  \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex05.zip 

loc rem 
  \para* \it  Dátum:  \end 12. 3. 2012 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované párovaniu
  ( \it  ex05a  \end) a reprezentácii celých čísel ( \it  ex05b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2011/2012. 
  \para http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1112ls/udp-screen.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

pred/0 Quux 'Tex0_foo'
  Quux <-> \f

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,3,Op(Ent('equiv'),0),Arg(1))

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

appldisp/2 Tex2_sub
  Infix(Arg(0),39,0,Op(Ent('minus'),0),Arg(1))

appldisp/2 Tex2_add
  Infix(Arg(0),39,0,Op('+',0),Arg(1))

appldisp/1 Tex1_opp
  Prefix(50,0,Op(Ent('minus'),0),Arg(0))

appldisp/2 Tex2_mul
  Infix(Arg(0),39,0,Op(Ent('sdot'),0),Arg(1))

appldisp/2 Tex2_eqz
  Infix(Arg(0),31,3,Subsup(Op('=',0),75,Op('Z',0),None),Arg(1))

appldisp/2 Tex2_checkz
  Infix(Arg(0),30,0,Subsup(Op('=',0),75,Op('Z',0),Id(6,'?',0)),Arg(1))

appldisp/1 Tex1_cz
  Prefix(90,0,Subsup(Id(0,'C',0),50,Op('Z',0),None),Arg(0))

appldisp/0 Tex0_zeroz
  Subsup(Num('0',0),75,Op('Z',0),None)

appldisp/1 Tex1_oppz
  Prefix(50,0,Subsup(Op(Ent('minus'),0),50,Op('Z',0),None),Arg(0))

appldisp/2 Tex2_addz
  Infix(Arg(0),50,0,Subsup(Op('+',0),75,Op('Z',0),None),Arg(1))

appldisp/2 Tex2_nmulz
  Infix(Arg(0),50,0,Subsup(Op(Ent('sdot'),0),75,Op('Z',0),None),Arg(1))

appldisp/0 Tex0_onez
  Subsup(Num('1',0),75,Op('Z',0),None)

appldisp/2 Tex2_mulz
  Infix(Arg(0),50,0,Subsup(Op(Ent('times'),0),75,Op('Z',0),None),Arg(1))

appldisp/2 Tex2_subz
  Infix(Arg(0),50,0,Subsup(Op(Ent('minus'),0),75,Op('Z',0),None),Arg(1))

appldisp/2 Tex2_gcd
  Std('gcd',0)

appldisp/2 Tex2_egcd
  Prefix(90,2,Underover(Id(0,'gcd',0),None,Op(Ent('OverBar'),0)),
         Fenced(Op('(',0),Infix(Arg(0),30,2,Op(',',0),Arg(1)),Op(')',0)))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  9. PÁROVANIE  \end 

rem 
  \para \bf  9.4. Kódovanie celých čísel párovaním  \end 

rem 
  \para \it  Úvod.  \end Celé čísla môžeme reprezentovať triedami dvojíc 
  prirodzených čísel, pričom trieda dvojíc 
  \para [( \ft a \end, \ft b \end)] = { ( \ft c \end, \ft d \end) | 
  \ft Tex2_add(a,d) = Tex2_add(c,b) \end } 
  \para* reprezentuje číslo \ft Tex2_sub(a,b) \end. 
  \para V tejto časti cvičenia \it  zakódujeme  \end celé čísla do 
  prirodzených čísel tak, že usporiadanú dvojicu prirodzených čísel ( 
  \ft a \end, \ft b \end), ktorá reprezentuje celé číslo 
  \ft Tex2_sub(a,b) \end, zakódujeme párom \ft Paren(a,b) \end. Táto 
  reprezentácia \it  nie je jednoznačná  \end, jedno celé číslo je 
  reprezentované nekonečným počtom párov. 
  \para Na pároch zadefinujeme aritmetické operácie ako na celých číslach. 
  \para Aritmetické operácie využijeme na naprogramovanie rozšíreného 
  euklidovského algoritmu. 

rem 
  \para \it  Notačné konvencie pre túto časť cvičenia.  \end 
  \para Premenné \ft a \end, \ft b \end, \ft c \end, \ft d \end, \ft e \end, 
  \ft f \end označujú prirodzené čísla. 
  \para Premenné \ft x \end, \ft y \end, \ft z \end označujú reprezentantov 
  celých čísel. 
  \para Operácie na reprezentantoch celých čísel majú koncovku -z 
  (napríklad \ft Addz \end) a zobrazujú sa s dolným indexom Z (napríklad 
  \ft Tex2_addz(x,y) \end). 

rem 
  \para \bf  Úloha. Reprezentant celého čísla.  \end Celé čísla 
  reprezentujeme kódmi dvojíc prirodzených čísel. Predikát \ft Z(x) \end 
  platí, keď \ft x \end reprezentuje celé číslo. 
  \para Špecifikácia: 
  \eq* 
    Z(x) <-> \e a\e b x = Paren(a,b)
  \end

pred Z 'Tex1_z'
  Z(x) <- Quux

rem 
  \para \bf  Úloha. Rovnosť celých čísel, ekvivalencia reprezentantov. 
   \end \header* pred/2 Eqz  \end Zadefinujte predikát 
  \ft Tex2_equiv(Eqz(x,y),Tex2_eqz(x,y)) \end, ktorý platí, ak prirodzené 
  čísla \ft x \end a \ft y \end reprezentujú to isté celé číslo. 
  \para Špecifikácia: \header* pred/2 Eqz 'Tex2_eqz' \end 
  \eq* 
    Eqz((a,b),c,d) <-> Tex2_sub(a,b) = Tex2_sub(c,d)
  \end

pred/2 Eqz 'Tex2_eqz'
  Eqz(x,y) <- Quux

rem 
  \para Dokážte, že za predpokladu \ft Z(x) & Z(y) & Z(z) \end pre vašu 
  definíciu platí: 
  \eq* 
    Eqz(x,x)
  \end
  \eq* 
    Eqz(x,y) -> Eqz(y,x)
  \end
  \eq* 
    Eqz(x,y) & Eqz(y,z) -> Eqz(x,z)
  \end

rem 
  \para \it  Pomocná definícia pre testovanie.  \end Nasledujúcu funkciu 
  vyžijeme pri testovaní. Preskočte. 

fun/2 Checkz 'Tex2_checkz'
  Checkz(x,y) = Result_ok(x,y,Type_z) <- Eqz(x,y)
  Checkz(x,y) = Result_failed(x,y,Type_z) <- ~Eqz(x,y)

rem 
  \para \bf  Úloha. Kanonický reprezentant.  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Cz(x),Tex1_cz(x)) \end, ktorá pre ľubovoľného reprezentanta 
  \ft x \end nejakého celého čísla vypočíta kanonického reprezentanta 
  tohto celého čísla. 
  \para Špecifikácia: \header* fun Cz 'Tex1_cz' \end 
  \eq* 
    Z(x) -> Z Cz(x)
  \end
  \eq* 
    Z(x) -> Eqz(x,Cz(x))
  \end
  \eq* 
    Cz(x) = a,b -> a = 0 \/ b = 0
  \end

fun Cz 'Tex1_cz'
  Cz(x) = Foo

rem 
  \para \it  Testovanie.  \end Otestujte svoje riešenie pomocou nasledujúcej 
  konštanty \ft Cz_test \end. Použite dopyt (query): 
  \verbatim 
      Cz_test = r:Results
  \end
  \para Ak je vaša definícia funkcie \ft Cz(x) \end správna, výsledkom bude: 
  \para \ft r = 
            Result_ok((0,0),(0,0),Type_m),Result_ok((5,0),(5,0),Type_m),
            Result_ok((0,5),(0,5),Type_m),Result_ok((0,0),(0,0),Type_m),
            Result_ok((5,0),(5,0),Type_m),Result_ok((0,5),(0,5),Type_m),0 \end 
  \para* Ak je vaša definícia chybná, vo výsledku sa objaví 
  \ft Result_failed(x,y,Type_m) \end pre nesprávny výsledok \ft x \end 
  a očakávanú správnu hodnotu \ft y \end. 

fun/0 Cz_test 
  Cz_test = 
  Check(Cz(0,0),0,0),Check(Cz(5,0),5,0),Check(Cz(0,5),0,5),Check(Cz(2,2),0,0),
  Check(Cz(7,2),5,0),Check(Cz(4,9),0,5),0

rem 
  \para \bf  9.4.1. Operácie na celých číslach  \end 

rem 
  \para \bf  Úloha. Nula, neutrálny prvok sčítania.  \end Zadefinujte 
  konštantu \ft Tex2_equiv(Zeroz,Tex0_zeroz) \end, ktorej hodnotou je 
  reprezentant celého čísla \ft 0 \end. 
  \para Špecifikácia: \header* fun/0 Zeroz 'Tex0_zeroz' \end 
  \eq* 
    Z(Zeroz)
  \end
  \eq* 
    Zeroz = Paren(a,b) <-> Tex2_sub(a,b) = 0
  \end

fun/0 Zeroz 'Tex0_zeroz'
  Zeroz = Foo

fun/0 Zeroz_test 
  Zeroz_test = Checkz(Zeroz,5,5),0

rem 
  \para \it  Testovanie.  \end Otestujte svoje riešenie pomocou nasledujúcej 
  konštanty \ft Zeroz_test \end podobne ako pri funkcii \ft Cz(x) \end. 
  Použite dopyt (query): 
  \verbatim 
      Zeroz_test = r:Results
  \end

rem 
  \para \bf  Úloha. Sčítanie celých čísel.  \end \header* fun/2 Addz  \end 
  Zadefinujte funkciu \ft Tex2_equiv(Addz(x,y),Tex2_addz(x,y)) \end, ktorá 
  vráti reprezentanta súčtu celých čísel s reprezentantmi \ft x \end a 
  \ft y \end. 
  \para Špecifikácia: \header* fun/2 Addz 'Tex2_addz' \end 
  \eq* 
    Z(x) & Z(y) -> Z Addz(x,y)
  \end
  \eq* 
    Addz((a,b),c,d) = Paren(e,f) <-> 
    Tex2_add(Tex2_sub(a,b),Tex2_sub(c,d)) = Tex2_sub(e,f)
  \end

fun/2 Addz 'Tex2_addz'
  Addz(x,y) = Foo

rem 
  \para \it  Testovanie.  \end Otestujte svoje riešenie pomocou nasledujúcej 
  konštanty \ft Addz_test \end podobne ako pri funkcii \ft Cz(x) \end. Použite 
  dopyt (query): 
  \verbatim 
      Addz_test = r:Results
  \end
  \para Ďalšie definície testujte podobne. 

fun/0 Addz_test 
  Addz_test = 
  Checkz(Addz((10,5),20,5),20,0),Checkz(Addz((10,5),5,20),0,10),
  Checkz(Addz((5,10),5,20),0,20),Checkz(Addz((5,10),20,5),10,0),
  Checkz(Addz((5,10),17,12),0,0),0

rem 
  \para \bf  Úloha. Opačné celé číslo.  \end \header* fun Oppz  \end 
  Zadefinujte funkciu \ft Tex2_equiv(Oppz(x),Tex1_oppz(x)) \end, ktorá vráti 
  reprezentanta opačného čísla k celému číslu s reprezentantom 
  \ft x \end. 
  \para Špecifikácia: \header* fun Oppz 'Tex1_oppz' \end 
  \eq* 
    Z(x) -> Z Oppz(x)
  \end
  \eq* 
    Oppz(a,b) = Paren(c,d) <-> Tex1_opp Tex2_sub(a,b) = Tex2_sub(c,d)
  \end

fun Oppz 'Tex1_oppz'
  Oppz(x) = Foo

rem 
  \para \it  Testovanie.  \end 
  \verbatim 
      Oppz_test = r:Results
  \end

fun/0 Oppz_test 
  Oppz_test = 
  Checkz(Oppz(0,0),5,5),Checkz(Oppz(5,0),2,7),Checkz(Oppz(0,5),9,4),
  Checkz(Oppz(2,2),0,0),Checkz(Oppz(7,2),4,9),Checkz(Oppz(4,9),7,2),0

rem 
  \para Dokážte, že za predpokladu \ft Z(x) & Z(y) & Z(z) \end pre vaše 
  definície platí: 
  \eq* 
    Eqz(Addz(x,Addz(y,z)),Addz(Addz(x,y),z))
  \end
  \eq* 
    Eqz(Addz(x,y),Addz(y,x))
  \end
  \eq* 
    Eqz(Addz(x,Zeroz),x)
  \end
  \eq* 
    Eqz(Addz(x,Oppz(x)),Zeroz)
  \end

rem 
  \para \bf  Úloha. Odčítanie celých čísel.  \end 
  \header* fun/2 Subz  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Subz(x,y),Tex2_subz(x,y)) \end, ktorá vráti reprezentanta 
  rozdielu celých čísel s reprezentantmi \ft x \end a \ft y \end. \it  
  Nepoužite  \end funkcie \ft Addz \end a \ft Oppz \end. 
  \para Špecifikácia: \header* fun/2 Subz 'Tex2_subz' \end 
  \eq* 
    Z(x) & Z(y) -> Z Subz(x,y)
  \end
  \eq* 
    Subz((a,b),c,d) = Paren(e,f) <-> 
    Tex2_sub(Tex2_sub(a,b),Tex2_sub(c,d)) = Tex2_sub(e,f)
  \end

fun/2 Subz 'Tex2_subz'
  Subz(x,y) = Foo

rem 
  \para \it  Testovanie.  \end 
  \verbatim 
      Subz_test = r:Results
  \end

fun/0 Subz_test 
  Subz_test = 
  Checkz(Subz((10,5),20,5),0,10),Checkz(Subz((4,3),1,1),1,0),
  Checkz(Subz((10,5),5,20),20,0),Checkz(Subz((5,10),5,20),10,0),
  Checkz(Subz((5,10),20,5),0,20),Checkz(Subz((5,10),7,7),0,5),
  Checkz(Subz((1,1),2,1),0,1),Checkz(Subz((2,2),4,4),3,3),
  Checkz(Subz((1,1),3,5),2,0),0

rem 
  \para Dokážte, že pre vaše definície platí: 
  \eq* 
    Z(x) & Z(y) -> Eqz(Subz(x,y),Addz(x,Oppz(y)))
  \end

rem 
  \para \bf  Úloha. Jednotka, neutrálny prvok násobenia.  \end Zadefinujte 
  konštantu \ft Tex2_equiv(Onez,Tex0_onez) \end, ktorej hodnotou je 
  reprezentant celého čísla \ft 1 \end. 
  \para Špecifikácia: \header* fun/0 Onez 'Tex0_onez' \end 
  \eq* 
    Z(Onez)
  \end
  \eq* 
    Onez = Paren(a,b) <-> Tex2_sub(a,b) = 1
  \end

fun/0 Onez 'Tex0_onez'
  Onez = Foo

rem 
  \para \it  Testovanie.  \end 
  \verbatim 
      Onez_test = r:Results
  \end

fun/0 Onez_test 
  Onez_test = Checkz(Onez,5,4),0

rem 
  \para \bf  Úloha. Násobenie celého čísla prirodzeným číslom.  \end 
  \header* fun/2 Nmulz  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Nmulz(a,x),Tex2_nmulz(a,x)) \end, ktorá vráti reprezentanta 
  súčinu celého čísla s reprezentantom \ft x \end a prirodzeného čísla 
  \ft a \end. 
  \para Špecifikácia: \header* fun/2 Nmulz 'Tex2_nmulz' \end 
  \eq* 
    N(a) & Z(x) -> Z Nmulz(a,x)
  \end
  \eq* 
    Nmulz(a,b,c) = Paren(d,e) <-> Tex2_mul(a,Tex2_sub(b,c)) = Tex2_sub(d,e)
  \end

fun/2 Nmulz 'Tex2_nmulz'
  Nmulz(a,x) = Foo

rem 
  \para \it  Testovanie.  \end 
  \verbatim 
      Nmulz_test = r:Results
  \end

fun/0 Nmulz_test 
  Nmulz_test = 
  Checkz(Nmulz(0,20,5),0,0),Checkz(Nmulz(0,2,2),0,0),Checkz(Nmulz(0,1,2),0,0),
  Checkz(Nmulz(1,2,1),1,0),Checkz(Nmulz(1,2,2),0,0),Checkz(Nmulz(1,1,2),0,1),
  Checkz(Nmulz(2,10,7),6,0),Checkz(Nmulz(3,1,1),0,0),Checkz(Nmulz(2,2,7),0,10),0

rem 
  \para \bf  Úloha. Násobenie celých čísel.  \end \header* fun/2 Mulz  \end 
  Zadefinujte funkciu \ft Tex2_equiv(Mulz(x,y),Tex2_addz(x,y)) \end, ktorá 
  vráti reprezentanta súčinu celých čísel s reprezentantmi \ft x \end a 
  \ft y \end. 
  \para Špecifikácia: \header* fun/2 Mulz 'Tex2_mulz' \end 
  \eq* 
    Z(x) & Z(y) -> Z Mulz(x,y)
  \end
  \eq* 
    Mulz((a,b),c,d) = Paren(e,f) <-> 
    Tex2_mul(Tex2_sub(a,b),Tex2_sub(c,d)) = Tex2_sub(e,f)
  \end

fun/2 Mulz 'Tex2_mulz'
  Mulz(x,y) = Foo

rem 
  \para \it  Testovanie.  \end 
  \verbatim 
      Mulz_test = r:Results
  \end

fun/0 Mulz_test 
  Mulz_test = 
  Checkz(Mulz((1,3),1,3),4,0),Checkz(Mulz((1,3),1,2),2,0),
  Checkz(Mulz((1,3),1,1),0,0),Checkz(Mulz((1,3),3,2),0,2),
  Checkz(Mulz((1,3),3,1),0,4),Checkz(Mulz((3,4),2,3),1,0),
  Checkz(Mulz((3,4),2,2),0,0),Checkz(Mulz((3,4),2,1),0,1),
  Checkz(Mulz((3,4),5,3),0,2),Checkz(Mulz((3,3),2,2),0,0),
  Checkz(Mulz((4,4),2,1),0,0),Checkz(Mulz((1,1),4,2),0,0),
  Checkz(Mulz((3,2),2,1),1,0),Checkz(Mulz((5,4),4,1),3,0),
  Checkz(Mulz((5,2),3,1),6,0),0

rem 
  \para Dokážte, že za predpokladu \ft Z(x) & Z(y) & Z(z) & N(a) \end pre 
  vaše definície platí: 
  \eq* 
    Eqz(Mulz(x,Mulz(y,z)),Mulz(Mulz(x,y),z))
  \end
  \eq* 
    Eqz(Mulz(x,y),Mulz(y,x))
  \end
  \eq* 
    Eqz(Mulz(x,Onez),x)
  \end
  \eq* 
    Eqz(Mulz(x,Zeroz),Zeroz)
  \end
  \eq* 
    Eqz(Mulz(x,Addz(y,z)),Addz(Mulz(x,y),Mulz(x,z)))
  \end
  \eq* 
    Eqz(Nmulz(a,x),Mulz(Nmulz(a,Onez),x))
  \end
  \eq* 
    Eqz(Oppz(x),Mulz(Oppz(Onez),x))
  \end

rem 
  \para \bf  9.4.2. Rozšírený euklidovský algoritmus  \end 

rem 
  \para \it  Euklidovský algoritmus.  \end 

fun/2 Gcd 'Tex2_gcd'
  Gcd(a,b) = b <- a = 0
  Gcd(a,b) = Gcd(b mod a,a) <- a != 0

rem 
  \para \bf  Úloha. Rozšírený euklidovský algoritmus.  \end 
  \header* fun/2 Egcd  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Egcd(a,b),Tex2_egcd(a,b)) \end, ktorá pre všetky prirodzené 
  čísla \ft a \end a \ft b \end vráti dvojicu reprezentantov celých čísel 
  \ft x \end a \ft y \end takých, že platí 
  \ft Gcd(a,b) = Tex2_add(Tex2_mul(a,x),Tex2_mul(b,y)) \end. 
  \para Špecifikácia: \header* fun/2 Egcd 'Tex2_egcd' \end 
  \eq* 
    N(a) & N(b) -> \e x\e y(Egcd(a,b) = Paren(x,y) & Z(x) & Z(y))
  \end
  \eq* 
    Egcd(a,b) = Paren(x,y) -> 
    Eqz(Nmulz(Gcd(a,b),Onez),Addz(Nmulz(a,x),Nmulz(b,y)))
  \end

fun/2 Egcd 'Tex2_egcd'
  Egcd(a,b) = Foo

rem 
  \para \it  Testovanie.  \end 
  \verbatim 
      Egcd_test = r:Results
  \end

fun/2 Egcd_check 
  Egcd_check(a,b) = Checkz(Addz(Nmulz(a,x),Nmulz(b,y)),Nmulz(g,Onez)) <- 
    Egcd(a,b) = x,y & Gcd(a,b) = g

fun/0 Egcd_test 
  Egcd_test = 
  Egcd_check(0,0),Egcd_check(5,0),Egcd_check(0,5),Egcd_check(15,7),
  Egcd_check(7,15),Egcd_check(210,260),Egcd_check(260,210),
  Egcd_check(13026,23712),Egcd_check(23712,13026),0

