mod Ex04a


loc rem 
  \para \bf  4. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2014/2015  \end 
  \para* \bf  ČASŤ A  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex04.zip 

loc rem 
  \para* \it  Dátum:  \end 18. 3. 2015 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.21  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované aritmetickým 
  operáciám na binárnom zápise čísel ( \it  ex04a  \end) a tuplingu ( 
  \it  ex04b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2014/2015. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2015.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 


incl Mtesting04

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/0 Tex0_tau
  Id(0,Ent('tau'),0)

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots
  Op(Ent('ctdot'),0)

appldisp/2 Tex2_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots_around
  Fenced(Op(Ent('ctdot'),0),Arg(0),Op(Ent('ctdot'),0))

appldisp/1 Tex1_paren_cdots_paren_around
  Fenced(Op('(',Ent('ctdot'),'(',0),Arg(0),Op(')',Ent('ctdot'),')',0))

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

appldisp/2 Tex2_idx
  Subsup(Arg(0),75,Arg(1),None)

appldisp/1 Tex1_set
  Fenced(Op('{',0),Arg(0),Op('}',0))

appldisp/2 Tex2_lt
  Infix(Arg(0),25,3,Op(Ent('lt'),0),Arg(1))

appldisp/2 Tex2_le
  Infix(Arg(0),25,3,Op(Ent('lE'),0),Arg(1))

appldisp/2 Tex2_in
  Infix(Arg(0),25,0,Op(Ent('isin'),0),Arg(1))

appldisp/1 Tex1_f
  Prefix(90,2,Id(1,'F',0),Arg(0))

appldisp/0 Tex0_0
  Num('0',0)

appldisp/1 Tex1_s0
  Std('S0',0)

appldisp/1 Tex1_s1
  Std('S1',0)

appldisp/1 Tex1_s2
  Std('S2',0)

appldisp/2 Tex2_equiv
  Infix(Arg(0),26,3,Op(Ent('equiv'),0),Arg(1))

appldisp/2 Tex2_exp
  Subsup(Arg(0),75,None,Arg(1))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  8. BINÁRNA ČÍSELNÁ SÚSTAVA  \end 

rem 
  \para \it  Binárny zápis čísla.  \end Každé prirodzené číslo 
  \ft n \end možno zapísať v tvare 
  \eq* 
    n = 
    (Tex1_paren_cdots_paren_around((0*2+Tex2_idx(b,k))*2+Tex2_idx(b,k-1))*2+b1)*
    2+Tex2_idx(b,0)
  \end
  \para kde \ft Tex2_in(Tex2_idx(b,i),Tex1_set(0,1)) \end pre všetky 
  \ft Tex2_le(0,Tex2_le(i,k)) \end. 
  \para Postupnosť \ft 0 \end \ft Tex2_idx(b,k) \end \ft Tex2_idx(b,k-1) \end 
  … \ft b1 \end \ft Tex2_idx(b,0) \end nazývame \it  binárnym zápisom  \end 
  (binárnou reprezentáciou) čísla \ft n \end. 
  \para Napríklad 
  \eq* 
    13 = (((0*2+1)*2+1)*2+0)*2+1
  \end
  \para Binárny zápis čísla \ft 13 \end je teda 
  \eq* 
    S1 S0 S1 S1(0)
  \end

rem 
  \para \bf  8.1. Binárne konštruktory  \end 

rem 
  \para \it  [CL] Binárne konštruktory.  \end V CL sú preddefinované 
  funkcie 
  \eq* 
    Tex2_equiv(Tex1_s0(x),S0(x)) = 2*x+0
  \end
  \eq* 
    Tex2_equiv(Tex1_s1(x),S1(x)) = 2*x+1
  \end
  \para nazývané \it  binárne konštruktory  \end. Pomocou nich môžeme 
  konštruovať binárny zápis čísel. Funkciu \ft Tex1_s0(n) \end môžeme 
  chápať ako „pridaj číslicu 0 na koniec binárneho zápisu čísla 
  \ft n \end “. Tomu zodpovedá aj spôsob jej zobrazenia: \ft S0(n) \end. 
  Význam \ft S1 \end sa dá chápať analogicky. 

rem 
  \para \bf  [CL] Úloha  \end. Vyhodnoťte nasledujúce dopyty (queries): 
  \verbatim 
  S1 S0 S1 S1(0) = n
  \end
  \verbatim 
  50 = n & S0(n) = p & S1(n) = q
  \end

rem 
  \para \bf  8.2. Binárna diskriminácia  \end 

rem 
  \para \bf  \it  [CL] Binárny formát.  \end  \end CL dokáže zobraziť 
  hodnotu premennej v Query v binárnom zápise pomocou \it  binárneho 
  formátu  \end \ft Nb \end. 
  \para Syntax: 
  \verbatim 
      hodnota = premenna:Nb
  \end
  \para Hodnota sa zobrazí akoby bola skonštruovaná z 0 pomocou 
  konštruktorov \ft S0 \end a \ft S1 \end. 

rem 
  \para \bf  [CL] Úloha  \end. Vyhodnoťte nasledujúce dopyty (queries): 
  \verbatim 
  13 = n:Nb
  \end
  \verbatim 
  13+12 = n & n = m:Nb
  \end
  \verbatim 
  S1 S0 S1 S0 S1(0) = n & n = m:Nb
  \end

rem 
  \para \bf  \it  [CL] Binárna diskriminácia.  \end  \end Binárny zápis 
  každého prirodzeného čísla \ft n \end končí číslicou 0 alebo 
  číslicou 1: 
  \eq (N2_cover)
    \e m n = S0(m) \/ \e m n = S1(m)
  \end
  \para Tieto možnosti sú vzájomne výlučné 
  \eq (N2_excl)
    ~(\e m n = S0(m) & \e m n = S1(m))
  \end
  \para a tvoria \it  binárnu diskrimináciu  \end. CL pozná túto 
  diskrimináciu. Používame ju v tvare 
  \def* 
    Tex1_cdots(Tex0_tau) <- Tex0_tau = S0(m)
    Tex1_cdots(Tex0_tau) <- Tex0_tau = S1(m)
  \end
  \para kde \ft t \end je ľubovoľný výraz (obyčajne argument funkcie) a 
  \ft m \end je \it  nová  \end premenná (podobne ako pri monadickej 
  diskriminácii). 
  \para Binárnu diskrimináciu možno dosadiť do argumentov definovanej 
  funkcie nasledovne: 
  \def* 
    Tex1_f S0(m) = Tex1_cdots_around(m)
    Tex1_f S1(m) = Tex1_cdots_around(m)
  \end

rem 
  \para \bf  [CL] Úloha  \end. Zadajte nasledujúce dopyty (queries) pre 
  viacero rôznych hodnôt \ft n \end: 
  \verbatim 
  13 = n:Nb & n = 0
  \end
  \verbatim 
  13 = n:Nb & n = S0(m)
  \end
  \verbatim 
  13 = n:Nb & n = S0(m:Nb)
  \end
  \verbatim 
  13 = n:Nb & n = S1(m)
  \end
  \verbatim 
  13 = n:Nb & n = S1(m:Nb)
  \end

rem 
  \para \bf  Úloha.  \end Pomocou binárnej diskriminácie naprogramujte 
  funkciu \ft Mod4(x) \end, ktorej hodnotou je zvyšok po delení čísla 
  \ft n \end číslom \ft 4 \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Mod4_test = r:Results
  \end

fun Mod4 
  Mod4(x) = Foo

fun/0 Mod4_test 
  Mod4_test = 
  Check(Mod4(0),0),Check(Mod4(1),1),Check(Mod4(2),2),Check(Mod4(3),3),
  Check(Mod4(4),0),Check(Mod4(5),1),Check(Mod4(6),2),Check(Mod4(7),3),
  Check(Mod4(8),0),Check(Mod4(9),1),Check(Mod4(10),2),
  Check(Mod4(12345*67890),2),0

rem 
  \para \bf  8.3. Binárna rekurzia  \end 

rem 
  \para \bf  \it  Binárna rekurzia.  \end  \end Ak funkciu zadefinujeme tak, 
  že všetky \it  rekurzívne volania majú menší počet binárnych číslic 
   \end ako pôvodný argument, teda 
  \def* 
    Tex1_f S0(m) = Tex0_cdots <- m = 0
    Tex1_f S0(m) = Tex1_cdots_around Tex1_f(m) <- m > 0
    Tex1_f S1(m) = Tex1_cdots_around Tex1_f(m)
  \end
  \para hovoríme o \it  binárnej rekurzii  \end. \it  Všimnite si  \end, že 
  pre \ft S0(m) \end je potrené rozlíšiť prípady \ft m = 0 \end (teda aj 
  \ft S0(m) = 0 \end) a \ft m > 0 \end (teda aj \ft S0(m) > 0 \end a \ft m \end 
  sa dá zapísať menším počtom binárnych číslic ako \ft S0(m) \end). 
  Binárna rekurzia je špeciálnym prípadom všeobecnej (course-of-values) 
  rekurzie, pretože 
  \eq* 
    m > 0 -> m < S0(m)
  \end
  \eq* 
    m < S1(m)
  \end
  \para Všetky funkcie v tomto cvičení definujte \bf  iba binárnou 
  rekurziou  \end! 

rem 
  \para \bf  8.4. Aritmetické operácie na binárnom zápise čísel  \end 

rem 
  \para \it  Poznámka.  \end Binárnou rekurziou môžeme zadefinovať \it  
  efektívne  \end aritmetické operácie na prirodzených číslach 
  s neobmedzenou presnosťou. Počet krokov potrebných na takto zadefinované 
  operácie lineárne závisí od počtu číslic v binárnom zápise 
  argumentov operácie, nie od hodnoty argumentov. 

rem 
  \para \bf  Úloha. Nasledovník.  \end Binárnou rekurziou zadefinujte funkciu 
  nasledovník \ft Succ(x) = x+1 \end. 
  \para* \it  Návod.  \end Predstavte si binárnu verziu sčítania, ako ste sa 
  ho učili na základnej škole. Uvedomte si, kedy nastáva prenos do 
  vyššieho rádu. 
  \verbatim 
    01100 (12)     01101 (13)      01111 (15)
    +   1          +   1          +    1     
    -----          -----          ------     
    01101 (13)     01110 (14)     010000 (16)
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Succ_test = r:Results_n
  \end

fun Succ 
  Succ(x) = Foo

fun/0 Succ_test 
  Succ_test = 
  Check(Succ(0),1),Check(Succ(1),2),Check(Succ(2),3),Check(Succ(3),4),
  Check(Succ(4),5),Check(Succ(5),6),Check(Succ(6),7),Check(Succ(7),8),
  Check(Succ(8),9),Check(Succ(32768*32367-1),32768*32367),
  Check(Succ(Sq(32768)-1),Sq(32768)),0

rem 
  \para \bf  Úloha. Sčítanie.  \end \header* fun/2 Add  \end Binárnou 
  rekurziou zadefinujte funkciu sčítanie \ft Add(x,y) = x+y \end. 
  \para* \it  Návod 1 (názorný).  \end Predstavte si binárnu verziu 
  sčítania, ako ste sa ho učili na základnej škole. Rozoberte jednotlivé 
  prípady: 
  \verbatim 
     00    x0    x0    x0    x1    x1    x1
    + y   +00   +y0   +y1   +00   +y0   +y1
    ---   ---   ---   ---   ---   ---   ---
     ??    ??    ??    ??    ??    ??    ??
  \end
  \para Na prenos do vyššieho rádu použite funkciu nasledovník ( 
  \ft Succ \end) z predchádzajúcej úlohy. 
  \para* \it  Návod 2 (algebraický).  \end Uvedomte si, že 
  \ft S0(x) = 2*x+0 \end a že \ft S1(x) = 2*x+1 \end. Preto napríklad 
  \ft Add(S0(x),S1(y)) = Tex1_paren(2*x+0)+(2*y+1) \end. Upravte tento výraz 
  tak, aby sa dal zapísať \it  iba  \end pomocou \ft S0 \end, \ft S1 \end, 
  funkcie \ft Succ(x) \end a rekurzívneho volania \ft Add(x,y) \end, ktoré 
  má hodnotu \ft x+y \end. Podobne postupujte aj v ostatných prípadoch. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Add_test = r:Results_n
  \end

fun/2 Add 
  Add(S0(x),S0(y)) = Foo <- x = 0
  Add(S0(x),S1(y)) = Foo <- x = 0
  Add(S0(x),S0(y)) = Foo <- x > 0 & y = 0
  Add(S0(x),S0(y)) = Foo <- x > 0 & y > 0
  Add(S0(x),S1(y)) = Foo <- x > 0
  Add(S1(x),S0(y)) = Foo <- y = 0
  Add(S1(x),S0(y)) = Foo <- y > 0
  Add(S1(x),S1(y)) = Foo

fun/0 Add_test 
  Add_test = 
  Check(Add(0,0),0+0),Check(Add(0,43210),0+43210),Check(Add(3,0),3+0),
  Check(Add(3,3),3+3),Check(Add(3,12),3+12),Check(Add(12,0),12+0),
  Check(Add(12,3),12+3),Check(Add(12,12),12+12),
  Check(Add(12345*67890,98765*43210),12345*67890+98765*43210),0

rem 
  \para \bf  Úloha. Násobenie.  \end \header* fun/2 Mul  \end Binárnou 
  rekurziou zadefinujte funkciu násobenie \ft Mul(x,y) = x*y \end. 
  \para* \it  Návod.  \end Využite algebraický návod k funkcii \ft Add \end. 
  Použite iba rekurzívne volanie \ft Mul \end, funkciu \ft Add \end a binárne 
  konštruktory. Binárnu diskrimináciu použite iba na jeden argument. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Mul_test = r:Results_n
  \end

fun/2 Mul 
  Mul(x,y) = Foo

fun/0 Mul_test 
  Mul_test = 
  Check(Mul(0,0),0*0),Check(Mul(0,20304),0*20304),Check(Mul(20304,0),20304*0),
  Check(Mul(1,20304),1*20304),Check(Mul(20304,1),20304*1),
  Check(Mul(2,20304),2*20304),Check(Mul(20304,2),20304*2),
  Check(Mul(3,20304),3*20304),Check(Mul(20304,3),20304*3),
  Check(Mul(4,20304),4*20304),Check(Mul(20304,4),20304*4),
  Check(Mul(5,20304),5*20304),Check(Mul(20304,5),20304*5),
  Check(Mul(6,20304),6*20304),Check(Mul(20304,6),20304*6),
  Check(Mul(20304,5000),20304*5000),Check(Mul(5000,20304),5000*20304),
  Check(Mul(Sq(20304),Sq(50000)),Sq(20304)*Sq(50000)),
  Check(Mul(Sq(50000),Sq(20304)),Sq(50000)*Sq(20304)),0

rem 
  \para \bf  Úloha. Druhá mocnina.  \end Binárnou rekurziou zadefinujte 
  funkciu druhej mocniny \ft Square(x) = Sq(x) \end. \bf  Nepoužite  \end 
  žiadne doteraz naprogramované ani vlastné pomocné funkcie \bf  okrem  
   \end sčítania. 
  \para* \it  Návod.  \end Uvedomte si, že \ft S1(x) = 2*x+1 \end a teda 
  \ft Square S1(x) = Sq(2*x+1) \end. Upravte tento výraz tak, aby sa dal 
  zapísať iba pomocou \ft S0 \end, \ft S1 \end, sčítania \ft Add \end 
  a rekurzívneho volania \ft Square(x) \end, ktoré má hodnotu 
  \ft Sq(x) \end. Podobne postupujte pri \ft Square S0(x) = Sq(2*x) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Square_test = r:Results_n
  \end

fun Square 
  Square(x) = Foo

fun/0 Square_test 
  Square_test = 
  Check(Square(0),0),Check(Square(1),1),Check(Square(2),Sq(2)),
  Check(Square(3),Sq(3)),Check(Square(4),Sq(4)),Check(Square(5),Sq(5)),
  Check(Square(6),Sq(6)),Check(Square(7),Sq(7)),Check(Square(8),Sq(8)),
  Check(Square(32768*32767-1),Sq(32768*32767-1)),
  Check(Square(Sq Sq(65536)-1),Sq(Sq Sq(65536)-1)),0

rem 
  \para \bf  Úloha. Umocnenie.  \end \header* fun/2 Exp  \end Binárnou 
  rekurziou zadefinujte funkciu umocnenie \ft Exp(x,y) = Tex2_exp(x,y) \end. 
  \para* \it  Návod.  \end Postupujte podobne ako pri funkcii \ft Square \end, 
  teda vyjadrite pomocou už zadefinovaných operácií a rekurzie 
  \ft Exp(x,y) \end hodnoty \ft Exp(x,S0(y)) = Tex2_exp(x,2*y) \end a 
  \ft Exp(x,S1(y)) = Tex2_exp(x,2*y+1) \end. Použite funkcie \ft Mul \end a 
  \ft Square \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Exp_test = r:Results_n
  \end

fun/2 Exp 
  Exp(x,y) = Foo

fun/0 Exp_test 
  Exp_test = 
  Check(Exp(0,0),1),Check(Exp(0,20304),0),Check(Exp(1,20304),1),
  Check(Exp(10,0),1),Check(Exp(10,1),10),Check(Exp(10,2),100),
  Check(Exp(10,3),1000),Check(Exp(10,4),10000),Check(Exp(10,5),100000),
  Check(Exp(10,6),1000000),Check(Exp(2,100),Sq(1024*Sq Sq(1024))),0

rem 
  \para \bf  Prémiová domáca úloha \it  du04  \end.  \end (2+1+1+2 body) 
  Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp#pdu  \end 
  \para Časti a) – d) môžete odovzdať nezávisle od seba. Časť d) sa 
  nachádza v súbore \it  ex04b.cl  \end. 
  \para* \bf  a)  \end (2 body) Dokážte, že pre vašu definíciu funkcie 
  \ft Exp \end platí: 
  \eq (Exp_succ)
    Exp(x,y+1) = x*Exp(x,y)
  \end
  \para Použite svoju definíciu funkcie \ft Exp \end, úplnú indukciu, 
  analýzu prípadov 
  \eq (N2_cover)
    \e m(n = S0(m) & m = 0) \/ \e m(n = S0(m) & m > 0) \/ \e m n = S1(m)
  \end
  \para ďalej fakty 
  \eq* 
    m > 0 -> m < S0(m)
  \end
  \eq* 
    m < S1(m)
  \end
  \para definície konštruktorov \ft S0 \end a \ft S1 \end a vlastnosti 
  sčítania a násobenia. \bf  Nepredpokladajte  \end, že \ft Exp \end 
  skutočne počíta umocnenie! 

rem 
  \para* \bf  b)  \end (1 bod) Naprogramujte binárnou rekurziou funkciu 
  \ft Pred(x) \end, ktorá počíta predchodcu čísla \ft x \end, teda 
  \ft Pred(x) = x-1 \end. \bf  Nepoužite  \end žiadne pomocné funkcie, okrem 
  \ft S0 \end a \ft S1 \end ani žiadne zabudované aritmetické operácie. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Pred_test = r:Results_n
  \end

fun Pred 
  Pred(x) = Foo

fun/0 Pred_test 
  Pred_test = 
  Check(Pred(0),0-1),Check(Pred(1),1-1),Check(Pred(2),2-1),Check(Pred(3),3-1),
  Check(Pred(4),4-1),Check(Pred(5),5-1),Check(Pred(6),6-1),Check(Pred(7),7-1),
  Check(Pred(8),8-1),Check(Pred(9),9-1),
  Check(Pred(32768*32367-1),32768*32367-2),Check(Pred(Sq(32768)-1),Sq(32768)-2),
  0

rem 
  \para* \bf  c)  \end (1 bod) \header* fun/2 Sub  \end Binárnou rekurziou 
  naprogramujte funkciu \ft Sub(x,y) \end, ktorá počíta rozdiel čísel 
  \ft x \end a \ft y \end za predpokladu, že \ft x >= y \end, teda 
  \eq (Sub_spec)
    x >= y -> x = y+Sub(x,y)
  \end
  \para V prípade, že \ft x < y \end, môže byť hodnota \ft Sub(x,y) \end 
  ľubovoľná. 
  \para \bf  Použite  \end pomocnú funkciu \ft Pred \end a binárne 
  konštruktory. \bf  Nepoužite  \end iné pomocné funkcie, žiadne 
  zabudované aritmetické operácie ani porovnania. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Sub_test = r:Results_n
  \end

fun/2 Sub 
  Sub(x,y) = Foo

fun/0 Sub_test 
  Sub_test = 
  Check(Sub(19,0),19-0),Check(Sub(19,1),19-1),Check(Sub(19,2),19-2),
  Check(Sub(19,3),19-3),Check(Sub(19,4),19-4),Check(Sub(19,5),19-5),
  Check(Sub(19,6),19-6),Check(Sub(19,7),19-7),Check(Sub(19,8),19-8),
  Check(Sub(19,9),19-9),Check(Sub(19,10),19-10),Check(Sub(19,11),19-11),
  Check(Sub(19,12),19-12),Check(Sub(19,13),19-13),Check(Sub(19,14),19-14),
  Check(Sub(19,15),19-15),Check(Sub(19,16),19-16),Check(Sub(19,17),19-17),
  Check(Sub(19,18),19-18),Check(Sub(19,19),19-19),
  Check(Sub(123456789*10,987654321),123456789*10-987654321),
  Check(Sub(32768*32367,32767*32366),32768*32367-32767*32366),
  Check(Sub(32768*32367-1,32767*32366),32768*32367-1-32767*32366),
  Check(Sub(32768*32367,32767*32366-1),32768*32367-(32767*32366-1)),
  Check(Sub(32768*32367-1,32767*32366-1),32768*32367-1-(32767*32366-1)),0

