mod Ex01b logic: 'cl'

rem 
  \para \bf  1. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  2013/2014  \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex01.zip 

rem 
  \para* \it  Dátum:  \end 18. a 19. 2. 2014 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované dopytom ( 
  \it  ex01a  \end) a explicitným definíciám ( \it  ex01b  \end). 

rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania LS 
  2013/2014. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2014.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer Programming. 
  2001. 

rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

rem 
  \para \it  [CL] CL-TeX.  \end Nasledujúce komponenty umožňujú špeciálne 
  zobrazenie niektorých funkcií. 

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/2 Tex2_exp
  Subsup(Arg(0),75,None,Arg(1))

appldisp/2 Tex2_min
  Std('min',0)

appldisp/2 Tex2_max
  Std('max',0)

appldisp/3 Tex2_min3
  Std('min3',0)

appldisp/3 Tex2_max3
  Std('max3',0)

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

appldisp/0 Tex0_tau
  Id(0,Ent('tau'),0)

appldisp/0 Tex0_sigma
  Id(0,Ent('sigma'),0)

loc rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  3. JAZYK CL  \end 

rem 
  \para \bf  3.1 Základy syntaxe  \end 

rem 
  \para \it  [CL] Syntax.  \end Identifikátorové konvencie: 
  \items 
   \item \para \it  Identifikátor premennej  \end je reťazec malých písmen 
         anglickej abecedy, voliteľne nasledovaný jednou alebo dvoma 
         číslicami predstavujúcimi index. Príklady: \ft x \end, \ft ys \end, 
         \ft i1 \end, \ft foo99 \end. 
   \item \para \it  Identifikátor funkcie  \end (funkčný symbol) je reťazec 
         začínajúci veľkým písmenom anglickej abecedy a obsahujúci malé 
         písmená, číslice a podčiarkovník '_'. Examples: \ft F \end, 
         \ft Max \end, \ft Power_of_some_prime \end, \ft A1b2c3 \end. 
  \end

rem 
  \para \it  [CL] Poznámka.  \end \it  Komponent  \end je buď poznámka 
  (remark), alebo definícia (function definition, predicate definition) alebo 
  teoréma (theorem). 

rem 
  \para \bf  4. EXPLICITNÉ DEFINÍCIE  \end 

rem 
  \para \it  Funkcia druhej mocniny.  \end Nasledujúci komponent obsahuje 
  definíciu funkcie \ft Square(x) \end, ktorej hodnotou je druhá mocnina 
  \ft Tex2_exp(x,2) \end čísla \ft x \end. 

fun Square 
  Square(x) = x*x

rem 
  \para \bf  Úloha.  \end Vyhodnoťte funkciu druhej mocniny pre niekoľko 
  argumentov; napríklad položte dopyt \ft Square(5) = x \end. 

rem 
  \para \bf  Úloha. Funkcia tretej mocniny.  \end Napíšte explicitnú 
  definíciu funkcie \ft Cube(x) \end, ktorej hodnotou je tretia mocnina 
  \ft Tex2_exp(x,3) \end čísla \ft x \end. 
  \para* \it  [CL] Návod.  \end Použite tlačidlo [ \it  Ins/Del  \end ] 
  vpravo pod týmto zadaním. 

rem 
  \para \bf  Úloha. Súčet dvoch druhých mocnín.  \end 
  \header* fun/2 Sum_of_squares  \end Napíšte explicitnú definíciu binárnej 
  (2-argumentovej) funkcie \ft Sum_of_squares(x,y) \end, ktorej hodnotou je 
  súčet druhých mocnín \ft Tex2_exp(x,2) \end a \ft Tex2_exp(y,2) \end. 

rem 
  \para \it  [CL] Poznámka.  \end Svoje riešenie priebežne ukladajte 
  kliknutím tlačidla [ \it  Save  \end ] na lište v pravom hornom rohu okna 
  alebo stlačením \it  Alt  \end + \it  S  \end. 

rem 
  \para \bf  4.1. Explicitné definície s jednou podmienkou  \end 

rem 
  \para \it  Minimum.  \end Nasledujúci komponent obsahuje \it  klauzálnu 
  definíciu  \end funkcie minima dvoch čísel. 
  \para Funkcia spĺňa špecifikáciu: \header* fun/2 Min 'Tex2_min' \end 
  \eq* 
    Min(x,y) <= x & Min(x,y) <= y
  \end
  \eq* 
    Min(x,y) = x \/ Min(x,y) = y
  \end
  \para \it  Poznámka.  \end V definícii je použitá \it  dichotomická 
   \end diskriminácia \ft Tex0_tau <= Tex0_sigma \end | 
  \ft Tex0_tau > Tex0_sigma \end. \it  Diskriminácia  \end je sada podmienok, 
  o ktorých CL vie, že sú navzájom výlučné. 
  \para* \it  [CL] Poznámka.  \end Hoci skutočné meno funkcie začína 
  veľkým písmenom, funkcia je nastavená tak, že sa \it  zobrazuje  \end 
  s malým začiatočným písmenom (podľa zvyklostí v matematike). 
  Matematické zobrazovanie programov je v CL všadeprítomné (napríklad 
  obrátenú implikáciu píšeme „<-“ a zobrazuje sa „←“, reláciu 
  menšie alebo rovné píšeme „<=“ a zobrazuje sa „≦“ atď.). 

fun/2 Min 'Tex2_min'
  Min(x,y) = x <- x <= y
  Min(x,y) = y <- x > y

rem 
  \para \bf  Úloha.  \end Vyhodnoťte funkciu minima pre niekoľko hodnôt 
  argumentov. 

rem 
  \para \it  [CL] Poznámka.  \end Príklad syntakticky nesprávnej definície 
  rovnakej funkcie: 
  \def 
    fun/2 Min 'Tex2_min'
    Min(x,y) = x <- x <= y
    Min(a,b) = b <- a > b
  \end
  \para Prvá aplikácia \ft Min(x,y) \end sa syntakticky líši od druhej 
  aplikácie \ft Min(a,b) \end. Obe aplikácie musia byť rovnaké tak, ako vo 
  vyššie uvedenej správnej definícii. 

rem 
  \para \bf  Úloha. Maximum.  \end Zadefinujte binárnu funkciu 
  \ft Tex2_max(x,y) \end, ktorej hodnotou je maximum čísel \ft x \end a 
  \ft y \end. Ako identifikátor funkcie použite \ft Max \end a v menu 
  „displayed by“ vyberte \ft Tex2_max \end. 
  \para Funkcia má spĺňať špecifikáciu: \header* fun/2 Max 'Tex2_max' \end 
  \eq* 
    Max(x,y) >= x & Max(x,y) >= y
  \end
  \eq* 
    Max(x,y) = x \/ Max(x,y) = y
  \end

rem 
  \para \bf  4.2. Explicitné definície s viacerými podmienkami  \end 

rem 
  \para \bf  Úloha. Minimum troch čísel.  \end \header* fun/3 Min3  \end 
  Zadefinujte ternárnu (3-argumentovú) funkciu \ft Min3(x,y,z) \end, ktorej 
  hodnotou je minimum čísel \ft x \end, \ft y \end, \ft z \end. 
  \para Špecifikácia: 
  \eq* 
    Min3(x,y,z) <= x & Min3(x,y,z) <= y & Min3(x,y,z) <= z
  \end
  \eq* 
    Min3(x,y,z) = x \/ Min3(x,y,z) = y \/ Min3(x,y,z) = z
  \end

rem 
  \para \bf  Úloha. Maximum troch čísel.  \end \header* fun/3 Max3  \end 
  Zadefinujte ternárnu funkciu \ft Max3(x,y,z) \end, ktorej hodnotou je maximum 
  čísel \ft x \end, \ft y \end, \ft z \end. 
  \para Špecifikácia: 
  \eq* 
    Max3(x,y,z) >= x & Max3(x,y,z) >= y & Max3(x,y,z) >= z
  \end
  \eq* 
    Max3(x,y,z) = x \/ Max3(x,y,z) = y \/ Max3(x,y,z) = z
  \end

rem 
  \para \bf  Úloha. Medián.  \end \header* fun/3 Median  \end Zadefinujte 
  ternárnu funkciu \ft Median(x,y,z) \end, ktorej hodnotou je medián čísel 
  \ft x \end, \ft y \end and \ft z \end. 
  \para Špecifikácia: 
  \eq (Median_middle)
    x <= y & y <= z -> Median(x,y,z) = y
  \end
  \eq (Median_perm1)
    Median(x,y,z) = Median(y,x,z)
  \end
  \eq (Median_perm2)
    Median(x,y,z) = Median(x,z,y)
  \end

rem 
  \para \it  Poznámka.  \end Vaše riešenie odporúčame otestovať dopytom: 
  \verbatim 
    Median(1,2,3),Median(1,3,2),Median(2,1,3),
    Median(2,3,1),Median(3,1,2),Median(3,2,1),
    Median(1,2,2),Median(2,1,2),Median(2,2,1),
    Median(3,2,2),Median(2,3,2),Median(2,2,3),
    Median(2,2,2) = x
  \end
  \para s očakávaným výsledkom \ft x = 2,2,2,2,2,2,2,2,2,2,2,2,2 \end 

rem 
  \para \bf  Úloha. Disjunktívne podmienky.  \end \header* fun/3 F1  \end 
  Zadefinujte ternárnu funkciu \ft F1(x,y,z) \end tak, aby platilo: 
  \items 
   \item \para ak \ft x < y \end \it  alebo  \end \ft x >= z \end, tak 
         \ft F1(x,y,z) = 1 \end; 
   \item \para inak \ft F1(x,y,z) = 2 \end. 
  \end
  \para Keďže v klauzálnej definícii sa nedá použiť disjunkcia, musíte 
  vhodne zložiť dichotomické diskriminácie podobne ako pri 
  predchádzajúcich funkciách. 

rem 
  \para \bf  Úloha.  \end Táto úloha má 4 časti a) – d), v ktorých 
  je pomocou skladania dichotomických diskriminácií potrebné zadefinovať 
  funkcie tak, aby mali uvedené vlastnosti. 
  \para* \it  Upozornenia.  \end 
  \para Uvedomte si, že všetky funkcie v CL sú definované iba na 
  prirodzených číslach. 
  \para Niektoré časti tejto úlohy nemajú riešenie. V takom prípade 
  nájdite konkrétne hodnoty premenných \ft x \end, \ft y \end a \ft z \end, 
  pre ktoré je zadanie sporné. 

rem 
  \para \bf  a)  \end \header* fun/3 F2  \end Zadefinujte ternárnu funkciu 
  \ft F2(x,y,z) \end tak, aby platilo: 
  \items 
   \item \para ak \ft Paren((x < y+z \/ Paren((x > y & x > z)))) \end, tak 
         \ft F2(x,y,z) = 1 \end; 
   \item \para inak \ft F2(x,y,z) = 2 \end. 
  \end

rem 
  \para \bf  b)  \end \header* fun/3 F3  \end Zadefinujte ternárnu funkciu 
  \ft F3(x,y,z) \end tak, aby platilo: 
  \items 
   \item \para ak \ft x > y \end, tak \ft F3(x,y,z) = 1 \end; 
   \item \para ak \ft x > z \end, tak \ft F3(x,y,z) = 2 \end; 
   \item \para inak \ft F3(x,y,z) = 3 \end. 
  \end

rem 
  \para \bf  c)  \end \header* fun/3 F4  \end Zadefinujte ternárnu funkciu 
  \ft F4(x,y,z) \end tak, aby platilo: 
  \items 
   \item \para ak \ft x > y+z \end, tak \ft F4(x,y,z) = 1 \end; 
   \item \para ak \ft x < y \end, tak \ft F4(x,y,z) = 2 \end; 
   \item \para inak \ft F4(x,y,z) = 3 \end. 
  \end

rem 
  \para \bf  d)  \end \header* fun/3 F5  \end Zadefinujte ternárnu funkciu 
  \ft F5(x,y,z) \end tak, aby platilo: 
  \items 
   \item \para ak \ft x < y+z \end, tak \ft F5(x,y,z) = 1 \end; 
   \item \para ak \ft x > y \end, tak \ft F5(x,y,z) = 2 \end; 
   \item \para inak \ft F5(x,y,z) = 3 \end. 
  \end

rem 
  \para \bf  4.3. Verifikácia explicitných definícií  \end 

rem 
  \para \bf  Prémiová domáca úloha \it  du01  \end.  \end (1+2 body) 
  \para* \it  Podmienky.  \end Pravidlá pre prémiové domáce úlohy nájdete 
  na \it  http://dai.fmph.uniba.sk/courses/udp/#pdu  \end. 
  \para Riešenia nespĺňajúce tam uvedené podmienky (vrátane adresáta 
  a formátu e-mailu) vyradíme! 
  \para* \it  Zadanie.  \end Dokážte podobne ako na prednáške, že: 
  \header* fun/2 Max 'Tex2_max' \end \header* fun/3 Max3  \end 
  \para \bf  a)  \end (1 bod) vaša definícia funkcie \ft Max \end má 
  vlastnosť \ft Max(a,b) = Max(b,a) \end; 
  \para \bf  b)  \end (2 body) vaša definícia funkcie \ft Max3 \end má 
  vlastnosť \ft Max3(a,b,c) = Max3(b,a,c) \end. 
  \para* \it  Poznámka.  \end Časti a) a b) budeme hodnotiť nezávisle. Pre 
  posúdenie správnosti dôkazu nám musíte poslať aj vaše definície 
  spomínaných funkcií. 
  \para* \it  Termín.  \end Nedeľa 23. 2. 2014 o 24:00. 
  \para K riešeniam odoslaným najneskôr v piatok 21. 2. o 12:00 vám 
  poskytneme spätnú väzbu a v prípade potreby možnosť opravy. 

rem 
  \para \bf  [CL] Záverečná poznámka.  \end Uložte svoje riešenie 
  a ukončite prostredie CL, teda kliknite tlačidlo [ \it  Save & Exit  \end ] 
  v pravom hornom rohu alebo stlačte \it  Alt  \end + \it  X  \end. 

