mod Mxml

rem 
  \para \bf  DEFINÍCIE PRE SPRACOVANIE XML V CL  \end 

appldisp/1 Tex1_lst
  Fenced(Op('[',0),Arg(0),Op(']',0))

appldisp/1 Tex1_lx
  Std('[X]',0)

appldisp/2 Tex2_type
  Infix(Arg(0),0,1,Op('::',0),Arg(1))

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

rem 
  \para Tento modul definuje konštruktory, formátovacie predikáty a pomocné 
  funkcie pre jednoduché kódovanie XML v CL. 
  \para Formátovacím predikátom budeme hovoriť \ft typy \end. 
  \para Definície typov a typy funkcií budeme zapisovať aj notáciou podobnou 
  jazyku Haskell: 
  \items 
   \item \para \ft Tex1_paren(T1,T2) \end 
         \para* Hodnota typu \ft Tex1_paren(T1,T2) \end je dvojica (pár), 
         ktorej prvá zložka je hodnota typu \ft T1 \end a druhá zložka je 
         hodnota typu \ft T2 \end. 
   \item \para \ft Tex1_lst(T) \end 
         \para* Hodnota typu \ft Tex1_lst(T) \end je zoznam hodnôt, z ktorých 
         každá je typu \ft T \end. 
   \item \para \ft Tex2_type(F,(T1 -> T2)) \end 
         \para* Ak \it  argument  \end funkcie \ft F \end je typu \ft T1 \end, 
         jej \it  výsledok  \end je typu \ft T2 \end. Platí teda: 
         \eq* 
           T1(x) -> T2 F(x)
         \end
  \end

rem 
  \para \bf  Typ \ft Xml \end  \end 

rem 
  \para \bf  \it  Typy \ft Attr \end a \ft Lattr \end.  \end  \end \ft Attr \end 
  je typ jedného atribútu v XML elemente (dvojica reťazcov meno, hodnota). 
  \ft Lattr \end je zoznam atribútov. 
  \para \ft Attr = Tex1_paren(Str,Str) \end 
  \para \ft Lattr = Tex1_lst(Attr) \end 

pred Attr 
  Attr(n,v) <- Str(n) & Str(v)

pred Lattr 
  Lattr(0)
  Lattr(a,as) <- Attr(a) & Lattr(as)

rem 
  \para \bf  \it  Konštruktory uzlov XML dokumentu.  \end  \end Konštruktory 
  \ft Xe \end a \ft Xs \end kódujú uzly XML dokumentu. 
  \para Hodnota \it  typu \ft X \end  \end je tvorená jedným z konštruktorov 
  \ft Xe \end a \ft Xs \end. CL nám umožní zadefinovať tento typ až 
  neskôr. 
  \items 
   \item \para \header* fun/3 Xe  \end Konštruktor 
         \ft Xe(name,attrs,childxnodes) \end kóduje \it  elementový uzol  \end 
         XML dokumentu s menom \ft name \end (reťazec), atribútmi 
         \ft attrs \end (typu \ft Tex1_lst(Attr) \end) a deťmi 
         \ft childxnodes \end (zoznam uzlov, teda \ft Tex1_lst(X) \end). 
         \para 
         \ft Tex2_type(Xe,(Tex1_paren(Str,Tex1_lst(Attr),Tex1_lst(X)) -> X)) \end 
   \item \para Konštruktor \ft Xs(text) \end kóduje \it  textový uzol  \end 
         XML dokumentu, ktorý obsahuje reťazec \ft text \end. 
         \para \ft Tex2_type(Xs,(Str -> X)) \end 
  \end

fun/3 Xe 
  Xe(name,attrs,childxnodes) = 0,name,attrs,childxnodes

fun Xs 
  Xs(text) = 1,text

rem 
  \para \bf  \it  Typy \ft X \end a \ft Lx \end.  \end  \end 
  \items 
   \item \para Hodnota typu \ft X \end kóduje \it  uzol  \end XML dokumentu. Je 
         teda tvorená konštruktorom \ft Xe \end alebo \ft Xs \end. 
   \item \para Hodnota typu \ft Lx \end kóduje \it  zoznam uzlov  \end XML 
         dokumentu. 
         \para \ft Lx = Tex1_lst(X) \end 
  \end

pred Lx 
  Lx(0)
  Lx(Xe(n,as,cs),xs) <- Str(n) & Lattr(as) & Lx(cs) & Lx(xs)
  Lx(Xs(t),xs) <- Str(t) & Lx(xs)

pred X 
  X Xe(n,as,cs) <- Str(n) & Lattr(as) & Lx(cs)
  X Xs(t) <- Str(t)

rem 
  \para \it  [CL] Poznámka.  \end CL nedovoľuje vzájomnú rekurziu, preto 
  musíme typ \ft Lx \end definovať skôr ako \ft X \end a tiež trocha 
  zložitejším spôsobom. Prirodzenejšia by bola definícia: 
  \def* 
    Lx(0)
    Lx(x,xs) <- X(x) & Lx(xs)
  \end
  \para vzájomne rekurzívna s  \ft X \end. 

rem 
  \para \bf  \it  [CL] Typ \ft Xml \end.  \end  \end Typ \ft Xml \end je 
  definovaný rovnako ako \ft Lx \end. Ak však sformátujeme nejakú hodnotu 
  \ft xs \end v query pomocou \ft Xml \end: 
  \verbatim 
    Xe('e',0,0),0 = xs:Xml 
  \end
  \para CL sa pokúsi zobraziť \ft xs \end ako XML dokument. Pre úspešné 
  zobrazenie musí byť hodnota \ft xs \end: 
  \items 
   \item \para \it  jednoprvkový  \end zoznam typu \ft Tex1_lst(X) \end, 
   \item \para jediný prvok tohto zoznamu musí byť koreňový \it  element 
          \end dokumentu ( \ft Xe \end). 
  \end

pred Xml 
  Xml(0)
  Xml(Xe(n,as,cs),xs) <- Str(n) & Lattr(as) & Xml(cs) & Xml(xs)
  Xml(Xs(t),xs) <- Str(t) & Xml(xs)

rem 
  \para \bf  Zobrazovanie čísel v desiatkovej sústave  \end 

rem 
  \para Nasledujúce funkcie zobrazujú čísla v desiatkovej sústave do: 
  \items 
   \item \para reťazcov \ft Tex2_type(N2str,(N -> Str)) \end, 
   \item \para uzlov XML dokumentu \ft Tex2_type(N2x,(N -> X)) \end, 
   \item \para zoznamov uzlov XML dokumentu \ft Tex2_type(N2lx,(N -> Lx)) \end. 
  \end

fun/2 N2str1 
  N2str1(10*q+r,s) = r+"0",s <- 0 <= r & r <= 9 & q = 0
  N2str1(10*q+r,s) = N2str1(q,r+"0",s) <- 0 <= r & r <= 9 & q != 0

fun N2str 
  N2str(n) = N2str1(n,0)

fun N2x 
  N2x(n) = Xs N2str(n)

fun N2lx 
  N2lx(n) = N2x(n),0

rem 
  \para \bf  Kostra XHTML dokumentu  \end 

rem 
  \para \bf  \it  Funkcia \ft Xhtml \end.  \end  \end \header* fun/2 Xhtml  \end 
  Funkcia \ft Xhtml(title,bodycs) \end vytvorí kostru XHTML dokumentu. 
  \verbatim 
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <title>***</title>
      </head>
      <body>
      ###
      </body>
    </html>
  \end
  \para Do elementu title (***) vloží reťazec \ft title \end. Do tela 
  dokumentu (###) vloží zoznam XML uzlov \ft bodycs \end. 
  \para \ft Tex2_type(Xhtml,(Tex1_paren(Str,Lx) -> Xml)) \end 
  \para \ft L Xhtml(title,bodycs) = 1 \end 

fun/2 Xhtml 
  Xhtml(title,bodycs) = 
  Xe('html',(('xmlns','http://www.w3.org/1999/xhtml'),0),h,b,0),0 <- 
    Xe('head',0,Xe('title',0,Xs(title),0),0) = h & Xe('body',0,bodycs) = b

