mod Ex13

loc rem 
  \para \bf  13. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2012/2013  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex13.zip 

loc rem 
  \para* \it  Dátum:  \end 6. 5. 2013 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované postfixovému 
  stroju a numerickým výrazom. 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2012/2013. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2013.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Maux13

incl Mtesting13

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  18. POSTFIXOVÝ STROJ A NUMERICKÉ VÝRAZY  \end 

rem 
  \para \bf  18.1. Postfixový stroj  \end 

rem 
  \para Na prednáške sme opísali postfixový stroj, ktorý vykonáva program 
  (postupnosť inštrukcií) modifikáciou zásobníka čísel. 

rem 
  \para \bf  \it  Inštrukcie postfixového stroja.  \end  \end Nasledujúce 
  konštruktory kódujú inštrukcie postfixového stroja. Predikát 
  \ft Instr \end platí pre kódy inštrukcií. 
  \para* Všimnite si skutočné mená konštruktorov ( \ft Ci \end, 
  \ft Vi \end, \ft Ai \end, \ft Mi \end). 

fun Ci 'Tex1_ci'
  Ci(n) = 1,n

fun Vi 'Tex1_vi'
  Vi(i) = 0,i

fun/0 Ai 'Tex0_ai'
  Ai = 2,0

fun/0 Mi 'Tex0_mi'
  Mi = 3,0

pred Instr 
  Instr Ci(n) <- N(n)
  Instr Vi(i) <- N(i)
  Instr(Ai)
  Instr(Mi)

rem 
  \para \bf  \it  Programy postfixového stroja.  \end  \end Program 
  postfixového stroja je postupnosť inštrukcií. 

rem 
  \para \bf  Úloha.  \end Zadefinujte predikát \ft Program(is) \end, ktorý 
  platí, ak \ft is \end je kódom programu, teda zoznamom kódov inštrukcií. 

pred Program 
  Program(is) <- Quux

rem 
  \para \bf  \it  Zásobník postfixového stroja.  \end  \end Postfixový stroj 
  má zásobník čísel, ktorý sa mení počas behu programu. Inštrukcie 
  pridávajú čísla na vrch zásobníka, alebo čísla z vrchu zásobníka 
  odoberajú. 
  \para Zásobník zakódujeme zoznamom prirodzených čísel, pričom hodnota 
  na vrchu zásobníka je prvým prvkom zoznamu. 

rem 
  \para \bf  \it  Beh postfixového stroja.  \end  \end Postfixový stroj 
  postupne vykonáva inštrukcie v programe. Inštrukcie menia zásobník 
  nasledovným spôsobom (viď tiež ilustráciu v prednáškach [1, §18.1, 
  str. 122]): 
  \items 
   \item \para \ft Ci(n) \end pridá číslo \ft n \end na vrch zásobníka. 
   \item \para \ft Vi(i) \end pridá na vrch zásobníka kópiu čísla, ktoré 
         sa nachádza v zásobníku na \ft i \end-tom mieste (počítajúc 
         od 0). 
   \item \para \ft Ai \end odoberie zo zásobníka vrchnú hodnotu \ft a \end 
         a hodnotu pod ňou \ft b \end a namiesto nich pridá na vrch 
         zásobníka hodnotu \ft b+a \end. 
   \item \para \ft Mi \end odoberie zo zásobníka vrchnú hodnotu \ft a \end 
         a hodnotu pod ňou \ft b \end a namiesto nich pridá na vrch 
         zásobníka hodnotu \ft b*a \end. 
  \end

rem 
  \para \bf  Úloha.  \end Odkrokujte na papieri beh nasledovných dvoch 
  programov, ak začiatočný stav zásobníka je \ft 3,5,7,0 \end. 

fun/0 Prog1 
  Prog1 = Ci(4),Ci(6),Ai,Vi(3),Mi,0

fun/0 Prog2 
  Prog2 = Vi(0),Vi(1),Mi,Ci(2),Vi(2),Vi(4),Mi,Mi,Ai,Vi(3),Vi(4),Mi,Ai,0

rem 
  \para \bf  Úloha.  \end Zjednodušte program \ft Prog1 \end na 
  3 inštrukcie, teda napíšte program \ft Prog11 \end, ktorý vypočíta na 
  vrch zásobníka rovnaký výsledok ako \ft Prog1 \end, ale 
  \ft L(Prog11) = 3 \end. 

fun/0 Prog11 
  Prog11 = Foo

rem 
  \para \bf  Úloha.  \end Napíšte program \ft Prog3 \end pre postfixový 
  stroj, ktorý zmení zásobník zo stavu \ft n,vs \end do stavu 
  \ft n*(n+1),n,vs \end. 

fun/0 Prog3 
  Prog3 = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Run  \end Zadefinujte funkciu 
  \ft Run(is,vs) \end, ktorá simuluje beh postfixového stroja s programom 
  \ft is \end na zásobníku \ft vs \end. 
  \para* Po skončení programu vráti funkcia \ft Run \end hodnotu z vrchu 
  zásobníka. 
  \para* Použite funkciu \ft Sub(xs,i) \end ( \ft Sub \end) z modulu 
  \ft Maux13 \end. 

fun/2 Run 
  Run(is,vs) = Foo

rem 
  \para \bf  Úloha.  \end Spustite programy \ft Prog1 \end a \ft Prog2 \end 
  funkciou \ft Run \end a overte, či ste ich správne odkrokovali. 
  \para* Otestujte tiež svoje programy \ft Prog11 \end a \ft Prog3 \end na 
  rôznych začiatočných stavoch zásobníkov: 
  \verbatim 
      3,5,7,0 = vs & Run(Prog1,vs) = rp1 & Run(Prog11,vs) = rp11
  \end
  \verbatim 
      7 = n & Run(Prog3,n,0) = rp3 & n*(n+1) = x
  \end
  \para Pomocou funkcie \ft Run \end môžeme presne vyjadriť vlastnosti 
  programov \ft Prog11 \end a \ft Prog3 \end: 
  \eq* 
    Run(Prog11,vs) = Run(Prog1,vs)
  \end
  \eq* 
    Run(Prog3,n,vs) = n*(n+1)
  \end

rem 
  \para \bf  18.2. Numerické výrazy s premennými  \end 

rem 
  \para \bf  \it  Numerické výrazy s premennými.  \end  \end Numerické 
  výrazy s premennými sú tvorené: 
  \items 
   \item \para číselnými konštantami \ft 0 \end, \ft 1 \end, \ft 2 \end, 
         …, \ft n \end, …, 
   \item \para premennými \ft Tex2_varidx(x,Tex0_z) \end, \ft x1 \end, 
         \ft x2 \end, …, \ft Tex2_varidx(x,i) \end, …, 
   \item \para aplikáciou sčítania \ft t1+t2 \end na dva numerické výrazy 
         \ft t1 \end a \ft t2 \end, 
   \item \para aplikáciou násobenia \ft Tex2_times(t1,t2) \end na dva 
         numerické výrazy \ft t1 \end a \ft t2 \end. 
  \end

rem 
  \para \bf  \it  Kódovanie numerických výrazov s premennými.  \end  \end 
  Numerické výrazy majú stromovú štruktúru. Môžeme ich zakódovať 
  podobne ako binárne stromy. Použijeme nasledujúce konštruktory: 

fun Ct 'Tex1_ct'
  Ct(n) = 1,n

fun Vt 'Tex1_vt'
  Vt(i) = 0,i

fun/2 At 'Tex2_at'
  At(t1,t2) = 2,t1,t2

fun/2 Mt 'Tex2_mt'
  Mt(t1,t2) = 3,t1,t2

rem 
  \items 
   \item \para \ft Ct(n) \end kóduje číselnú konštantu \ft n \end, 
   \item \para \ft Vt(i) \end kóduje premennú \ft Tex2_varidx(x,i) \end, 
   \item \para \ft At(t1,t2) \end kóduje súčet výrazov, ktoré sú 
         zakódované číslami \ft t1 \end a \ft t2 \end, 
   \item \para \ft Mt(t1,t2) \end kóduje súčin výrazov, ktoré sú 
         zakódované číslami \ft t1 \end a \ft t2 \end. 
  \end
  \para Predikát \ft Term(t) \end platí, ak \ft t \end je kód numerického 
  výrazu. 

pred Term 
  Term Ct(n) <- N(n)
  Term Vt(i) <- N(i)
  Term At(t1,t2) <- Term(t1) & Term(t2)
  Term Mt(t1,t2) <- Term(t1) & Term(t2)

rem 
  \para \bf  Úloha.  \end Vypočítajte hodnotu výrazov s kódmi 
  \ft Term1 \end a \ft Term2 \end, ak premenná \ft Tex2_varidx(x,Tex0_z) \end 
  má hodnotu \ft 3 \end, premenná \ft x1 \end má hodnotu \ft 5 \end 
  a premenná \ft x2 \end má hodnotu \ft 7 \end. 

fun/0 Term1 
  Term1 = Mt(At(Ct(4),Ct(6)),Vt(2))

fun/0 Term2 
  Term2 = At(At(Mt(Vt(0),Vt(0)),Mt(Ct(2),Mt(Vt(0),Vt(1)))),Mt(Vt(2),Vt(2)))

rem 
  \para \bf  Úloha.  \end Zjednodušte výraz \ft Term1 \end tak, že súčet 
  konštánt nahradíte jedinou konštantou. Zapíšte kód zjednodušeného 
  výrazu: 

fun/0 Term11 
  Term11 = Foo

rem 
  \para \bf  Úloha.  \end Zakódujte numerický výraz 
  \ft Tex2_times(Tex2_varidx(x,Tex0_z),Tex2_varidx(x,Tex0_z)+1) \end: 

fun/0 Term3 
  Term3 = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Den  \end Zadefinujte \it  denotačnú 
   \end funkciu \ft Den(t,vs) = Tex2_den(t,vs) \end, ktorá vypočíta hodnotu 
  numerického výrazu \ft t \end pri \it  ohodnotení premenných  \end 
  \ft vs \end. Ohodnotenie premenných \ft vs \end je zoznam, v ktorom 
  \ft i \end-ty prvok predstavuje hodnotu premennej \ft Vt(i) \end. 

fun/2 Den 'Tex2_den'
  Den(t,vs) = Foo

rem 
  \para \bf  Úloha.  \end Vypočítajte hodnotu výrazov s kódmi 
  \ft Term1 \end a \ft Term2 \end pomocou funkcie \ft Den(t,vs) \end pri 
  ohodnotení premenných \ft 3,5,7,0 \end. 
  \para* Výpočtami pri rôznych ohodnoteniach otestujte, či ste správne 
  určili \ft Term11 \end: 
  \verbatim 
      3,5,7,0 = vs & Den(Term1,vs) = dt1 & Den(Term11,vs) = dt11
  \end
  \para* a \ft Term3 \end: 
  \verbatim 
      7 = n & Den(Term3,n,0) = dt3 & n*(n+1) = dt31
  \end
  \para Pomocou denotačnej funkcie môžeme presne vyjadriť vlastnosti 
  výrazov \ft Term11 \end a \ft Term3 \end: 
  \eq* 
    Den(Term11,vs) = Den(Term1,vs)
  \end
  \eq* 
    Den(Term3,n,vs) = n*(n+1)
  \end

rem 
  \para \bf  18.3. Kompilácia výrazov do programov  \end 

rem 
  \para \bf  \it  Programy počítajúce numerické výrazy.  \end  \end 
  Všimnite si, že ak spustíme program \ft Prog1 \end so zásobníkom 
  \ft vs \end, na vrch zásobníka sa vypočíta hodnota výrazu \ft Term1 \end 
  pri ohodnotení premenných \ft vs \end. Teda: 
  \eq* 
    Run(Prog1,vs) = Den(Term1,vs)
  \end
  \para Podobný vzťah je medzi \ft Prog2 \end a \ft Term2 \end i medzi 
  \ft Prog3 \end a \ft Term3 \end. 

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Comp(t) \end, ktorá 
  skompiluje numerický výraz \ft t \end do programu pre postfixový stroj tak, 
  že platí 
  \eq* 
    Term(t) -> Program Comp(t)
  \end
  \eq* 
    Term(t) -> Run(Comp(t),vs) = Den(t,vs)
  \end
  \para \header* fun/2 Comp1  \end Ako sme ukázali na prednáške, musíme 
  použiť pomocnú funkciu \ft Comp1(t,j) \end, ktorá skompiluje výraz 
  \ft t \end do programu, ktorý vypočíta hodnotu výrazu \ft t \end, keď sa 
  na zásobníku nad ohodnotením \ft vs \end nachádza \ft j \end 
  medzivýsledkov \ft ms \end: 
  \eq* 
    Term(t) -> Program Comp1(t,j)
  \end
  \eq* 
    Term(t) & L(ms) = j -> 
    Run(Comp1(t,j)++p,ms++vs) = Run(p,Paren(Den(t,vs),ms++vs))
  \end

fun/2 Comp1 
  Comp1(t,j) = Foo

fun Comp 
  Comp(t) = Foo

rem 
  \para \it  Testovanie.  \end Nasledujúce definície vám pomôžu pri 
  testovaní kompilácie numerických výrazov. Napríklad dopyt: 
  \verbatim 
    Try(Term4,2,3,0) = x:Resf
  \end
  \para* by mal mať výsledok: 
  \eq* 
    x = 
    Mt(At(Vt(0),Mt(Ct(3),Vt(1))),Ct(5)),(2,3,0),55,
    (Vi(0),Ci(3),Vi(3),Mi,Ai,Ci(5),Mi,0),55
  \end

fun/2 Try 
  Try(t,vs) = t,vs,Den(t,vs),is,Run(is,vs) <- Comp(t) = is

pred Resf 
  Resf(t,vs,d,is,r) <- Term(t) & Ln(vs) & N(d) & Program(is) & N(r)

fun/0 Term4 
  Term4 = Mt(At(Vt(0),Mt(Ct(3),Vt(1))),Ct(5))

fun/0 Term5 
  Term5 = Mt(At(Vt(0),Ct(2)),Mt(Vt(1),Ct(4)))

fun/0 Term6 
  Term6 = At(Mt(Ct(9),Vt(0)),Mt(Ct(4),At(Vt(0),Vt(1))))

fun/0 Term7 
  Term7 = Mt(At(Vt(2),Vt(0)),At(Mt(Ct(2),Vt(1)),Ct(4)))

rem 
  \para \bf  Úloha.  \end Nájdite výrazy, ktorých hodnoty počítajú 
  nasledujúce programy, teda pre daný \ft p \end nájdite taký \ft t \end, 
  že platí 
  \eq* 
    Den(t,vs) = Run(p,vs)
  \end
  \para Táto úloha je opakom kompilácie, nazýva sa \it  dekompilácia  \end. 
  \para Program \ft Prog8 \end sa dá dekompilovať do výrazu \ft Term8 \end 
  tak, aby platilo \ft Comp(Term8) = Prog8 \end. Pre program \ft Prog9 \end to 
  ale neplatí. Výraz \ft Term9 \end, ktorý nájdete, bude počítať rovnaké 
  hodnoty, ale jeho kompiláciou dostanete iný program ako \ft Prog9 \end. 

fun/0 Prog8 
  Prog8 = Vi(1),Ci(7),Ai,Vi(1),Mi,0

fun/0 Term8 
  Term8 = Foo

fun/0 Prog9 
  Prog9 = Vi(0),Vi(0),Mi,Vi(0),Ci(1),Ai,Mi,0

fun/0 Term9 
  Term9 = Foo

rem 
  \para \bf  Prémiová domáca úloha \it  du13  \end.  \end (3 body) 
  \para Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp/#pdu  \end. 
  \para* \it  Definícia.  \end Podvýraz výrazu \ft t \end nazývame \it  
  konštantný  \end, ak neobsahuje premenné. Konštantný podvýraz výrazu 
  \ft t \end je \it  maximálny  \end, ak žiaden jeho nadvýraz v \ft t \end 
  nie je konštantný. 
  \para Napríklad konštantnými podvýrazmi výrazu 
  \ft t = Mt(Ct(2),Mt(Vt(0),At(Ct(3),Ct(5)))) \end sú: \ft Ct(2) \end, 
  \ft Ct(3) \end, \ft Ct(5) \end a \ft At(Ct(3),Ct(5)) \end. Z nich 
  \ft Ct(2) \end a \ft At(Ct(3),Ct(5)) \end sú maximálne. 
  \para* \it  Zadanie.  \end \header* fun Parteval  \end Zadefinujte funkciu 
  \ft Parteval(t) \end, ktorá čiastočne vyhodnotí výraz \ft t \end, teda 
  nahradí každý maximálny konštantný podvýraz \ft t1 \end výrazu 
  \ft t \end konštantou \ft Ct(n) \end, kde \ft n = Den(t1,0) \end. 
  \para* \it  Príklad.  \end 
  \eq* 
    Parteval Mt(Ct(2),Mt(Vt(0),At(Ct(3),Ct(5)))) = Mt(Ct(2),Mt(Vt(0),Ct(8)))
  \end
  \eq* 
    Parteval(Term1) = Term11
  \end
  \para* \it  Návod.  \end Naprogramujte vašu funkciu tak, aby postupovala 
  zdola nahor: Najprv zavolajte rekurziu v tele klauzuly („za šípkou“). 
  Ak rekurzia zredukuje oba podvýrazy na konštanty, môžete zredukovať aj 
  celý výraz. Aby ste zbytočne nediskriminovali všetky možné výsledky 
  rekurzívnych volaní, použite preddefinovaný predikát \ft Is_ct(t) \end, 
  ktorý platí práve vtedy, keď \ft t \end je konštanta. Pre vstupný výraz 
  \ft At(t1,t2) \end je tento postup naznačený v komponente funkcie 
  \ft Parteval \end nižšie. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Parteval_test = r:Results_term
  \end

pred Is_ct 
  Is_ct Ct(n)

fun Parteval 
  Parteval Ct(n) = Foo
  Parteval Vt(i) = Foo
  Parteval At(t1,t2) = Foo <- Parteval(t1) = pt1 & Is_ct(pt1) & Quux
  Parteval At(t1,t2) = Foo <- Parteval(t1) = pt1 & ~Is_ct(pt1)
  Parteval Mt(t1,t2) = Foo <- Quux

fun/0 Parteval_test 
  Parteval_test = 
  Check(Parteval Ct(3),Ct(3)),Check(Parteval Vt(2),Vt(2)),
  Check(Parteval At(Vt(1),Vt(2)),At(Vt(1),Vt(2))),
  Check(Parteval At(Ct(3),Vt(2)),At(Ct(3),Vt(2))),
  Check(Parteval At(Vt(1),Ct(5)),At(Vt(1),Ct(5))),
  Check(Parteval At(Ct(3),Ct(5)),Ct(8)),
  Check(Parteval Mt(Vt(1),Vt(2)),Mt(Vt(1),Vt(2))),
  Check(Parteval Mt(Ct(3),Vt(2)),Mt(Ct(3),Vt(2))),
  Check(Parteval Mt(Vt(1),Ct(5)),Mt(Vt(1),Ct(5))),
  Check(Parteval Mt(Ct(3),Ct(5)),Ct(15)),
  Check(Parteval Mt(Ct(2),Mt(Vt(0),At(Ct(3),Ct(5)))),Mt(Ct(2),Mt(Vt(0),Ct(8)))),
  Check(Parteval At(At(Mt(Ct(3),Ct(5)),Vt(0)),Ct(2)),At(At(Ct(15),Vt(0)),Ct(2))),
  0

