mod Ex12a


loc rem 
  \para \bf  12. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2012/2013  \end 
  \para* \bf  ČASŤ A  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex12.zip 

loc rem 
  \para* \it  Dátum:  \end 6. 5. 2013 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované úplným binárnym
  stromom a číslovaniu uzlov binárnych stromov (ex12a) a všeobecným stromom
  (ex12b).

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2012/2013. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2013.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 


incl Maux12

incl Mtesting12

incl Maux12a

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  ÚPLNÉ BINÁRNE STROMY A ČÍSLOVANIE UZLOV  \end 

rem 
  \para \bf  \it  Testovací strom.  \end  \end 

fun/0 T1 
  T1 = Nd(9,Nd(3,Nd(2,E,E),Nd(7,E,Nd(0,E,E))),Nd(5,E,Nd(4,E,E)))

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Dp(t),Tex1_dp(t)) \end, ktorá určí hĺbku binárneho stromu 
  \ft t \end, teda dĺžku najdlhšej cesty z koreňa do niektorého z listov 
  \ft E \end. 
  \para* \header* fun Dp 'Tex1_dp' \end Napríklad 
  \eq* 
    Dp Nd(9,Nd(3,Nd(2,E,E),Nd(7,E,Nd(0,E,E))),Nd(5,E,Nd(4,E,E))) = 4
  \end
  \para Využite funkciu \ft Tex2_equiv(Tex2_max_std(x,y),Max(x,y)) \end 
  definovanú v module \ft Maux12a \end. 
  \para* Testovanie: 
  \verbatim 
      Dp_test = r:Results
  \end

fun Dp 'Tex1_dp'
  Dp(t) = Foo

fun/0 Dp_test 
  Dp_test = 
  Check(Dp(E),0),Check(Dp Nd(2,E,E),1),Check(Dp Nd(3,Nd(2,E,E),E),2),
  Check(Dp Nd(3,E,Nd(2,E,E)),2),Check(Dp Nd(3,Nd(2,E,E),Nd(7,E,E)),2),
  Check(Dp(T1),4),0

rem 
  \para \bf  Úplné binárne stromy  \end 

rem 
  \para \bf  \it  Úplný binárny strom.  \end  \end Binárny strom \ft t \end 
  je \it  úplný  \end, ak 
  \eq* 
    Sz(t)+1 = Exp(2,Dp(t))
  \end
  \para Na každej úrovni v úplnom strome okrem poslednej sú všetky uzly 
  neprázdne (Nd). Na poslednej úrovni sú iba prázdne stromy. 
  \para Príkladom úplného stromu hĺbky \ft 3 \end je 
  \eq* 
    Nd(0,Nd(1,Nd(3,E,E),Nd(5,E,E)),Nd(2,Nd(4,E,E),Nd(6,E,E)))
  \end

rem 
  \para \bf  Úloha.  \end \header* fun/2 Full  \end Zadefinujte funkciu 
  \ft Full(n,a) \end, ktorá vytvorí úplný binárny strom hĺbky \ft n \end. 
  Vo všetkých uzloch tohto stromu bude uložená hodnota hodnota \ft a \end. 
  \para* Napríklad: 
  \eq* 
    Full(3,8) = Nd(8,Nd(8,Nd(8,E,E),Nd(8,E,E)),Nd(8,Nd(8,E,E),Nd(8,E,E)))
  \end
  \para Špecifikácia: 
  \eq* 
    Bt Full(n,a)
  \end
  \eq* 
    Dp Full(n,a) = n & Sz Full(n,a)+1 = Exp(2,n)
  \end
  \eq* 
    Inbt(x,Full(n,a)) -> x = a
  \end
  \para* Testovanie: 
  \verbatim 
      Full_test = r:Results_bt
  \end

fun/2 Full 
  Full(n,a) = Foo

fun/0 Full_test 
  Full_test = 
  Check(Full(0,8),E),Check(Full(1,8),Nd(8,E,E)),
  Check(Full(3,8),Nd(8,Nd(8,Nd(8,E,E),Nd(8,E,E)),Nd(8,Nd(8,E,E),Nd(8,E,E)))),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Full_pre(n) \end, ktorá 
  vytvorí úplný binárny strom \ft t \end hĺbky \ft n \end. Uzlom v strome 
  \ft t \end sú priradené hodnoty tak, aby pri výpise v poradí \it  
  preorder  \end tvorili súvislý interval prirodzených čísel 
  \ft 0,1,2,Tex0_ldots \end. 
  \para* Napríklad: 
  \eq* 
    Full_pre(4) = 
    Nd(0,Nd(1,Nd(2,Nd(3,E,E),Nd(4,E,E)),Nd(5,Nd(6,E,E),Nd(7,E,E))),
       Nd(8,Nd(9,Nd(10,E,E),Nd(11,E,E)),Nd(12,Nd(13,E,E),Nd(14,E,E))))
  \end
  \para* Špecifikácia: 
  \eq* 
    Bt Full_pre(n)
  \end
  \eq* 
    Dp Full_pre(n) = n & Sz Full_pre(n)+1 = Exp(2,n)
  \end
  \eq* 
    Preorder Full_pre(n) = Interval(0,Exp(2,n)-1)
  \end
  \para \it  Návod.  \end \header* fun/2 Full_pre1  \end Zadefinujte 
  a použite pomocnú funkciu \ft Full_pre1(n,m) \end. Vytvorí úplný 
  binárny strom hĺbky \ft n \end, v ktorom sú uzly očíslované tak, aby 
  pri výpise v poradí preorder tvorili súvislý interval 
  \ft m,m+1,m+2,Tex0_ldots \end. Využite funkciu 
  \ft Tex2_equiv(Tex2_exp_std(x,y),Exp(x,y)) \end definovanú v module 
  \ft Maux12 \end. 
  \para* Napríklad: 
  \eq* 
    Full_pre1(3,8) = 
    Nd(8,Nd(9,Nd(10,E,E),Nd(11,E,E)),Nd(12,Nd(13,E,E),Nd(14,E,E)))
  \end
  \para* Špecifikácia: 
  \eq* 
    Bt Full_pre1(n,m)
  \end
  \eq* 
    Dp Full_pre1(n,m) = n & Sz Full_pre1(n,m)+1 = Exp(2,n)
  \end
  \eq* 
    Preorder Full_pre1(n,m) = Interval(m,m+Exp(2,n)-1)
  \end
  \para* Testovanie: 
  \verbatim 
      Full_pre_test = r:Results_bt
  \end

fun/2 Full_pre1 
  Full_pre1(n,m) = Foo

fun Full_pre 
  Full_pre(n) = Foo

fun/0 Full_pre_test 
  Full_pre_test = 
  Check(Full_pre(0),E),Check(Full_pre(1),Nd(0,E,E)),
  Check(Full_pre(2),Nd(0,Nd(1,E,E),Nd(2,E,E))),
  Check(Full_pre(3),Nd(0,Nd(1,Nd(2,E,E),Nd(3,E,E)),Nd(4,Nd(5,E,E),Nd(6,E,E)))),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Full_in(n) \end, ktorá 
  spĺňa špecifikáciu: 
  \eq* 
    Bt Full_in(n)
  \end
  \eq* 
    Dp Full_in(n) = n & Sz Full_in(n)+1 = Exp(2,n)
  \end
  \eq* 
    Inorder Full_in(n) = Interval(0,Exp(2,n)-1)
  \end
  \para Postupujte podobne (využite podobnú pomocnú funkciu) ako 
  v predchádzajúcej úlohe. 
  \para* Testovanie: 
  \verbatim 
      Full_in_test = r:Results_bt
  \end

fun Full_in 
  Full_in(n) = Foo

fun/0 Full_in_test 
  Full_in_test = 
  Check(Full_in(0),E),Check(Full_in(1),Nd(0,E,E)),
  Check(Full_in(2),Nd(1,Nd(0,E,E),Nd(2,E,E))),
  Check(Full_in(3),Nd(3,Nd(1,Nd(0,E,E),Nd(2,E,E)),Nd(5,Nd(4,E,E),Nd(6,E,E)))),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Full_post(n) \end, ktorá 
  spĺňa špecifikáciu: 
  \eq* 
    Bt Full_post(n)
  \end
  \eq* 
    Dp Full_post(n) = n & Sz Full_post(n)+1 = Exp(2,n)
  \end
  \eq* 
    Postorder Full_post(n) = Interval(0,Exp(2,n)-1)
  \end
  \para* Testovanie: 
  \verbatim 
      Full_post_test = r:Results_bt
  \end

fun Full_post 
  Full_post(n) = Foo

fun/0 Full_post_test 
  Full_post_test = 
  Check(Full_post(0),E),Check(Full_post(1),Nd(0,E,E)),
  Check(Full_post(2),Nd(2,Nd(0,E,E),Nd(1,E,E))),
  Check(Full_post(3),Nd(6,Nd(2,Nd(0,E,E),Nd(1,E,E)),Nd(5,Nd(3,E,E),Nd(4,E,E)))),
  0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Full_br(n) \end, ktorá 
  vytvorí úplný binárny strom \ft t \end hĺbky \ft n \end. Uzlom v strome 
  \ft t \end sú priradené hodnoty tak, aby tvorili súvislý interval 
  prirodzených čísel \ft 0,1,2,Tex0_ldots \end pri prehľadávaní stromu 
  \it  do šírky  \end (breadth-first order). 
  \para* Napríklad: 
  \eq* 
    Full_br(4) = 
    Nd(0,Nd(1,Nd(3,Nd(7,E,E),Nd(8,E,E)),Nd(4,Nd(9,E,E),Nd(10,E,E))),
       Nd(2,Nd(5,Nd(11,E,E),Nd(12,E,E)),Nd(6,Nd(13,E,E),Nd(14,E,E))))
  \end
  \para Objavte vzťah medzi hodnotou uzla a hodnotami jeho detí. 
  \para* Špecifikácia (neúplná, lebo sme nedefinovali prehľadávanie do 
  šírky): 
  \eq* 
    Bt Full_br(n)
  \end
  \eq* 
    Dp Full_br(n) = n & Sz Full_br(n)+1 = Exp(2,n)
  \end
  \eq* 
    Inbt(x,Full_br(n)) <-> x+1 < Exp(2,n)
  \end
  \para \it  Návod.  \end \header* fun/2 Full_br1  \end Zadefinujte a použite 
  pomocnú funkciu \ft Full_br1(k,m) \end. Ak \ft t \end je podstromom stromu 
  \ft Full_br(n) \end, \ft t \end má hĺbku \ft k <= n \end a v koreni 
  hodnotu \ft m \end, tak výsledkom \ft Full_br1(k,m) \end je práve podstrom 
  \ft t \end. 
  \para* Napríklad 
  \eq* 
    Full_br1(2,4) = Nd(4,Nd(9,E,E),Nd(10,E,E))
  \end
  \para* Špecifikácia: 
  \eq* 
    Bt Full_br1(k,m)
  \end
  \eq* 
    Dp Full_br1(k,m) = k & Sz Full_br1(k,m)+1 = Exp(2,k)
  \end
  \eq* 
    Inbt(x,Full_br1(k,m)) <-> \e y(x = Conc2(m,y) & y+1 < Exp(2,k))
  \end
  \para \ft Conc2(x,y) \end je dyadické zreťazenie. 
  \para* Testovanie: 
  \verbatim 
      Full_br1_test = r:Results_bt
      Full_br_test = r:Results_bt
  \end

fun/2 Full_br1 
  Full_br1(k,m) = Foo

fun Full_br 
  Full_br(n) = Foo

fun/0 Full_br_test 
  Full_br_test = 
  Check(Full_br(0),E),Check(Full_br(1),Nd(0,E,E)),
  Check(Full_br(2),Nd(0,Nd(1,E,E),Nd(2,E,E))),
  Check(Full_br(3),Nd(0,Nd(1,Nd(3,E,E),Nd(4,E,E)),Nd(2,Nd(5,E,E),Nd(6,E,E)))),0

rem 
  \para \bf  Číslovanie uzlov v binárnych stromoch  \end 

rem 
  \para \bf  \it  Izomorfné binárne stromy.  \end  \end 
  \header* pred/2 Isomorphic 'Tex2_isomorphic' \end Pre dané binárne stromy 
  \ft t1 \end a \ft t2 \end platí predikát \ft Isomorphic(t1,t2) \end práve 
  vtedy, keď sú tieto stromy izomorfné, teda majú rovnaký tvar, ale nie 
  nutne rovnaké hodnoty uložené v uzloch. 

pred/2 Isomorphic 'Tex2_isomorphic'
  Isomorphic(E,E)
  Isomorphic(Nd(x1,l1,r1),Nd(x2,l2,r2)) <- Isomorphic(l1,l2) & Isomorphic(r1,r2)

rem 
  \para \bf  \it  Číslovanie uzlov v binárnych stromoch.  \end  \end 
  V nasledujúcich úlohách budeme číslovať uzly v binárnych stromoch. To 
  znamená, že pre daný strom vytvoríme izomorfný strom, v ktorom sú 
  hodnoty v uzloch nahradené číslami \ft 0,1,2,Tex0_ldots \end 
  v predpísanom poradí. 

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Num_pre(t) \end, ktorá 
  očísluje uzly binárneho stromu \ft t \end tak, aby pri výpise v poradí 
  \it  preorder  \end tvorili súvislý interval prirodzených čísel 
  \ft 0,1,2,Tex0_ldots \end. 
  \para* Napríklad: 
  \eq* 
    Num_pre Nd(9,Nd(3,Nd(2,E,E),Nd(7,E,Nd(0,E,E))),Nd(5,E,Nd(4,E,E))) = 
    Nd(0,Nd(1,Nd(2,E,E),Nd(3,E,Nd(4,E,E))),Nd(5,E,Nd(6,E,E)))
  \end
  \para* Špecifikácia: 
  \eq* 
    Bt(t) -> Isomorphic(Num_pre(t),t)
  \end
  \eq* 
    Bt(t) -> Preorder Num_pre(t) = Interval(0,Sz(t))
  \end
  \para \it  Návod.  \end \header* fun/2 Num_pre1  \end Zadefinujte a použite 
  pomocnú funkciu \ft Num_pre1(t,m) \end, ktorá očísluje uzly binárneho 
  stromu \ft t \end tak, aby pri výpise v poradí \it  preorder  \end tvorili 
  súvislý interval prirodzených čísel \ft m,m+1,m+2,Tex0_ldots \end. 
  Využite funkciu \ft Sz(t) \end. 
  \para* Špecifikácia: 
  \eq* 
    Bt(t) -> Isomorphic(Num_pre1(t,m),t)
  \end
  \eq* 
    Bt(t) -> Preorder Num_pre1(t,m) = Interval(m,m+Sz(t))
  \end
  \para* Testovanie: 
  \verbatim 
      Num_pre_test = r:Results_bt
  \end

fun/2 Num_pre1 
  Num_pre1(t,m) = Foo

fun Num_pre 
  Num_pre(t) = Foo

fun/0 Num_pre_test 
  Num_pre_test = 
  Check(Num_pre(E),E),Check(Num_pre Nd(2,E,E),Nd(0,E,E)),
  Check(Num_pre Nd(3,Nd(2,E,E),E),Nd(0,Nd(1,E,E),E)),
  Check(Num_pre Nd(3,E,Nd(2,E,E)),Nd(0,E,Nd(1,E,E))),
  Check(Num_pre Nd(3,Nd(2,E,E),Nd(7,E,E)),Nd(0,Nd(1,E,E),Nd(2,E,E))),
  Check(Num_pre(T1),Nd(0,Nd(1,Nd(2,E,E),Nd(3,E,Nd(4,E,E))),Nd(5,E,Nd(6,E,E)))),
  Check(Num_pre Full(4,8),Full_pre(4)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Num_in(t) \end, ktorá 
  spĺňa špecifikáciu: 
  \eq* 
    Bt(t) -> Isomorphic(Num_in(t),t)
  \end
  \eq* 
    Bt(t) -> Inorder Num_in(t) = Interval(0,Sz(t))
  \end
  \para Postupujte podobne (využite podobnú pomocnú funkciu) ako 
  v predchádzajúcej úlohe. 
  \para* Testovanie: 
  \verbatim 
      Num_in_test = r:Results_bt
  \end

fun Num_in 
  Num_in(t) = Foo

fun/0 Num_in_test 
  Num_in_test = 
  Check(Num_in(E),E),Check(Num_in Nd(2,E,E),Nd(0,E,E)),
  Check(Num_in Nd(3,Nd(2,E,E),E),Nd(1,Nd(0,E,E),E)),
  Check(Num_in Nd(3,E,Nd(2,E,E)),Nd(0,E,Nd(1,E,E))),
  Check(Num_in Nd(3,Nd(2,E,E),Nd(7,E,E)),Nd(1,Nd(0,E,E),Nd(2,E,E))),
  Check(Num_in(T1),Nd(4,Nd(1,Nd(0,E,E),Nd(2,E,Nd(3,E,E))),Nd(5,E,Nd(6,E,E)))),
  Check(Num_in Full(4,8),Full_in(4)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Num_post(t) \end, ktorá 
  spĺňa špecifikáciu: 
  \eq* 
    Bt(t) -> Isomorphic(Num_post(t),t)
  \end
  \eq* 
    Bt(t) -> Postorder Num_post(t) = Interval(0,Sz(t))
  \end
  \para* Testovanie: 
  \verbatim 
      Num_post_test = r:Results_bt
  \end

fun Num_post 
  Num_post(t) = Foo

fun/0 Num_post_test 
  Num_post_test = 
  Check(Num_post(E),E),Check(Num_post Nd(2,E,E),Nd(0,E,E)),
  Check(Num_post Nd(3,Nd(2,E,E),E),Nd(1,Nd(0,E,E),E)),
  Check(Num_post Nd(3,E,Nd(2,E,E)),Nd(1,E,Nd(0,E,E))),
  Check(Num_post Nd(3,Nd(2,E,E),Nd(7,E,E)),Nd(2,Nd(0,E,E),Nd(1,E,E))),
  Check(Num_post(T1),Nd(6,Nd(3,Nd(0,E,E),Nd(2,E,Nd(1,E,E))),Nd(5,E,Nd(4,E,E)))),
  Check(Num_post Full(4,8),Full_post(4)),0

