mod Ex05a

loc rem 
  \para \bf  5. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2012/2013  \end 
  \para* \bf  ČASŤ A  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex05.zip 

loc rem 
  \para* \it  Dátum:  \end 11. 3. 2013 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované symbolickým 
  operáciám na dyadickom zápise čísel ( \it  ex05a  \end) a párovaniu ( 
  \it  ex05b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2012/2013. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2013.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Mtesting05

appldisp/0 Tex0_foo
  Std('?',0)

appldisp/0 Tex0_tau
  Id(0,Ent('tau'),0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

pred/0 Quux 'Tex0_foo'
  Quux <-> \f

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,3,Op(Ent('equiv'),0),Arg(1))

appldisp/2 Tex2_conc
  Infix(Arg(0),35,0,Op(Ent('star'),0),Arg(1))

appldisp/2 Tex2_eq_
  Prefix(90,2,Subsup(Id(0,'Eq',0),75,Op(Ent('lowast'),0),None),
         Fenced(Op('(',0),Infix(Arg(0),30,2,Op(',',0),Arg(1)),Op(')',0)))

appldisp/1 Tex1_palindrome_
  Prefix(90,2,Subsup(Id(0,'Palindrome',0),75,Op(Ent('lowast'),0),None),Arg(0))

appldisp/2 Tex2_suffix_
  Prefix(90,2,Subsup(Id(0,'Suffix',0),75,Op(Ent('lowast'),0),None),
         Fenced(Op('(',0),Infix(Arg(0),30,2,Op(',',0),Arg(1)),Op(')',0)))

appldisp/2 Tex2_prefix_
  Prefix(90,2,Subsup(Id(0,'Prefix',0),75,Op(Ent('lowast'),0),None),
         Fenced(Op('(',0),Infix(Arg(0),30,2,Op(',',0),Arg(1)),Op(')',0)))

appldisp/2 Tex2_segment_
  Prefix(90,2,Subsup(Id(0,'Segment',0),75,Op(Ent('lowast'),0),None),
         Fenced(Op('(',0),Infix(Arg(0),30,2,Op(',',0),Arg(1)),Op(')',0)))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  8. DYADICKÁ ČÍSELNÁ SÚSTAVA  \end 

rem 
  \para \bf  8.5. Symbolické operácie na dyadickom zápise čísel  \end 

rem 
  \para \it  Poznámka.  \end V nasledujúcich úlohách sa budeme na dyadický 
  zápis čísla pozerať ako na kód reťazca symbolov \ft 1 \end a \ft 2 \end. 
  Teda číslo \ft 19 = S1 S1 S2 S1(0) \end chápeme ako reťazec „1211“. Na 
  rozdiel od aritmetických operácií v časti A, v tejto časti cvičenia je 
  dôležitý iba dyadický zápis. Číslo, ktoré označuje, nie je 
  podstatné. 
  \para Pozor na obrátené poradie zápisu a zobrazenia konštruktorov 
  \ft S1 \end, \ft S2 \end. Úlohy sú formulované vzhľadom na poradie 
  zobrazenia. 
  \para V úlohách môžete využiť už zadefinované funkcie. 

rem 
  \para \bf  Úloha.  \end Zadefinujte (dyadickou rekurziou) funkciu 
  \ft Len(x) \end počítajúcu dĺžku dyadického reťazca \ft x \end. 
  \para Napríklad \ft Len S1 S2 S2(0) = 3 \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Len_test = r:Results
  \end

fun Len 
  Len(x) = Foo

fun/0 Len_test 
  Len_test = 
  Check(Len(0),0),Check(Len S1(0),1),Check(Len S2(0),1),Check(Len S1 S1(0),2),
  Check(Len S1 S2(0),2),Check(Len S2 S1(0),2),Check(Len S2 S2(0),2),
  Check(Len S1 S1 S1(0),3),Check(Len S2 S2 S2(0),3),0

rem 
  \para \bf  Úloha.  \end \header* pred/2 Eq  \end Zadefinujte dyadickou 
  rekurziou \it  predikát  \end \ft Eq(x,y) \end, ktorý platí práve vtedy, 
  keď sú dyadické reťazce \ft x \end a \ft y \end symbol po symbole 
  rovnaké. 
  \eq* 
    Eq(x,y) <-> x = y
  \end
  \para \bf  Použite iba  \end dyadickú diskrimináciu a dyadickú rekurziu, 
  \bf  nepoužite  \end diskrimináciu na rovnosť a nerovnosť ( 
  \ft x = y \end | \ft x != y \end). 
  \para* \it  Návod.  \end Kapitola \it  9. Predikáty  \end v [1]. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Eq_test = r:Results_pred
  \end

pred/2 Eq 
  Eq(0,0) <- Quux
  Eq(0,S1(y)) <- Quux
  Eq(0,S2(y)) <- Quux
  Eq(S1(x),Foo) <- Quux
  Eq(S2(x),Foo) <- Quux

fun/2 Eq_ 'Tex2_eq_'
  Eq_(x,y) = 0 <- ~Eq(x,y)
  Eq_(x,y) = 1 <- Eq(x,y)

fun/0 Eq_test 
  Eq_test = 
  Check(Eq_(0,0),1),Check(Eq_(0,S1(0)),0),Check(Eq_(S1(0),0),0),
  Check(Eq_(S1(0),S1(0)),1),Check(Eq_(S1(0),S2(0)),0),Check(Eq_(S2(0),0),0),
  Check(Eq_(S2(0),S1(0)),0),Check(Eq_(S2(0),S2(0)),1),
  Check(Eq_(S2 S2 S1(0),S2 S2 S1(0)),1),Check(Eq_(S2 S2 S1(0),S2 S1 S2(0)),0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Conc  \end Zadefinujete funkciu 
  \ft Tex2_equiv(Conc(x,y),Tex2_conc(x,y)) \end, ktorá spojí (zreťazí) 
  dyadické reťazce \ft x \end and \ft y \end. 
  \para Napríklad 
  \ft Conc(S2 S1 S1(0),S1 S2 S2(0)) = S1 S2 S2 S2 S1 S1(0) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Conc_test = r:Results_n2
  \end

fun/2 Conc 'Tex2_conc'
  Conc(x,y) = Foo

fun/0 Conc_test 
  Conc_test = 
  Check(Conc(0,0),0),Check(Conc(S1(0),0),S1(0)),Check(Conc(S2(0),0),S2(0)),
  Check(Conc(0,S1(0)),S1(0)),Check(Conc(0,S2(0)),S2(0)),
  Check(Conc(S1(0),S1(0)),S1 S1(0)),Check(Conc(S2(0),S1(0)),S1 S2(0)),
  Check(Conc(0,S2(0)),S2(0)),Check(Conc(S1(0),S2(0)),S2 S1(0)),
  Check(Conc(S2(0),S2(0)),S2 S2(0)),
  Check(Conc(S2 S1 S1(0),S1 S2 S2(0)),S1 S2 S2 S2 S1 S1(0)),0

rem 
  \para \it  Tvrdenie.  \end Dyadické zreťazenie má nasledujúce vlastnosti: 
  \eq* 
    Conc(0,y) = y
  \end
  \eq* 
    Conc(x,0) = x
  \end
  \eq* 
    Conc(x,Conc(y,z)) = Conc(Conc(x,y),z)
  \end
  \eq* 
    Conc(x,y) = 0 -> x = 0 & y = 0
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Rev(x) \end, ktorej hodnotou 
  je dyadický reťazec, ktorý vznikne obrátením reťazca \ft x \end. 
  \para Napríklad \ft Rev S1 S2 S1 S1(0) = S1 S1 S2 S1(0) \end. 
  \para Vo všeobecnosti 
  \eq (Rev_self_inv)
    Rev Rev(x) = x
  \end
  \eq (Rev_digit)
    d = S1(0) \/ d = S2(0) -> Rev(d) = d
  \end
  \eq (Rev_conc)
    Rev Conc(x,y) = Conc(Rev(y),Rev(x))
  \end
  \para Z týchto vlastností a z vlastností a definície zreťazenia sa 
  dá definícia funkcie \ft Rev \end jednoznačne algebraicky odvodiť. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Rev_test = r:Results_n2
  \end

fun Rev 
  Rev(x) = Foo

fun/0 Rev_test 
  Rev_test = 
  Check(Rev(0),0),Check(Rev S1(0),S1(0)),Check(Rev S2(0),S2(0)),
  Check(Rev S1 S2(0),S2 S1(0)),Check(Rev S2 S1(0),S1 S2(0)),
  Check(Rev S1 S2 S1 S1(0),S1 S1 S2 S1(0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte predikát \ft Palindrome(x) \end, ktorý 
  platí práve vtedy, keď je dyadický reťazec \ft x \end rovnaký pri 
  čítaní spredu aj zozadu. Využite vyššie definované funkcie a 
  predikáty. 
  \para Napríklad \ft Palindrome S1 S2 S1 S1 S2 S2 S1 S1 S2 S1(0) \end platí, 
  ale \ft Palindrome S2 S1 S1 S1 S2 S2 S1 S1 S2 S1(0) \end neplatí. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Palindrome_test = r:Results_pred
  \end

pred Palindrome 
  Palindrome(x) <- Quux

fun Palindrome_ 'Tex1_palindrome_'
  Palindrome_(x) = 0 <- ~Palindrome(x)
  Palindrome_(x) = 1 <- Palindrome(x)

fun/0 Palindrome_test 
  Palindrome_test = 
  Check(Palindrome_(0),1),Check(Palindrome_ S1(0),1),Check(Palindrome_ S2(0),1),
  Check(Palindrome_ S1 S1(0),1),Check(Palindrome_ S1 S2(0),0),
  Check(Palindrome_ S2 S1(0),0),Check(Palindrome_ S2 S2(0),1),
  Check(Palindrome_ S1 S2 S1(0),1),
  Check(Palindrome_ S1 S2 S1 S1 S2 S2 S1 S1 S2 S1(0),1),
  Check(Palindrome_ S2 S1 S1 S1 S2 S2 S1 S1 S2 S1(0),0),0

rem 
  \para* \bf  Úloha.  \end Zadefinujte funkciu \ft Last(x) \end, ktorej 
  hodnotou je posledná (najpravejšia, najmenej významná) číslica 
  dyadického reťazca \ft x \end, ak je neprázdny, a \ft 0 \end v opačnom 
  prípade. 
  \para Napríklad \ft Last S1 S2 S1 S2(0) = 1 \end. 
  \para Vo všeobecnosti 
  \eq* 
    d = S1(0) \/ d = S2(0) -> Last Conc(x,d) = d
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Last_test = r:Results_n2
  \end

fun Last 
  Last(x) = Foo

fun/0 Last_test 
  Last_test = 
  Check(Last(0),0),Check(Last S1(0),S1(0)),Check(Last S2(0),S2(0)),
  Check(Last S1 S2 S1 S2(0),S1(0)),Check(Last S2 S1 S2 S1 S2(0),S2(0)),0

rem 
  \para* \bf  Úloha.  \end Zadefinujte funkciu \ft First(x) \end, ktorej 
  hodnotou je prvá (najľavejšia, najvýznamnejšia) číslica dyadického 
  reťazca \ft x \end, ak je neprázdny, a \ft 0 \end v opačnom prípade. 
  \para Napríklad \ft First S1 S2 S1 S2(0) = 2 \end. 
  \para Vo všeobecnosti 
  \eq* 
    d = S1(0) \/ d = S2(0) -> First Conc(d,x) = d
  \end
  \para Pokúste sa nájsť definíciu dyadickou rekurziou bez pomocných 
  funkcií. Vhodne použite diskrimináciu na rovnosť s nulou ( 
  \ft Tex0_tau = 0 \end | \ft Tex0_tau != 0 \end). 
  \para* \it  Testovanie.  \end 
  \verbatim 
      First_test = r:Results_n2
  \end

fun First 
  First(x) = Foo

fun/0 First_test 
  First_test = 
  Check(First(0),0),Check(First S1(0),S1(0)),Check(First S2(0),S2(0)),
  Check(First S2 S1(0),S1(0)),Check(First S1 S2(0),S2(0)),
  Check(First S1 S1 S2 S2 S1(0),S1(0)),Check(First S1 S1 S2 S2 S1 S2(0),S2(0)),0

rem 
  \para* \bf  Úloha.  \end Zadefinujte funkciu \ft Change(x) \end, ktorej 
  hodnotou je dyadický reťazec, ktorý vznikne z reťazca \ft x \end zámenou 
  každého výskytu číslice \ft 1 \end za číslicu \ft 2 \end a naopak. 
  \para Napríklad \ft Change S2 S1 S1 S2 S1(0) = S1 S2 S2 S1 S2(0) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Change_test = r:Results_n2
  \end

fun Change 
  Change(x) = Foo

fun/0 Change_test 
  Change_test = 
  Check(Change(0),0),Check(Change S1(0),S2(0)),Check(Change S2(0),S1(0)),
  Check(Change S2 S1 S1 S2 S1(0),S1 S2 S2 S1 S2(0)),0

rem 
  \para \bf  Úloha.  \end  Zadefinujte funkciu \ft Before(x) \end, ktorej 
  hodnotou je dyadický reťazec, ktorý vznikne vložením číslice \ft 2 \end 
  pred každý výskyt číslice \ft 1 \end v reťazci \ft x \end. 
  \para Napríklad 
  \ft Before S2 S1 S1 S2 S1(0) = S2 S1 S2 S1 S2 S2 S1 S2(0) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Before_test = r:Results_n2
  \end

fun Before 
  Before(x) = Foo

fun/0 Before_test 
  Before_test = 
  Check(Before(0),0),Check(Before S1(0),S1 S2(0)),Check(Before S2(0),S2(0)),
  Check(Before S1 S1(0),S1 S2 S1 S2(0)),Check(Before S1 S2(0),S1 S2 S2(0)),
  Check(Before S2 S1(0),S2 S1 S2(0)),Check(Before S2 S2(0),S2 S2(0)),
  Check(Before S2 S1 S1 S2 S1(0),S2 S1 S2 S1 S2 S2 S1 S2(0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft After(x) \end, ktorej 
  hodnotou je dyadický reťazec, ktorý vznikne vložením číslice \ft 1 \end 
  za každý výskyt číslice \ft 2 \end v reťazci \ft x \end. 
  \para Napríklad \ft After S2 S1 S1 S2 S1(0) = S1 S2 S1 S1 S1 S2 S1(0) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      After_test = r:Results_n2
  \end

fun After 
  After(x) = Foo

fun/0 After_test 
  After_test = 
  Check(After(0),0),Check(After S1(0),S1(0)),Check(After S2(0),S1 S2(0)),
  Check(After S1 S1(0),S1 S1(0)),Check(After S1 S2(0),S1 S1 S2(0)),
  Check(After S2 S1(0),S1 S2 S1(0)),Check(After S2 S2(0),S1 S2 S1 S2(0)),
  Check(After S2 S1 S1 S2 S1(0),S1 S2 S1 S1 S1 S2 S1(0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Del1(x) \end, ktorej hodnotou 
  je dyadický reťazec, ktorý vznikne zmazaním každého výskytu číslice 
  \ft 1 \end v reťazci \ft x \end. 
  \para Napríklad \ft Del1 S2 S1 S1 S2 S1(0) = S2 S2(0) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Del1_test = r:Results_n2
  \end

fun Del1 
  Del1(x) = Foo

fun/0 Del1_test 
  Del1_test = 
  Check(Del1(0),0),Check(Del1 S1(0),0),Check(Del1 S2(0),S2(0)),
  Check(Del1 S1 S1(0),0),Check(Del1 S1 S2(0),S2(0)),Check(Del1 S2 S1(0),S2(0)),
  Check(Del1 S2 S2(0),S2 S2(0)),Check(Del1 S2 S1 S1 S2 S1(0),S2 S2(0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Del12(x) \end, ktorej 
  hodnotou je dyadický reťazec, ktorý vznikne zmazaním každého výskytu 
  číslice \ft 1 \end nasledovaného číslicou \ft 2 \end v reťazci 
  \ft x \end. 
  \para Napríklad \ft Del12 S2 S1 S1 S2 S2 S1(0) = S2 S1 S2 S2(0) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Del12_test = r:Results_n2
  \end

fun Del12 
  Del12(x) = Foo

fun/0 Del12_test 
  Del12_test = 
  Check(Del12(0),0),Check(Del12 S1(0),S1(0)),Check(Del12 S2(0),S2(0)),
  Check(Del12 S1 S1(0),S1 S1(0)),Check(Del12 S1 S2(0),S1 S2(0)),
  Check(Del12 S2 S1(0),S2(0)),Check(Del12 S2 S2(0),S2 S2(0)),
  Check(Del12 S2 S1 S1 S2 S2 S1(0),S2 S1 S2 S2(0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Rotr(x) \end, ktorej hodnotou 
  je dyadický reťazec, ktorý vznikne rotáciou reťazca \ft x \end o jednu 
  číslicu doprava. 
  \para Napríklad \ft Rotr S2 S1 S1 S2 S1(0) = S1 S1 S2 S1 S2(0) \end. 
  \para Vo všeobecnosti 
  \eq* 
    d = S1(0) \/ d = S2(0) -> Rotr Conc(x,d) = Conc(d,x)
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Rotr_test = r:Results_n2
  \end

fun Rotr 
  Rotr(x) = Foo

fun/0 Rotr_test 
  Rotr_test = 
  Check(Rotr(0),0),Check(Rotr S1(0),S1(0)),Check(Rotr S2(0),S2(0)),
  Check(Rotr S1 S1(0),S1 S1(0)),Check(Rotr S1 S2(0),S2 S1(0)),
  Check(Rotr S2 S1(0),S1 S2(0)),Check(Rotr S2 S2(0),S2 S2(0)),
  Check(Rotr S2 S1 S1 S2 S1(0),S1 S1 S2 S1 S2(0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Rotl(x) \end, ktorej hodnotou 
  je dyadický reťazec, ktorý vznikne rotáciou reťazca \ft x \end o jednu 
  číslicu doľava. 
  \para Napríklad \ft Rotl S2 S1 S1 S2 S1(0) = S1 S2 S1 S1 S2(0) \end. 
  \para Vo všeobecnosti 
  \eq* 
    d = S1(0) \/ d = S2(0) -> Rotl Conc(d,x) = Conc(x,d)
  \end
  \para* \it  Návod.  \end Využite, že platí 
  \eq* 
    Rev Rotl(x) = Rotr Rev(x)
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Rotl_test = r:Results_n2
  \end

fun Rotl 
  Rotl(x) = Foo

fun/0 Rotl_test 
  Rotl_test = 
  Check(Rotl(0),0),Check(Rotl S1(0),S1(0)),Check(Rotl S2(0),S2(0)),
  Check(Rotl S1 S1(0),S1 S1(0)),Check(Rotl S1 S2(0),S2 S1(0)),
  Check(Rotl S2 S1(0),S1 S2(0)),Check(Rotl S2 S2(0),S2 S2(0)),
  Check(Rotl S2 S1 S1 S2 S1(0),S1 S2 S1 S1 S2(0)),0

rem 
  \para \bf  Úloha.  \end \header* pred/2 Suffix  \end Zadefinujte predikát 
  \ft Suffix(x,z) \end, ktorý platí práve vtedy, keď je dyadický reťazec 
  \ft z \end sufixom (koncovým úsekom) dyadického reťazca \ft x \end. 
  \para Napríklad \ft Suffix(S2 S2 S1 S1 S2 S1(0),S1 S2 S1(0)) \end neplatí, 
  ale \ft Suffix(S2 S2 S1 S1 S2 S1(0),S2 S2 S1(0)) \end platí. 
  \para Vo všeobecnosti 
  \eq* 
    Suffix(x,z) <-> \e y x = Conc(y,z)
  \end
  \para* \it  Návod.  \end Využite, že platí 
  \eq* 
    Suffix(x,z) <-> 
    z = 0 \/ \e v\e y(x = S1(y) & z = S1(v) & Suffix(y,v)) \/ 
    \e v\e y(x = S2(y) & z = S2(v) & Suffix(y,v))
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Suffix_test = r:Results_pred
  \end

pred/2 Suffix 
  Suffix(x,z) <- Quux

fun/2 Suffix_ 'Tex2_suffix_'
  Suffix_(x,z) = 0 <- ~Suffix(x,z)
  Suffix_(x,z) = 1 <- Suffix(x,z)

fun/0 Suffix_test 
  Suffix_test = 
  Check(Suffix_(0,0),1),Check(Suffix_(S1(0),0),1),
  Check(Suffix_(S1 S2 S2(0),0),1),Check(Suffix_(0,S1(0)),0),
  Check(Suffix_(0,S2(0)),0),Check(Suffix_(S1(0),S1(0)),1),
  Check(Suffix_(S2 S1 S1(0),S2 S2(0)),0),Check(Suffix_(S1 S2(0),S2(0)),0),
  Check(Suffix_(S2 S1(0),S1(0)),0),Check(Suffix_(S2(0),S2(0)),1),
  Check(Suffix_(S1 S2 S2(0),S1 S1(0)),0),
  Check(Suffix_(S2 S2 S1 S1 S2 S1(0),S1 S2 S1(0)),0),
  Check(Suffix_(S2 S2 S1 S1 S2 S1(0),S2 S2 S1(0)),1),0

rem 
  \para \bf  Úloha.  \end \header* pred/2 Prefix  \end Zadefinujte predikát 
  \ft Prefix(y,x) \end, ktorý platí práve vtedy, keď je dyadický reťazec 
  \ft y \end prefixom (začiatočným úsekom) dyadického reťazca \ft x \end. 
  \para Napríklad \ft Prefix(S1 S2 S1(0),S2 S2 S1 S1 S2 S1(0)) \end platí, ale 
  \ft Prefix(S2 S2 S1(0),S2 S2 S1 S1 S2 S1(0)) \end neplatí. 
  \para Vo všeobecnosti 
  \eq* 
    Prefix(y,x) <-> \e z x = Conc(y,z)
  \end
  \para* \it  Návod.  \end Využite, že platí 
  \eq* 
    Prefix(y,x) <-> 
    Eq(x,y) \/ \e z(x = S1(z) & Prefix(y,z)) \/ \e z(x = S2(z) & Prefix(y,z))
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Prefix_test = r:Results_pred
  \end

pred/2 Prefix 
  Prefix(y,x) <- Quux

fun/2 Prefix_ 'Tex2_prefix_'
  Prefix_(y,x) = 0 <- ~Prefix(y,x)
  Prefix_(y,x) = 1 <- Prefix(y,x)

fun/0 Prefix_test 
  Prefix_test = 
  Check(Prefix_(0,0),1),Check(Prefix_(0,S1(0)),1),
  Check(Prefix_(0,S2 S2 S1(0)),1),Check(Prefix_(S1(0),0),0),
  Check(Prefix_(S2(0),0),0),Check(Prefix_(S1(0),S1(0)),1),
  Check(Prefix_(S2 S1(0),S2 S1 S1(0)),0),Check(Prefix_(S1(0),S2 S1 S2(0)),0),
  Check(Prefix_(S2(0),S1 S2 S1(0)),0),Check(Prefix_(S2(0),S2(0)),1),
  Check(Prefix_(S1 S2(0),S1 S2 S2(0)),0),
  Check(Prefix_(S1 S2 S1(0),S2 S2 S1 S1 S2 S1(0)),1),
  Check(Prefix_(S2 S2 S1(0),S2 S2 S1 S1 S2 S1(0)),0),0

rem 
  \para \bf  Úloha.  \end \header* pred/2 Segment  \end Zadefinujte predikát 
  \ft Segment(u,x) \end, ktorý platí práve vtedy, keď je dyadický reťazec 
  \ft u \end úsekom (súvislým podreťazcom) dyadického reťazca \ft x \end. 
  \para Napríklad \ft Segment(S1 S1 S1(0),S2 S2 S1 S1 S2 S1(0)) \end neplatí, 
  ale \ft Segment(S1 S1(0),S2 S2 S1 S1 S2 S1(0)) \end platí. 
  \para Vo všeobecnosti 
  \eq* 
    Segment(u,x) <-> \e y\e z x = Conc(Conc(y,u),z)
  \end
  \para* \it  Návod.  \end Využite, že platí 
  \eq* 
    Segment(u,x) <-> 
    Suffix(x,u) \/ \e y(x = S1(y) & Segment(u,y)) \/ 
    \e y(x = S2(y) & Segment(u,y))
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Segment_test = r:Results_pred
  \end

pred/2 Segment 
  Segment(u,x) <- Quux

fun/2 Segment_ 'Tex2_segment_'
  Segment_(u,x) = 0 <- ~Segment(u,x)
  Segment_(u,x) = 1 <- Segment(u,x)

fun/0 Segment_test 
  Segment_test = 
  Check(Segment_(0,0),1),Check(Segment_(0,S1(0)),1),
  Check(Segment_(0,S2 S2 S1(0)),1),Check(Segment_(S1(0),0),0),
  Check(Segment_(S2(0),0),0),Check(Segment_(S1(0),S1(0)),1),
  Check(Segment_(S1 S2(0),S2 S1 S1(0)),0),Check(Segment_(S1(0),S2 S1 S1(0)),1),
  Check(Segment_(S2(0),S2 S1 S1(0)),1),Check(Segment_(S2(0),S2(0)),1),
  Check(Segment_(S1 S2(0),S1 S2 S2(0)),1),
  Check(Segment_(S1 S1 S1(0),S2 S2 S1 S1 S2 S1(0)),0),
  Check(Segment_(S1 S1(0),S2 S2 S1 S1 S2 S1(0)),1),0

rem 
  \para \bf  Prémiová domáca úloha \it  du05a  \end.  \end (2+2 body) 
  Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp#pdu  \end 
  \para Časti a) a b) môžete odovzdať nezávisle od seba. 
  \para* \bf  a)  \end (2 body) Dokážte, že vaša definícia funkcie 
  \ft Conc \end je asociatívna 
  \eq (Conc_assoc)
    Conc(Conc(x,y),z) = Conc(x,Conc(y,z))
  \end
  \para Použite úplnú indukciu, analýzu prípadov na základe platnosti 
  disjunkcie 
  \eq* 
    n = 0 \/ \e m n = S1(m) \/ \e m n = S2(m)
  \end
  \para a fakt, že platí 
  \eq* 
    m < S1(m) & m < S2(m)
  \end
  \para* \bf  b)  \end (2 body) Naprogramujte funkciu \ft Rotr \end podľa 
  vyššie uvedeného zadania \it  bez  \end použitia pomocných funkcií, teda 
  \it  iba pomocou  \end \ft 0 \end, \ft S1 \end, \ft S2 \end, dyadickej 
  diskriminácie a dyadickej rekurzie. 

