mod Ex04b

loc rem 
  \para \bf  4. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2012/2013  \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex04.zip 

rem 
  \para* \it  Dátum:  \end 4. 3. 2013 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované dyadickej 
  číselnej sústave a operáciám na dyadickom zápise čísel – 
  aritmetickým ( \it  ex04a  \end) a symbolickým ( \it  ex04b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2012/2013. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2013.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Mtesting04

appldisp/0 Tex0_foo
  Std('?',0)

appldisp/0 Tex0_tau
  Id(0,Ent('tau'),0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,3,Op(Ent('equiv'),0),Arg(1))

appldisp/2 Tex2_conc
  Infix(Arg(0),35,0,Op(Ent('star'),0),Arg(1))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  8. DYADICKÁ ČÍSELNÁ SÚSTAVA  \end 

rem 
  \para \bf  8.5. Symbolické operácie na dyadickom zápise čísel  \end 

rem 
  \para \it  Poznámka.  \end V nasledujúcich úlohách sa budeme na dyadický 
  zápis čísla pozerať ako na kód reťazca symbolov \ft 1 \end a \ft 2 \end. 
  Teda číslo \ft 19 = S1 S1 S2 S1(0) \end chápeme ako reťazec „1211“. Na 
  rozdiel od aritmetických operácií v časti A, v tejto časti cvičenia je 
  dôležitý iba dyadický zápis. Číslo, ktoré označuje, nie je 
  podstatné. 
  \para Pozor na obrátené poradie zápisu a zobrazenia konštruktorov 
  \ft S1 \end, \ft S2 \end. Úlohy sú formulované vzhľadom na poradie 
  zobrazenia. 
  \para V úlohách môžete využiť už zadefinované funkcie. 

rem 
  \para \bf  Úloha.  \end Zadefinujte (dyadickou rekurziou) funkciu 
  \ft Len(x) \end počítajúcu dĺžku dyadického reťazca \ft x \end. 
  \para Napríklad \ft Len S1 S2 S2(0) = 3 \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Len_test = r:Results
  \end

fun Len 
  Len(x) = Foo

fun/0 Len_test 
  Len_test = 
  Check(Len(0),0),Check(Len S1(0),1),Check(Len S2(0),1),Check(Len S1 S1(0),2),
  Check(Len S1 S2(0),2),Check(Len S2 S1(0),2),Check(Len S2 S2(0),2),
  Check(Len S1 S1 S1(0),3),Check(Len S2 S2 S2(0),3),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Eq  \end Zadefinujte dyadickou 
  rekurziou funkciu \ft Eq(x,y) \end, ktorá vráti \ft 1 \end práve vtedy, 
  keď sú dyadické reťazce \ft x \end a \ft y \end rovnaké, a \ft 0 \end 
  práve vtedy, keď sú rôzne. 
  \eq* 
    Eq(x,y) = 1 <-> x = y
  \end
  \eq* 
    Eq(x,y) = 0 <-> x != y
  \end
  \para Použite \bf  iba  \end dyadickú diskrimináciu. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Eq_test = r:Results
  \end

fun/2 Eq 
  Eq(0,0) = Foo
  Eq(0,S1(y)) = Foo
  Eq(0,S2(y)) = Foo
  Eq(S1(x),Foo) = Foo
  Eq(S2(x),Foo) = Foo

fun/0 Eq_test 
  Eq_test = 
  Check(Eq(0,0),1),Check(Eq(0,S1(0)),0),Check(Eq(S1(0),0),0),
  Check(Eq(S1(0),S1(0)),1),Check(Eq(S1(0),S2(0)),0),Check(Eq(S2(0),0),0),
  Check(Eq(S2(0),S1(0)),0),Check(Eq(S2(0),S2(0)),1),
  Check(Eq(S2 S2 S1(0),S2 S2 S1(0)),1),Check(Eq(S2 S2 S1(0),S2 S1 S2(0)),0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Conc  \end Zadefinujete funkciu 
  \ft Tex2_equiv(Conc(x,y),Tex2_conc(x,y)) \end, ktorá spojí (zreťazí) 
  dyadické reťazce \ft x \end and \ft y \end. 
  \para Napríklad 
  \ft Conc(S2 S1 S1(0),S1 S2 S2(0)) = S1 S2 S2 S2 S1 S1(0) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Conc_test = r:Results_n2
  \end

fun/2 Conc 'Tex2_conc'
  Conc(x,y) = Foo

fun/0 Conc_test 
  Conc_test = 
  Check(Conc(0,0),0),Check(Conc(S1(0),0),S1(0)),Check(Conc(S2(0),0),S2(0)),
  Check(Conc(0,S1(0)),S1(0)),Check(Conc(0,S2(0)),S2(0)),
  Check(Conc(S1(0),S1(0)),S1 S1(0)),Check(Conc(S2(0),S1(0)),S1 S2(0)),
  Check(Conc(0,S2(0)),S2(0)),Check(Conc(S1(0),S2(0)),S2 S1(0)),
  Check(Conc(S2(0),S2(0)),S2 S2(0)),
  Check(Conc(S2 S1 S1(0),S1 S2 S2(0)),S1 S2 S2 S2 S1 S1(0)),0

rem 
  \para \it  Tvrdenie.  \end Dyadické zreťazenie má nasledujúce vlastnosti: 
  \eq* 
    Conc(0,y) = y
  \end
  \eq* 
    Conc(x,0) = x
  \end
  \eq* 
    Conc(x,Conc(y,z)) = Conc(Conc(x,y),z)
  \end
  \eq* 
    Conc(x,y) = 0 -> x = 0 & y = 0
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Rev(x) \end, ktorej hodnotou 
  je dyadický reťazec, ktorý vznikne obrátením reťazca \ft x \end. 
  \para Napríklad \ft Rev S1 S2 S1 S1(0) = S1 S1 S2 S1(0) \end. 
  \para Vo všeobecnosti 
  \eq (Rev_self_inv)
    Rev Rev(x) = x
  \end
  \eq (Rev_digit)
    d = S1(0) \/ d = S2(0) -> Rev(d) = d
  \end
  \eq (Rev_conc)
    Rev Conc(x,y) = Conc(Rev(y),Rev(x))
  \end
  \para Z týchto vlastností a z vlastností a definície zreťazenia sa 
  dá definícia funkcie \ft Rev \end jednoznačne algebraicky odvodiť. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Rev_test = r:Results_n2
  \end

fun Rev 
  Rev(x) = Foo

fun/0 Rev_test 
  Rev_test = 
  Check(Rev(0),0),Check(Rev S1(0),S1(0)),Check(Rev S2(0),S2(0)),
  Check(Rev S1 S2(0),S2 S1(0)),Check(Rev S2 S1(0),S1 S2(0)),
  Check(Rev S1 S2 S1 S1(0),S1 S1 S2 S1(0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Palindrome(x) \end, ktorá 
  má hodnotu \ft 1 \end, ak je dyadický reťazec \ft x \end rovnaký pri 
  čítaní spredu aj zozadu. Inak má funkcia hodnotu \ft 0 \end. Využite 
  vyššie definované funkcie. 
  \para Napríklad \ft Palindrome S1 S2 S1 S1 S2 S2 S1 S1 S2 S1(0) = 1 \end, 
  \ft Palindrome S2 S1 S1 S1 S2 S2 S1 S1 S2 S1(0) = 0 \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Palindrome_test = r:Results
  \end

fun Palindrome 
  Palindrome(x) = Foo

fun/0 Palindrome_test 
  Palindrome_test = 
  Check(Palindrome(0),1),Check(Palindrome S1(0),1),Check(Palindrome S2(0),1),
  Check(Palindrome S1 S1(0),1),Check(Palindrome S1 S2(0),0),
  Check(Palindrome S2 S1(0),0),Check(Palindrome S2 S2(0),1),
  Check(Palindrome S1 S2 S1(0),1),
  Check(Palindrome S1 S2 S1 S1 S2 S2 S1 S1 S2 S1(0),1),
  Check(Palindrome S2 S1 S1 S1 S2 S2 S1 S1 S2 S1(0),0),0

rem 
  \para* \bf  Úloha.  \end Zadefinujte funkciu \ft Last(x) \end, ktorej 
  hodnotou je posledná (najpravejšia, najmenej významná) číslica 
  dyadického reťazca \ft x \end, ak je neprázdny, a \ft 0 \end v opačnom 
  prípade. 
  \para Napríklad \ft Last S1 S2 S1 S2(0) = 1 \end. 
  \para Vo všeobecnosti 
  \eq* 
    d = S1(0) \/ d = S2(0) -> Last Conc(x,d) = d
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Last_test = r:Results_n2
  \end

fun Last 
  Last(x) = Foo

fun/0 Last_test 
  Last_test = 
  Check(Last(0),0),Check(Last S1(0),S1(0)),Check(Last S2(0),S2(0)),
  Check(Last S1 S2 S1 S2(0),S1(0)),Check(Last S2 S1 S2 S1 S2(0),S2(0)),0

rem 
  \para* \bf  Úloha.  \end Zadefinujte funkciu \ft First(x) \end, ktorej 
  hodnotou je prvá (najľavejšia, najvýznamnejšia) číslica dyadického 
  reťazca \ft x \end, ak je neprázdny, a \ft 0 \end v opačnom prípade. 
  \para Napríklad \ft First S1 S2 S1 S2(0) = 2 \end. 
  \para Vo všeobecnosti 
  \eq* 
    d = S1(0) \/ d = S2(0) -> First Conc(d,x) = d
  \end
  \para Pokúste sa nájsť definíciu dyadickou rekurziou bez pomocných 
  funkcií. Vhodne použite diskrimináciu na rovnosť s nulou ( 
  \ft Tex0_tau = 0 \end | \ft Tex0_tau != 0 \end). 
  \para* \it  Testovanie.  \end 
  \verbatim 
      First_test = r:Results_n2
  \end

fun First 
  First(x) = Foo

fun/0 First_test 
  First_test = 
  Check(First(0),0),Check(First S1(0),S1(0)),Check(First S2(0),S2(0)),
  Check(First S2 S1(0),S1(0)),Check(First S1 S2(0),S2(0)),
  Check(First S1 S1 S2 S2 S1(0),S1(0)),Check(First S1 S1 S2 S2 S1 S2(0),S2(0)),0

rem 
  \para* \bf  Úloha.  \end Zadefinujte funkciu \ft Change(x) \end, ktorej 
  hodnotou je dyadický reťazec, ktorý vznikne z reťazca \ft x \end zámenou 
  každého výskytu číslice \ft 1 \end za číslicu \ft 2 \end a naopak. 
  \para Napríklad \ft Change S2 S1 S1 S2 S1(0) = S1 S2 S2 S1 S2(0) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Change_test = r:Results_n2
  \end

fun Change 
  Change(x) = Foo

fun/0 Change_test 
  Change_test = 
  Check(Change(0),0),Check(Change S1(0),S2(0)),Check(Change S2(0),S1(0)),
  Check(Change S2 S1 S1 S2 S1(0),S1 S2 S2 S1 S2(0)),0

rem 
  \para \bf  Úloha.  \end  Zadefinujte funkciu \ft Before(x) \end, ktorej 
  hodnotou je dyadický reťazec, ktorý vznikne vložením číslice \ft 2 \end 
  pred každý výskyt číslice \ft 1 \end v reťazci \ft x \end. 
  \para Napríklad 
  \ft Before S2 S1 S1 S2 S1(0) = S2 S1 S2 S1 S2 S2 S1 S2(0) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Before_test = r:Results_n2
  \end

fun Before 
  Before(x) = Foo

fun/0 Before_test 
  Before_test = 
  Check(Before(0),0),Check(Before S1(0),S1 S2(0)),Check(Before S2(0),S2(0)),
  Check(Before S1 S1(0),S1 S2 S1 S2(0)),Check(Before S1 S2(0),S1 S2 S2(0)),
  Check(Before S2 S1(0),S2 S1 S2(0)),Check(Before S2 S2(0),S2 S2(0)),
  Check(Before S2 S1 S1 S2 S1(0),S2 S1 S2 S1 S2 S2 S1 S2(0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft After(x) \end, ktorej 
  hodnotou je dyadický reťazec, ktorý vznikne vložením číslice \ft 1 \end 
  za každý výskyt číslice \ft 2 \end v reťazci \ft x \end. 
  \para Napríklad \ft After S2 S1 S1 S2 S1(0) = S1 S2 S1 S1 S1 S2 S1(0) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      After_test = r:Results_n2
  \end

fun After 
  After(x) = Foo

fun/0 After_test 
  After_test = 
  Check(After(0),0),Check(After S1(0),S1(0)),Check(After S2(0),S1 S2(0)),
  Check(After S1 S1(0),S1 S1(0)),Check(After S1 S2(0),S1 S1 S2(0)),
  Check(After S2 S1(0),S1 S2 S1(0)),Check(After S2 S2(0),S1 S2 S1 S2(0)),
  Check(After S2 S1 S1 S2 S1(0),S1 S2 S1 S1 S1 S2 S1(0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Del1(x) \end, ktorej hodnotou 
  je dyadický reťazec, ktorý vznikne zmazaním každého výskytu číslice 
  \ft 1 \end v reťazci \ft x \end. 
  \para Napríklad \ft Del1 S2 S1 S1 S2 S1(0) = S2 S2(0) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Del1_test = r:Results_n2
  \end

fun Del1 
  Del1(x) = Foo

fun/0 Del1_test 
  Del1_test = 
  Check(Del1(0),0),Check(Del1 S1(0),0),Check(Del1 S2(0),S2(0)),
  Check(Del1 S1 S1(0),0),Check(Del1 S1 S2(0),S2(0)),Check(Del1 S2 S1(0),S2(0)),
  Check(Del1 S2 S2(0),S2 S2(0)),Check(Del1 S2 S1 S1 S2 S1(0),S2 S2(0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Del12(x) \end, ktorej 
  hodnotou je dyadický reťazec, ktorý vznikne zmazaním každého výskytu 
  číslice \ft 1 \end nasledovaného číslicou \ft 2 \end v reťazci 
  \ft x \end. 
  \para Napríklad \ft Del12 S2 S1 S1 S2 S2 S1(0) = S2 S1 S2 S2(0) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Del12_test = r:Results_n2
  \end

fun Del12 
  Del12(x) = Foo

fun/0 Del12_test 
  Del12_test = 
  Check(Del12(0),0),Check(Del12 S1(0),S1(0)),Check(Del12 S2(0),S2(0)),
  Check(Del12 S1 S1(0),S1 S1(0)),Check(Del12 S1 S2(0),S1 S2(0)),
  Check(Del12 S2 S1(0),S2(0)),Check(Del12 S2 S2(0),S2 S2(0)),
  Check(Del12 S2 S1 S1 S2 S2 S1(0),S2 S1 S2 S2(0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Rotr(x) \end, ktorej hodnotou 
  je dyadický reťazec, ktorý vznikne rotáciou reťazca \ft x \end o jednu 
  číslicu doprava. 
  \para Napríklad \ft Rotr S2 S1 S1 S2 S1(0) = S1 S1 S2 S1 S2(0) \end. 
  \para Vo všeobecnosti 
  \eq* 
    d = S1(0) \/ d = S2(0) -> Rotr Conc(x,d) = Conc(d,x)
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Rotr_test = r:Results_n2
  \end

fun Rotr 
  Rotr(x) = Foo

fun/0 Rotr_test 
  Rotr_test = 
  Check(Rotr(0),0),Check(Rotr S1(0),S1(0)),Check(Rotr S2(0),S2(0)),
  Check(Rotr S1 S1(0),S1 S1(0)),Check(Rotr S1 S2(0),S2 S1(0)),
  Check(Rotr S2 S1(0),S1 S2(0)),Check(Rotr S2 S2(0),S2 S2(0)),
  Check(Rotr S2 S1 S1 S2 S1(0),S1 S1 S2 S1 S2(0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Rotl(x) \end, ktorej hodnotou 
  je dyadický reťazec, ktorý vznikne rotáciou reťazca \ft x \end o jednu 
  číslicu doľava. 
  \para Napríklad \ft Rotl S2 S1 S1 S2 S1(0) = S1 S2 S1 S1 S2(0) \end. 
  \para Vo všeobecnosti 
  \eq* 
    d = S1(0) \/ d = S2(0) -> Rotl Conc(d,x) = Conc(x,d)
  \end
  \para* \it  Návod.  \end Využite, že platí 
  \eq* 
    Rev Rotl(x) = Rotr Rev(x)
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Rotl_test = r:Results_n2
  \end

fun Rotl 
  Rotl(x) = Foo

fun/0 Rotl_test 
  Rotl_test = 
  Check(Rotl(0),0),Check(Rotl S1(0),S1(0)),Check(Rotl S2(0),S2(0)),
  Check(Rotl S1 S1(0),S1 S1(0)),Check(Rotl S1 S2(0),S2 S1(0)),
  Check(Rotl S2 S1(0),S1 S2(0)),Check(Rotl S2 S2(0),S2 S2(0)),
  Check(Rotl S2 S1 S1 S2 S1(0),S1 S2 S1 S1 S2(0)),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Suffix  \end Zadefinujte funkciu 
  \ft Suffix(x,z) \end, ktorá má hodnotu \ft 1 \end, ak je dyadický reťazec 
  \ft z \end sufixom (koncovým úsekom) dyadického reťazca \ft x \end. Inak 
  má funkcia hodnotu \ft 0 \end. 
  \para Napríklad \ft Suffix(S2 S2 S1 S1 S2 S1(0),S1 S2 S1(0)) = 0 \end, 
  \ft Suffix(S2 S2 S1 S1 S2 S1(0),S2 S2 S1(0)) = 1 \end. 
  \para Vo všeobecnosti 
  \eq* 
    Suffix(x,z) = 1 <-> \e y x = Conc(y,z)
  \end
  \eq* 
    Suffix(x,z) <= 1
  \end
  \para* \it  Návod.  \end Využite, že platí 
  \eq* 
    Suffix(x,z) = 1 <-> 
    z = 0 \/ \e v\e y(x = S1(y) & z = S1(v) & Suffix(u,y) = 1) \/ 
    \e v\e y(x = S2(y) & z = S2(v) & Suffix(u,y) = 1)
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Suffix_test = r:Results
  \end

fun/2 Suffix 
  Suffix(x,z) = Foo

fun/0 Suffix_test 
  Suffix_test = 
  Check(Suffix(0,0),1),Check(Suffix(S1(0),0),1),Check(Suffix(S1 S2 S2(0),0),1),
  Check(Suffix(0,S1(0)),0),Check(Suffix(0,S2(0)),0),
  Check(Suffix(S1(0),S1(0)),1),Check(Suffix(S2 S1 S1(0),S2 S2(0)),0),
  Check(Suffix(S1 S2(0),S2(0)),0),Check(Suffix(S2 S1(0),S1(0)),0),
  Check(Suffix(S2(0),S2(0)),1),Check(Suffix(S1 S2 S2(0),S1 S1(0)),0),
  Check(Suffix(S2 S2 S1 S1 S2 S1(0),S1 S2 S1(0)),0),
  Check(Suffix(S2 S2 S1 S1 S2 S1(0),S2 S2 S1(0)),1),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Prefix  \end Zadefinujte funkciu 
  \ft Prefix(y,x) \end, ktorá má hodnotu \ft 1 \end, ak je dyadický reťazec 
  \ft y \end prefixom (začiatočným úsekom) dyadického reťazca \ft x \end. 
  Inak má funkcia hodnotu \ft 0 \end. 
  \para Napríklad \ft Prefix(S1 S2 S1(0),S2 S2 S1 S1 S2 S1(0)) = 1 \end, 
  \ft Prefix(S2 S2 S1(0),S2 S2 S1 S1 S2 S1(0)) = 0 \end. 
  \para Vo všeobecnosti 
  \eq* 
    Prefix(y,x) = 1 <-> \e z x = Conc(y,z)
  \end
  \eq* 
    Prefix(y,x) <= 1
  \end
  \para* \it  Návod.  \end Využite, že platí 
  \eq* 
    Prefix(y,x) = 1 <-> 
    Eq(x,y) = 1 \/ \e z(x = S1(z) & Prefix(y,z) = 1) \/ 
    \e z(x = S2(z) & Prefix(y,z) = 1)
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Prefix_test = r:Results
  \end

fun/2 Prefix 
  Prefix(y,x) = Foo

fun/0 Prefix_test 
  Prefix_test = 
  Check(Prefix(0,0),1),Check(Prefix(0,S1(0)),1),Check(Prefix(0,S2 S2 S1(0)),1),
  Check(Prefix(S1(0),0),0),Check(Prefix(S2(0),0),0),
  Check(Prefix(S1(0),S1(0)),1),Check(Prefix(S2 S1(0),S2 S1 S1(0)),0),
  Check(Prefix(S1(0),S2 S1 S2(0)),0),Check(Prefix(S2(0),S1 S2 S1(0)),0),
  Check(Prefix(S2(0),S2(0)),1),Check(Prefix(S1 S2(0),S1 S2 S2(0)),0),
  Check(Prefix(S1 S2 S1(0),S2 S2 S1 S1 S2 S1(0)),1),
  Check(Prefix(S2 S2 S1(0),S2 S2 S1 S1 S2 S1(0)),0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Segment  \end Zadefinujte funkciu 
  \ft Segment(u,x) \end, ktorá má hodnotu \ft 1 \end, ak je dyadický reťazec 
  \ft u \end úsekom (súvislým podreťazcom) dyadického reťazca \ft x \end. 
  Inak má funkcia hodnotu \ft 0 \end. 
  \para Napríklad \ft Segment(S1 S1 S1(0),S2 S2 S1 S1 S2 S1(0)) = 0 \end, 
  \ft Segment(S1 S1(0),S2 S2 S1 S1 S2 S1(0)) = 1 \end. 
  \para Vo všeobecnosti 
  \eq* 
    Segment(u,x) = 1 <-> \e y\e z x = Conc(Conc(y,u),z)
  \end
  \eq* 
    Segment(u,x) <= 1
  \end
  \para* \it  Návod.  \end Využite, že platí 
  \eq* 
    Segment(u,x) = 1 <-> 
    Suffix(x,u) = 1 \/ \e y(x = S1(y) & Segment(u,y) = 1) \/ 
    \e y(x = S2(y) & Segment(u,y) = 1)
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Segment_test = r:Results
  \end

fun/2 Segment 
  Segment(u,x) = Foo

fun/0 Segment_test 
  Segment_test = 
  Check(Segment(0,0),1),Check(Segment(0,S1(0)),1),
  Check(Segment(0,S2 S2 S1(0)),1),Check(Segment(S1(0),0),0),
  Check(Segment(S2(0),0),0),Check(Segment(S1(0),S1(0)),1),
  Check(Segment(S1 S2(0),S2 S1 S1(0)),0),Check(Segment(S1(0),S2 S1 S1(0)),1),
  Check(Segment(S2(0),S2 S1 S1(0)),1),Check(Segment(S2(0),S2(0)),1),
  Check(Segment(S1 S2(0),S1 S2 S2(0)),1),
  Check(Segment(S1 S1 S1(0),S2 S2 S1 S1 S2 S1(0)),0),
  Check(Segment(S1 S1(0),S2 S2 S1 S1 S2 S1(0)),1),0

rem 
  \para \bf  Prémiová domáca úloha \it  du04b  \end.  \end (2+2 body) 
  Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp#pdu  \end 
  \para Časti a) a b) môžete odovzdať nezávisle od seba. 
  \para* \bf  a)  \end (2 body) Dokážte, že vaša definícia funkcie 
  \ft Conc \end je asociatívna 
  \eq (Conc_assoc)
    Conc(Conc(x,y),z) = Conc(x,Conc(y,z))
  \end
  \para Použite úplnú indukciu, analýzu prípadov na základe platnosti 
  disjunkcie 
  \eq* 
    n = 0 \/ \e m n = S1(m) \/ \e m n = S2(m)
  \end
  \para a fakt, že platí 
  \eq* 
    m < S1(m) & m < S2(m)
  \end
  \para* \bf  b)  \end (2 body) Naprogramujte funkciu \ft Rotr \end podľa 
  vyššie uvedeného zadania \it  bez  \end použitia pomocných funkcií, teda 
  \it  iba pomocou  \end \ft 0 \end, \ft S1 \end, \ft S2 \end, dyadickej 
  diskriminácie a dyadickej rekurzie. 

