mod Ex10b

loc rem 
  \para \bf  10. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2011/2012  \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex10.zip 

loc rem 
  \para* \it  Dátum:  \end 16. 4. 2012 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované kombinatorickým
  úlohám na zoznamoch – rozpoznávaniu rôznych druhov podzoznamov
  a generovaniu zoznamov všetkých týchto podzoznamov. Budeme študovať súvislé
  úseky ( \it  ex10a  \end) a podpostupnosti a permutácie ( \it  ex10b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2011/2012. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2012.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Maux10

incl Mtesting10

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  14. KOMBINATORICKÉ PREDIKÁTY A FUNKCIE NA ZOZNAMOCH  \end 

rem 
  \para \bf  \it  Pridanie znaku na začiatok viacerých reťazcov.  \end  \end 
  \header* fun/2 Map_pair  \end \ft Map_pair(a,xss) \end pridá prvok \ft a \end 
  na začiatok každého zoznamu v zozname zoznamov \ft xss \end (znak 
  \ft a \end na začiatok každého reťazca v zozname reťazcov \ft xss \end). 
  \eq* 
    ys in Map_pair(a,xss) <-> \e xs(ys = Paren(a,xs) & xs in xss)
  \end
  \eq* 
    Ch(a) & Lstr(xss) -> Lstr Map_pair(a,xss)
  \end

fun/2 Map_pair 
  Map_pair(a,0) = 0
  Map_pair(a,xs,xss) = (a,xs),Map_pair(a,xss)

rem 
  \para \bf  14.2. Vybrané podpostupnosti  \end 

rem 
  \para \bf  \it  Vybraná podpostupnosť.  \end  \end 
  \header* pred/2 Subseq  \end Predikát 
  \ft Subseq(ys,xs) \end platí práve vtedy, 
  keď zoznam \ft ys \end je \it  vybranou podpostupnosťou  \end zoznamu 
  \ft xs \end. To znamená, že \ft ys \end vznikne vynechaním niektorých 
  prvkov zo zoznamu \ft xs \end (aj žiadnych alebo všetkých). Vzájomné 
  poradie zostávajúcich prvkov sa nezmení. 
  \para Presnejšie, zoznam \ft ys \end je vybranou podpostupnosťou zoznamu 
  \ft xs = x1,x2,Tex0_ldots,Tex2_varidx(x,n),0 \end, ak 
  \eq* 
    ys = Tex2_varidx(x,i1),Tex0_ldots,Tex2_varidx(x,Tex2_varidx(i,k)),0
  \end
  \para pre nejakú rastúcu postupnosť \ft i1 \end, \ft i2 \end, 
  \ft Tex0_ldots \end, \ft Tex2_varidx(i,k) \end indexov prvkov zoznamu 
  \ft xs \end, teda \ft 0 <= i1 \end < \ft i2 \end < \ft Tex0_cdots \end < 
  \ft Tex2_varidx(i,k) <= n \end. 
  \para Formálne: 
  \eq* 
    Subseq(ys,xs) <-> 
    \e is(Set(is) & L(ys) = L(is) & 
          \a i(i < L(is) -> 
               Tex2_sub(is,i) < L(xs) & 
               Tex2_sub(ys,i) = Tex2_sub(xs,Tex2_sub(is,i))))
  \end
  \para Napríklad 
  \eq* 
    Subseq('','vsetko')
  \end
  \eq* 
    Subseq('veko','vsetko')
  \end
  \eq* 
    Subseq('vsetko','vsetko')
  \end
  \eq* 
    ~Subseq('svet','vsetko')
  \end
  \eq* 
    ~Subseq('sito','vsetko')
  \end
  \para V nasledujúcich úlohách využijeme, že 
  \items 
   \item \para jedinou vybranou podpostupnosťou prázdneho zoznamu je prázdny 
         zoznam: 
         \eq (Subseq_zero)
           Subseq(ys,0) <-> ys = 0
         \end
   \item \para vybranými podpostupnosťami neprázdneho zoznamu \ft x,xs \end 
         sú 
         \para a) všetky zoznamy \ft x,zs \end, kde \ft zs \end je vybranou 
         podpostupnosťou zoznamu \ft xs \end, 
         \para b) všetky podpostupnosti zoznamu \ft xs \end, 
         \para* teda 
         \eq (Subseq_pair)
           Subseq(ys,Paren(x,xs)) <-> 
           \e zs(ys = Paren(x,zs) & Subseq(zs,xs)) \/ Subseq(ys,xs)
         \end
  \end

rem 
  \para \bf  Úloha.  \end \header* pred/2 Subseq  \end Zadefinujte predikát 
  \ft Subseq(ys,xs) \end zoznamovou rekurziou. 
  Využite vlastnosti (Subseq_zero) a (Subseq_pair). 
  \para* Testovanie: 
  \verbatim 
      Subseq_test = r:Results
  \end

pred/2 Subseq 
  Subseq(ys,xs) <- Quux

fun/2 Subseq_ 
  Subseq_(ys,xs) = 1 <- Subseq(ys,xs)
  Subseq_(ys,xs) = 0 <- ~Subseq(ys,xs)

fun/0 Subseq_test 
  Subseq_test = 
  Check(Subseq_(0,0),1),Check(Subseq_((0,0),0),0),Check(Subseq_(0,0,0),1),
  Check(Subseq_((0,0),0,0),1),Check(Subseq_((1,0),0,0),0),
  Check(Subseq_((0,0,0),0,0),0),Check(Subseq_('','vsetko'),1),
  Check(Subseq_('st','vsetko'),1),Check(Subseq_('veko','vsetko'),1),
  Check(Subseq_('vsetko','vsetko'),1),Check(Subseq_('svet','vsetko'),0),
  Check(Subseq_('sito','vsetko'),0),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Subseqs(xs) \end, ktorá 
  vráti \it  zoznam všetkých vybraných podpostupností  \end zoznamu 
  (reťazca) \ft xs \end. Funkciu zadefinujte zoznamovou rekurziou. Využite 
  vlastnosti vybraných podpostupností z predchádzajúcej poznámky 
  a funkciu \ft Map_pair \end. 
  \para* Špecifikácia: 
  \eq* 
    ys in Subseqs(xs) <-> Subseq(ys,xs)
  \end
  \eq* 
    Str(xs) -> Lstr Subseqs(xs)
  \end
  \para* Napríklad: 
  \eq* 
    Subseqs('ak') = 'ak','a','k','',0
  \end
  \eq* 
    Subseqs('tak') = 'tak','ta','tk','t','ak','a','k','',0
  \end
  \para Na poradí reťazcov vo výslednom zozname nezáleží. 
  \para* Testovanie: 
  \verbatim 
      Subseqs_test = r:Results_lstr
  \end

fun Subseqs 
  Subseqs(xs) = Foo

fun/0 Subseqs_test 
  Subseqs_test = 
  Check_lext(Subseqs(''),'',0),Check_lext(Subseqs('y'),'y','',0),
  Check_lext(Subseqs('ak'),'ak','a','k','',0),
  Check_lext(Subseqs('tak'),'tak','ta','tk','t','ak','a','k','',0),0

rem 
  \para \bf  14.3. Permutácie  \end 

rem 
  \para \bf  \it  Permutácia.  \end  \end \header* pred/2 Perm 'Tex2_perm' \end 
  Predikát \ft Perm(xs,ys) \end (8. prednáška, cvičenie ex08a) platí 
  práve vtedy, keď zoznam \ft xs \end je permutáciou zoznamu \ft ys \end. 

pred/2 Perm 'Tex2_perm'
  Perm(xs,ys) <-> \a a Count(a,xs) = Count(a,ys)

rem 
  \para Cieľom nasledujúcich úloh je zadefinovať funkciu \ft Perms(xs) \end, 
  ktorá vráti zoznam všetkých permutácií zoznamu \ft xs \end. Aby sme 
  našli definíciu \ft Perms(xs) \end zoznamovou rekurziou, potrebujeme 
  vyjadriť permutácie zoznamu \ft x,xs \end pomocou permutácií \ft xs \end. 

rem 
  \para \bf  \it  Vsunutie prvku do zoznamu.  \end  \end 
  \header* pred/3 Insertion  \end Predikát \ft Insertion(ys,xs,a) \end platí 
  práve vtedy, keď zoznam \ft ys \end vznikne vsunutím prvku \ft a \end do 
  zoznamu \ft xs \end: \header* pred/3 Insertion 'Tex3_insertion' \end 
  \eq* 
    Insertion(ys,xs,a) <-> \e us\e vs(xs = us++vs & ys = us++(a,vs))
  \end
  \para Vlastnosti predikátu \ft Insertion \end: 
  \eq (Insertion_zero)
    Insertion(ys,0,a) <-> ys = Paren(a,0)
  \end
  \eq (Insertion_pair)
    Insertion(ys,Paren(x,xs),a) <-> 
    ys = Paren(a,x,xs) \/ \e zs(ys = Paren(x,zs) & Insertion(zs,xs,a))
  \end

rem 
  \para \bf  Úloha.  \end \header* pred/3 Insertion  \end Naprogramujte 
  predikát \ft Tex2_equiv(Insertion(ys,xs,a),Tex3_insertion(ys,xs,a)) \end 
  zoznamovou rekurziou. 
  \para* Testovanie:
  \verbatim 
      Insertion_test = r:Results
  \end

pred/3 Insertion 'Tex3_insertion'
  Insertion(ys,xs,a) <- Quux

fun/3 Insertion_ 'Tex3_insertion_'
  Insertion_(ys,xs,a) = 1 <- Insertion(ys,xs,a)
  Insertion_(ys,xs,a) = 0 <- ~Insertion(ys,xs,a)

fun/0 Insertion_test 
  Insertion_test = 
  Check(Insertion_(0,0,99),0),Check(Insertion_((99,0),0,99),1),
  Check(Insertion_(0,(1,0),99),0),Check(Insertion_((1,0),(1,0),99),0),
  Check(Insertion_((99,0),(1,0),99),0),Check(Insertion_((1,1,0),(1,0),99),0),
  Check(Insertion_((1,99,0),(1,0),99),1),Check(Insertion_((99,1,0),(1,0),99),1),
  Check(Insertion_((99,99,0),(1,0),99),0),
  Check(Insertion_((1,0,3,2,4,0),(1,0,3,2,4,0),99),0),
  Check(Insertion_((99,1,0,3,2,4,0),(1,0,3,2,4,0),99),1),
  Check(Insertion_((1,0,3,99,2,4,0),(1,0,3,2,4,0),99),1),
  Check(Insertion_((1,0,3,2,4,99,0),(1,0,3,2,4,0),99),1),
  Check(Insertion_((1,0,99,3,2,99,4,0),(1,0,3,2,4,0),99),0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Interleave  \end Zadefinujte funkciu 
  \ft Interleave(a,xs) \end, ktorá vráti zoznam všetkých vsunutí prvku 
  (znaku) \ft a \end do zoznamu (reťazca) \ft xs \end. Využite vlastnosti 
  (Insertion_zero) a (Insertion_pair). 
  \para* Špecifikácia: 
  \eq* 
    ys in Interleave(a,xs) <-> Insertion(ys,xs,a)
  \end
  \eq* 
    Ch(a) & Str(xs) -> Lstr Interleave(a,xs)
  \end
  \para* Napríklad: 
  \eq* 
    Interleave("#",'') = '#',0
  \end
  \eq* 
    Interleave("#",'ak') = '#ak','a#k','ak#',0
  \end
  \eq* 
    Interleave("#",'tak') = '#tak','t#ak','ta#k','tak#',0
  \end
  \para* Testovanie: 
  \verbatim 
      Interleave_test = r:Results_lstr
  \end

fun/2 Interleave 
  Interleave(a,xs) = Foo

fun/0 Interleave_test 
  Interleave_test = 
  Check_lext(Interleave("#",''),'#',0),Check_lext(Interleave("#",'y'),'#y','y#',0),
  Check_lext(Interleave("#",'ak'),'#ak','a#k','ak#',0),
  Check_lext(Interleave("#",'tak'),'#tak','t#ak','ta#k','tak#',0),0

rem 
  \para \bf  Úloha. Vsunutie prvku do viacerých zoznamov.  \end 
  \header* fun/2 Conc_map_i  \end Zadefinujte funkciu 
  \ft Conc_map_i(a,xss) \end, ktorá vráti zoznam všetkých vsunutí prvku 
  (znaku) \ft a \end do všetkých zoznamov (reťazcov) v \ft xss \end. Použite 
  funkciu \ft Interleave \end a zreťazenie. 
  \para Špecifikácia: 
  \eq* 
    ys in Conc_map_i(a,xss) <-> \e xs(xs in xss & Insertion(ys,xs,a))
  \end
  \eq* 
    Ch(a) & Lstr(xss) -> Lstr Conc_map_i(a,xss)
  \end
  \para* Napríklad: 
  \eq* 
    Conc_map_i("#",'tak','','@',0) = '#tak','t#ak','ta#k','tak#','#','#@','@#',0
  \end
  \para* Testovanie: 
  \verbatim 
      Conc_map_i_test = r:Results_lstr
  \end

fun/2 Conc_map_i 
  Conc_map_i(a,xss) = Foo

fun/0 Conc_map_i_test 
  Conc_map_i_test = 
  Check_lext(Conc_map_i("#",0),0),
  Check_lext(Conc_map_i("*",'2x',0),'*2x','2*x','2x*',0),
  Check_lext(Conc_map_i("#",'tak','','@',0),'#tak','t#ak','ta#k','tak#','#','#@','@#',0),0

rem 
  \para \bf  \it  Rekurzívne vlastnosti permutácií.  \end  \end Pomocou 
  predikátu \ft Insertion \end môžeme vyjadriť vlastnosti permutácií, 
  ktoré nám pomôžu pri rekurzívnej definícii funkcie, ktorá vytvorí ich 
  zoznam. Platí: 
  \items 
   \item \para jedinou permutáciou prázdneho zoznamu je prázdny zoznam: 
         \eq (Perm_zero)
           Perm(ys,0) <-> ys = 0
         \end
   \item \para každá permutácia neprázdneho zoznamu \ft x,xs \end vznikne 
         vsunutím prvku \ft x \end do niektorej permutácie zoznamu 
         \ft xs \end: 
         \eq (Perm_pair)
           Perm(ys,Paren(x,xs)) <-> \e zs(Insertion(ys,zs,x) & Perm(zs,xs))
         \end
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Perms(xs) \end, ktorá vráti 
  zoznam všetkých permutácií zoznamu (reťazca) \ft xs \end. Funkciu 
  zadefinujte zoznamovou rekurziou. Využite vlastnosti 
  permutácií z predchádzajúcej poznámky a funkciu \ft Conc_map_i \end. 
  \para* Napríklad: 
  \eq* 
    Perms('ak') = 'ak','ka',0
  \end
  \eq* 
    Perms('tak') = 'tak','atk','akt','tka','kta','kat',0
  \end
  \para Na poradí reťazcov vo výslednom zozname nezáleží. 
  \para* Špecifikácia: 
  \eq* 
    ys in Perms(xs) <-> Perm(ys,xs)
  \end
  \eq* 
    Str(xs) -> Lstr Perms(xs)
  \end
  \para* Testovanie: 
  \verbatim 
      Perms_test = r:Results_lstr
      Perms('Perms') = pss:Lstr & L(pss) = n
  \end

fun Perms 
  Perms(xs) = Foo

fun/0 Perms_test 
  Perms_test = 
  Check_lext(Perms(''),'',0),Check_lext(Perms('k'),'k',0),Check_lext(Perms('ak'),'ak','ka',0),
  Check_lext(Perms('tak'),'tak','atk','akt','tka','kta','kat',0),0

rem 
  \para \bf  14.4. Ďalšie úlohy  \end 

rem 
  \para \bf  Prémiová domáca úloha \it  du10b  \end.  \end (3 body) 
  \para* Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp/#pdu  \end. 
  \para* \header* fun/2 Subseqsk  \end Zadefinujte funkciu 
  \ft Subseqsk(k,xs) \end, ktorá vráti zoznam všetkých vybraných 
  podpostupností \bf  dĺžky \ft k \end  \end zoznamu (reťazca) \ft xs \end. 
  \para* Použite \bf  iba  \end párovanie, zreťazenie, rekurzívne volanie 
  a pomocnú funkciu \ft Map_pair \end. Riešenie s inými pomocnými 
  funkciami (napríklad filtrujúce zoznam všetkých podpostupností podľa 
  dĺžky) nebudeme akceptovať. 
  \para* Špecifikácia: 
  \eq* 
    ys in Subseqsk(k,xs) <-> Subseq(ys,xs) & L(ys) = k
  \end
  \eq* 
    N(k) & Str(xs) -> Lstr Subseqsk(k,xs)
  \end
  \para* Napríklad: 
  \eq* 
    Subseqsk(0,'hocijaky') = '',0
  \end
  \eq* 
    Subseqsk(7,'') = 0
  \end
  \eq* 
    Subseqsk(2,'aky') = 'ak','ay','ky',0
  \end
  \eq* 
    Subseqsk(3,'aky') = 'aky',0
  \end
  \eq* 
    Subseqsk(3,'taky') = 'tak','tay','tky','aky',0
  \end
  \para* Na poradí reťazcov vo výslednom zozname nezáleží. 
  \para* \it  Odporúčanie.  \end Sformulujte si najprv podobné vlastnosti 
  vybraných podpostupností dĺžky \ft k \end ako (Subseq_zero) 
  a (Subseq_pair): 
  \eq (Subseqk_zero)
    Subseq(ys,xs) & L(ys) = 0 <-> Quux
  \end
  \eq (Subseqk_empty)
    Subseq(ys,0) & L(ys) = k+1 <-> Quux
  \end
  \eq (Subseqk_pair)
    Subseq(ys,Paren(x,xs)) & L(ys) = k+1 <-> Quux
  \end

