mod Ex10a

loc rem 
  \para \bf  10. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
   \end 
  \para* \bf  ČASŤ A  \end 
  \para* http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1011ls/ex/ex10.zip 

loc rem 
  \para* \it  Dátum:  \end streda 20. 4. 2011 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.19  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované kombinatorike 
  na zoznamoch (ex10a) a číslovaniu uzlov v binárnych stromoch (ex10b). 
  Cvičenie tiež obsahuje pomocný modul auxb pre ex10b. 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] D. Guller. Poznámky k prednáškam z CL. 
  \para http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/clslov.pdf 
  \para* [2] J. Komara and P. J. Voda. Metamathematics of Computer Programming. 
  2001. 
  \para http://ii.fmph.uniba.sk/cl/courses/1-INF-465-dp/1011ls/doc/meta2001.pdf 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

pred/0 Quux 'Tex0_foo'
  Quux <-> \f

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/0 Tex0_ldots
  Op(Ent('hellip'),0)

appldisp/2 Tex2_varidx
  Subsup(Arg(0),75,Arg(1),None)

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

appldisp/2 Tex2_count
  Prefix(90,2,Subsup(Op('#',0),99,Arg(0),None),Arg(1))

appldisp/2 Tex2_perm
  Infix(Arg(0),15,0,Op(Ent('sim'),0),Arg(1))

fun/2 Count 'Tex2_count'
  Count(a,0) = 0
  Count(a,x,xs) = 1+Count(a,xs) <- a = x
  Count(a,x,xs) = Count(a,xs) <- a != x

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  KOMBINATORICKÉ FUNKCIE NA ZOZNAMOCH  \end 

rem 
  \para V nasledujúcich úlohách budeme definovať funkcie, ktoré 
  vytvárajú zoznamy sufixov, prefixov, vybraných podpostupností 
  a permutácií daného zoznamu. 

rem 
  \para \bf  [CL] Reťazce  \end 

rem 
  \para \bf  \it  Znaky a reťazce.  \end  \end \it  Reťazec  \end je v CL 
  zoznamom \it  znakov  \end (viď definície predikátov – formátov 
  \ft Ch \end a \ft Str \end v module \ft Standard \end). Znaky sú uzavreté 
  v úvodzovkách (napr. "a"), reťazce v apostrofoch (napr. 'abc efg 123'). 
  Čísla zobrazíme ako znaky pomocou formátu \ft Ch \end. Zoznamy zobrazíme 
  ako reťazce pomocou formátu \ft Str \end. 

rem 
  \para \bf  Úloha.  \end Vyhodnoťte query: 
  \verbatim 
      90 = c:Ch & 72,101,108,108,111,33,0 = xs:Str &
      ("l","a",0) = ys:Str & 'tra'++ys++ys = zs:Str
  \end

rem 
  \para \bf  \it  Zoznamy reťazcov.  \end  \end Doteraz sme väčšinou 
  pracovali s jednoduchými zoznamami čísel, občas s dvojicami zoznamov 
  alebo zoznamami dvojíc. Hodnotami väčšiny funkcií v tomto cvičení 
  budú \it  zoznamy zoznamov  \end. Prehľadnejšie je pozerať sa na ne ako na 
  \it  zoznamy reťazcov  \end. 
  \para Nasledujúci predikát – formát \ft Lstr \end platí pre zoznamy 
  reťazcov a umožňuje takto zobrazovať hodnoty premenných v query. 

pred Lstr 
  Lstr(0)
  Lstr(xs,xss) <- Str(xs) & Lstr(xss)

rem 
  \para \bf  Úloha.  \end Vyhodnoťte query: 
  \verbatim 
      (97,98,99,0),0,(100,101,0),0 = xss:Lstr
  \end

rem 
  \para \bf  Sufixy  \end 

rem 
  \para \bf  \it  Sufix.  \end  \end \header* pred/2 Suffix  \end Predikát 
  \ft Suffix(zs,xs) \end (7. prednáška, cvičenie ex07c) platí práve vtedy, 
  keď zoznam \ft zs \end je sufixom (súvislým koncovým úsekom) zoznamu 
  \ft xs \end: 

pred/2 Suffix 
  Suffix(zs,xs) <-> \e ys xs = ys++zs

rem 
  \para V nasledujúcej úlohe využijeme, že 
  \items 
   \item \para jediným sufixom prázdneho zoznamu je prázdny zoznam: 
         \eq* 
           Suffix(zs,0) <-> zs = 0
         \end
   \item \para sufixami neprázdneho zoznamu \ft x,xs \end sú 
         \para a) zoznam \ft x,xs \end sám, 
         \para b) všetky sufixy zoznamu \ft xs \end, 
         \para* teda: 
         \eq* 
           Suffix(zs,Paren(x,xs)) <-> zs = x,xs \/ Suffix(zs,xs)
         \end
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Suffixes(xs) \end, ktorá 
  vráti \it  zoznam všetkých sufixov  \end zoznamu (reťazca) \ft xs \end. 
  Funkciu zadefinujte zoznamovou rekurziou. Využite vlastnosti 
  sufixov uvedené v predchádzajúcej poznámke. 
  \para* Napríklad: 
  \eq* 
    Suffixes(1,2,3,0) = (1,2,3,0),(2,3,0),(3,0),0,0
  \end
  \eq* 
    Suffixes('aky') = 'aky','ky','y','',0
  \end
  \eq* 
    Suffixes('taky') = 'taky','aky','ky','y','',0
  \end
  \para Výsledok v druhom príklade zobrazujte formátom \ft Lstr \end (viď 
  vyššie). 
  \para* Špecifikácia: 
  \eq* 
    zs in Suffixes(xs) <-> Suffix(zs,xs)
  \end
  \eq* 
    Str(xs) -> Lstr Suffixes(xs)
  \end

fun Suffixes 
  Suffixes(xs) = Foo

rem 
  \para \bf  Pridanie znaku na začiatok viacerých reťazcov  \end 

rem 
  \para \bf  Úloha.  \end \header* fun/2 Map_pair  \end Zadefinujte funkciu 
  \ft Map_pair(a,xss) \end, ktorá pridá prvok \ft a \end na začiatok 
  každého zoznamu v zozname zoznamov \ft xss \end (znak \ft a \end na 
  začiatok každého reťazca v zozname reťazcov \ft xss \end). 
  \para* Napríklad: 
  \eq* 
    Map_pair(99,(50,30,20,0),(1,2,0),0,(7,0),0) = 
    (99,50,30,20,0),(99,1,2,0),(99,0),(99,7,0),0
  \end
  \eq* 
    Map_pair("#",'abcde','','123','@',0) = '#abcde','#','#123','#@',0
  \end
  \para Špecifikácia: 
  \eq* 
    ys in Map_pair(a,xss) <-> \e xs(ys = a,xs & xs in xss)
  \end
  \eq* 
    Ch(a) & Lstr(xss) -> Lstr Map_pair(a,xss)
  \end

fun/2 Map_pair 
  Map_pair(a,xss) = Foo

rem 
  \para \bf  Prefixy  \end 

rem 
  \para \bf  \it  Prefix.  \end  \end \header* pred/2 Prefix  \end Predikát 
  \ft Prefix(ys,xs) \end (7. prednáška, cvičenie ex07c) platí práve vtedy, 
  keď \ft ys \end je prefixom (súvislým začiatočným úsekom) zoznamu 
  \ft xs \end: 

pred/2 Prefix 
  Prefix(ys,xs) <-> \e zs xs = ys++zs

rem 
  \para V nasledujúcej úlohe využijeme, že 
  \items 
   \item \para jediným prefixom prázdneho zoznamu je prázdny zoznam: 
         \eq* 
           Prefix(ys,0) <-> ys = 0
         \end
   \item \para prefixami neprázdneho zoznamu \ft x,xs \end sú 
         \para a) prázdny zoznam, 
         \para b) všetky zoznamy \ft x,zs \end, kde \ft zs \end je prefixom 
         zoznamu \ft xs \end, 
         \para* teda: 
         \eq* 
           Prefix(ys,Paren(x,xs)) <-> ys = 0 \/ \e zs(ys = x,zs & Prefix(zs,xs))
         \end
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Prefixes(xs) \end, ktorá 
  vráti \it  zoznam všetkých prefixov  \end zoznamu (reťazca) \ft xs \end. 
  Funkciu zadefinujte zoznamovou rekurziou. Využite vlastnosti 
  prefixov uvedené v predchádzajúcej poznámke a funkciu 
  \ft Map_pair \end. 
  \para* Napríklad: 
  \eq* 
    Prefixes(2,3,5,0) = 0,(2,0),(2,3,0),(2,3,5,0),0
  \end
  \eq* 
    Prefixes('aky') = '','a','ak','aky',0
  \end
  \eq* 
    Prefixes('taky') = '','t','ta','tak','taky',0
  \end
  \para Špecifikácia: 
  \eq* 
    ys in Prefixes(xs) <-> Prefix(ys,xs)
  \end
  \eq* 
    Str(xs) -> Lstr Prefixes(xs)
  \end

fun Prefixes 
  Prefixes(xs) = Foo

rem 
  \para \bf  Vybrané podpostupnosti  \end 

rem 
  \para \bf  \it  Vybraná podpostupnosť.  \end  \end 
  \header* pred/2 Subseq  \end Predikát \ft Subseq(ys,xs) \end platí práve 
  vtedy, keď zoznam \ft ys \end je \it  vybranou podpostupnosťou  \end zoznamu 
  \ft xs \end. To znamená, že \ft ys \end vznikne vynechaním niektorých 
  prvkov zo zoznamu \ft xs \end (aj žiadnych alebo všetkých). Vzájomné 
  poradie zostávajúcich prvkov sa nezmení. 
  \para Presnejšie, zoznam \ft ys \end je vybranou podpostupnosťou zoznamu 
  \ft xs = Tex2_varidx(x,0),x1,x2,Tex0_ldots,Tex2_varidx(x,n),0 \end, ak 
  \eq* 
    ys = 
    Tex2_varidx(x,Tex2_varidx(i,0)),Tex2_varidx(x,i1),Tex0_ldots,
    Tex2_varidx(x,Tex2_varidx(i,k)),0
  \end
  \para pre nejakú rastúcu postupnosť 
  \ft Tex2_varidx(i,0),i1,i2,Tex0_ldots,Tex2_varidx(i,k) \end indexov prvkov 
  zoznamu \ft xs \end, teda \ft 0 <= Tex2_varidx(i,0) \end < \ft i1 \end < 
  \ft i2 \end < \ft Tex0_cdots \end < \ft Tex2_varidx(i,k) <= n \end. 
  \para Napríklad 
  \eq* 
    Subseq('','vsetko')
  \end
  \eq* 
    Subseq('veko','vsetko')
  \end
  \eq* 
    Subseq('vsetko','vsetko')
  \end
  \eq* 
    ~Subseq('svet','vsetko')
  \end
  \eq* 
    ~Subseq('sito','vsetko')
  \end
  \para Predikát \ft Subseq(ys,xs) \end môžeme rekurzívne zadefinovať 
  nasledovne: 

pred/2 Subseq 
  Subseq(ys,0) <- ys = 0
  Subseq(ys,x,xs) <- ys = 0
  Subseq(ys,x,xs) <- ys = y,zs & y = x & Subseq(zs,xs)
  Subseq(ys,x,xs) <- ys = y,zs & y != x & Subseq(ys,xs)

rem 
  \para V nasledujúcej úlohe využijeme, že 
  \items 
   \item \para jedinou vybranou podpostupnosťou prázdneho zoznamu je prázdny 
         zoznam: 
         \eq* 
           Subseq(ys,0) <-> ys = 0
         \end
   \item \para vybranými podpostupnosťami neprázdneho zoznamu \ft x,xs \end 
         sú 
         \para a) všetky zoznamy \ft x,zs \end, kde \ft zs \end je vybranou 
         podpostupnosťou zoznamu \ft xs \end, 
         \para b) všetky podpostupnosti zoznamu \ft xs \end, 
         \para* teda 
         \eq* 
           Subseq(ys,Paren(x,xs)) <-> 
           \e zs(ys = x,zs & Subseq(zs,xs)) \/ Subseq(ys,xs)
         \end
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Subseqs(xs) \end, ktorá 
  vráti \it  zoznam všetkých vybraných podpostupností  \end zoznamu 
  (reťazca) \ft xs \end. Funkciu zadefinujte zoznamovou rekurziou. Využite 
  vlastnosti vybraných podpostupností z predchádzajúcej poznámky 
  a funkciu \ft Map_pair \end. 
  \para* Napríklad: 
  \eq* 
    Subseqs('ak') = 'ak','a','k','',0
  \end
  \eq* 
    Subseqs('tak') = 'tak','ta','tk','t','ak','a','k','',0
  \end
  \para Na poradí reťazcov vo výslednom zozname nezáleží. 
  \para* Špecifikácia: 
  \eq* 
    ys in Subseqs(xs) <-> Subseq(ys,xs)
  \end
  \eq* 
    Str(xs) -> Lstr Subseqs(xs)
  \end

fun Subseqs 
  Subseqs(xs) = Foo

rem 
  \para \bf  Permutácie  \end 

rem 
  \para \bf  \it  Permutácia.  \end  \end \header* pred/2 Perm 'Tex2_perm' \end 
  Predikát \ft Perm(xs,ys) \end (8. prednáška, cvičenie ex08a) platí 
  práve vtedy, keď zoznam \ft xs \end je permutáciou zoznamu \ft ys \end. 

pred/2 Perm 'Tex2_perm'
  Perm(xs,ys) <-> \a a Count(a,xs) = Count(a,ys)

rem 
  \para Cieľom nasledujúcich úloh je zadefinovať funkciu \ft Perms(xs) \end, 
  ktorá vráti zoznam všetkých permutácií zoznamu \ft xs \end. Aby sme 
  našli definíciu \ft Perms(xs) \end zoznamovou rekurziou, potrebujeme 
  vyjadriť permutácie zoznamu \ft x,xs \end pomocou permutácií \ft xs \end. 

rem 
  \para \bf  \it  Vsunutie prvku do zoznamu.  \end  \end 
  \header* pred/3 Inserted  \end Predikát \ft Inserted(ys,xs,a) \end platí 
  práve vtedy, keď zoznam \ft ys \end vznikne vsunutím prvku \ft a \end do 
  zoznamu \ft xs \end. 

pred/3 Inserted 
  Inserted(ys,xs,a) <-> \e vs\e ws(xs = vs++ws & ys = vs++(a,ws))

rem 
  \para \bf  Úloha.  \end \header* fun/2 Interleave  \end Zadefinujte funkciu 
  \ft Interleave(a,xs) \end, ktorá vráti zoznam všetkých vsunutí prvku 
  (znaku) \ft a \end do zoznamu (reťazca) \ft xs \end. 
  \para Rekurzívnu definíciu s využitím funkcie \ft Map_pair \end by vám 
  mali pomôcť objaviť nasledujúce príklady: 
  \eq* 
    Interleave("#",'') = '#',0
  \end
  \eq* 
    Interleave("#",'ak') = '#ak','a#k','ak#',0
  \end
  \eq* 
    Interleave("#",'tak') = '#tak','t#ak','ta#k','tak#',0
  \end
  \para a vlastnosti predikátu \ft Inserted \end: 
  \eq* 
    Inserted((a,0),0,a)
  \end
  \eq* 
    Inserted(ys,(x,xs),a) <-> 
    ys = a,x,xs \/ \e zs(ys = x,zs & Inserted(zs,xs,a))
  \end
  \para* spolu so špecifikáciou: 
  \eq* 
    ys in Interleave(a,xs) <-> Inserted(ys,xs,a)
  \end
  \eq* 
    Ch(a) & Str(xs) -> Lstr Interleave(a,xs)
  \end

fun/2 Interleave 
  Interleave(a,xs) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Conc_map_i  \end Zadefinujte funkciu 
  \ft Conc_map_i(a,xss) \end, ktorá vráti zoznam všetkých vsunutí prvku 
  (znaku) \ft a \end do všetkých zoznamov (reťazcov) v \ft xss \end. Použite 
  funkciu \ft Interleave \end a zreťazenie. 
  \para* Napríklad: 
  \eq* 
    Conc_map_i("#",'tak','','@',0) = '#tak','t#ak','ta#k','tak#','#','#@','@#',0
  \end
  \para Špecifikácia: 
  \eq* 
    ys in Conc_map_i(a,xss) <-> \e xs(xs in xss & Inserted(ys,xs,a))
  \end
  \eq* 
    Ch(a) & Lstr(xss) -> Lstr Conc_map_i(a,xss)
  \end

fun/2 Conc_map_i 
  Conc_map_i(a,xss) = Foo

rem 
  \para \bf  \it  Rekurzívne vlastnosti permutácií.  \end  \end Pomocou 
  predikátu \ft Inserted \end môžeme vyjadriť vlastnosti permutácií, 
  ktoré nám pomôžu pri rekurzívnej definícii funkcie, ktorá vytvorí ich 
  zoznam. Platí: 
  \items 
   \item \para jedinou permutáciou prázdneho zoznamu je prázdny zoznam: 
         \eq* 
           Perm(ys,0) <-> ys = 0
         \end
   \item \para každá permutácia neprázdneho zoznamu \ft x,xs \end vznikne 
         vsunutím prvku \ft x \end do niektorej permutácie zoznamu 
         \ft xs \end: 
         \eq* 
           Perm(ys,Paren(x,xs)) <-> \e zs(Inserted(ys,zs,x) & Perm(zs,xs))
         \end
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Perms(xs) \end, ktorá vráti 
  zoznam všetkých permutácií zoznamu (reťazca) \ft xs \end. Funkciu 
  zadefinujte zoznamovou rekurziou. Využite vlastnosti 
  permutácií z predchádzajúcej poznámky a funkciu \ft Conc_map_i \end. 
  \para* Napríklad: 
  \eq* 
    Perms('ak') = 'ak','ka',0
  \end
  \eq* 
    Perms('tak') = 'tak','atk','akt','tka','kta','kat',0
  \end
  \para Na poradí reťazcov vo výslednom zozname nezáleží. 
  \para* Špecifikácia: 
  \eq* 
    ys in Perms(xs) <-> Perm(ys,xs)
  \end
  \eq* 
    Str(xs) -> Lstr Perms(xs)
  \end

fun Perms 
  Perms(xs) = Foo

