mod Ex09b

loc rem 
  \para \bf  9. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
   \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1011ls/ex/ex09.zip 

loc rem 
  \para* \it  Dátum:  \end streda 13. 4. 2011 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.19  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované binárnym
  stromom (ex09a) a binárnym vyhľadávacím stromom (ex09b).

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania LS 2010/2011. 
  \para http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1011ls/udp-screen.pdf
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/clslov.pdf
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer Programming. 
  2001. 
  \para http://ii.fmph.uniba.sk/cl/courses/1-INF-465-dp/1011ls/doc/meta2001.pdf

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

pred/0 Quux 'Tex0_foo'
  Quux <-> \f

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,3,Op(Ent('equiv'),0),Arg(1))

appldisp/0 Tex0_e
  Op(Ent('bull'),0)

appldisp/3 Tex3_nd
  Frac(Arg(0),1,Infix(Arg(1),25,3,Op(Ent('mid'),0),Arg(2)))

appldisp/2 Tex2_inbt
  Infix(Arg(0),25,1,Subsup(Id(0,Ent('epsiv'),0),75,Id(1,'b',0),None),Arg(1))

appldisp/2 Tex2_inbst
  Infix(Arg(0),25,0,Op(Ent('isin'),0),Arg(1))

appldisp/2 Tex2_lt
  Infix(Arg(0),25,0,Op(Ent('pr'),0),Arg(1))

appldisp/2 Tex2_gt
  Infix(Arg(0),25,0,Op(Ent('sc'),0),Arg(1))

appldisp/2 Tex2_insert
  Infix(Arg(0),35,1,Op(Ent('cup'),0),Fenced(Op('{',0),Arg(1),Op('}',0)))

appldisp/2 Tex2_ltb
  Infix(Arg(0),25,0,Subsup(Id(0,Ent('pr'),0),75,Id(1,'b',0),None),Arg(1))

appldisp/2 Tex2_join
  Infix(Arg(0),35,1,Op(Ent('sqcup'),0),Arg(1))

appldisp/2 Tex2_delete
  Infix(Arg(0),35,1,Op(Ent('setmn'),0),Fenced(Op('{',0),Arg(1),Op('}',0)))

fun/0 E 'Tex0_e'
  E = 0,0

fun/3 Nd 'Tex3_nd'
  Nd(x,l,r) = 1,x,l,r

pred Bt 
  Bt(E)
  Bt Nd(x,l,r) <- N(x) & Bt(l) & Bt(r)

pred/2 Inbt 'Tex2_inbt'
  Inbt(a,Nd(x,l,r)) <- a = x
  Inbt(a,Nd(x,l,r)) <- a != x & Inbt(a,l)
  Inbt(a,Nd(x,l,r)) <- a != x & ~Inbt(a,l) & Inbt(a,r)

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  15.3. Binárne vyhľadávacie stromy  \end 

rem 
  \para \bf  \it  Definícia.  \end  \end Binárny strom \ft t \end je 
  vyhľadávací, ak pre každý jeho podstrom \ft Nd(x,l,r) \end platí, že 
  prvky nachádzajúce sa v ľavom potomkovi \ft l \end sú menšie ako 
  \ft x \end a prvky nachádzajúce sa v pravom potomkovi \ft r \end sú 
  väčšie ako \ft x \end. 
  \para Vlastnosť „ \ft t \end je binárnym vyhľadávacím stromom“ budeme 
  označovať predikátom \ft Bst(t) \end. Výsledkom nasledujúcich dvoch úloh 
  je rekurzívna definícia tohto predikátu. 

rem 
  \para \bf  \it  Príklad.  \end  \end Nasledujúci binárny strom je 
  vyhľadávací. 
  \eq* 
    Nd(12,Nd(5,Nd(2,Nd(0,E,E),Nd(4,Nd(3,E,E),E)),Nd(7,E,Nd(9,E,E))),
       Nd(20,Nd(15,E,E),Nd(25,Nd(22,E,E),E)))
  \end
  \para Tento strom je zadefinovaný ako konštanta \ft T1 \end na konci tohto 
  súboru. 

rem 
  \para \bf  Úloha.  \end \header* pred/2 Lt  \end \header* pred/2 Gt  \end 
  Rekurziou na binárnych stromoch zadefinujte predikáty 
  \ft Tex2_equiv(Lt(a,t),Tex2_lt(a,t)) \end a 
  \ft Tex2_equiv(Gt(a,t),Tex2_gt(a,t)) \end. \header* pred/2 Lt 'Tex2_lt' \end 
  \header* pred/2 Gt 'Tex2_gt' \end Predikát \ft Lt(a,t) \end platí, ak 
  \ft a \end je menšie ako všetky hodnoty uložené v strome \ft t \end. 
  Predikát \ft Gt(a,t) \end platí, ak \ft a \end je väčšie ako všetky 
  hodnoty uložené v strome \ft t \end. 
  \para Špecifikácia: 
  \eq* 
    Bt(t) -> Lt(a,t) <-> \a x(Inbt(x,t) -> a < x)
  \end
  \eq* 
    Bt(t) -> Gt(a,t) <-> \a x(Inbt(x,t) -> a > x)
  \end

pred/2 Lt 'Tex2_lt'
  Lt(a,t) <- Quux

pred/2 Gt 'Tex2_gt'
  Gt(a,t) <- Quux

rem 
  \para \bf  Úloha.  \end Zadefinujte predikát \ft Bst(t) \end, ktorý platí, 
  keď \ft t \end je binárnym vyhľadávacím stromom. Predikát pomocou 
  rekurzie na binárnych stromoch overí vyhľadávaciu vlastnosť v každom 
  podstrome stromu \ft t \end. Použite predikáty \ft Lt(a,t) \end a 
  \ft Gt(a,t) \end z predchádzajúcej úlohy. 
  \para Pozitívne príklady: \ft Bst(E) \end, \ft Bst Nd(5,E,E) \end, 
  \ft Bst(T1) \end. 
  \para Negatívne príklady: \ft ~Bst Nd(2,Nd(2,E,E),Nd(4,E,E)) \end, 
  \ft ~Bst Nd(6,Nd(2,Nd(3,E,E),Nd(5,E,E)),Nd(9,Nd(7,E,E),Nd(8,E,E))) \end. 

pred Bst 
  Bst(t) <- Quux

rem 
  \para \bf  Úloha.  \end \header* pred/2 Inbst  \end Zadefinujte predikát 
  \ft Tex2_equiv(Inbst(a,t),Tex2_inbst(a,t)) \end, ktorý platí, ak \ft a \end 
  je hodnotou uloženou v binárnom vyhľadávacom strome. 
  \para \header* pred/2 Inbst 'Tex2_inbst' \end Napríklad \ft Inbst(4,T1) \end 
  a \ft ~Inbst(6,T1) \end. 
  \para Špecifikácia: 
  \eq* 
    Bst(t) -> Inbst(a,t) <-> Inbt(a,t)
  \end
  \para Využite (ale netestujte ani nijak nezabezpečujte), že \ft t \end je 
  vyhľadávací strom. Pri vyhľadávaní prvku stačí prejsť jedinú cestu 
  v strome, na ktorej sa môže nachádzať. 

pred/2 Inbst 'Tex2_inbst'
  Inbst(a,t) <- Quux

rem 
  \para \bf  Úloha.  \end \header* fun/2 Insert  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Insert(t,a),Tex2_insert(t,a)) \end, ktorá vloží hodnotu 
  \ft a \end do binárneho vyhľadávacieho stromu \ft t \end. 
  \para Špecifikácia: \header* fun/2 Insert 'Tex2_insert' \end 
  \eq* 
    Bst(t) -> Bst Insert(t,a)
  \end
  \eq* 
    Bst(t) -> Inbst(x,Insert(t,a)) <-> x = a \/ Inbst(x,t)
  \end
  \para Nepoužite žiadne pomocné funkcie ani predikáty (ani \ft Bst(t) \end 
  a \ft Inbst(a,t) \end). Pri vynáraní z rekurzie je potrebné strom 
  zrekonštruovať. 

fun/2 Insert 'Tex2_insert'
  Insert(t,a) = Foo

rem 
  \para \bf  \it  Zmazanie prvku z binárneho vyhľadávacieho stromu.  \end 
   \end \header* fun/2 Delete  \end \header* fun/2 Join  \end Proces 
  vymazávania hodnoty \ft a \end z binárneho vyhľadávacieho stromu 
  \ft t \end sme opísali na prednáške. V nasledujúcich úlohách ho 
  naprogramujeme ako rekurzívnu funkciu 
  \ft Tex2_equiv(Delete(t,a),Tex2_delete(t,a)) \end. Použijeme pri tom dve 
  pomocné funkcie: 
  \items 
   \item \para Funkcia \ft Extract_max(t) \end vyberie z binárneho 
         vyhľadávacieho stromu jeho maximum. 
   \item \para Funkcia \ft Tex2_equiv(Join(s,t),Tex2_join(s,t)) \end spojí 
         stromy \ft s \end a \ft t \end, ktoré sú ľavým a pravým potomkom 
         vymazávaného uzla, do nového binárneho vyhľadávacieho stromu. 
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Extract_max(t) \end, ktorá 
  pre neprázdny binárny vyhľadávací strom \ft t \end vráti dvojicu 
  \ft m,t1 \end, kde 
  \items 
   \item \para \ft m \end je maximálna hodnota uložená v strome \ft t \end, 
   \item \para \ft t1 \end je binárny vyhľadávací strom, ktorý obsahuje 
         rovnaké hodnoty ako \ft t \end okrem \ft m \end. 
  \end
  \para Špecifikácia: 
  \eq* 
    Bst(t) & t != E -> \e m\e t1 Extract_max(t) = m,t1
  \end
  \eq* 
    Bst(t) & Extract_max(t) = m,t1 -> \a x(Inbst(x,t) -> x <= m)
  \end
  \eq* 
    Bst(t) & Extract_max(t) = m,t1 -> 
    Bst(t1) & \a x(Inbst(x,t1) <-> x != m & Inbst(x,t1))
  \end
  \para Nepoužite žiadne pomocné funkcie. Výsledok rekurzívneho volania je 
  pred použitím potrebné rozdeliť na zložky \ft m \end a \ft s \end podobne 
  ako pri tuplingových funkciách v predchádzajúcich cvičeniach. 
  \para Otestujte svoje riešenie napríklad nasledujúcimi dvoma dotazmi: 
  \verbatim 
      Extract_max(T1) = m,t:Bt
      T1 = Nd(x,l:Bt,r:Bt) & Extract_max(l) = maxl,l1:Bt & Extract_max(r) = maxr,r1:Bt
  \end

fun Extract_max 
  Extract_max(t) = Foo,Foo

rem 
  \para \bf  \it  Porovnanie všetkých hodnôt v dvoch binárnych stromoch. 
   \end  \end Nasledujúci predikát platí, ak sú všetky hodnoty v binárnom 
  strome \ft s \end menšie ako všetky hodnoty v binárnom strome \ft t \end. 
  Definícia s kvantifikátormi sa nedá vyhodnotiť, predikát slúži iba na 
  špecifikáciu nasledujúcej funkcie \ft Join \end. 

pred/2 Ltb 'Tex2_ltb'
  Ltb(s,t) <-> \a x\a y(Inbt(x,s) & Inbt(y,t) -> x < y)

rem 
  \para Všimite si, že platí 
  \eq* 
    Bst Nd(x,l,r) -> Ltb(l,r)
  \end

rem 
  \para \bf  Úloha.  \end \header* fun/2 Join  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Join(s,t),Tex2_join(s,t)) \end, ktorá spojí dvoch bývalých 
  potomkov uzla v binárnom vyhľadávacom strome do jedného binárneho 
  vyhľadávacieho stromu. 
  \para Ak sú \it  oba  \end stromy neprázdne, funkcia vytvorí nový strom 
  využitím výsledkov funkcie \ft Extract_max \end. 
  \para Ak je \ft s \end prázdny funkcia vráti \ft t \end. Ak je \ft s \end 
  neprázdny a \ft t \end prázdny, funkcia vráti \ft s \end. 
  \para \header* fun/2 Join 'Tex2_join' \end Špecifikácia: 
  \eq* 
    Bst(s) & Bst(t) & Ltb(s,t) -> Bst Join(s,t)
  \end
  \eq* 
    Bst(s) & Bst(t) & Ltb(s,t) -> 
    \a x(Inbst(x,Join(s,t)) <-> Inbst(x,s) \/ Inbst(x,t))
  \end
  \para Použite iba funkciu \ft Extract_max \end. Nie je potrebná rekurzia. 
  \para Svoje riešenie môžete otestovať napríklad na priamych podstromoch 
  stromu \ft T1 \end takto: 
  \verbatim 
      T1 = Nd(x,l:Bt,r:Bt) & Join(l,r) = t:Bt
  \end

fun/2 Join 'Tex2_join'
  Join(s,t) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Delete  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Delete(t,a),Tex2_delete(t,a)) \end, ktorá zmaže hodnotu 
  \ft a \end z binárneho vyhľadávacieho stromu \ft t \end. 
  \para \header* fun/2 Delete 'Tex2_delete' \end Špecifikácia: 
  \eq* 
    Bst(t) -> Bst Delete(t,a)
  \end
  \eq* 
    Bst(t) -> Inbst(x,Delete(t,a)) <-> x != a & Inbst(x,t)
  \end
  \para Použite iba rekurziu a funkciu \ft Join(s,t) \end. 

fun/2 Delete 'Tex2_delete'
  Delete(t,a) = Foo

rem 
  \para \bf  \it  Testovací binárny vyhľadávací strom.  \end  \end 
  Konštantu \ft T1 \end môžete použiť na testovanie svojich riešení 
  predchádzajúcich úloh. 

fun/0 T1 
  T1 = 
  Nd(12,Nd(5,Nd(2,Nd(0,E,E),Nd(4,Nd(3,E,E),E)),Nd(7,E,Nd(9,E,E))),
     Nd(20,Nd(15,E,E),Nd(25,Nd(22,E,E),E)))

