mod Ex09a

loc rem 
  \para \bf  9. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
   \end 
  \para* \bf  ČASŤ A  \end 
  \para* http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1011ls/ex/ex09.zip 

loc rem 
  \para* \it  Dátum:  \end streda 13. 4. 2011 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.19  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované binárnym
  stromom (ex09a) a binárnym vyhľadávacím stromom (ex09b).

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania LS 2010/2011. 
  \para http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1011ls/udp-screen.pdf
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/clslov.pdf
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer Programming. 
  2001. 
  \para http://ii.fmph.uniba.sk/cl/courses/1-INF-465-dp/1011ls/doc/meta2001.pdf

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

pred/0 Quux 'Tex0_foo'
  Quux <-> \f

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_f
  Std('f',0)

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,3,Op(Ent('equiv'),0),Arg(1))

appldisp/0 Tex0_e
  Op(Ent('bull'),0)

appldisp/3 Tex3_nd
  Frac(Arg(0),1,Infix(Arg(1),25,3,Op(Ent('mid'),0),Arg(2)))

appldisp/1 Tex1_sz
  Subsup(Fenced(Op(Ent('mid'),0),Arg(0),Op(Ent('mid'),0)),75,Id(1,'b',0),None)

appldisp/2 Tex2_inbt
  Infix(Arg(0),25,1,Subsup(Id(0,Ent('epsiv'),0),75,Id(1,'b',0),None),Arg(1))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para* \bf  15. BINÁRNE STROMY  \end 

rem 
  \para* \bf  15.1. Kódovanie binárnych stromov  \end 

rem 
  \para \bf  \it  Kódovanie binárnych stromov párovými konštruktormi  \end 
   \end Binárne stromy budeme kódovať pomocou nasledujúcich párových \it  
  konštruktorov  \end. 
  \items 
   \item \para Konštruktor \ft Tex2_equiv(E,Tex0_e) \end kóduje prázdny 
         strom. 
   \item \para \header* fun/3 Nd  \end Konštruktor 
         \ft Tex2_equiv(Nd(x,l,r),Tex3_nd(x,l,r)) \end kóduje uzol stromu, v 
         ktorom je uložená hodnota \ft x \end, jeho ľavý potomok je 
         zakódovaný číslom \ft l \end a pravý potomok číslom \ft r \end. 
  \end

fun/0 E 'Tex0_e'
  E = 0,0

fun/3 Nd 'Tex3_nd'
  Nd(x,l,r) = 1,x,l,r

rem 
  \para \bf  \it  Príklad.  \end  \end Binárny strom môžeme zakódovať 
  napríklad takto: 
  \verbatim 
      Nd(0,Nd(1,Nd(3,E,E),Nd(4,E,E)),Nd(2,E,Nd(6,E,E)))
  \end
  \para Uvedený kód binárneho stromu sa zobrazí nasledovne: 
  \eq* 
    Nd(0,Nd(1,Nd(3,E,E),Nd(4,E,E)),Nd(2,E,Nd(6,E,E)))
  \end
  \para Tento príklad je zadefinovaný ako konštanta \ft T1 \end na konci 
  tohto súboru. Môžete ju použiť na testovanie riešení úloh v tomto 
  cvičení. 

rem 
  \para \bf  \it  [CL] Diskriminácia na binárnych stromoch.  \end  \end CL 
  dokáže diskriminovať hodnoty vytvorené konštruktormi \ft E \end a 
  \ft Nd(x,l,r) \end. 
  \para Binárne stromy budeme dekódovať \it  diskrimináciou na binárnych 
  stromoch  \end: 
  \def* 
    Tex1_cdots(t) <- t = E
    Tex1_cdots(t) <- t = Nd(x,l,r)
  \end
  \para Túto diskrimináciu môžeme tiež dosadiť do argumentov definovanej 
  funkcie alebo predikátu: 
  \def* 
    Tex1_f(E) = Tex0_cdots
    Tex1_f Nd(x,l,r) = Tex0_cdots
  \end

rem 
  \para \bf  \it  Predikát \ft Bt \end.  \end  \end Predikát \ft Bt(t) \end 
  platí, ak \ft t \end je kódom binárneho stromu, teda ak sa dá vytvoriť 
  pomocou konštruktorov \ft E \end a \ft Nd(x,l,r) \end. 

pred Bt 
  Bt(E)
  Bt Nd(x,l,r) <- N(x) & Bt(l) & Bt(r)

rem 
  \para \bf  \it  [CL] Predikát \ft Bt \end ako formát.  \end  \end Keď kód 
  binárneho stromu priradíme premennej v query, implicitne sa zobrazí ako 
  párovací výraz. Vyskúšajte napríklad query: 
  \verbatim 
      Nd(3,E,E) = l & Nd(7,E,E) = r & Nd(5,l,r) = t
  \end
  \para Predikát \ft Bt(t) \end je zadefinovaný tak, aby bol \it  formátom 
   \end – návodom na zobrazovanie hodnôt. Vďaka tomu ho môžeme použiť 
  na zobrazovanie hodnôt v query vo forme binárnych stromov, napríklad: 
  \verbatim 
      Nd(3,E,E) = l:Bt & Nd(7,E,E) = r:Bt & Nd(5,l,r) = t:Bt
      1,9,(0,0),0,0 = t:Bt
      T1 = v & v = t:Bt
  \end

rem 
  \para \bf  \it  Chyby pri kódovaní binárnych stromov.  \end  \end Ak 
  necháme formátom \ft Bt \end zobraziť číslo, ktoré \it  nekóduje  \end 
  binárny strom, vo výsledku sa objavia chybové hlásenia. 
  \para Častou chybou je použitie číselnej hodnoty v strome priamo, bez 
  skonštruovania uzla ( \ft Nd \end), v ktorom by bola uložená: 
  \verbatim 
      Nd(5,3,7) = t:Bt
  \end
  \para Inou častou chybou je použitie \ft 0 \end namiesto prázdneho stromu 
  \ft E \end: 
  \verbatim 
      Nd(5,Nd(3,0,0),Nd(7,0,0)) = t:Bt
  \end
  \para Správne píšeme: 
  \verbatim 
      Nd(5,Nd(3,E,E),Nd(7,E,E)) = t:Bt
  \end

rem 
  \para \bf  15.2. Operácie na binárnych stromoch  \end 

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Sz(t),Tex1_sz(t)) \end, ktorá určí počet uzlov ( 
  \ft Nd \end) v binárnom strome \ft t \end. 
  \para \header* fun Sz 'Tex1_sz' \end Napríklad \ft Sz Nd(4,E,E) = 1 \end, 
  \ft Sz(T1) = 6 \end. 

fun Sz 'Tex1_sz'
  Sz(t) = Foo

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Reflect(t) \end, ktorá 
  vytvorí zrkadlový obraz binárneho stromu \ft t \end. 
  \para Napríklad 
  \eq* 
    Reflect Nd(0,Nd(1,Nd(3,E,E),Nd(4,E,E)),Nd(2,E,Nd(6,E,E))) = 
    Nd(0,Nd(2,Nd(6,E,E),E),Nd(1,Nd(4,E,E),Nd(3,E,E)))
  \end

fun Reflect 
  Reflect(t) = Foo

rem 
  \para \bf  Úloha.  \end \header* pred/2 Inbt  \end Zadefinujte predikát 
  \ft Tex2_equiv(Inbt(a,t),Tex2_inbt(a,t)) \end, ktorý platí, ak je hodnota 
  \ft a \end uložená v niektorom uzle stromu \ft t \end. 
  \para \header* pred/2 Inbt 'Tex2_inbt' \end Napríklad \ft Inbt(3,T1) \end, 
  ale \ft ~Inbt(5,T1) \end. 
  \para \it  Návod.  \end Predikát má nasledujúce vlastnosti: 
  \eq* 
    ~Inbt(a,E)
  \end
  \eq* 
    Inbt(a,Nd(x,l,r)) <-> a = x \/ Inbt(a,l) \/ Inbt(a,r)
  \end
  \para Pri definícii predikátu nie je možné použiť disjunkciu. Využite 
  diskrimináciu na platnosť a neplatnosť predikátu. Negáciu (neplatnosť) 
  predikátu zapisujeme symbolom ~ (napr. ~Inbt(a,t)). 

pred/2 Inbt 'Tex2_inbt'
  Inbt(a,t) <- Quux

rem 
  \para \bf  Úloha.  \end Zadefinujte funkcie \ft Inorder(t) \end, 
  \ft Preorder(t) \end a \ft Postorder(t) \end, ktoré vytvoria zoznam hodnôt 
  uložených v uzloch binárneho stromu \ft t \end v príslušnom poradí. 
  \para Napríklad \ft Inorder(T1) = 3,1,4,0,2,6,0 \end; 
  \ft Preorder(T1) = 0,1,3,4,2,6,0 \end; \ft Postorder(T1) = 3,4,1,6,2,0,0 \end. 

fun Inorder 
  Inorder(t) = Foo

fun Preorder 
  Preorder(t) = Foo

fun Postorder 
  Postorder(t) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Inordera  \end Zadefinujte funkciu 
  \ft Inordera(t,as) \end, ktorá \it  bez použitia zreťazenia  \end vytvorí 
  zoznam hodnôt uložených v uzloch binárneho stromu \ft t \end v poradí 
  inorder nasledovaný zoznamom \ft as \end. 
  \para Napríklad 
  \ft Inordera(Nd(1,Nd(2,E,E),Nd(3,E,E)),98,99,0) = 2,1,3,98,99,0 \end a 
  \ft Inordera(T1,98,99,0) = 3,1,4,0,2,6,98,99,0 \end. 
  \para Funkcia má vlastnosť 
  \eq (*)
    Bt(t) -> Inordera(t,as) = Inorder(t)++as
  \end
  \para a teda 
  \eq* 
    Bt(t) -> Inordera(t,0) = Inorder(t)
  \end
  \para Nepoužite zreťazenie (++) ani žiadne pomocné funkcie. 
  \para Predstavte si zoznam \ft as \end ako zásobník, na ktorý postupne 
  ukladáte hodnoty zo stromu \ft t \end od poslednej po prvú. 
  \para Definíciu funkcie \ft Inordera \end tiež môžete odvodiť 
  z definície funkcie \ft Inorder \end a z vlastnosti (*). 

fun/2 Inordera 
  Inordera(t,as) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Preordera  \end 
  \header* fun/2 Postordera  \end Podobne ako v predchádzajúcej úlohe 
  zadefinujte funkcie \ft Preordera(t,as) \end a \ft Postordera(t,as) \end 
  s vlastnosťami 
  \eq* 
    Bt(t) -> Preordera(t,as) = Preorder(t)++as
  \end
  \eq* 
    Bt(t) -> Postordera(t,as) = Postorder(t)++as
  \end
  \para bez použitia zreťazenia alebo pomocných funkcií. 

fun/2 Preordera 
  Preordera(t,as) = Foo

fun/2 Postordera 
  Postordera(t,as) = Foo

rem 
  \para \bf  \it  Testovací binárny strom.  \end  \end Konštantu \ft T1 \end 
  môžete použiť na testovanie svojich riešení predchádzajúcich úloh. 

fun/0 T1 
  T1 = Nd(0,Nd(1,Nd(3,E,E),Nd(4,E,E)),Nd(2,E,Nd(6,E,E)))

