mod Skuska_0621_0900

incl Strings

incl Xml_mod

rem 
  \para \bf  SKÚŠKA Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA  \end 
  \para* 21. 6. 2007 o 9:00 

rem 
  \para \bf  Vaše meno:  \end [doplňte!] 

rem 
  \para Skúškový test tvorí jedna úloha rozdelená na päť častí. 
  Zadanie je uvedené nižšie. 
  \para* \bf  POKYNY  \end 
  \items 
   \item \para Na vyriešenie úlohy máte 135 minút. 
   \item \para Meno súboru obsahujúceho vaše riešenie: \it  
         skuska_0621_0900.cl  \end. 
   \item \para Na priebežné ukladanie vášho riešenia používajte tlačidlo 
         \it  Save  \end ( \it  Alt+S  \end). 
   \item \para Vaše riešenie odovzdajte podľa pokynov skúšajúceho. 
  \end
  \para* \bf  POČET BODOV:  \end 40 (20+6+11+3)

appldisp/0 Cdots
  Op(Ent('ctdot'),0)

fun/0 Fill_in 'Cdots'
  Fill_in = 20070621

pred/0 Fill__in 'Cdots'
  Fill__in <- 0 = 1

rem 
  \para \bf  INTERAKTÍVNA APLIKÁCIA — HRA NIM  \end 

rem 
  \para Vašou úlohou je naprogramovať hru Nim. Nim je hra, v ktorej dvaja 
  hráči striedavo odoberajú jednu až \ft n \end zápaliek z kôpky. Kto 
  zoberie poslednú zápalku, prehráva. V inom variante ten, kto zoberie 
  poslednú zápalku, vyhráva. Váš program má umožňovať hrať oba 
  varianty pre ľubovoľný kladný začiatočný počet zápaliek a 
  ľubovoľné \ft n > 1 \end pričom jedným z hráčov je počítač. Ľudský 
  hráč (ďalej len hráč) na začiatku zvolí parametre hry. Počítač 
  ťahá prvý. 
  \para \bf  Upozornenie:  \end Prvoradá je \bf  funkčnosť  \end, hoci aj 
  chudobná. Evidentne netestované „riešenia“ budú výrazne 
  penalizované. Snažte sa napísať funkcie \ft Main \end a \ft Process \end 
  tak, aby sa naprogramované operácie dali odskúšať. 
  \para Môžete pridávať ľubovoľné pomocné funkcie, ale \bf  nemeňte 
  mená ani počty argumentov  \end funkcií, ktorých šablóny sme pripravili 
  na vyplnenie. Napríklad funkcia \ft Ht_nim \end má podľa doleuvedenej 
  šablóny mať jeden argument (stav hry). Nepridávajte jej žiadne ďalšie 
  argumenty. 

rem 
  \para \bf  Kódovanie stavu hry  \end 

rem 
  \para Hra Nim sa môže nachádzať v troch stavoch: 
  \items 
   \item \para Začiatok: V tomto stave očakávame, že hráč zvolí parametre 
         hry. 
   \item \para Samotná hra: V tomto stave prebieha hra, kým je počet 
         zápaliek na kôpke nenulový. Musíme si v ňom pamätať zvolené 
         parametre a kvôli zobrazovaniu si budeme pamätať aj posledný ťah 
         počítača. Hra má nasledujúce parametre: 
         \items 
          \item \para \ft pocet \end: momentálny počet zápaliek na kôpke; 
          \item \para \ft maxtah \end: maximálny počet zápaliek, ktoré 
                možno odobrať v jednom ťahu; 
          \item \para \ft posledny \end: reťazec \ft 'vyhráva' \end alebo 
                \ft 'prehráva' \end, podľa toho, či ten, kto zoberie 
                poslednú zápalku hru vyhrá alebo prehrá; 
          \item \para \ft tahpocitac \end: počet zápaliek, ktoré v ostatnom 
                ťahu odobral z kôpky počítač; 
         \end
   \item \para Koniec: Do tohto stavu sa hra dostane, keď niekto odoberie 
         poslednú zápalku z kôpky. Pamätáme si v ňom, kto je víťazom (0: 
         počítač, 1: hráč). Z tohto stavu sa môžeme znova prepnúť do 
         stavu Začiatok. 
  \end
  \para Stav hry zakódujeme nasledujúcimi troma konštruktormi. 

fun/0 Zaciatok 
  Zaciatok = 0

fun/4 Hra 
  Hra(pocet,maxtah,posledny,tahpocitac) = 0,pocet,maxtah,posledny,tahpocitac

fun Koniec 
  Koniec(vitaz) = 1,vitaz

pred Stav 
  Stav(Zaciatok)
  Stav Hra(pocet,maxtah,posledny,tahpocitac) <- 
    N(pocet) & N(maxtah) & Str(posledny) & N(tahpocitac)
  Stav Koniec(vitaz) <- N(vitaz)

rem 
  \para \bf  Zobrazenie stavu hry v XHTML  \end (20 bodov) 

rem 
  \para \ft Is(Ht_nim,(Stav -> Lst(X))) \end 
  \para Stav hry zobrazíme ako XHTML dokument generovaný funkciou 
  \ft Ht_nim(t) \end. V každom stave obsahuje dokument formulár, ktorý 
  umožní hráčovi ovládať hru. 
  \para XHTML dokumenty pre jednotlivé stavy by mali vyzerať zhruba 
  nasledovne: 
  \items 
   \item \para \ft Zaciatok \end: (8 bodov) 
         \verbatim 
  Hra Nim
  
  Začiatočný počet zápaliek: [________]
  Počet zápaliek odoberaných v jednom ťahu: 1 až [________]
  Kto zoberie poslednú zápalku, ( ) vyhráva, (*) prehráva.
  [Štart]
         \end
   \item \para \ft Hra(pocet,maxtah,posledny,tahpocitac) \end: (8 bodov) 
         \verbatim 
  Hráme Nim
  
  Kto zoberie poslednú zápalku, $posledny$.
  Počítač odobral $tahpocitac$ zápaliek.
  Na kôpke je $pocet$ zápaliek.
  Koľko zápaliek odoberáš? [________] (1 až $maxtah$) [Ťah]
  [Nová hra]
         \end
   \item \para \ft Koniec(0) \end: (2 body) 
         \verbatim 
  Dohrali sme Nim
  
  Prehral(a) si!
  [Nová hra]
         \end
   \item \para \ft Koniec(1) \end: (2 body) 
         \verbatim 
  Dohrali sme Nim
  
  Gratulujem, vyhral(a) si!
  [Nová hra]
         \end
  \end
  \para Odporúčame každú zložitejšiu časť generovať samostatnou 
  funkciou. Používajte pomocné funkcie z modulov \ft Xml_mod \end ( 
  \ft Html \end, \ft Input \end, \ft Input_radio \end, \ft Button \end)
  a \ft Strings \end (\ft Show\end). 
  \para \bf  Testujte!  \end „Riešenia“, ktoré negenerujú XML budú 
  výrazne penalizované. 

fun Ht_nim 
  Ht_nim(Zaciatok) = Fill_in
  Ht_nim Hra(pocet,maxtah,posledny,tahpocitac) = Fill_in
  Ht_nim Koniec(vitaz) = Fill_in

rem 
  \para \bf  Stratégia počítača  \end (6 bodov) 

rem 
  \para Nasledujúce dve funkcie majú určiť, koľko zápaliek má počítač 
  odobrať z kôpky v nasledujúcom ťahu, aby (pokiaľ je to možné) vyhral. 
  Prvá funkcia počíta ťah pre prípad, keď ten, kto zoberie poslednú 
  zápalku vyhráva. Druhá funkcia počíta ťah pre prípad, keď ten, kto 
  zoberie poslednú zápalku prehráva. 
  \para Pre \ft pocet > 0 \end musia obe funkcie vždy vrátiť kladné číslo 
  nie väčšie ako \ft pocet \end ani ako \ft maxtah \end. Na výpočet 
  optimálnej stratégie nie sú potrebné žiadne ďalšie údaje. 

fun/2 Pocitac_posledny_vyhrava 
  Pocitac_posledny_vyhrava(pocet,maxtah) = Fill_in

fun/2 Pocitac_posledny_prehrava 
  Pocitac_posledny_prehrava(pocet,maxtah) = Fill_in

rem 
  \para \bf  Spracovanie udalostí  \end (11 bodov) 

rem 
  \para \ft Is(Process,(Attrs,Stav -> Stav)) \end \header* fun/2 Process  \end 
  \para Funkcia \ft Process(r,s) \end spracúva odoslanie formulárov hry. Dáta 
  z formulára dostane v premennej \ft r \end (ako zoznam dvojíc reťazcov: 
  meno, hodnota). Stav hry dostane v premennej \ft s \end. 
  \para \ft Process \end na základe predchádzajúceho stavu hry a prijatých 
  dát rozhodne o nasledujúcom stave. Ak bolo stlačené tlačidlo 
  \items 
   \item \para \it  Nová hra  \end (bez ohľadu na predchádzajúci stav), hra 
         sa dostane do stavu \ft Zaciatok \end; 
   \item \para \it  Štart  \end, z formulára sa získajú parametre hry. Ak 
         nie sú rozumné ( \ft maxtah < 1 \end alebo \ft pocet = 0 \end), hra 
         ostáva v stave \ft Zaciatok \end. Pre rozumné parametre sa hra 
         dostane do stavu \ft Hra \end a \it  počítač spraví svoj prvý ťah 
          \end; 
   \item \para \it  Ťah  \end, z formulára sa získajú údaje o hráčovom 
         ťahu. Ak hráč ťahal nesprávne (odobral 0 alebo viac ako 
         \ft maxtah \end alebo viac ako \ft pocet \end zápaliek), stav hry sa 
         nemení. Ak hráč ťahal správne, zmení sa počet zápaliek na 
         kôpke. Ak je počet nulový, hra sa končí (či víťazstvom alebo 
         prehrou závisí od \ft posledny \end). Inak spraví ťah počítač. 
         Hra sa môže opäť skončiť, ak na kôpke neostali žiadne zápalky. 
         Ak nejaké ostali, hra ostáva v stave \ft Hra \end s novým počtom 
         zápaliek a zaznamenaným ťahom počítača. 
  \end
  \para Nezabudnite tiež ošetriť prípad, že nebol odoslaný žiadny 
  formulár (reload alebo stlačenie Reexec. Query v CL). Premenná \ft r \end 
  má vtedy hodnotu \ft 0 \end. Hra by v tomto prípade nemala nijak zmeniť 
  stav. 
  \para Pre prehľadnosť by ste mali spracúvať stlačenie tlačidiel Štart a 
  Ťah osobitnými funkciami. Na spracovanie ťahu odporúčame pridať ďalšie 
  pomocné funkcie. 
  \para Na získavanie údajov z \ft r \end použite funkciu \ft Fva \end z 
  modulu \ft Xml_mod \end, na prevod reťazcov na čísla funkciu \ft Read \end 
  z modulu \ft Strings \end. 
  \para Na stav sa môžete pýtať testom v tvare:
  \def*
    Foo(Fill_in,s,Fill_in) = Fill_in <- Fill__in & s = Zaciatok & Fill__in
    Foo(Fill_in,s,Fill_in) = Fill_in <-
      Fill__in & s = Hra(pocet,maxtah,posledny,tahpocitac) & Fill__in
    Foo(Fill_in,s,Fill_in) = Fill_in <- Fill__in & s = Koniec(vitaz) & Fill__in
  \end
  \para Nemusíte nutne uvažovať všetky prípady, stačí ten, ktorý môže nastať
  pri stlačení príslušného tlačidla.

fun/2 Process 
  Process(r,s) = Fill_in

rem 
  \para \bf  Hlavná funkcia  \end (3 body) 

rem 
  \para \ft Is(Main,(Attrs,Stav -> Lst(X),Stav)) \end \header* fun/2 Main  \end 
  \para Funkcia \ft Main \end očakáva, že bude zavolaná z query 
  \verbatim 
       Main(request,data) = x:Xml,data99:Stav
  \end
  \para Funkcia zoberie dáta z odoslaného formulára (špeciálna premenná 
  \ft request \end) a predchádzajúci stav hry (špeciálna premenná 
  \ft data \end). Pomocnou funkcie \ft Process \end určí nový stav a vráti 
  dvojicu: XHTML pre nový stav, samotný nový stav. 

fun/2 Main 
  Main(r,s) = Fill_in,Fill_in <- Fill__in

