mod Skuska_0614_0800

incl Strings

incl Xml_mod

rem 
  \para \bf  SKÚŠKA Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA  \end 
  \para* 14. 6. 2007 o 8:00 

rem 
  \para \bf  Vaše meno:  \end [doplňte!] 

rem 
  \para Skúškový test tvorí jedna úloha rozdelená na päť častí. 
  Zadanie je uvedené nižšie. 
  \para* \bf  POKYNY  \end 
  \items 
   \item \para Na vyriešenie úlohy máte 135 minút. 
   \item \para Meno súboru obsahujúceho vaše riešenie: \it  
         skuska_0614_0800.cl  \end. 
   \item \para Na priebežné ukladanie vášho riešenia používajte tlačidlo 
         \it  Save  \end ( \it  Alt+S  \end). 
   \item \para Vaše riešenie odovzdajte podľa pokynov skúšajúceho. 
  \end
  \para* \bf  POČET BODOV:  \end 40 (5+10+15+5+5) 

appldisp/0 Cdots
  Op(Ent('ctdot'),0)

fun/0 Fill_in 'Cdots'
  Fill_in = 20070614

appldisp/0 E_d
  Op(Ent('bull'),0)

appldisp/3 Nd_d
  Frac(Arg(0),1,Infix(Arg(1),25,3,Op(Ent('mid'),0),Arg(2)))

rem 
  \para \bf  INTERAKTÍVNA APLIKÁCIA — EDITOR BINÁRNYCH STROMOV  \end 

rem 
  \para Vašou úlohou je naprogramovať jednoduchý editor binárnych stromov. 
  Editor má umožňovať: 
  \items 
   \item \para pridávanie uzlov, 
   \item \para vymazávanie podstromov, 
   \item \para zmenu hodnôt v uzloch, 
   \item \para zrkadlenie podstromov 
   \item \para a vygenerovanie XML, ktoré popíše vytvorený binárny strom. 
  \end
  \para Editor je presnejšie popísaný nižšie. 
  \para \bf  Upozornenie:  \end Prvoradá je \bf  funkčnosť  \end, hoci aj 
  chudobná. Evidentne netestované „riešenia“ budú výrazne 
  penalizované. Ak sa vám aj nepodarí naprogramovať všetky operácie na 
  štruktúrovanom texte, dbajte na to, aby aspoň tie, ktoré naprogramujete, 
  naozaj fungovali. Snažte sa napísať funkcie \ft Main \end a 
  \ft Process \end tak, aby sa naprogramované operácie dali odskúšať. 
  \para Môžete pridávať ľubovoľné pomocné funkcie, ale \bf  nemeňte 
  mená ani počty argumentov  \end funkcií, ktorých šablóny sme pripravili 
  na vyplnenie. Napríklad funkcia \ft Ht_btedit \end má podľa doleuvedenej 
  šablóny mať jeden argument. Nepridávajte jej žiadne ďalšie argumenty. 

rem 
  \para \bf  Kódovanie binárnych stromov  \end 

rem 
  \para Binárny strom je 
  \items 
   \item \para buď prázdny \ft E_d \end ( \ft E \end), alebo 
   \item \para tvorený uzlom \ft Nd_d(v,l,r) \end ( \ft Nd(v,l,r) \end), v 
         ktorom je uložená číselná hodnota \ft v \end a ktorý má dva 
         podstromy \ft l \end a \ft r \end, ktoré sú (rekurzívne) binárnymi 
         stromami. 
  \end

fun/0 E 'E_d'
  E = 0

fun/3 Nd 'Nd_d'
  Nd(v,l,r) = 1,v,l,r

pred Bt 
  Bt(E)
  Bt Nd(v,l,r) <- N(v) & Bt(l) & Bt(r)

rem 
  \para \bf  \it  Príklad  \end  \end 

fun/0 Bt_example 
  Bt_example = Nd(4,Nd(5,E,Nd(10,E,E)),Nd(7,Nd(1,Nd(2,E,E),E),Nd(9,E,E)))

rem 
  \para \bf  Vytvorenie XML pre binárny strom  \end (5 bodov) 

rem 
  \para \ft Is(Xml_bt,(Bt -> Lst(X))) \end 
  \para Funkcia \ft Xml_bt(t) \end pre binárny strom \ft t \end vytvorí XML 
  dokument popisujúci tento strom nasledovne: 
  \items 
   \item \para Koreňovým elementom dokumentu je element \it  tree  \end, 
         ktorý obsahuje práve jedno dieťa popisujúce strom \ft t \end. 
   \item \para Strom \ft E \end je popísaný elementom \it  empty  \end. 
   \item \para Strom \ft Nd(v,l,r) \end je popísaný elementom \it  node  \end 
         s troma deťmi: 
         \para Prvým dieťaťom je element \it  value  \end obsahujúci 
         číselnú hodnotu \ft v \end (ako reťazec). 
         \para Druhým a tretím dieťaťom sú elementy popisujúce ľavý a 
         pravý podstrom. 
  \end
  \para Napríklad strom z konštanty \ft Bt_example \end je popísaný 
  nasledujúcou konštantou \ft Xml_bt_example \end. 
  \para Pripomíname, že XML dokument je vždy zoznam, hoci koreňový element 
  je iba jeden. Na konverziu čísel na reťazce použite funkciu \ft Show \end 
  z modulu \ft Xml_mod \end. 

fun/0 X_xml_bt_example 
  X_xml_bt_example = 
  Xe('tree',0,
     Xe('node',0,Xe('value',0,Xs('4'),0),
        Xe('node',0,Xe('value',0,Xs('5'),0),Xe('empty',0,0),
           Xe('node',0,Xe('value',0,Xs('10'),0),Xe('empty',0,0),Xe('empty',0,0),0),0),
        Xe('node',0,Xe('value',0,Xs('7'),0),
           Xe('node',0,Xe('value',0,Xs('1'),0),
              Xe('node',0,Xe('value',0,Xs('2'),0),Xe('empty',0,0),Xe('empty',0,0),0),
              Xe('empty',0,0),0),
           Xe('node',0,Xe('value',0,Xs('9'),0),Xe('empty',0,0),Xe('empty',0,0),0),0),0),0),
  0

fun Xml_bt 
  Xml_bt(t) = Fill_in

rem 
  \para \bf  Operácie na binárnych stromoch  \end (10 bodov) 

rem 
  \para Úlohou nasledujúcich funkcií je realizovať operácie na binárnom 
  strome, ktoré bude volať funkcia \ft Process \end. 
  \para Tieto funkcie majú aspoň dva argumenty: strom ( \ft t \end) a cestu ( 
  \ft p \end) v tomto strome. \it  Cesta  \end je reťazec, ktorý určuje uzol 
  v strome (a podstrom, ktorého je tento uzol koreňom) nasledovným spôsobom: 
  \items 
   \item \para Prázdna cesta ( \ft p = 0 \end) určuje koreň stromu \ft t \end 
         (teda celý strom \ft t \end). 
   \item \para Cesta v tvare \ft p = "l",p1 \end (teda začínajúca znakom \it  
         l  \end) určuje ten istý uzol ako cesta \ft p1 \end v ľavom 
         podstrome stromu \ft t \end (ak je \ft t \end neprázdny, čiže ak 
         \ft t = Nd(v,l,r) \end). 
   \item \para Cesta v tvare \ft p = "r",p1 \end (teda začínajúca znakom \it  
         r  \end) určuje ten istý uzol ako cesta \ft p1 \end v pravom 
         podstrome stromu \ft t \end (ak je \ft t \end neprázdny). 
  \end
  \para Napríklad v strome 
  \eq* 
    Nd(4,Nd(5,E,Nd(10,E,E)),Nd(7,Nd(1,Nd(2,E,E),E),Nd(9,E,E)))
  \end
  \para cesta \ft 'l' \end (čiže \ft "l",0 \end) určuje podstrom 
  \ft Nd(5,E,Nd(10,E,E)) \end; cesta \ft 'rll' \end (čiže 
  \ft "r","l","l",0 \end) určuje podstrom \ft Nd(2,E,E) \end. 
  \para Každá z nasledujúcich funkcií 
  \items 
   \item \para nájde uzol v strome určený cestou (postupným vnáraním sa do 
         cestou určených podstromov), 
   \item \para vykoná na určenom uzle príslušnú operáciu 
   \item \para a (pri vynáraní sa z rekurzie) zrekonštruuje ostatné časti 
         stromu do pôvodnej podoby. 
  \end
  \para Ani pri jednej funkcii nemusíte uvažovať prípad, keď sa vetva v 
  strome skončí skôr ako cesta (teda dosiahnete \ft E \end, ale cesta ešte 
  nie je prázdna). To isté platí pre prípad, keď cesta obsahuje iné znaky 
  ako \it  l  \end a \it  r  \end. 

rem 
  \para \ft Is(Add_node,(Str,Bt -> Bt)) \end \header* fun/2 Add_node  \end (2 
  body) 
  \para Funkcia \ft Add_node(p,t) \end vytvorí v binárnom strome \ft t \end 
  nový uzol s hodnotou 0 a prázdnymi podstromami na mieste, na ktorom končí 
  cesta \ft p \end. 

fun/2 Add_node 
  Add_node(p,t) = Fill_in

rem 
  \para \ft Is(Del_subtree,(Str,Bt -> Bt)) \end \header* fun/2 Del_subtree  \end 
  (2 body) 
  \para Funkcia \ft Del_subtree(p,t) \end zruší podstrom, do koreňa ktorého 
  vedie cesta \ft p \end. Zrušiť znamená nahradiť prázdnym stromom. 

fun/2 Del_subtree 
  Del_subtree(p,t) = Fill_in

rem 
  \para \ft Is(Mirror_subtree,(Str,Bt -> Bt)) \end (4 body) 
  \header* fun/2 Mirror_subtree  \end 
  \para Funkcia \ft Mirror_subtree(p,t) \end zamení podstrom stromu \ft t \end, 
  do ktorého vedie cesta \ft p \end, za jeho zrkadlový obraz. 
  \para Napríklad zrkadlovým obrazom stromu 
  \ft Nd(4,Nd(5,E,Nd(10,E,E)),Nd(7,Nd(1,Nd(2,E,E),E),Nd(9,E,E))) \end je 
  \ft Nd(4,Nd(7,Nd(9,E,E),Nd(1,E,Nd(2,E,E))),Nd(5,Nd(10,E,E),E)) \end 

fun/2 Mirror_subtree 
  Mirror_subtree(p,t) = Fill_in

rem 
  \para \ft Is(Modify,(Str,N,Bt -> Bt)) \end \header* fun/3 Modify  \end (2 
  body) 
  \para Funkcia \ft Modify(p,v,t) \end zmení na \ft v \end hodnotu v uzle 
  stromu \ft t \end, do ktorého vedie cesta \ft p \end. 

fun/3 Modify 
  Modify(p,v,t) = Fill_in

rem 
  \para \bf  Zobrazenie editora do XHTML  \end (15 bodov) 

rem 
  \para \ft Is(Ht_btedit,(Bt -> Lst(X))) \end 
  \para Editor binárnych stromov je XHTML dokument generovaný funkciou 
  \ft Ht_btedit(t) \end dynamicky podľa stromu \ft t \end. Nasledujúca 
  konštanta \ft X_btedit_example \end ukazuje možný vzhľad editora pre 
  stromu z konštanty \ft Bt_example \end uvedenej vyššie. 
  \para* \it  Vzhľad editora  \end 
  \para Editor musí viditeľne odrážať štruktúru editovaného stromu. 
  Uvedený príklad na tento účel využíva (či skôr zneužíva) vnorené 
  tabuľky. Neprázdny uzol je zobrazený tabuľkou. Jej prvý riadok obsahuje 
  jedinú bunku s atribútom \it  colspan="2"  \end. Druhý riadok obsahuje dve 
  bunky, do ktorých sú vnorené podstromy. Pre sprehľadnenie sú bunky aj 
  tabuľka vhodne naštýlované. 
  \para Túto reprezentáciu môžete prebrať (nič vám nebráni pozrieť sa 
  do kódu konštanty \ft X_btedit_example \end), alebo môžete použiť 
  vlastnú. Strom môžete napríklad reprezentovať vnorenými zoznamami (XHTML 
  element \it  ul  \end). 
  \para* \it  Formuláre a ovládacie prvky  \end 
  \para Editor má obsahovať tieto ovládacie prvky: 
  \points 
   \item \para Tlačidlo Finish. Funkcia: ukončiť editovanie a ukázať XML 
         popisujúce strom. 
   \item \para Tlačidlo Add Node pre každý prázdny podstrom vyskytujúci sa 
         v strome. Funkcia: vložiť na miesto tohto podstromu nový neprázdny 
         uzol. 
   \item \para Textové pole s číselnou hodnotou, menu (select) na výber 
         jednej z operácií Modify, Delete a Mirror a tlačidlo Apply pre 
         každý neprázdny uzol v strome. Funkcia: zmeniť hodnotu v uzle; 
         zmazať uzol a celý jeho podstrom; nahradiť podstrom zrkadlovým 
         obrazom. 
  \end
  \para Uvedomte si, že v prípadoch 2 a 3 je pre funkčnosť editora 
  nevyhnutné, aby \bf  formulár obsahoval cesty k uzlom  \end, na ktorých sa 
  má vykonať operácia. Tieto cesty budete musieť konštruovať počas 
  generovania editora zo stromu. 
  \para Celý editor môže byť vnorený do jediného formulára, alebo môže 
  obsahovať mnoho formulárov (jeden pre Finish, po jednom pre Add Node a po 
  jednom pre každý neprázdny uzol). Konštanta \ft X_btedit_example \end 
  obsahuje mnoho formulárov. Výhodou takéhoto usporiadania je, že je cestu k 
  uzlu môžete uložiť v skrytom (hidden) prvku formulára a nemusíte sa 
  starať o to, aby textové polia, select-y a tlačidlá pre rôzne uzly mali 
  rôzne mená. 
  \para* \it  Odporúčania a upozornenia  \end 
  \para Nesnažte sa spraviť celý editor na prvýkrát. Začnite 
  skonštruovaním základného XHTML pre strom. Pridajte generujúcej 
  funkcii/funkciám argument, v ktorom budete udržiavať cestu k uzlom. 
  Postupne pridávajte ovládacie prvky. Odporúčame každú zložitejšiu 
  časť generovať samostatnou funkciou. Používajte pomocné funkcie z modulu 
  \ft Xml_mod \end ( \ft Html \end, \ft Input \end, \ft Button \end, 
  \ft Show \end). 
  \para \bf  Testujte!  \end „Riešenia“, ktoré negenerujú XML budú 
  výrazne penalizované. 

fun/0 X_btedit_example 'Nd_d'
  X_btedit_example = 
  Xe('html',(('xmlns','http://www.w3.org/1999/xhtml'),0),
     Xe('head',0,Xe('title',0,Xs('Binary Tree Editor'),0),0),
     Xe('body',0,
        Xe('form',0,
           Xe('button',
              (('type','submit'),('disabled','disabled'),('name','finish'),('value','finish'),0),
              Xs('Finish'),0),0),
        Xe('table',(('style','margin:0.25em'),0),
           Xe('tr',0,
              Xe('th',
                 (('colspan','2'),('style','padding:0.25em;background-color:#cde'),0),
                 Xe('form',0,Xe('input',(('type','hidden'),('name','path'),('value',''),0),0),
                    Xe('input',(('type','text'),('name','val'),('value','4'),('size','5'),0),0),
                    Xe('select',(('name','op'),0),
                       Xe('option',(('value','mod'),0),Xs('Modify'),0),
                       Xe('option',(('value','del'),0),Xs('Delete'),0),
                       Xe('option',(('value','mir'),0),Xs('Mirror'),0),0),
                    Xe('input',
                       (('type','submit'),('disabled','disabled'),('name','apply'),
                        ('value','Apply'),0),0),0),0),0),
           Xe('tr',0,
              Xe('td',(('style','vertical-align:top'),0),
                 Xe('table',(('style','margin:0.25em'),0),
                    Xe('tr',0,
                       Xe('th',
                          (('colspan','2'),
                           ('style','padding:0.25em;background-color:#cde'),0),
                          Xe('form',0,
                             Xe('input',(('type','hidden'),('name','path'),('value','l'),0),0),
                             Xe('input',
                                (('type','text'),('name','val'),('value','5'),('size','5'),0),0),
                             Xe('select',(('name','op'),0),
                                Xe('option',(('value','mod'),0),Xs('Modify'),0),
                                Xe('option',(('value','del'),0),Xs('Delete'),0),
                                Xe('option',(('value','mir'),0),Xs('Mirror'),0),0),
                             Xe('input',
                                (('type','submit'),('disabled','disabled'),('name','apply'),
                                 ('value','Apply'),0),0),0),0),0),
                    Xe('tr',0,
                       Xe('td',(('style','vertical-align:top'),0),
                          Xe('form',0,
                             Xe('input',(('type','hidden'),('name','path'),('value','ll'),0),0),
                             Xe('input',(('type','hidden'),('name','op'),('value','add'),0),0),
                             Xe('button',
                                (('type','submit'),('disabled','disabled'),('name','apply'),
                                 ('value','apply'),0),Xs('Add Node'),0),0),0),
                       Xe('td',(('style','vertical-align:top'),0),
                          Xe('table',(('style','margin:0.25em'),0),
                             Xe('tr',0,
                                Xe('th',
                                   (('colspan','2'),
                                    ('style','padding:0.25em;background-color:#cde'),
                                    0),
                                   Xe('form',0,
                                      Xe('input',
                                         (('type','hidden'),('name','path'),('value','lr'),0),
                                         0),
                                      Xe('input',
                                         (('type','text'),('name','val'),('value','10'),
                                          ('size','5'),0),0),
                                      Xe('select',(('name','op'),0),
                                         Xe('option',(('value','mod'),0),Xs('Modify'),0),
                                         Xe('option',(('value','del'),0),Xs('Delete'),0),
                                         Xe('option',(('value','mir'),0),Xs('Mirror'),0),
                                         0),
                                      Xe('input',
                                         (('type','submit'),('disabled','disabled'),
                                          ('name','apply'),('value','Apply'),0),0),0),0),
                                0),
                             Xe('tr',0,
                                Xe('td',(('style','vertical-align:top'),0),
                                   Xe('form',0,
                                      Xe('input',
                                         (('type','hidden'),('name','path'),('value','lrl'),
                                          0),0),
                                      Xe('input',
                                         (('type','hidden'),('name','op'),('value','add'),0),
                                         0),
                                      Xe('button',
                                         (('type','submit'),('disabled','disabled'),
                                          ('name','apply'),('value','apply'),0),
                                         Xs('Add Node'),0),0),0),
                                Xe('td',(('style','vertical-align:top'),0),
                                   Xe('form',0,
                                      Xe('input',
                                         (('type','hidden'),('name','path'),('value','lrr'),
                                          0),0),
                                      Xe('input',
                                         (('type','hidden'),('name','op'),('value','add'),0),
                                         0),
                                      Xe('button',
                                         (('type','submit'),('disabled','disabled'),
                                          ('name','apply'),('value','apply'),0),
                                         Xs('Add Node'),0),0),0),0),0),0),0),0),0),
              Xe('td',(('style','vertical-align:top'),0),
                 Xe('table',(('style','margin:0.25em'),0),
                    Xe('tr',0,
                       Xe('th',
                          (('colspan','2'),
                           ('style','padding:0.25em;background-color:#cde'),0),
                          Xe('form',0,
                             Xe('input',(('type','hidden'),('name','path'),('value','r'),0),0),
                             Xe('input',
                                (('type','text'),('name','val'),('value','7'),('size','5'),0),0),
                             Xe('select',(('name','op'),0),
                                Xe('option',(('value','mod'),0),Xs('Modify'),0),
                                Xe('option',(('value','del'),0),Xs('Delete'),0),
                                Xe('option',(('value','mir'),0),Xs('Mirror'),0),0),
                             Xe('input',
                                (('type','submit'),('disabled','disabled'),('name','apply'),
                                 ('value','Apply'),0),0),0),0),0),
                    Xe('tr',0,
                       Xe('td',(('style','vertical-align:top'),0),
                          Xe('table',(('style','margin:0.25em'),0),
                             Xe('tr',0,
                                Xe('th',
                                   (('colspan','2'),
                                    ('style','padding:0.25em;background-color:#cde'),
                                    0),
                                   Xe('form',0,
                                      Xe('input',
                                         (('type','hidden'),('name','path'),('value','rl'),0),
                                         0),
                                      Xe('input',
                                         (('type','text'),('name','val'),('value','1'),
                                          ('size','5'),0),0),
                                      Xe('select',(('name','op'),0),
                                         Xe('option',(('value','mod'),0),Xs('Modify'),0),
                                         Xe('option',(('value','del'),0),Xs('Delete'),0),
                                         Xe('option',(('value','mir'),0),Xs('Mirror'),0),
                                         0),
                                      Xe('input',
                                         (('type','submit'),('disabled','disabled'),
                                          ('name','apply'),('value','Apply'),0),0),0),0),
                                0),
                             Xe('tr',0,
                                Xe('td',(('style','vertical-align:top'),0),
                                   Xe('table',(('style','margin:0.25em'),0),
                                      Xe('tr',0,
                                         Xe('th',
                                            (('colspan','2'),
                                             ('style',
                                              'padding:0.25em;background-color:#cde'),
                                             0),
                                            Xe('form',0,
                                               Xe('input',
                                                  (('type','hidden'),('name','path'),
                                                   ('value','rll'),0),0),
                                               Xe('input',
                                                  (('type','text'),('name','val'),
                                                   ('value','2'),('size','5'),0),0),
                                               Xe('select',(('name','op'),0),
                                                  Xe('option',(('value','mod'),0),
                                                     Xs('Modify'),0),
                                                  Xe('option',(('value','del'),0),
                                                     Xs('Delete'),0),
                                                  Xe('option',(('value','mir'),0),
                                                     Xs('Mirror'),0),0),
                                               Xe('input',
                                                  (('type','submit'),
                                                   ('disabled','disabled'),
                                                   ('name','apply'),('value','Apply'),0),
                                                  0),0),0),0),
                                      Xe('tr',0,
                                         Xe('td',(('style','vertical-align:top'),0),
                                            Xe('form',0,
                                               Xe('input',
                                                  (('type','hidden'),('name','path'),
                                                   ('value','rlll'),0),0),
                                               Xe('input',
                                                  (('type','hidden'),('name','op'),
                                                   ('value','add'),0),0),
                                               Xe('button',
                                                  (('type','submit'),
                                                   ('disabled','disabled'),
                                                   ('name','apply'),('value','apply'),0),
                                                  Xs('Add Node'),0),0),0),
                                         Xe('td',(('style','vertical-align:top'),0),
                                            Xe('form',0,
                                               Xe('input',
                                                  (('type','hidden'),('name','path'),
                                                   ('value','rllr'),0),0),
                                               Xe('input',
                                                  (('type','hidden'),('name','op'),
                                                   ('value','add'),0),0),
                                               Xe('button',
                                                  (('type','submit'),
                                                   ('disabled','disabled'),
                                                   ('name','apply'),('value','apply'),0),
                                                  Xs('Add Node'),0),0),0),0),0),0),
                                Xe('td',(('style','vertical-align:top'),0),
                                   Xe('form',0,
                                      Xe('input',
                                         (('type','hidden'),('name','path'),('value','rlr'),
                                          0),0),
                                      Xe('input',
                                         (('type','hidden'),('name','op'),('value','add'),0),
                                         0),
                                      Xe('button',
                                         (('type','submit'),('disabled','disabled'),
                                          ('name','apply'),('value','apply'),0),
                                         Xs('Add Node'),0),0),0),0),0),0),
                       Xe('td',(('style','vertical-align:top'),0),
                          Xe('table',(('style','margin:0.25em'),0),
                             Xe('tr',0,
                                Xe('th',
                                   (('colspan','2'),
                                    ('style','padding:0.25em;background-color:#cde'),
                                    0),
                                   Xe('form',0,
                                      Xe('input',
                                         (('type','hidden'),('name','path'),('value','rr'),0),
                                         0),
                                      Xe('input',
                                         (('type','text'),('name','val'),('value','9'),
                                          ('size','5'),0),0),
                                      Xe('select',(('name','op'),0),
                                         Xe('option',(('value','mod'),0),Xs('Modify'),0),
                                         Xe('option',(('value','del'),0),Xs('Delete'),0),
                                         Xe('option',(('value','mir'),0),Xs('Mirror'),0),
                                         0),
                                      Xe('input',
                                         (('type','submit'),('disabled','disabled'),
                                          ('name','apply'),('value','Apply'),0),0),0),0),
                                0),
                             Xe('tr',0,
                                Xe('td',(('style','vertical-align:top'),0),
                                   Xe('form',0,
                                      Xe('input',
                                         (('type','hidden'),('name','path'),('value','rrl'),
                                          0),0),
                                      Xe('input',
                                         (('type','hidden'),('name','op'),('value','add'),0),
                                         0),
                                      Xe('button',
                                         (('type','submit'),('disabled','disabled'),
                                          ('name','apply'),('value','apply'),0),
                                         Xs('Add Node'),0),0),0),
                                Xe('td',(('style','vertical-align:top'),0),
                                   Xe('form',0,
                                      Xe('input',
                                         (('type','hidden'),('name','path'),('value','rrr'),
                                          0),0),
                                      Xe('input',
                                         (('type','hidden'),('name','op'),('value','add'),0),
                                         0),
                                      Xe('button',
                                         (('type','submit'),('disabled','disabled'),
                                          ('name','apply'),('value','apply'),0),
                                         Xs('Add Node'),0),0),0),0),0),0),0),0),0),
              0),0),0),0),0

fun Ht_btedit 
  Ht_btedit(t) = Fill_in

rem 
  \para \bf  Spracovanie udalostí  \end (5 bodov) 

rem 
  \para \ft Is(Process,(Attrs,Bt -> Bt)) \end \header* fun/2 Process  \end 
  \para Funkcia \ft Process(r,t) \end spracúva odoslanie formulárov editora 
  (okrem Finish). Dáta z formulára dostane v premennej \ft r \end (ako zoznam 
  dvojíc reťazcov meno, hodnota). Funkcia z prijatých údajov musí zistiť 
  cestu k uzlu, na ktorom sa má vykonať operácia. Ďalej musí zistiť, o 
  akú operáciu sa jedná. Nakoniec zavolá príslušnú funkciu z časti \it  
  Operácie na binárnych stromoch  \end na vstupnom strome \ft t \end a vráti 
  jej výsledok. 
  \para Nezabudnite tiež ošetriť prípad, že nebolo stlačené žiadne 
  tlačidlo (reload alebo stlačenie Reexec. Query v CL). Premenná \ft r \end 
  má vtedy hodnotu \ft 0 \end. Editovaný strom by sa v tomto prípade nemali 
  stratiť. 
  \para Na získavanie údajov z \ft r \end použite funkciu \ft Fva \end z 
  modulu \ft Xml_mod \end. 

fun/2 Process 
  Process(r,t) = Fill_in

rem 
  \para \bf  Hlavná funkcia  \end (5 bodov) 

rem 
  \para \ft Is(Main,(Attrs,Bt -> Lst(X),Bt)) \end \header* fun/2 Main  \end 
  \para Funkcia \ft Main \end očakáva, že bude zavolaná z query 
  \verbatim 
       Main(request,data) = x:Xml,data99:Bt
  \end
  \para Funkcia teda zoberie dáta z odoslaného formulára (špeciálna 
  premenná \ft request \end) a strom (špeciálna premenná \ft data \end) a 
  vždy vráti dvojicu: XML (alebo XHTML) a (potenciálne nový) strom. 
  \para V špeciálnom prípade, keď bolo stlačené tlačidlo Finish, funkcia 
  \ft Main \end vyrobí XML reprezentáciu stromu volaním \ft Xml_bt \end a 
  vráti dvojicu tvorenú týmto XML a vstupným stromom. 
  \para Ak nebolo stlačené Finish, \ft Main \end odovzdá \ft request \end a 
  \ft data \end funkcii \ft Process \end, ktorá vytvorí novú verziu stromu. 
  Pre túto novú verziu \ft Main \end vyrobí XHTML editor volaním 
  \ft Ht_btedit \end. \ft Main \end vráti dvojicu tvorenú týmto XHTML a novou 
  verziou stromu. 

fun/2 Main 
  Main(r,d) = Fill_in,Fill_in

