mod Xml_mod

incl Strings

rem 
  \para \bf  Types for Atributes of XML Elements  \end 

rem 
  \para \bf  type  \end \ft Attr = Str,Str \end 

pred Attr 
  Attr(a,v) <- Str(a) & Str(v)

rem 
  \para \bf  type  \end \ft Attrs = Lst(Attr) \end 

pred Attrs 
  Attrs(0)
  Attrs(w,a) <- Attr(w) & Attrs(a)

rem 
  \para \ft Is(Fva,(Str,Lst(Attr) -> Str)) \end. 
  \para \header* fun/2 Fva  \end Used for looking up the values of attributes. 
  The application \ft Fva(a,attrs) \end searches the attributes \ft attrs \end 
  for the value associated with the attribute name \ft a \end. 

fun/2 Fva 
  Fva(a,0) = ''
  Fva(a,(b,v),x) = v <- a = b
  Fva(a,(b,v),x) = Fva(a,x) <- a != b

rem 
  \para \bf  Types of Xml Documents  \end 

rem 
  \para \ft Is(Xe,(Str,Lst(Attr),Lst(X) -> X)) \end 

fun/3 Xe 
  Xe(name,attr,cont) = 0,name,attr,cont

rem 
  \para \ft Is(Xs,(Str -> X)) \end 

fun Xs 
  Xs(s) = 1,s

rem 
  \para \bf  type  \end \ft Xml = Lst(X) \end 

pred Xml 
  Xml(0)
  Xml(Xe(n,a,c),r) <- Str(n) & Attrs(a) & Xml(c) & Xml(r)
  Xml(Xs(s),r) <- Str(s) & Xml(r)

rem 
  \para \bf  type  \end \ft Txml = Lst(X) \end. 
  \para A format to be used for testing. \ft Txml \end is identical to 
  \ft Xml \end, but the value formatted as \ft Txml \end is shown as a CL term, 
  not a real XML document. 

pred Txml 
  Txml(0)
  Txml(Xe(n,a,c),r) <- Str(n) & Attrs(a) & Txml(c) & Txml(r)
  Txml(Xs(s),r) <- Str(s) & Txml(r)

rem 
  \para \bf  Some Operations on Documents  \end 

rem 
  \para \ft Is(Html,(Str,Lst(X) -> Lst(X))) \end. \header* fun/2 Html  \end 
  \para Takes a title (string) and body elements and yields a XHTML document. 
  Note that \ft L Html(t,c) = 1 \end. 

fun/2 Html 
  Html(ttle,c) = Xe('html',(('xmlns','http://www.w3.org/1999/xhtml'),0),h,b,0),0 <- 
    Xe('head',0,Xe('title',0,Xs(ttle),0),0) = h & Xe('body',0,c) = b

rem 
  \para \ft Is(Value_of,(Lst(X) -> Lst(Str))) \end. 

fun Value_of 
  Value_of(0) = 0
  Value_of(Xs(s),x) = s++Value_of(x)
  Value_of(Xe(nm,a,y),x) = Value_of(y)++Value_of(x)

rem 
  \para \ft Is(Input_a,(Str,Str,Str,Lst(Attr) -> X)) \end. 

fun/4 Input_a 
  Input_a(tp,nme,val,a) = Xe('input',(('type',tp),('name',nme),('value',val),a),0)

rem 
  \para \ft Is(Input,(Str,Str,Str -> X)) \end. 

fun/3 Input 
  Input(tp,nme,val) = Input_a(tp,nme,val,0)

rem 
  \para \ft Is(Input_radio,(Str,Str,Str -> X)) \end. 

fun/3 Input_radio 
  Input_radio(nme,val,ch) = Input_a('radio',nme,val,('checked','checked'),0) <- 
    val = ch
  Input_radio(nme,val,ch) = Input_a('radio',nme,val,0) <- val != ch

rem 
  \para \ft Is(Button,(Str,Str,Str -> X)) \end. 

fun/3 Button 
  Button(nme,val,caption) = 
  Xe('button',(('type','submit'),('name',nme),('value',val),0),Xs(caption),0)

rem 
  \para \bf  Conversion of numbers  \end 

rem 
  \para \ft Is(Showx,(N -> Lst(X))) \end 
  \para Yields an \ft Lst(X) \end value containing the decimal representation of 
  a natural number. 

fun Showx 
  Showx(n) = Xs Show(n),0

rem 
  \para \ft Is(Show_fixx,(N,N -> Lst(X))) \end \header* fun/2 Show_fixx  \end 
  \para \ft Show_fixx(n,f) \end yields an \ft Lst(X) \end value containing the 
  decimal representation of the number \ft n*Exp(10,Unary_minus_d(f)) \end, 
  i.e., the number \ft n \end intepreted as a fixed-point number with \ft f \end 
  fractional digits. 

fun/2 Show_fixx 
  Show_fixx(n,f) = Xs Show_fix(n,f),0

