mod Strings

appldisp/1 Lst
  Fenced(Op('[',0),Arg(0),Op(']',0))

appldisp/2 Is
  Infix(Arg(0),0,1,Op('::',0),Arg(1))

appldisp/2 Ispred
  Infix(Arg(0),0,3,Op(Ent('sube'),0),Arg(1))

appldisp/2 Exp_d
  Subsup(Arg(0),75,None,Arg(1))

appldisp/1 Unary_minus_d
  Prefix(70,2,Op(Ent('minus'),0),Arg(0))

appldisp/2 Lt_s_d
  Infix(Arg(0),25,0,Subsup(Op(Ent('lt'),0),75,Id(0,'s',0),None),Arg(1))

fun/2 Exp 'Exp_d'
  Exp(b,S0(x)) = 1 <- x = 0
  Exp(b,S0(x)) = e*e <- x > 0 & Exp(b,x) = e
  Exp(b,S1(x)) = b*e*e <- Exp(b,x) = e

rem 
  \para \bf  String Operations  \end 

rem 
  \para \bf  \it  Conversion of numbers to strings  \end  \end 

rem 
  \para \ft Is(Show,(N -> Str)) \end 
  \para \header* fun/2 Show1  \end Yields a string representing a natural number 
  in decimal notation. Uses an auxiliary accumulator function 
  \ft Is(Show1,(N,Str -> Str)) \end such that \ft Show1(n,a) = Show(n)++a \end. 

fun/2 Show1 
  Show1(10*q+r,a) = a1 <- 0 <= r & r <= 9 & r+"0",a = a1 & q = 0
  Show1(10*q+r,a) = Show1(q,a1) <- 0 <= r & r <= 9 & r+"0",a = a1 & q > 0

fun Show 
  Show(n) = Show1(n,'')

rem 
  \para \ft Is(Show_fix,(N,N -> Str)) \end 
  \para Yields a string representing a fixed-point number in decimal notation. A 
  fixed-point number \ft q \end is given as a pair \ft n,f \end of numbers such 
  that \ft q = n*Exp_d(10,Unary_minus_d(f)) \end, i.e., \ft f \end 
  least-significant decimal digits of the number \ft n \end form the fractional 
  part of \ft q \end. 

fun/3 Show_fix1 
  Show_fix1(0,n,a) = Show1(n,".",a)
  Show_fix1(f+1,10*q+r,a) = Show_fix1(f,q,"0"+r,a) <- 0 <= r & r <= 9

fun/2 Show_fix 
  Show_fix(n,f) = Show(n) <- f = 0
  Show_fix(n,f) = Show_fix1(f,n,'') <- f > 0

rem 
  \para \bf  \it  Conversion of strings to numbers  \end  \end 

rem 
  \para \ft Is(Read_ns,(N,Str -> N,Str)) \end 
  \para Takes a number \ft a \end (accumulator) and a string \ft s \end. Reads 
  the characters of \ft s \end up to the end or the first non-digit character. 
  Let \ft k \end be the number of digit characters, let \ft n \end be the number 
  represented by them, and let \ft s1 \end be the rest of the string. The 
  function yields the pair \ft a*Exp(10,k)+n,s1 \end. 

fun/2 Read_ns 
  Read_ns(a,0) = a,0
  Read_ns(a,c,s) = n,s1 <- "0" <= c & c <= "9" & Read_ns(10*a+c-"0",s) = n,s1
  Read_ns(a,c,s) = a,c,s <- "0" <= c & c > "9"
  Read_ns(a,c,s) = a,c,s <- "0" > c

rem 
  \para \ft Is(Read_fix,(Str,N -> N)) \end 
  \para Interprets the string as a fixed-point number with \ft f \end fractional 
  digits. Yields the number (shifted by \ft f \end digits to the right). 
  \para If \ft f > 0 \end and the radix point ( \ft "." \end) is missing, the 
  function yields \ft 0 \end. The radix point must be followed by exactly 
  \ft f \end digits, otherwise the number is misinterpreted. 
  \para If \ft f = 0 \end, no radix point is allowed. 
  \para The string must end after the last digit of the number. 

fun/2 Read_fix 
  Read_fix(s,f) = n <- f = 0 & Read_ns(0,s) = n,0
  Read_fix(s,f) = n*Exp(10,f)+m <- 
    f > 0 & Read_ns(0,s) = n,".",s1 & Read_fix(s1,0) = m

rem 
  \para \bf  \it  Lexicographic Comparison of Strings  \end  \end 

rem 
  \para \ft Ispred(Lt_s,Str,Str) \end 
  \para The predicate \ft Lt_s \end (displayed as \ft Lt_s_d(s,t) \end) compares 
  two strings lexicographically. Note that this is different from the comparison 
  of numbers which encode the strings using the pairing function. For example, 
  \ft 'abc' < 'ac' \end is false, but \ft Lt_s_d('abc','ac') \end is true. 

pred/2 Lt_s 'Lt_s_d'
  Lt_s(0,d,t)
  Lt_s((c,s),d,t) <- c < d
  Lt_s((c,s),d,t) <- c = d & Lt_s(s,t)

