mod Ex06

incl Mtex

incl Mtexnt

incl Maux

loc rem 
  \para \bf  6. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.21 
  \para* \it  Dátum:  \end piatok 27.3.2020 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/1920ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované symbolickým 
  výrazom. Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície a vlastnosti 
         pomocných funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  \para \bf  Hodnotenie.  \end 
  \items 
   \item \para Počet bodov za úlohy v tomto súbore: 5 
   \item \para Počet bodov za prémiove úlohy v tomto súbore: 2 
  \end
  \para Odovzdať do 2.4.2020 (štvrtok) do 18:00. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Online. 
   \item \para \it  [2]  \end Ján Kľuka. Úvod do deklaratívneho 
         programovania. Online. 
  \end

rem 
  \para \bf  [CL] CL-TeX.  \end 

appldisp/1 Tex1_appl_mu_sb
  Prefix(80,0,Id(0,Ent('mu'),0),Fenced(Op('[',0),Arg(0),Op(']',0)))

rem 
  \para \bf  Chapter. Programs Operating on Symbolic Expressions.  \end 

rem 
  \para The symbolic data structures are usually defined in the functional 
  programming languages with the help of union types which can be readily 
  arithmetized. We have seen already in one of the previous chapters an example 
  of union type defining binary trees. In this chapter we will use another union 
  types to arithmetize certain classes of symbolic expressions. 

rem 
  \para \bf  Section. Numeric Terms.  \end 

rem 
  \para Numeric terms are symbolic expressions formed from variables and 
  constants by the application of numeric binary operators of addition and 
  multiplication. 

rem 
  \para \bf  Subsection. Arithmetization of Numeric Terms.  \end 

rem 
  \para \bf  Constructors of numeric terms.  \end Arithmetization of numeric 
  expressions is done with the help of the following four pair constructors with 
  pairwise different tags. 

fun Vt 'Tex_f1_nt_vt'
  Vt(i) = 0,i

fun Ct 'Tex_f1_nt_ct'
  Ct(n) = 1,n

fun/2 At 'Tex_f2_nt_at'
  At(t1,t2) = 2,t1,t2

fun/2 Mt 'Tex_f2_nt_mt'
  Mt(t1,t2) = 3,t1,t2

rem 
  \para \bf  Discrimination on the constructors of numeric terms.  \end 
  \header* fun F 'Tex_f1_f' \end The pattern matching style of definitions of 
  functions operating over the codes of numeric terms is obtained with 
  conditionals called \it  discrimination on the constructors of numeric terms 
   \end. Example: 
  \def 
    fun F 'Tex_f1_f'
    F Vt(i) = Foo
    F Ct(n) = Foo
    F At(t1,t2) = Foo
    F Mt(t1,t2) = Foo
  \end

rem 
  \para \bf  Numeric terms.  \end Discrimination on the constructors of numeric 
  terms is used in the definition of the predicate \ft Term(t) \end holding of 
  the codes of numeric terms. The predicate is defined by course of values 
  recursion. We refer to this kind of recursive definition as \it  structural 
  recursion on numeric terms  \end. 

pred Term 
  Term Vt(i) <- N(i)
  Term Ct(n) <- N(n)
  Term At(t1,t2) <- Term(t1) & Term(t2)
  Term Mt(t1,t2) <- Term(t1) & Term(t2)

rem 
  \para In the sequel we identify numeric terms with their codes and from now on 
  we say \it  the numeric term \ft t \end  \end instead of \it  the code 
  \ft t \end of a numeric term  \end. 

rem 
  \para \bf  [CL] Formatting the output.  \end Use the format \ft Term \end to 
  display numbers as numeric terms. Try out the following simple queries 
  \verbatim 
     98041654 = t:Term
  \end
  \verbatim 
     3,(2,(0,1),1,2),0,3 = t:Term
  \end
  \verbatim 
     Mt(At(Vt(1),Ct(2)),Vt(3)) = t
  \end

rem 
  \para \bf  Subsection. Basic Operations and Predicates.  \end 

rem 
  \para \bf  Size of numeric terms.  \end \header* fun Sz 'Tex_f1_nt_sz' \end 
  The function \ft Sz(t) \end yields the size of the numeric term \ft t \end, 
  i.e. the number of operations including variables needed to construct the 
  term. Example: 
  \eq* 
    Sz Mt(At(Vt(1),Ct(2)),Vt(3)) = 5
  \end
  \para The function is defined by structural recursion on numeric terms. 

fun Sz 'Tex_f1_nt_sz'
  Sz Vt(i) = 1
  Sz Ct(n) = 1
  Sz At(t1,t2) = Sz(t1)+Sz(t2)+1
  Sz Mt(t1,t2) = Sz(t1)+Sz(t2)+1

rem 
  \para \bf  Denotation of numeric terms. \it  (1 point)  \end  \end 
  \header* fun/2 Den 'Tex_f2_nt_den' \end The function \ft Den(t,v) \end takes 
  the numeric term \ft t \end and (the code of) the assignment \ft v \end and 
  yields the value, i. e. denotation, of the term in the assignment. Example: 
  \eq* 
    Den(Mt(At(Vt(1),Ct(2)),Vt(3)),10,11,12,13,0) = (11+2)*13
  \end
  \para The function is defined by structural recursion on numeric terms. 

fun/2 Den 'Tex_f2_nt_den'
  Den(t,v) = Foo

rem 
  \para \bf  Free variables.  \end \header* fun Fv 'Tex_f1_nt_fv' \end The 
  function \ft Fv(t) \end yields the list of the indices of variables occurring 
  in the numeric term \ft t \end. Example: 
  \eq* 
    Fv Mt(At(Vt(1),Ct(2)),Vt(3)) = 1,3,0
  \end
  \para The function is defined by structural recursion on numeric terms. 

fun Fv 'Tex_f1_nt_fv'
  Fv(t) = Foo

rem 
  \para \bf  Subsection. Additive Normal Form.  \end 

rem 
  \para \bf  Multiplicative terms.  \end The predicate \ft Mterm(t) \end is 
  holding of multiplicative terms. These are numeric terms formed from variables 
  and constants by the application of multiplication. Example: 
  \eq* 
    Mterm Mt(Mt(Vt(1),Ct(2)),Vt(3)) & ~Mterm Mt(At(Vt(1),Ct(2)),Vt(3))
  \end
  \para The predicate is defined by structural recursion on numeric terms. 

pred Mterm 
  Mterm Vt(i)
  Mterm Ct(n)
  Mterm Mt(t1,t2) <- Mterm(t1) & Mterm(t2)

rem 
  \para \bf  Terms in additive normal form.  \end The predicate \ft Anf(t) \end 
  is holding of terms in additive normal form. These are either multiplicative 
  terms or addition of two numeric terms in additive normal form. Example: 
  \eq* 
    Anf At(Mt(Vt(1),Vt(3)),Mt(Ct(2),Vt(3))) & ~Anf Mt(At(Vt(1),Ct(2)),Vt(3))
  \end
  \para The predicate is defined by structural recursion on numeric terms. 

pred Anf 
  Anf(t) <- Mterm(t)
  Anf(t) <- ~Mterm(t) & t = At(t1,t2) & Anf(t1) & Anf(t2)

rem 
  \para \bf  Exercise.  \end \header* fun/2 Mul_ma  \end Define the function 
  \ft Mul_ma(s,t) \end such that 
  \eq* 
    Term(s) & Term(t) -> Term Mul_ma(s,t)
  \end
  \eq* 
    Mterm(s) & Term(t) & Anf(t) -> Anf Mul_ma(s,t)
  \end
  \eq* 
    Term(s) & Term(t) -> Den(Mul_ma(s,t),vs) = Den(Mt(s,t),vs)
  \end

fun/2 Mul_ma 
  Mul_ma(s,t) = Foo

rem 
  \para \bf  Exercise.  \end \header* fun/2 Mul_aa  \end Define the function 
  \ft Mul_aa(s,t) \end such that 
  \eq* 
    Term(s) & Term(t) -> Term Mul_aa(s,t)
  \end
  \eq* 
    Term(s) & Anf(s) & Term(t) & Anf(t) -> Anf Mul_aa(s,t)
  \end
  \eq* 
    Term(s) & Term(t) -> Den(Mul_aa(s,t),vs) = Den(Mt(s,t),vs)
  \end

fun/2 Mul_aa 
  Mul_aa(s,t) = Foo

rem 
  \para \bf  Rearranging terms into additive normal form. \it  (2 points)  \end 
   \end Define the function \ft Anf_from(t) \end such that 
  \eq* 
    Term(t) -> Term Anf_from(t)
  \end
  \eq* 
    Term(t) -> Anf Anf_from(t)
  \end
  \eq* 
    Term(t) -> Den(Anf_from(t),vs) = Den(t,vs)
  \end

fun Anf_from 
  Anf_from(t) = Foo

rem 
  \para \bf  Subsection. Left Associated Addition.  \end 

rem 
  \para In this part we give an example of a program which goes beyond 
  structural recursion. We consider the problem of rearranging numeric terms so 
  that the additions which they contain are associated to left. 

rem 
  \para \bf  Terms with left associated addition.  \end The predicate 
  \ft Lassoc(t) \end is holding of numeric terms with left associated addition. 
  Example: 
  \eq* 
    Lassoc At(At(Vt(1),Vt(2)),Vt(3)) & ~Lassoc At(Vt(1),At(Vt(2),Vt(3)))
  \end
  \para The predicate is defined by structural recursion on numeric terms. 

pred Lassoc 
  Lassoc Vt(i)
  Lassoc Ct(n)
  Lassoc Mt(t1,t2)
  Lassoc At(t,Vt(i)) <- Lassoc(t)
  Lassoc At(t,Ct(n)) <- Lassoc(t)
  Lassoc At(t,Mt(t1,t2)) <- Lassoc(t)

rem 
  \para \bf  Rearranging terms into expressions with left associated addition. 
  \it  (1 point)  \end  \end Define the function \ft Lassoc_from(t) \end such 
  that 
  \eq* 
    Term(t) -> Term Lassoc_from(t)
  \end
  \eq* 
    Term(t) -> Lassoc Lassoc_from(t)
  \end
  \eq* 
    Term(t) -> Den(Lassoc_from(t),v) = Den(t,v)
  \end
  \para Do not use auxiliary functions! 
  \para \it  Hint.  \end Put 
  \eq* 
    Lassoc_from At(t1,At(t2,t3)) = Lassoc_from At(At(t1,t2),t3)
  \end
  \para \header* fun M1 'Tex1_appl_mu_sb' \end Define \ft Lassoc_from(t) \end by 
  recursion with the measure \ft M1(t) \end: 
  \def 
    fun M1 'Tex1_appl_mu_sb'
    M1 Vt(i) = 0
    M1 Ct(n) = 0
    M1 Mt(t1,t2) = 0
    M1 At(t1,t2) = M1(t1)+2*M1(t2)+1
  \end

fun Lassoc_from 
  Lassoc_from(t) = Foo

rem 
  \para \bf  Subsection. Postfix Machine.  \end 

rem 
  \para Numeric terms are compiled into programs of a postfix machine and then 
  the programs are executed. 

rem 
  \para \bf  Instructions.  \end The instructions of the postfix machine are 
  defined with the help of four pair constructors with pairwise different tags. 

fun Vi 'Tex_f1_nt_vi'
  Vi(i) = 0,i

fun Ci 'Tex_f1_nt_ci'
  Ci(n) = 1,n

fun/0 Ai 'Tex_f0_nt_ai'
  Ai = 2,0

fun/0 Mi 'Tex_f0_nt_mi'
  Mi = 3,0

rem 
  \para The predicate \ft Instr(i) \end holding of instructions of the postfix 
  machine is defined as follows. 

pred Instr 
  Instr Vi(i) <- N(i)
  Instr Ci(n) <- N(n)
  Instr(Ai)
  Instr(Mi)

rem 
  \para \bf  Programs.  \end The predicate \ft Program(p) \end holding of 
  programs of the postfix machine is defined by list recursion. 

pred Program 
  Program(0)
  Program(i,p) <- Instr(i) & Program(p)

rem 
  \para \bf  [CL] Formatting the output.  \end Use the format \ft Program \end 
  to display numbers as programs. Try out the following simple queries 
  \verbatim 
     4723455160 = p:Program
  \end
  \verbatim 
     (0,1),(1,2),(2,0),(0,3),(3,0),0 = p:Program
  \end
  \verbatim 
     Vi(1),Ci(2),Ai,Vi(3),Mi,0 = p
  \end

rem 
  \para \bf  Compilation. \it  (1 point)  \end  \end Numeric terms are compiled 
  into programs of the postfix machine with the help of the operation 
  \ft Cmp(t) \end: 
  \eq* 
    Term(t) -> Program Cmp(t)
  \end
  \para Example: 
  \eq* 
    Cmp Mt(At(Vt(1),Ct(2)),Vt(3)) = Vi(1),Ci(2),Ai,Vi(3),Mi,0
  \end
  \para The compilation function is defined by structural recursion on numeric 
  terms. 

fun Cmp 
  Cmp(t) = Foo

rem 
  \para \bf  One-step evaluation. \it  (1 point)  \end  \end The operation of 
  the postfix machine itself is described by the ternary function 
  \ft Run(p,v,s) \end, where \ft p \end is a program, \ft v \end is an 
  assignment (environment), and \ft s \end is a list of values (I/O stack). 
  Specification: 
  \eq* 
    Term(t) -> Run(Cmp(t),v,0) = Den(t,v)
  \end
  \para Invariant: 
  \eq* 
    Term(t) -> Run(Cmp(t)++p,v,s) = Run(p,v,Den(t,v),s)
  \end
  \para The function \ft Run(p,v,s) \end is defined by structural recursion on 
  the program \ft p \end. 

fun/3 Run 
  Run(p,v,s) = Foo

rem 
  \para \bf  Decompilation. \it  (2 bonus points)  \end  \end Define the 
  function \ft Decmp(t) \end such that 
  \eq* 
    Term(t) -> Decmp Cmp(t) = t
  \end
  \para Example: 
  \eq* 
    Decmp(Vi(1),Ci(2),Ai,Vi(3),Mi,0) = Mt(At(Vt(1),Ct(2)),Vt(3))
  \end
  \para \it  Hint.  \end \header* fun/2 Decmp1 'Tex_f2_f' \end Define first an 
  auxiliary binary function \ft Decmp1(p,s) \end such that 
  \eq* 
    Term(t) -> Decmp1(Cmp(t)++p,s) = Decmp1(p,t,s)
  \end

fun/2 Decmp1 'Tex_f2_f'
  Decmp1(p,t,s) = Foo

fun Decmp 
  Decmp(p) = Foo

loc rem 
  ******************************************************************************
  ********************************* DEBUGGING **********************************
  ******************************************************************************

loc rem 
  \para \bf  Rearranging terms into additive normal form.  \end 

loc fun/0 T11 
  T11 = Mt(At(Vt(1),Ct(2)),Vt(3))

loc fun/0 T12 
  T12 = Mt(At(Vt(0),Vt(1)),At(Vt(1),Vt(2)))

loc fun/0 T13 
  T13 = Mt(Vt(0),Mt(Ct(2),At(Vt(0),Vt(1))))

loc fun/0 T14 
  T14 = 
  Mt(At(Mt(Vt(1),Vt(0)),At(Vt(2),Ct(10))),At(Mt(Ct(3),Vt(3)),At(Vt(4),Ct(4))))

loc rem 
  \para \bf  Rearranging terms into expressions with left associated addition. 
   \end 

loc fun/0 T21 
  T21 = At(Vt(1),At(Vt(2),Vt(3)))

loc fun/0 T22 
  T22 = At(At(Vt(1),Vt(2)),At(Vt(3),Vt(4)))

loc fun/0 T23 
  T23 = 
  At(At(Vt(1),At(Vt(2),At(Vt(3),Vt(4)))),At(Vt(5),At(Vt(6),At(Vt(7),Vt(8)))))

loc rem 
  \para \bf  Some useful queries.  \end 

loc rem 
  98041654 = t:Term
  3,(2,(0,1),1,2),0,3 = t:Term
  Mt(At(Vt(1),Ct(2)),Vt(3)) = t
  
  Sz Mt(At(Vt(1),Ct(2)),Vt(3)) = size
  Den(Mt(At(Vt(1),Ct(2)),Vt(3)),10,11,12,13,0) = denotation
  Fv Mt(At(Vt(1),Ct(2)),Vt(3)) = freevariables
  
  T11 = t1:Term & Anf_from(t1) = t2:Term & Anf(t2)
  
  T21 = t1:Term & Lassoc_from(t1) = t2:Term & Lassoc(t2)
  
  Cmp Mt(At(Vt(1),Ct(2)),Vt(3)) = p:Program
  Mt(At(Vt(1),Ct(2)),Vt(3)) = t:Term & 10,11,12,13,0 = v & 
   Den(t,v) = denotation & Cmp(t) = p:Program & Run(p,v,0) = value & 
   denotation = value
  Decmp(Vi(1),Ci(2),Ai,Vi(3),Mi,0) = t:Term

