mod Mauxb

incl Mtex

incl Mtexbt

rem 
  \para \bf  Characteristic function.  \end 

fun/2 Eqf 'Tex_f2_n_char_eqf'
  Eqf(x,y) = 1 <- x = y
  Eqf(x,y) = 0 <- x != y

rem 
  \para \bf  Binary trees.  \end 

rem 
  \para \it  Arithmetization.  \end 

fun/0 E 'Tex_f0_bt_e'
  E = 0,0

fun/3 Nd 'Tex_f3_bt_nd'
  Nd(x,l,r) = 1,x,l,r

pred Bt 
  Bt(E)
  Bt Nd(x,l,r) <- N(x) & Bt(l) & Bt(r)

rem 
  \para \it  Basic operations and predicates.  \end 

fun Sz 'Tex_f1_bt_sz'
  Sz(E) = 0
  Sz Nd(x,l,r) = Sz(l)+Sz(r)+1

fun/2 Count 'Tex_f2_bt_count'
  Count(x,E) = 0
  Count(x,Nd(y,l,r)) = Count(x,l)+Count(x,r)+Eqf(x,y)

pred/2 Inbt 'Tex_p2_bt_in'
  Inbt(x,Nd(y,l,r)) <- x = y
  Inbt(x,Nd(y,l,r)) <- x != y & Inbt(x,l)
  Inbt(x,Nd(y,l,r)) <- x != y & ~Inbt(x,l) & Inbt(x,r)

pred/2 Subtree 'Tex_p2_bt_subtree'
  Subtree(t1,t2) <- t1 = t2
  Subtree(t1,t2) <- t1 != t2 & t2 = Nd(x2,l2,r2) & Subtree(t1,l2)
  Subtree(t1,t2) <- 
    t1 != t2 & t2 = Nd(x2,l2,r2) & ~Subtree(t1,l2) & Subtree(t1,r2)

rem 
  \para \bf  Braun trees.  \end 

pred/2 Index 
  Index(0,Nd(x,l,r))
  Index(S1(i),Nd(x,l,r)) <- Index(i,l)
  Index(S2(i),Nd(x,l,r)) <- Index(i,r)

pred Brt 
  Brt(t) <-> Bt(t) & \a i(Index(i,t) <-> i < Sz(t))

fun/2 Lookup 'Tex_f2_bt_lookup'
  Lookup(Nd(x,l,r),0) = x
  Lookup(Nd(x,l,r),S1(i)) = Lookup(l,i)
  Lookup(Nd(x,l,r),S2(i)) = Lookup(r,i)

fun/3 Update 'Tex_f3_bt_update'
  Update(Nd(y,l,r),0,x) = Nd(x,l,r)
  Update(Nd(y,l,r),S1(i),x) = Nd(y,Update(l,i,x),r)
  Update(Nd(y,l,r),S2(i),x) = Nd(y,l,Update(r,i,x))

fun/2 Insfirst 
  Insfirst(E,x) = Nd(x,E,E)
  Insfirst(Nd(y,l,r),x) = Nd(x,Insfirst(r,y),l)

