mod Ex12a

incl Mtex

incl Mtexbt

incl Mauxa

loc rem 
  \para \bf  12. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 12.81.20 
  \para* \it  Dátum:  \end streda 21.5.2014 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/1314ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované Braunovym 
  stromom a haldám. Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície niektorých 
         funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Downloadable lecture notes available through the web page of 
         the course. 
   \item \para \it  [2]  \end J. Komara and P. J. Voda. Metamathematics of 
         Computer Programming. 2001. 
  \end

rem 
  \para \bf  [CL] CL-TeX.  \end 

appldisp/1 Tex_f1_oh
  Prefix(70,2,Op(Ent('Oscr'),0),Arg(0))

appldisp/1 Tex_f1_bt_sz_brt
  Subsup(Fenced(Op(Ent('mid'),0),Arg(0),Op(Ent('mid'),0)),75,Num('1',0),None)

rem 
  \para \bf  Chapter. Programs Operating on Trees.  \end 

rem 
  \para \bf  Section. Braun Trees.  \end See also the section \it  Perfectly 
  Balanced Binary Trees  \end in [2]. 

rem 
  \para \bf  Braun trees.  \end 

pred/2 Index 
  Index(0,Nd(x,l,r))
  Index(S1(i),Nd(x,l,r)) <- Index(i,l)
  Index(S2(i),Nd(x,l,r)) <- Index(i,r)

pred Brt 
  Brt(t) <-> Bt(t) & \a i(Index(i,t) <-> i < Sz(t))

rem 
  \para We have 
  \eq* 
    Brt(E)
  \end
  \eq* 
    Brt Nd(x,l,r) <-> (Sz(l) = Sz(r) \/ Sz(l) = Sz(r)+1) & Brt(l) & Brt(r)
  \end

rem 
  \para \bf  Indexing in Braun trees.  \end 

fun/2 Lookup 'Tex_f2_bt_lookup'
  Lookup(t,i) = Foo

rem 
  \para \bf  Modification of Braun trees.  \end 
  \header* fun/3 Update 'Tex_f3_bt_update' \end Define the function 
  \ft Update(t,i,x) \end such that 
  \eq* 
    Brt(t) & i < Sz(t) -> Brt Update(t,i,x)
  \end
  \eq* 
    Brt(t) & i < Sz(t) -> Sz Update(t,i,x) = Sz(t)
  \end
  \eq* 
    Brt(t) & i < Sz(t) -> Lookup(Update(t,i,x),i) = x
  \end
  \eq* 
    Brt(t) & i < Sz(t) & j < Sz(t) & j != i -> 
    Lookup(Update(t,i,x),j) = Lookup(t,j)
  \end

fun/3 Update 'Tex_f3_bt_update'
  Update(t,i,x) = Foo

rem 
  \para \bf  New Braun tree.  \end Define the function \ft New(n) \end such that 
  \eq* 
    Brt New(n)
  \end
  \eq* 
    Sz New(n) = n
  \end

fun New 
  New(n) = Foo

rem 
  \para \bf  Filling a Braun tree.  \end \header* fun/2 Fill  \end Define the 
  function \ft Fill(n,x) \end such that 
  \eq* 
    Brt Fill(n,x)
  \end
  \eq* 
    Sz Fill(n,x) = n
  \end
  \eq* 
    i < n -> Lookup(Fill(n,x),i) = x
  \end

fun/2 Fill 
  Fill(n,x) = Foo

rem 
  \para \bf  Insertion of a new first label.  \end \header* fun/2 Insfirst  \end 
  Define the function \ft Insfirst(t,x) \end such that 
  \eq* 
    Brt(t) -> Brt Insfirst(t,x)
  \end
  \eq* 
    Brt(t) -> Sz Insfirst(t,x) = Sz(t)+1
  \end
  \eq* 
    Brt(t) -> Lookup(Insfirst(t,x),0) = x
  \end
  \eq* 
    Brt(t) & i < Sz(t) -> Lookup(Insfirst(t,x),i+1) = Lookup(t,i)
  \end

fun/2 Insfirst 
  Insfirst(t,x) = Foo

rem 
  \para \bf  Deletion of the first label.  \end Define the function 
  \ft Delfirst(t) \end such that 
  \eq* 
    Brt(t) & t != E -> Brt Delfirst(t)
  \end
  \eq* 
    Brt(t) & t != E -> Sz Delfirst(t) = Sz(t)-1
  \end
  \eq* 
    Brt(t) & t != E & i < Sz(t)-1 -> Lookup(Delfirst(t),i) = Lookup(t,i+1)
  \end
  \para \it  Hint.  \end Note that the application \ft Lookup(t,0) \end yields 
  root element for non-empty trees. 

fun Delfirst 
  Delfirst(t) = Foo

rem 
  \para \bf  Insertion of a new last label.  \end \header* fun/3 Inslast  \end 
  Define the function \ft Inslast(n,t,x) \end such that 
  \eq* 
    Brt(t) -> Brt Inslast(Sz(t),t,x)
  \end
  \eq* 
    Brt(t) -> Sz Inslast(Sz(t),t,x) = Sz(t)+1
  \end
  \eq* 
    Brt(t) & i < Sz(t) -> Lookup(Inslast(Sz(t),t,x),i) = Lookup(t,i)
  \end
  \eq* 
    Brt(t) -> Lookup(Inslast(Sz(t),t,x),Sz(t)) = x
  \end

fun/3 Inslast 
  Inslast(n,t,x) = Foo

rem 
  \para \bf  Deletion of the last label.  \end \header* fun/2 Dellast  \end 
  Define the function \ft Dellast(n,t) \end such that 
  \eq* 
    Brt(t) & t != E -> Brt Dellast(Sz(t)-1,t)
  \end
  \eq* 
    Brt(t) & t != E -> Sz Dellast(Sz(t)-1,t) = Sz(t)-1
  \end
  \eq* 
    Brt(t) & t != E & i < Sz(t)-1 -> Lookup(Dellast(Sz(t)-1,t),i) = Lookup(t,i)
  \end

fun/2 Dellast 
  Dellast(n,t) = Foo

rem 
  \para \bf  Quick computation of the size for Braun trees.  \end 
  \header* fun Sz_brt 'Tex_f1_bt_sz_brt' \end Find 
  \ft Tex_f1_oh Sq Dp(t) \end-algorithm for computing the size of Braun trees. 
  That is, define the function \ft Sz_brt(t) \end such that 
  \eq* 
    Brt(t) -> Sz_brt(t) = Sz(t)
  \end

fun Sz_brt 'Tex_f1_bt_sz_brt'
  Sz_brt(t) = Foo

loc rem 
  ******************************************************************************
  ********************************* DEBUGGING **********************************
  ******************************************************************************

loc rem 
  \para \bf  Building a Braun tree.  \end The function \ft Ln2brt(x) \end 
  converts a list into a Braun tree. Use the operation to test your solutions. 

loc fun Split 
  Split(0) = 0,0
  Split(u,0) = (u,0),0
  Split(u,v,w) = (u,y),v,z <- Split(w) = y,z

loc fun Ln2brt 
  Ln2brt(0) = E
  Ln2brt(v,w) = Nd(v,Ln2brt(y),Ln2brt(z)) <- Split(w) = y,z

