mod Mlogicpa

incl Mtexg

rem 
  \para \bf  [CL] CL-TeX.  \end 

appldisp/0 Tex0_dotsc
  Op(Ent('hellip'),0)

rem 
  \para \bf  Chapter. Peano Arithmetic.  \end 

rem 
  \para \bf  Section. Builting Functions and Predicates.  \end 

rem 
  \para \bf  Addition.  \end The addition function \ft x+y \end is pre-defined 
  in CL. The following properties are built in into the CL theorem prover: 
  \eq* 
    x+y = y+x
  \end
  \eq* 
    x+(y+z) = x+y+z
  \end
  \eq* 
    z+x = z+y <-> x = y
  \end
  \eq* 
    x+y = 0 <-> x = 0 & y = 0
  \end

rem 
  \para \bf  Multiplication.  \end The multiplication function \ft x*y \end is 
  pre-defined in CL. The following properties are built in into the CL theorem 
  prover: 
  \eq* 
    x*y = y*x
  \end
  \eq* 
    x*(y*z) = x*y*z
  \end
  \eq* 
    x != 0 -> x*y = x*z <-> y = z
  \end
  \eq* 
    x*y = 0 <-> x = 0 \/ y = 0
  \end
  \eq* 
    x*y = 1 <-> x = 1 & y = 1
  \end
  \eq* 
    x*(y+z) = x*y+x*z
  \end
  \eq* 
    1*x = x & 2*x = x+x & 3*x = x+x+x & Tex0_dotsc
  \end

rem 
  \para \bf  Modified subtraction.  \end The modified subtraction function 
  \ft x-y \end is pre-defined in CL. The following properties are built in into 
  the CL theorem prover: 
  \eq* 
    x >= y -> x-y = z <-> x = y+z
  \end
  \eq* 
    x <= y -> x-y = 0
  \end
  \eq* 
    x+y-(x+z) = y-z
  \end
  \eq* 
    x*(y-z) = x*y-x*z
  \end

rem 
  \para \bf  Integer division.  \end The integer division function \ft x/y \end 
  is pre-defined in CL. The following properties are built in into the CL 
  theorem prover: 
  \eq* 
    0/x = 0
  \end
  \eq* 
    x/0 = 0
  \end
  \eq* 
    x/1 = x
  \end
  \eq* 
    x < y -> x/y = 0
  \end
  \eq* 
    x != 0 -> x/x = 1
  \end
  \eq* 
    x*y/(x*z) = x/x*(y/z)
  \end
  \eq* 
    x != 0 -> (x*y+z)/x = y+z/x
  \end

rem 
  \para \bf  Remainder.  \end The remainder function \ft x mod y \end is 
  pre-defined in CL. The following properties are built in into the CL theorem 
  prover: 

rem 
  \para \bf  Comparision predicates.  \end The less-than comparison predicate 
  \ft x <= y \end is pre-defined in CL. The following properties are built in 
  into the CL theorem prover: 
  \eq* 
    x <= x
  \end
  \eq* 
    x <= y & y <= x -> x = y
  \end
  \eq* 
    x <= y & y <= z -> x <= z
  \end
  \eq* 
    0 <= x
  \end
  \eq* 
    x <= 0 <-> x = 0
  \end
  \eq* 
    x+y <= x+z <-> y <= z
  \end
  \eq* 
    x != 0 -> x*y <= x*z <-> y <= z
  \end
  \para Similarly for \ft x < y \end, \ft x >= y \end and \ft x > y \end. 

rem 
  \para \bf  Section. Case Analysis.  \end 

rem 
  \para \bf  Monadic case analysis.  \end Syntax: 
  \eq* 
    'case N ; <term>'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_case Tex_f2_g_x_sc(N,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f0_g_x_nothing,
                            Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(t,0),
                                              Tex_f1_g_x_assum Tex_f2_g_eq(t,x+1)))
         \end
         \para where \ft x \end is a new variable \it  (eigen-variable)  \end. 
  \end
  \para The predicate \ft N \end is defined in the module \it  Standard  \end. 

rem 
  \para \bf  Dichotomy case analysis.  \end Syntax: 
  \eq* 
    'case Dich ; <term>,<term>'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_case Tex_f2_g_x_sc(Dich,s,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f0_g_x_nothing,
                            Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_le(s,t),
                                              Tex_f1_g_x_assum Tex_f2_g_gt(s,t)))
         \end
  \end
  \para The binary predicate \ft Dich \end is defined in the module \it  
  Standard  \end. 

rem 
  \para \bf  Trichotomy case analysis.  \end Syntax: 
  \eq* 
    'case Trich ; <term>,<term>'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_case Tex_f2_g_x_sc(Trich,s,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f0_g_x_nothing,
                            Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_lt(s,t),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(s,
                                                                                             t),
                                                                Tex_f1_g_x_assum Tex_f2_g_gt(s,
                                                                                             t))))
         \end
  \end
  \para The binary predicate \ft Trich \end is defined in the module \it  
  Standard  \end. 

rem 
  \para \bf  Dyadic case analysis.  \end Syntax: 
  \eq* 
    'case N2 ; <term>'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_case Tex_f2_g_x_sc(N2,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f0_g_x_nothing,
                            Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(t,0),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(t,
                                                                                             S1(x)),
                                                                Tex_f1_g_x_assum Tex_f2_g_eq(t,
                                                                                             S2(x)))))
         \end
         \para where \ft x \end is a new variable \it  (eigen-variable)  \end. 
  \end
  \para The predicate \ft N2 \end is defined in the module \it  Standard  \end. 

rem 
  \para \bf  Section. Induction.  \end 

rem 
  \para \bf  Mathematical induction.  \end 
  \header* fun R 'Tex1_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'ind N ; <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(N,x) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(0),
                                              Tex_f1_g_x_goal Tex_f2_g_imp(R(x),
                                                                           R(x+1))))
         \end
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(Tex_f2_g_x_sc(N,x),a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(0),
                                              Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(a,
                                                                                           R(x)),
                                                                           R(x+1))))
         \end
  \end
  \para The predicate \ft N \end is defined in the module \it  Standard  \end. 

rem 
  \para \bf  Complete mathematical induction.  \end 
  \header* fun R 'Tex1_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'indm <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_indm(x) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(y,
                                                                         Tex_f2_g_imp(Tex_f2_g_lt(y,
                                                                                                  x),
                                                                                      R(y))),
                                                         R(x)))
         \end
   \item \para \ft Tex_f1_g_x_indm Tex_f2_g_x_sc(x,a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(y,
                                                                         Tex_f2_g_imp(Tex_f2_g_lt(y,
                                                                                                  x),
                                                                                      Tex_f2_g_forall(a,
                                                                                                      R(y)))),
                                                         R(x)))
         \end
  \end

rem 
  \para \bf  Course of values induction with measure.  \end 
  \header* fun M1 'Tex1_g_appl_mu_sb' \end 
  \header* fun R 'Tex1_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'indm <measure> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_indm M1(x) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(y,
                                                                         Tex_f2_g_imp(Tex_f2_g_lt(M1(y),
                                                                                                  M1(x)),
                                                                                      R(y))),
                                                         R(x)))
         \end
   \item \para \ft Tex_f1_g_x_indm Tex_f2_g_x_sc(M1(x),a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(y,
                                                                         Tex_f2_g_imp(Tex_f2_g_lt(M1(y),
                                                                                                  M1(x)),
                                                                                      Tex_f2_g_forall(a,
                                                                                                      R(y)))),
                                                         R(x)))
         \end
  \end

rem 
  \para \bf  Dyadic induction.  \end \header* fun R 'Tex1_g_appl_phi_sb' \end 
  Syntax: 
  \eq* 
    'ind N2 ; <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(N2,x) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(0),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(R(x),
                                                                                             R S1(x)),
                                                                Tex_f1_g_x_goal Tex_f2_g_imp(R(x),
                                                                                             R S2(x)))))
         \end
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(Tex_f2_g_x_sc(N2,x),a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(0),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(a,
                                                                                                             R(x)),
                                                                                             R S1(x)),
                                                                Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(a,
                                                                                                             R(x)),
                                                                                             R S2(x)))))
         \end
  \end
  \para The predicate \ft N2 \end is defined in the module \it  Standard  \end. 

rem 
  \para \bf  Section. Auxiliary Commands.  \end 

rem 
  \para \bf  Command \it  open  \end.  \end To force opening the definitions of 
  defined functions and predicates try to use the pseudo-command \it  open 
   \end. The system gives you the full list of commands available in the current 
  context which are needed to evaluate defined functions and predicates. 

