mod Ex08 logic: 'cl'

incl Mtex

incl Mtexln

incl Maux

loc rem 
  \para \bf  8. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.20 
  \para* \it  Dátum:  \end streda 9.4.2014 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/1314ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované zoznamom. 
  Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície a vlastnosti 
         pomocných funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Downloadable lecture notes available through the web page of 
         the course. 
   \item \para \it  [2]  \end J. Komara and P. J. Voda. Metamathematics of 
         Computer Programming. 2001. 
  \end

rem 
  \para \bf  Chapter. Programs Operating on Lists.  \end 

rem 
  \para \bf  Section. Operations on Lists.  \end 

theory Theory_map

fun F 'Tex_f1_f'

rem 
  \para \bf  Map.  \end \header* fun Map 'Tex_f1_ln_map_f' \end Given the 
  function \ft F(x) \end, define the function \ft Map(x) \end such that 
  \eq* 
    L Map(x) = L(x)
  \end
  \eq* 
    i < L(x) -> Sub(Map(x),i) = F Sub(x,i)
  \end
  \para Verify your implementation! 

fun Map 'Tex_f1_ln_map_f'
  Map(x) = Foo

thm Map_l
  L Map(x) = L(x)

thm Map_sub
  i < L(x) -> Sub(Map(x),i) = F Sub(x,i)

end theory Theory_map

rem 
  \para \bf  List modification.  \end \header* fun/3 Msub 'Tex_f3_ln_msub' \end 
  Define the function \ft Msub(x,i,a) \end such that 
  \eq* 
    i < L(x) -> L Msub(x,i,a) = L(x)
  \end
  \eq* 
    i < L(x) -> Sub(Msub(x,i,a),i) = a
  \end
  \eq* 
    i < L(x) & j < L(x) & j != i -> Sub(Msub(x,i,a),j) = Sub(x,j)
  \end
  \para Verify your implementation! 

fun/3 Msub 'Tex_f3_ln_msub'
  Msub(x,i,a) = Foo

thm Msub_l
  i < L(x) -> L Msub(x,i,a) = L(x)

thm Msub_sub_eq
  i < L(x) -> Sub(Msub(x,i,a),i) = a

thm Msub_sub_ne
  i < L(x) & j < L(x) & j != i -> Sub(Msub(x,i,a),j) = Sub(x,j)

rem 
  \para \bf  Zip and unzip.  \end \header* fun/2 Zip  \end Define the functions 
  \ft Zip(x,y) \end and \ft Unzip(z) \end such that 
  \eq* 
    L(x) = L(y) -> L Zip(x,y) = L(x)
  \end
  \eq* 
    L(x) = L(y) & i < L(x) -> Sub(Zip(x,y),i) = Sub(x,i),Sub(y,i)
  \end
  \para and 
  \eq* 
    L(x) = L(y) -> Unzip Zip(x,y) = x,y
  \end
  \para Verify your implementations! 

fun/2 Zip 
  Zip(x,y) = Foo

fun Unzip 
  Unzip(z) = Foo

thm Zip_l
  L(x) = L(y) -> L Zip(x,y) = L(x)

thm Zip_sub
  L(x) = L(y) & i < L(x) -> Sub(Zip(x,y),i) = Sub(x,i),Sub(y,i)

thm Unzip_zip
  L(x) = L(y) -> Unzip Zip(x,y) = x,y

rem 
  \para \bf  Take and drop.  \end \header* fun/2 Take  \end 
  \header* fun/2 Drop  \end Define the functions \ft Take(n,x) \end and 
  \ft Drop(n,x) \end such that 
  \eq* 
    n <= L(x) -> L Take(n,x) = n
  \end
  \eq* 
    n <= L(x) -> \e y x = Take(n,x)++y
  \end
  \para and 
  \eq* 
    n <= L(x) -> L Drop(n,x) = L(x)-n
  \end
  \eq* 
    n <= L(x) -> \e y x = y++Drop(n,x)
  \end
  \para Verify your implementations! 

fun/2 Take 
  Take(n,x) = Foo

fun/2 Drop 
  Drop(n,x) = Foo

thm Take_l
  n <= L(x) -> L Take(n,x) = n

thm Take_prefix
  n <= L(x) -> \e y x = Take(n,x)++y

thm Drop_l
  n <= L(x) -> L Drop(n,x) = L(x)-n

thm Drop_suffix
  n <= L(x) -> \e y x = y++Drop(n,x)

rem 
  \para \bf  Interval.  \end 
  \header* fun/2 Interval 'Tex_f2_ln_interval_co' \end Define the function 
  \ft Interval(m,n) \end such that 
  \eq* 
    L Interval(m,n) = n-m
  \end
  \eq* 
    i < n-m -> Sub(Interval(m,n),i) = m+i
  \end
  \para Verify your implementation! 

fun/2 Interval 'Tex_f2_ln_interval_co'
  Interval(m,n) = Foo

thm Interval_l
  L Interval(m,n) = n-m

thm Interval_sub
  i < n-m -> Sub(Interval(m,n),i) = m+i

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    k <= m & m <= n -> Interval(k,m)++Interval(m,n) = Interval(k,n)
  \end

thm Interval_conc
  k <= m & m <= n -> Interval(k,m)++Interval(m,n) = Interval(k,n)
proof  proved.

rem 
  \para \bf  List minimum.  \end Define the function \ft Minl(x) \end such that 
  \eq* 
    x != 0 -> Minl(x) in x
  \end
  \eq* 
    x != 0 & a in x -> Minl(x) <= a
  \end
  \para Verify your implementations! 

fun Minl 
  Minl(x) = Foo

thm Minl_in
  x != 0 -> Minl(x) in x

thm Minl_min
  x != 0 & a in x -> Minl(x) <= a
proof  proved.

rem 
  \para \bf  List maximum.  \end Define the function \ft Maxl(x) \end such that 
  \eq* 
    x != 0 -> Maxl(x) in x
  \end
  \eq* 
    x != 0 & a in x -> a <= Maxl(x)
  \end
  \para Verify your implementations! 

fun Maxl 
  Maxl(x) = Foo

thm Maxl_in
  x != 0 -> Maxl(x) in x

thm Maxl_max
  x != 0 & a in x -> a <= Maxl(x)

rem 
  \para \bf  Deleting elements from lists.  \end \header* fun/2 Delall  \end 
  Define the function \ft Delall(a,x) \end such that 
  \eq* 
    b in Delall(a,x) <-> b in x & b != a
  \end
  \para Verify your implementation! 

fun/2 Delall 
  Delall(a,x) = Foo

thm Delall_in
  b in Delall(a,x) <-> b in x & b != a

theory Theory_filter

pred A 

rem 
  \para \bf  Filter.  \end \header* fun Filter 'Tex_f1_ln_filter_a' \end Given 
  the predicate \ft A \end, define the function \ft Filter(x) \end such that 
  \eq* 
    a in Filter(x) <-> a in x & A(a)
  \end
  \para Verify your implementation! 

fun Filter 'Tex_f1_ln_filter_a'
  Filter(x) = Foo

thm Filter_in
  a in Filter(x) <-> a in x & A(a)

end theory Theory_filter

rem 
  \para \bf  Multiplicity.  \end \header* fun/2 Count 'Tex_f2_ln_count' \end 
  Define the function \ft Count(a,x) \end such that 
  \eq* 
    Count(a,b,0) = Eqf(a,b)
  \end
  \eq* 
    Count(a,x++y) = Count(a,x)+Count(a,y)
  \end
  \para Verify your implementation! 
  \para \it  Remark.  \end The \ft Eqf(x,y) \end is the characteristic function 
  of the binary equality predicate \ft x = y \end and it is defined in the 
  module \it  Maux*  \end. 

fun/2 Count 'Tex_f2_ln_count'
  Count(a,x) = Foo

thm Count_singleton
  Count(a,b,0) = Eqf(a,b)

thm Count_conc
  Count(a,x++y) = Count(a,x)+Count(a,y)
proof  proved.

rem 
  \para \bf  List union.  \end \header* fun Union 'Tex_f1_ln_union' \end Define 
  the function \ft Union(x) \end such that 
  \eq* 
    Union(x,0) = x
  \end
  \eq* 
    Union(x++y) = Union(x)++Union(y)
  \end
  \para Verify your implementation! 

fun Union 'Tex_f1_ln_union'
  Union(x) = Foo

thm Union_singleton
  Union(x,0) = x

thm Union_conc
  Union(x++y) = Union(x)++Union(y)
proof  proved.

