mod Maux logic: 'cl'

incl Mtex

rem 
  \para \bf  Numeric programs.  \end 

rem 
  \para \it  Maximum.  \end 

fun/2 Max 'Tex_f2_n_max'
  Max(x,y) = x <- x >= y
  Max(x,y) = y <- x < y

thm Spec_max_ge
  Max(x,y) >= x & Max(x,y) >= y
proof 
 case Dich; y,x @ x1,y1; x1,y1
  proved
  proved..

thm Spec_max_eq
  Max(x,y) = x \/ Max(x,y) = y
proof 
 case Dich; y,x @ x1,y1; x1,y1
  proved
  proved..

thm Max_comm
  Max(x,y) = Max(y,x)
proof 
 case Trich; x,y @ x1,y1; x1,y1; x1,y1
  proved
  proved
  proved..

thm Max_le
  Max(x,y) <= z <-> x <= z & y <= z
proof 
 case Dich; y,x @ x1,y1; x1,y1
  split* x > z <-> ~(x <= z & y <= z).2,0,1,(4,0,0,0),0
   proved
   proved
   proved.
  split* y > z <-> ~(x <= z & y <= z).2,0,1,(4,0,0,0),0
   proved
   proved
   proved...

rem 
  \para \it  Exponentiation of two.  \end 

fun Exp2 'Tex_f1_n_exp2'
  Exp2(0) = 1
  Exp2(x+1) = 2*Exp2(x)

thm Exp2_is_not_zero
  Exp2(x) != 0
proof 
 ind N; x @ 0; x
  proved
  proved..

thm Exp2_is_one
  Exp2(x) = 1 <-> x = 0
proof 
 case N; x @ 0; x1
  proved
  proved..

thm Exp2_gt_one
  Exp2(x) > 1 <-> x != 0
proof 
 case Trich; Exp2(x),1 @ x1,y; x1,y; x1,y
  use Exp2_is_not_zero; x proved.
  use Exp2_is_one.0; x proved.
  use Exp2_is_one.0; x proved...

thm Exp2_plus
  Exp2(x+y) = Exp2(x)*Exp2(y)
proof 
 ind N; x @ 0; x
  proved
  proved..

thm Exp2_minus
  x >= y -> Exp2(x-y) = Exp2(x)/Exp2(y)
proof 
 ind N; x; y @ 0; x
  proved
  case N; y @ 0; y1
   proved
   inst \a y(x >= y -> Exp2(x-y) = Exp2(x)/Exp2(y)); y1 proved....

thm Exp2_cancel_eq
  Exp2(x) = Exp2(y) <-> x = y
proof 
 ind N; x; y @ 0; x
  use Exp2_is_one.0; y proved.
  case N; y @ 0; y1
   proved
   inst \a y(Exp2(x) = Exp2(y) <-> x = y).0; y1 proved....

thm Exp2_cancel_le
  Exp2(x) <= Exp2(y) <-> x <= y
proof 
 ind N; x; y @ 0; x
  use Exp2_is_not_zero; y proved.
  case N; y @ 0; y1
   use Exp2_is_not_zero; x proved.
   inst \a y(Exp2(x) <= Exp2(y) <-> x <= y).0; y1 proved....

thm Exp2_cancel_lt
  Exp2(x) < Exp2(y) <-> x < y
proof 
 ind N; x; y @ 0; x
  use Exp2_gt_one.0; y proved.
  case N; y @ 0; y1
   use Exp2_is_not_zero; x proved.
   inst \a y(Exp2(x) < Exp2(y) <-> x < y).0; y1 proved....

thm Exp2_max
  Exp2 Max(x,y) = Max(Exp2(x),Exp2(y))
proof 
 case Dich; y,x @ x1,y1; x1,y1
  use Exp2_cancel_le.2,1,0; y; x proved.
  use Exp2_cancel_lt.2,1,0; x; y proved...

rem 
  \para \bf  Lists.  \end 

rem 
  \para \it  List length.  \end 

fun L 
  L(0) = 0
  L(v,w) = L(w)+1

thm L_zero
  L(x) = 0 <-> x = 0
proof 
 case Ln; x @ 0; v,w
  proved
  proved..

thm L_conc
  L(x++y) = L(x)+L(y)
proof 
 ind Ln; x @ 0; v,w
  proved
  proved..

rem 
  \para \it  List reversal.  \end 

fun Rev 
  Rev(0) = 0
  Rev(v,w) = Rev(w)++(v,0)

thm Rev_conc
  Rev(x++y) = Rev(y)++Rev(x)
proof 
 ind Ln; x @ 0; v,w
  proved
  proved..

rem 
  \para \it  Interval.  \end 

appldisp/2 Tex_f2_ln_interval_co
  Fenced(Op('[',0),Infix(Arg(0),25,3,Id(0,'  .. ',0),Arg(1)),Op(')',0))

fun/2 Interval 'Tex_f2_ln_interval_co'
  Interval(m,n) = 0 <- m >= n
  Interval(m,n) = m,Interval(m+1,n) <- m < n

thm Interval_conc
  k <= m & m <= n -> Interval(k,m)++Interval(m,n) = Interval(k,n)
proof 
 indm m-k @ m1,k1
  case Dich; m,k @ x,y; x,y
   proved
   inst \a m1\a k1(k+(m1-k1) < m -> k1 <= m1 & m1 <= n -> 
                   Interval(k1,m1)++Interval(m1,n) = Interval(k1,n)); m; k+1 proved....

