mod Ex06b logic: 'cl'

incl Mtex

incl Mtexg

incl Mauxb

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 12.81.20 
  \para* \it  Dátum:  \end utorok 19.3.2013 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/1213ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované 
  celočíselnej odmocnine a slovným úlohám. Zadanie sa skladá z týchto 
  súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície a vlastnosti 
         pomocných funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Downloadable lecture notes available through the web page of 
         the course. 
   \item \para \it  [2]  \end J. Komara and P. J. Voda. Metamathematics of 
         Computer Programming. 2001. 
  \end

rem 
  \para \bf  [CL] CL-TeX.  \end 

appldisp/2 Tex_f2_n2_conc_nassoc
  Infix(Arg(0),35,0,Op(Ent('sstarf'),0),Arg(1))

rem 
  \para \bf  Chapter. Programs Operating on Word Domains .  \end 

rem 
  \para \bf  Section. Dyadic Words.  \end 

rem 
  \para \bf  Subsection. Dyadic Arithmetic.  \end 

rem 
  \para \bf  [CL] Dyadic successors.  \end 
  \eq* 
    S1(x) = 2*x+1
  \end
  \eq* 
    S2(x) = 2*x+2
  \end
  \para The functions are defined in the module \it  Standard  \end. 

rem 
  \para \bf  [CL] Dyadic case analysis.  \end Syntax: 
  \eq* 
    'case N2 ; <term>'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_case Tex_f2_g_x_sc(N2,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f0_g_x_nothing,
                            Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(t,0),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(t,
                                                                                             S1(x)),
                                                                Tex_f1_g_x_assum Tex_f2_g_eq(t,
                                                                                             S2(x)))))
         \end
         \para where \ft x \end is a new variable \it  (eigen-variable)  \end. 
  \end
  \para The predicate \ft N2 \end is defined in the module \it  Standard  \end. 

rem 
  \para \bf  Dyadic induction.  \end Show that the principle of dyadic induction 
  is admissible in Peano arithmetic. 
  \para \it  Remark.  \end Prove the claim for the special case in the following 
  theory. 
  \para \it  Hint.  \end Reduce dyadic induction to complete induction. 

theory Dyadic_induction

pred A 'Tex2_g_appl_phi_sb'

axiom Base_case
  A(0)

axiom Induction_step1
  A(x) -> A S1(x)

axiom Induction_step2
  A(x) -> A S2(x)

thm Conclusion
  A(x)

end theory Dyadic_induction

rem 
  \para \bf  [CL] Dyadic induction.  \end 
  \header* fun R 'Tex2_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'ind N2 ; <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(N2,x) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(0),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(R(x),
                                                                                             R S1(x)),
                                                                Tex_f1_g_x_goal Tex_f2_g_imp(R(x),
                                                                                             R S2(x)))))
         \end
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(Tex_f2_g_x_sc(N2,x),a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(0),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(a,
                                                                                                             R(x)),
                                                                                             R S1(x)),
                                                                Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(a,
                                                                                                             R(x)),
                                                                                             R S2(x)))))
         \end
  \end

rem 
  \para \bf  Subsection. Basic Operations on Dyadic Words.  \end 

rem 
  \para \bf  Dyadic length.  \end 

fun L 
  L(0) = 0
  L S1(x) = L(x)+1
  L S2(x) = L(x)+1

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    L(x) = 0 <-> x = 0
  \end
  \eq* 
    L(x) = n <-> Exp2(n) <= x+1 & x+1 < Exp2(n+1)
  \end

thm L_is_zero
  L(x) = 0 <-> x = 0

thm L_def_contextual
  L(x) = n <-> Exp2(n) <= x+1 & x+1 < Exp2(n+1)

rem 
  \para \bf  Dyadic concatenation.  \end 

fun/2 Conc 'Tex_f2_n2_conc_nassoc'
  Conc(x,0) = x
  Conc(x,S1(y)) = S1 Conc(x,y)
  Conc(x,S2(y)) = S2 Conc(x,y)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Conc(x,y) = x*Exp2 L(y)+y
  \end
  \eq* 
    Conc(x,y) = 0 <-> x = 0 & y = 0
  \end
  \eq* 
    Conc(0,y) = y
  \end
  \eq* 
    Conc(Conc(x,y),z) = Conc(x,Conc(y,z))
  \end
  \eq* 
    L Conc(x,y) = L(x)+L(y)
  \end

thm Conc_cdef
  Conc(x,y) = x*Exp2 L(y)+y

thm Conc_is_zero
  Conc(x,y) = 0 <-> x = 0 & y = 0

thm Conc_left_zero
  Conc(0,y) = y

thm Conc_assoc
  Conc(Conc(x,y),z) = Conc(x,Conc(y,z))

thm L_conc
  L Conc(x,y) = L(x)+L(y)

rem 
  \para \bf  Dyadic reversal.  \end 

fun Rev 'Tex_f1_n2_rev'
  Rev(0) = 0
  Rev S1(x) = Conc(S1(0),Rev(x))
  Rev S2(x) = Conc(S2(0),Rev(x))

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Rev(x) = 0 <-> x = 0
  \end
  \eq* 
    Rev Conc(x,y) = Conc(Rev(y),Rev(x))
  \end
  \eq* 
    Rev Rev(x) = x
  \end
  \eq* 
    \e y Rev(y) = x
  \end
  \eq* 
    Rev(x) = Rev(y) -> x = y
  \end
  \eq* 
    L Rev(x) = L(x)
  \end

thm Rev_is_zero
  Rev(x) = 0 <-> x = 0

thm Rev_conc
  Rev Conc(x,y) = Conc(Rev(y),Rev(x))

thm Rev_rev
  Rev Rev(x) = x

thm Rev_surjective
  \e y Rev(y) = x

thm Rev_injective
  Rev(x) = Rev(y) -> x = y

thm L_rev
  L Rev(x) = L(x)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Conc(y,x) = Conc(z,x) -> y = z
  \end
  \eq* 
    Conc(x,y) = Conc(x,z) -> y = z
  \end

thm Conc_cancel_right
  Conc(y,x) = Conc(z,x) -> y = z

thm Conc_cancel_left
  Conc(x,y) = Conc(x,z) -> y = z

