mod Ex05b logic: 'cl'

incl Mtex

loc rem 
  \para \bf  5. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 12.81.20 
  \para* \it  Dátum:  \end utorok 5.3.2013 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/1213ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je rekurzii s mierou a 
  chvostovej rekurzii. Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície a vlastnosti 
         pomocných funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Downloadable lecture notes available through the web page of 
         the course. 
   \item \para \it  [2]  \end J. Komara and P. J. Voda. Metamathematics of 
         Computer Programming. 2001. 
  \end

rem 
  \para \bf  Chapter. Numeric Programs.  \end 

rem 
  \para \bf  Section. Tail Recursion and Iteration.  \end 

rem 
  \para \bf  Subsection. Tail Recursion and While-loops.  \end 

rem 
  \para \bf  Exercise.  \end Find an efficient, tail recursive implementation of 
  the function: 

fun F1 'Tex_f1_f_sub'
  F1(0) = 0
  F1(1) = 1
  F1(n+2) = F1(n+1)+F1(n)

rem 
  \para Your solution should simulate the following while-loop by primitive 
  recursion: 
  \verbatim 
  if n = 0 then return(0)
  else begin
   n,a,b := n-1,1,0;
   while n <> 0 do n,a,b := n-1,a+b,a;
   return(a)
  end
  \end
  \para Verify your implementation. 

rem 
  \para \it  While-loop by primitive recursion.  \end 

fun/3 While1 'Tex_f3_g'
  While1(n,a,b) = Foo

rem 
  \para Prove 
  \eq* 
    F1(n+1) = While1(n,1,0)
  \end

thm F1_by_while1
  F1(n+1) = While1(n,1,0)

rem 
  \para \bf  Exercise.  \end Find a similar tail recursive implementation of the 
  next function: 

fun F2 'Tex_f1_f_sub'
  F2(0) = 0
  F2(1) = 1
  F2(2) = 2
  F2(n+3) = F2(n+2)+F2(n+1)+F2(n)

rem 
  \para \it  While-loop by primitive recursion.  \end 

rem 
  \para \bf  Subsection. Tail Recursion and For-loops.  \end 

rem 
  \para \bf  Exercise.  \end Find an efficient, tail recursive implementation of 
  the function: 

fun F3 'Tex_f1_f_sub'
  F3(0) = 0
  F3(1) = 1
  F3(n+2) = F3(n+1)+F3(n)+n

rem 
  \para Your solution should simulate the following for-loop by backward 
  recursion: 
  \verbatim 
  if n = 0 then return(0)
  else if n = 1 then return(1)
  else begin
   n,a,b := n-2,1,0;
   for i = 0 to n do a,b := a+b+i,a;
   return(a)
  end
  \end
  \para Verify your implementation. 

rem 
  \para \it  For-loop by backward recursion.  \end 

fun/4 For3 'Tex_f4_g'
  For3(i,n,a,b) = Foo

rem 
  \para Prove 
  \eq* 
    F3(n+2) = For3(0,n,1,0)
  \end

thm F3_by_for3
  F3(n+2) = For3(0,n,1,0)

rem 
  \para \bf  Exercise.  \end Find a similar tail recursive implementation of the 
  next function: 

fun F4 'Tex_f1_f_sub'
  F4(0) = 0
  F4(1) = 1
  F4(2) = 2
  F4(n+3) = F4(n+2)+F4(n+1)+F4(n)+n

rem 
  \para \it  For-loop by backward recursion.  \end 

