mod Ex05a logic: 'cl'

incl Mtex

incl Mtexg

incl Mauxa

loc rem 
  \para \bf  5. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 12.81.20 
  \para* \it  Dátum:  \end utorok 5.3.2013 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/1213ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je rekurzii s mierou a 
  chvostovej rekurzii. Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície a vlastnosti 
         pomocných funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Downloadable lecture notes available through the web page of 
         the course. 
   \item \para \it  [2]  \end J. Komara and P. J. Voda. Metamathematics of 
         Computer Programming. 2001. 
  \end

rem 
  \para \bf  Chapter. Numeric Programs.  \end 

rem 
  \para \bf  Section. Recursion with Measure.  \end 

rem 
  \para \bf  Measure induction.  \end Show that the principle of measure 
  induction (course of values induction with measure) is admissible in Peano 
  arithmetic. 
  \para \it  Remark.  \end Prove the claim for the special case in the following 
  theory. 

theory Measure_induction

fun M1 'Tex2_g_appl_mu_sb'

pred A 'Tex2_g_appl_phi_sb'

axiom Progressivity
  \a x(\a y(M1(y) < M1(x) -> A(y)) -> A(x))

thm Conclusion
  A(x)

end theory Measure_induction

rem 
  \para \bf  [CL] Measure induction.  \end 
  \header* fun M1 'Tex2_g_appl_mu_sb' \end 
  \header* fun R 'Tex2_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'indm <measure> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_indm M1(x) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(y,
                                                                         Tex_f2_g_imp(Tex_f2_g_lt(M1(y),
                                                                                                  M1(x)),
                                                                                      R(y))),
                                                         R(x)))
         \end
   \item \para \ft Tex_f1_g_x_indm Tex_f2_g_x_sc(M1(x),a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(y,
                                                                         Tex_f2_g_imp(Tex_f2_g_lt(M1(y),
                                                                                                  M1(x)),
                                                                                      Tex_f2_g_forall(a,
                                                                                                      R(y)))),
                                                         R(x)))
         \end
  \end

rem 
  \para \bf  Greatest common divisor.  \end Euclid algorithm based on the 
  property 
  \eq* 
    x <= y & Divides(z,x) -> Divides(z,y) <-> Divides(z,y-x)
  \end
  \para \it  [CL] Remark.  \end This property in the form of the following 
  theorem 
  \eq Euclid_divides_minus
    x <= y & Divides(z,x) -> Divides(z,y-x) <-> Divides(z,y)
  \end
  \para is proved in the module \it  Maux*  \end. 

fun/2 Gcd 'Tex_f2_n_gcd'
  Gcd(x,y) = Max(x,y) <- x = 0
  Gcd(x,y) = Max(x,y) <- x != 0 & y = 0
  Gcd(x,y) = Gcd(x,y-x) <- x != 0 & y != 0 & x < y
  Gcd(x,y) = x <- x != 0 & y != 0 & x = y
  Gcd(x,y) = Gcd(x-y,y) <- x != 0 & y != 0 & x > y

rem 
  \para \bf  Exercise.  \end Prove the conditions of regularity for the function 
  \ft Gcd(x,y) \end: 
  \eq* 
    x != 0 & y != 0 & x < y -> Max(x,y-x) < Max(x,y)
  \end
  \eq* 
    x != 0 & y != 0 & x > y -> Max(x-y,y) < Max(x,y)
  \end

thm Condition_of_regularity_lt
  x != 0 & y != 0 & x < y -> Max(x,y-x) < Max(x,y)

thm Condition_of_regularity_gt
  x != 0 & y != 0 & x > y -> Max(x-y,y) < Max(x,y)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    x != 0 \/ y != 0 -> Divides(Gcd(x,y),x) & Divides(Gcd(x,y),y)
  \end
  \eq* 
    (x != 0 \/ y != 0) & Divides(z,x) & Divides(z,y) -> z <= Gcd(x,y)
  \end
  \para \it  [CL] Hint.  \end Prove the properties by induction with a measure . 
  In the induction step, consider two cases according to whether the disjunction 
  \ft x = 0 \/ y = 0 \end holds or not. Both cases when \ft x = 0 \/ y = 0 \end 
  are formulated as stand-alone lemmas. 

lemma Lemma_spec_gcd_divides
  (x = 0 \/ y = 0) & (x != 0 \/ y != 0) -> 
  Divides(Gcd(x,y),x) & Divides(Gcd(x,y),y)
proof 
 cut x = 0
  weak x = 0; y != 0
   use Divides_right_zero; y
    use Divides_reflexivity; y proved...
  weak x != 0; y = 0
   use Divides_reflexivity; x
    use Divides_right_zero; x proved.....

thm Spec_gcd_divides
  x != 0 \/ y != 0 -> Divides(Gcd(x,y),x) & Divides(Gcd(x,y),y)

lemma Lemma_spec_gcd_greatest
  (x = 0 \/ y = 0) & (x != 0 \/ y != 0) & Divides(z,x) & Divides(z,y) -> 
  z <= Gcd(x,y)
proof 
 cut x = 0
  use Divides_bounded; y; z proved.
  use Divides_bounded; x; z proved...

thm Spec_gcd_greatest
  (x != 0 \/ y != 0) & Divides(z,x) & Divides(z,y) -> z <= Gcd(x,y)

