mod Ex04a logic: 'cl'

incl Mtex

incl Mtexg

loc rem 
  \para \bf  4. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.20 
  \para* \it  Dátum:  \end utorok 5.3.2013 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/1213ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je primitívnej rekurzii a 
  'course-of-values' rekurzii. Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície a vlastnosti 
         pomocných funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Downloadable lecture notes available through the web page of 
         the course. 
   \item \para \it  [2]  \end J. Komara and P. J. Voda. Metamathematics of 
         Computer Programming. 2001. 
  \end

rem 
  \para \bf  Chapter. Numeric Programs.  \end 

rem 
  \para \bf  Section. Primitive Recursion.  \end 

rem 
  \para \bf  [CL] Mathematical induction.  \end 
  \header* fun R 'Tex2_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'ind N ; <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(N,x) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(0),
                                              Tex_f1_g_x_goal Tex_f2_g_imp(R(x),
                                                                           R(x+1))))
         \end
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(Tex_f2_g_x_sc(N,x),a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(0),
                                              Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(a,
                                                                                           R(x)),
                                                                           R(x+1))))
         \end
  \end
  \para Note that the predicate \ft N \end is defined in the module \it  
  Standard  \end as: 
  \def 
    pred N 
    N(0)
    N(x+1) <- N(x)
  \end

rem 
  \para \bf  Exponentiation.  \end 

fun/2 Exp 'Tex_f2_n_exp'
  Exp(x,0) = 1
  Exp(x,y+1) = x*Exp(x,y)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Exp(x,y) = 0 <-> x = 0 & y != 0
  \end
  \eq* 
    Exp(x,y) = 1 <-> x = 1 \/ y = 0
  \end

thm Exp_is_zero
  Exp(x,y) = 0 <-> x = 0 & y != 0

thm Exp_is_one
  Exp(x,y) = 1 <-> x = 1 \/ y = 0

rem 
  \para \bf  [CL] Remark.  \end Note that we then have 
  \eq* 
    Exp(x,y) > 1 <-> x > 1 & y != 0
  \end

thm Exp_gt_one
  Exp(x,y) > 1 <-> x > 1 & y != 0
proof 
 case Trich; Exp(x,y),1 @ x1,y1; x1,y1; x1,y1
  use Exp_is_zero.2,0,1,0,4,0,0; x; y proved.
  use Exp_is_one.2,0,0; x; y
   split x = 1 \/ y = 0.4,0,0,0
    proved
    proved..
  use Exp_is_zero.0; x; y
   use Exp_is_one.0; x; y proved....

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Exp(x,y+z) = Exp(x,y)*Exp(x,z)
  \end
  \eq* 
    x != 0 & y >= z -> Exp(x,y-z) = Exp(x,y)/Exp(x,z)
  \end

thm Exp_plus
  Exp(x,y+z) = Exp(x,y)*Exp(x,z)

thm Exp_minus
  x != 0 & y >= z -> Exp(x,y-z) = Exp(x,y)/Exp(x,z)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    x > 1 -> Exp(x,y) = Exp(x,z) <-> y = z
  \end
  \eq* 
    x > 1 -> Exp(x,y) <= Exp(x,z) <-> y <= z
  \end
  \eq* 
    x > 1 -> Exp(x,y) < Exp(x,z) <-> y < z
  \end

thm Exp_cancel_eq
  x > 1 -> Exp(x,y) = Exp(x,z) <-> y = z

thm Exp_cancel_le
  x > 1 -> Exp(x,y) <= Exp(x,z) <-> y <= z

thm Exp_cancel_lt
  x > 1 -> Exp(x,y) < Exp(x,z) <-> y < z

