mod Ex03b logic: 'cl'

incl Mtex

incl Mtexg

loc rem 
  \para \bf  3. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.20 
  \para* \it  Dátum:  \end utorok 26.2.2013 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/1213ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované logickému 
  vyplývaniu a explicitným definíciam. Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Downloadable lecture notes available through the web page of 
         the course. 
   \item \para \it  [2]  \end J. Komara and P. J. Voda. Metamathematics of 
         Computer Programming. 2001. 
  \end

rem 
  \para \bf  [CL] Remark.  \end The module \it  Mlogicpa  \end in the file \it  
  mlogicpa.cl  \end contains built-in properties of the pre-defined functions 
  and predicates in the system CL. Also it contains the syntax of arithmetic 
  tableau rules. 

rem 
  \para \bf  [CL] Remark.  \end In the following examples we recommend to use 
  the pseudo-command \it  open  \end to force the opening of the definitions of 
  defined functions and predicates. 

rem 
  \para \bf  Chapter. Numeric Programs.  \end 

rem 
  \para \bf  Section. Explicit Definitions.  \end 

rem 
  \para \bf  Example of a definition with negation discrimination.  \end 

fun/2 F_neg 'Tex_f2_f'
  F_neg(x,y) = 0 <- x = y
  F_neg(x,y) = 1 <- x != y

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    F_neg(x,y) = 0 \/ F_neg(x,y) = 1
  \end
  \para \it  Hint.  \end Use cut rule with the cut formula \ft x = y \end. 

thm Prop_f_neg
  F_neg(x,y) = 0 \/ F_neg(x,y) = 1

rem 
  \para \bf  [CL] Monadic case analysis.  \end Syntax: 
  \eq* 
    'case N ; <term>'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_case Tex_f2_g_x_sc(N,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f0_g_x_nothing,
                            Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(t,0),
                                              Tex_f1_g_x_assum Tex_f2_g_eq(t,x+1)))
         \end
         \para where \ft x \end is a new variable \it  (eigen-variable)  \end. 
  \end

rem 
  \para \bf  [CL] Remark.  \end Note that the predicate \ft N \end is defined in 
  the module \it  Standard  \end as: 
  \def 
    pred N 
    N(0)
    N(x+1) <- N(x)
  \end
  \para The proof system uses such predicates (you can define your own ones) for 
  the construction of case rules. Try typing just \it  case  \end and the system 
  gives you the full list of case commands available in the current context. 

rem 
  \para \bf  Example of a definition with discrimination on monadic patterns. 
   \end 

fun F_mona 'Tex_f1_f'
  F_mona(0) = 0
  F_mona(x+1) = 1

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    F_mona(x) = 0 \/ F_mona(x) = 1
  \end
  \para \it  Hint.  \end Use monadic case analysis on \ft x \end. 

thm Prop_f_mona
  F_mona(x) = 0 \/ F_mona(x) = 1

rem 
  \para \bf  [CL] Dichotomy case analysis.  \end Syntax: 
  \eq* 
    'case Dich ; <term>,<term>'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_case Tex_f2_g_x_sc(Dich,s,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f0_g_x_nothing,
                            Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_le(s,t),
                                              Tex_f1_g_x_assum Tex_f2_g_gt(s,t)))
         \end
  \end
  \para Note that the predicate \ft Dich \end is defined in the module \it  
  Standard  \end. 

rem 
  \para \bf  Example of a definition with dichotomy discrimination.  \end 

fun/2 F_dich 'Tex_f2_f'
  F_dich(x,y) = 0 <- x <= y
  F_dich(x,y) = 1 <- x > y

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    F_dich(x,y) = 0 \/ F_dich(x,y) = 1
  \end
  \para \it  Hint.  \end Use dichotomy case analysis. 

thm Prop_f_dich
  F_dich(x,y) = 0 \/ F_dich(x,y) = 1

rem 
  \para \bf  [CL] Trichotomy case analysis.  \end Syntax: 
  \eq* 
    'case Trich ; <term>,<term>'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_case Tex_f2_g_x_sc(Trich,s,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f0_g_x_nothing,
                            Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_lt(s,t),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(s,
                                                                                             t),
                                                                Tex_f1_g_x_assum Tex_f2_g_gt(s,
                                                                                             t))))
         \end
  \end
  \para Note that the predicate \ft Trich \end is defined in the module \it  
  Standard  \end. 

rem 
  \para \bf  Example of a definition with trichotomy discrimination.  \end 

fun/2 F_trich 'Tex_f2_f'
  F_trich(x,y) = 0 <- x < y
  F_trich(x,y) = 1 <- x = y
  F_trich(x,y) = 2 <- x > y

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    F_trich(x,y) = 0 \/ F_trich(x,y) = 1 \/ F_trich(x,y) = 2
  \end
  \para \it  Hint.  \end Use trichotomy case analysis. 

thm Prop_f_trich
  F_trich(x,y) = 0 \/ F_trich(x,y) = 1 \/ F_trich(x,y) = 2

rem 
  \para \bf  Minimum.  \end 

fun/2 Min 'Tex_f2_n_min'
  Min(x,y) = x <- x <= y
  Min(x,y) = y <- x > y

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Min(x,y) <= x & Min(x,y) <= y
  \end
  \eq* 
    Min(x,y) = x \/ Min(x,y) = y
  \end

thm Spec_min_le
  Min(x,y) <= x & Min(x,y) <= y

thm Spec_min_eq
  Min(x,y) = x \/ Min(x,y) = y

rem 
  \para \bf  Exercise.  \end \header* fun/2 Max 'Tex_f2_n_max' \end Find an 
  explicit definition of the maximum function \ft Max(x,y) \end satisfying 
  \eq* 
    Max(x,y) >= x & Max(x,y) >= y
  \end
  \eq* 
    Max(x,y) = x \/ Max(x,y) = y
  \end
  \para Prove that the function has the required properties. 

fun/2 Max 'Tex_f2_n_max'
  Max(x,y) = Foo

thm Spec_max_ge
  Max(x,y) >= x & Max(x,y) >= y

thm Spec_max_eq
  Max(x,y) = x \/ Max(x,y) = y

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Min(x,y) <= Max(x,y)
  \end
  \eq* 
    Min(x,y) = Max(x,y) <-> x = y
  \end

thm Min_max_le
  Min(x,y) <= Max(x,y)

thm Min_max_eq
  Min(x,y) = Max(x,y) <-> x = y

rem 
  \para \bf  Exercise.  \end \header* fun/3 Median  \end Find an explicit 
  definition of the function \ft Median(x,y,z) \end satisfying 
  \eq* 
    x <= y & y <= z -> Median(x,y,z) = y
  \end
  \eq* 
    Median(x,y,z) = Median(y,x,z)
  \end
  \eq* 
    Median(x,y,z) = Median(x,z,y)
  \end
  \para Prove that the function has the required properties. 

fun/3 Median 
  Median(x,y,z) = Foo

thm Spec_median_le
  x <= y & y <= z -> Median(x,y,z) = y

thm Spec_median_perm213
  Median(x,y,z) = Median(y,x,z)
proof  proved.

thm Spec_median_perm132
  Median(x,y,z) = Median(x,z,y)
proof  proved.

