mod Mauxb logic: 'cl'

incl Mtex

incl Mtexln

rem 
  \para \bf  List length.  \end 

fun L 
  L(0) = 0
  L(v,w) = L(w)+1

thm L_is_zero
  L(x) = 0 <-> x = 0
proof 
 case Ln; x @ 0; v,w
  proved
  proved..

thm L_conc
  L(x++y) = L(x)+L(y)
proof 
 ind Ln; x @ 0; v,w
  proved
  proved..

rem 
  \para \bf  List indexing.  \end 

fun/2 Sub 'Tex_f2_ln_sub'
  Sub(x,0) = v <- x = v,w
  Sub(x,i+1) = Sub(w,i) <- x = v,w

loc rem 
  \para \bf  List membership.  \end 

lemma In_expl_sub
  x in y <-> \e i(i < L(y) & Sub(y,i) = x)
proof 
 ind Ln; y @ 0; v,w
  proved
  weak x in w <-> \e i(i < L(w) & Sub(w,i) = x)
   split* x = v \/ \e i(i < L(w) & Sub(w,i) = x) <-> 
          \e i(i <= L(w) & Sub((v,w),i) = x).2,(1,(4,0,0,0),0),0
    weak x = v
     inst* \e i(i <= L(w) & Sub((v,w),i) = v); 0 proved..
    eigen \e i(i < L(w) & Sub(w,i) = x).0; i
     inst* \e i1(i1 <= L(w) & Sub((v,w),i1) = x); i+1 proved..
    eigen \e i(i <= L(w) & Sub((v,w),i) = x).0; i
     case N; i @ 0; j
      proved
      weak* x = v
       inst* \e i1(i1 < L(w) & Sub(w,i1) = x); j proved........

lemma In_expl_conc
  x in y <-> \e z1\e z2 y = z1++(x,z2)
proof 
 ind Ln; y @ 0; v,w
  proved
  weak x in w <-> \e z1\e z2 w = z1++(x,z2)
   split* x = v \/ \e z1\e z2 w = z1++(x,z2) <-> \e z1\e z2 v,w = z1++(x,z2).2,
                                                                             (1,
                                                                              (4,
                                                                               0,
                                                                               0,
                                                                               0),
                                                                              0),
                                                                             0
    weak x = v
     inst* \e z1\e z2 v,w = z1++(v,z2); 0; w proved..
    eigen \e z1\e z2 w = z1++(x,z2); z1,z2
     weak w = z1++(x,z2)
      inst* \e z3\e z4 v,z1++(x,z2) = z3++(x,z4); v,z1; z2 proved...
    eigen \e z1\e z2 v,w = z1++(x,z2); z1,z2
     case Ln; z1 @ 0; v1,w1
      proved
      weak z1 = v1,w1
       weak v = v1
        weak* x = v1
         weak w = w1++(x,z2)
          inst* \e z1\e z3 w1++(x,z2) = z1++(x,z3); w1; z2 proved...........

rem 
  \para \bf  Definition and basic properties of list comparision predicates. 
   \end 

pred/2 Lt 'Tex_p2_ln_lt'
  Lt(a,x) <-> \a b(b in x -> a < b)

thm Lt_zero
  Lt(a,0)
proof 
 exp Lt; a,0 proved..

thm Lt_pair
  Lt(a,v,w) <-> a < v & Lt(a,w)
proof 
 exp Lt; a,w
  exp Lt; a,v,w
   split* \a b(b = v \/ b in w -> a < b) <-> a < v & \a b(b in w -> a < b).2,
                                                                           (1,0,
                                                                            4,0,
                                                                            0,0),
                                                                           1,0,
                                                                           1,
                                                                           (4,0,
                                                                            0,0),
                                                                           0
    inst \a b(b = v \/ b in w -> a < b).1,(4,0,0),0; v proved.
    flatten \a b(b = v \/ b in w -> a < b).1,(4,1,0),0 proved.
    eigen* \a b(b = v -> a < b).0; b proved.
    proved....

thm Lt_mono
  a <= b & Lt(b,x) -> Lt(a,x)
proof 
 exp Lt; a,x
  eigen* \a b1(b1 in x -> a < b1).0; b1
   use Lt.2,0,0:0,2,1,0; b; x; b1 proved....

thm Lt_conc
  Lt(a,x++y) <-> Lt(a,x) & Lt(a,y)
proof 
 ind Ln; x @ 0; v,w
  use Lt_zero; a proved.
  use Lt_pair.0; a; v; w
   use Lt_pair.0; a; v; w++y proved....

rem 
  \para \bf  Definition and basic properties of finite sets.  \end 

pred Set 
  Set(s) <-> \a i\a j(i < j & j < L(s) -> Sub(s,i) < Sub(s,j))

thm Set_zero
  Set(0)
proof 
 exp Set; 0 proved..

thm Set_pair
  Set(a,s) <-> Set(s) & Lt(a,s)
proof 
 exp Lt; a,s
  exp Set; s
   exp Set; a,s
    split* \a j(j <= L(s) -> \a i(i < j -> Sub((a,s),i) < Sub((a,s),j))) <-> 
           \a j(j < L(s) -> \a i(i < j -> Sub(s,i) < Sub(s,j))) & 
           \a b(b in s -> a < b).2,(1,0,4,0,0,0),0
     eigen* \a j(j < L(s) -> \a i(i < j -> Sub(s,i) < Sub(s,j))).0:0,2,1,0; j,
                                                                            i
      inst \a j(j <= L(s) -> \a i(i < j -> Sub((a,s),i) < Sub((a,s),j))):0,2,1,0; j+1; i+1 proved..
     eigen* \a b(b in s -> a < b).0; b
      use In_expl_sub.2,0,0; b; s
       weak b in s
        eigen \e i(i < L(s) & Sub(s,i) = b).0; i
         sym Sub(s,i) = b
          weak b = Sub(s,i)
           inst \a j(j <= L(s) -> \a i(i < j -> Sub((a,s),i) < Sub((a,s),j))):0,
                                                                              2,
                                                                              1,0; i+1; 0 proved.......
     eigen* \a j(j <= L(s) -> \a i(i < j -> Sub((a,s),i) < Sub((a,s),j))).0:0,
                                                                            2,
                                                                            1,0; j,
                                                                                 i
      case N; j @ 0; j1
       proved
       case N; i @ 0; i1
        weak \a j(j < L(s) -> \a i(i < j -> Sub(s,i) < Sub(s,j)))
         weak j = j1+1
          weak i = 0
           inst \a b(b in s -> a < b); Sub(s,j1)
            split Sub(s,j1) in s -> a < Sub(s,j1).2,1,0
             weak \a b(b in s -> a < b)
              weak* a < Sub(s,j1)
               use In_expl_sub.0; Sub(s,j1); s
                weak Sub(s,j1) in s <-> \e i(i < L(s) & Sub(s,i) = Sub(s,j1))
                 inst* \e i(i < L(s) & Sub(s,i) = Sub(s,j1)); j1 proved.....
             proved.....
        inst \a j(j < L(s) -> \a i(i < j -> Sub(s,i) < Sub(s,j))):0,2,1,0; j1; i1 proved.........

thm Set_singleton
  Set(a,0)
proof 
 use Set_pair.0; a; 0
  weak Set(a,0) <-> Set(0) & Lt(a,0)
   use Set_zero
    weak Set(0)
     use Lt_zero; a proved......

thm Set_lt
  Set(a,s) -> Lt(b,a,s) <-> b < a
proof 
 use Set_pair.2,0,1,0,4,1,0; a; s
  weak Set(a,s)
   use Lt_pair.0; b; a; s
    weak Lt(b,a,s) <-> b < a & Lt(b,s)
     cut b < a
      use Lt_mono; b; a; s proved.
      proved......

thm Set_in
  Set(a,s) & b <= a -> b !in s
proof 
 inv* b !in s
  use Set_pair.2,0,1,0,4,1,0; a; s
   use Lt.2,0,0:0,2,1,0; a; s; b proved....

