mod Ex11a logic: 'cl'

incl Mtex

incl Mauxa

loc rem 
  \para \bf  11. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.20 
  \para* \it  Dátum:  \end piatok 11.5.2012 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/1112ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované zoznamom. 
  Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície a vlastnosti 
         pomocných funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Downloadable lecture notes available through the web page of 
         the course. 
   \item \para \it  [2]  \end J. Komara and P. J. Voda. Metamathematics of 
         Computer Programming. 2001. 
  \end

rem 
  \para \bf  Chapter. Programs Operating on Lists.  \end 

rem 
  \para \bf  Section. Sorting of Lists.  \end 

rem 
  \para \bf  [CL] Remark.  \end See the auxiliary module \it  Maux*  \end. 

rem 
  \para \bf  Subsection. Insertion Sort.  \end 

rem 
  \para \bf  Insertion function.  \end 

fun/2 Insert 
  Insert(a,x) = Foo

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Perm(Insert(a,x),a,x)
  \end
  \eq* 
    Ord(x) -> Ord Insert(a,x)
  \end

lemma Lemma_insert_perm
  Perm(i,a,w) -> Perm((v,i),a,v,w)
proof 
 use Perm_cancel_conc_elem.0; 0; v; i; a,0; w proved..

thm Insert_perm
  Perm(Insert(a,x),a,x)

thm Insert_ord
  Ord(x) -> Ord Insert(a,x)

rem 
  \para \bf  Insertion sort.  \end 

fun Isort 
  Isort(x) = Foo

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Perm(Isort(x),x)
  \end
  \eq* 
    Ord Isort(x)
  \end

lemma Lemma_isort_perm
  Perm(iw,w) & Perm(ivw,v,iw) -> Perm(ivw,v,w)
proof 
 use Perm_trans; ivw; v,iw; v,w
  use Perm_pair; iw; w; v proved...

thm Isort_perm
  Perm(Isort(x),x)

thm Isort_ord
  Ord Isort(x)

rem 
  \para \bf  Subsection. Merge Sort.  \end 

rem 
  \para \bf  [CL] Remark.  \end Below we will use the discrimination on whether 
  or not \ft L(x) <= 1 \end. As we have 
  \eq* 
    L(x) <= 1 <-> Tex_f1_pp_proj2(x) = 0
  \end
  \para we may suppose that the test \ft L(x) <= 1 \end takes constant time. 

rem 
  \para \bf  Splitting the list into two halves.  \end 

fun Split 
  Split(x) = Foo <- L(x) <= 1
  Split(x) = Foo <- L(x) > 1

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    \e y\e z Split(x) = y,z
  \end
  \eq* 
    Split(x) = y,z -> Perm(x,y++z)
  \end
  \eq* 
    Split(x) = y,z -> L(y) = L(z) \/ L(y) = L(z)+1
  \end

thm Split_output
  \e y\e z Split(x) = y,z

lemma Lemma_split_perm
  Perm(w,y++z) -> Perm((u,v,w),u,y++(v,z))
proof 
 use Perm_cancel_conc_elem.0; u,0; v; w; u,y; z
  weak Perm((u,v,w),u,y++(v,z)) <-> Perm((u,w),u,y++z)
   use Perm_pair; w; y++z; u proved....

thm Split_perm
  Split(x) = y,z -> Perm(x,y++z)

thm Split_l_half
  Split(x) = y,z -> L(y) = L(z) \/ L(y) = L(z)+1

rem 
  \para \bf  Merging two ordered lists into one.  \end 

fun/2 Merge 
  Merge(x,y) = Foo

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Perm(Merge(x,y),x++y)
  \end
  \eq* 
    Ord(x) & Ord(y) -> Ord Merge(x,y)
  \end

lemma Lemma_merge_perm
  Perm(m,v1,w1++w2) -> Perm((v2,m),v1,w1++(v2,w2))
proof 
 use Perm_cancel_conc_elem.0; 0; v2; m; v1,w1; w2 proved..

thm Merge_perm
  Perm(Merge(x,y),x++y)

thm Merge_ord
  Ord(x) & Ord(y) -> Ord Merge(x,y)

rem 
  \para \bf  Merge sort.  \end 

fun Msort 
  Msort(x) = Foo <- L(x) <= 1
  Msort(x) = Foo <- L(x) > 1

rem 
  \para \bf  Exercise.  \end Prove the condition of regularity for the function 
  \ft Msort(x) \end: 
  \eq* 
    L(x) > 1 & Split(x) = y,z -> L(y) < L(x) & L(z) < L(x)
  \end

thm Condition_of_regularity_for_msort
  L(x) > 1 & Split(x) = y,z -> L(y) < L(x) & L(z) < L(x)
proof  proved.

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Perm(Msort(x),x)
  \end
  \eq* 
    Ord Msort(x)
  \end

lemma Lemma_msort_perm
  Perm(m,y1++z1) & Perm(y1,y) & Perm(z1,z) & Perm(x,y++z) -> Perm(m,x)
proof 
 use Perm_trans; m; y1++z1; x
  use Perm_conc; y1; y; z1; z
   use Perm_trans; y1++z1; y++z; x
    use Perm_sym; x; y++z proved.....

thm Msort_perm
  Perm(Msort(x),x)

thm Msort_ord
  Ord Msort(x)

