mod Ex10 logic: 'cl'

incl Mtex

incl Mtexg

incl Mtexnt

incl Maux

loc rem 
  \para \bf  10. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.20 
  \para* \it  Dátum:  \end utorok 24.4.2012 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/1112ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované symbolickým 
  výrazom. Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície a vlastnosti 
         pomocných funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Downloadable lecture notes available through the web page of 
         the course. 
   \item \para \it  [2]  \end J. Komara and P. J. Voda. Metamathematics of 
         Computer Programming. 2001. 
  \end

rem 
  \para \bf  Chapter. Programs Operating on Symbolic Expressions.  \end 

rem 
  \para \bf  Section. Numeric Terms.  \end 

rem 
  \para \bf  Subsection. Arithmetization of Numeric Terms.  \end 

rem 
  \para \bf  Constructors of numeric terms.  \end 

fun Vt 'Tex_f1_nt_vt'
  Vt(i) = 0,i

fun Ct 'Tex_f1_nt_ct'
  Ct(n) = 1,n

fun/2 At 'Tex_f2_nt_at'
  At(t1,t2) = 2,t1,t2

fun/2 Mt 'Tex_f2_nt_mt'
  Mt(t1,t2) = 3,t1,t2

rem 
  \para \bf  [CL] Discrimination on the constructors of numeric terms.  \end 
  Example(s): 
  \def 
    fun F 'Tex_f1_f'
    F Vt(i) = Foo
    F Ct(n) = Foo
    F At(t1,t2) = Foo
    F Mt(t1,t2) = Foo
  \end

rem 
  \para \bf  Numeric terms.  \end 

pred Term 
  Term Vt(i) <- N(i)
  Term Ct(n) <- N(n)
  Term At(t1,t2) <- Term(t1) & Term(t2)
  Term Mt(t1,t2) <- Term(t1) & Term(t2)

rem 
  \para \bf  [CL] Formatting the output.  \end Use the format \ft Term \end to 
  display numbers as numeric terms. Try out the following simple queries 
  \verbatim 
     98041654 = t:Term
  \end
  \verbatim 
     3,(2,(0,1),1,2),0,3 = t:Term
  \end

rem 
  \para \bf  [CL] Structural case analysis on numeric terms.  \end Syntax: 
  \eq* 
    'case Term ; <term>'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_case Tex_f2_g_x_sc(Term,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_assum Term(t),
                            Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(t,
                                                                           Vt(i)),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(t,
                                                                                             Ct(n)),
                                                                Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_and(Tex_f2_g_eq(t,
                                                                                                                            At(t1,
                                                                                                                               t2)),
                                                                                                                Tex_f2_g_and(Term(t1),
                                                                                                                             Term(t2))),
                                                                                  Tex_f1_g_x_assum Tex_f2_g_and(Tex_f2_g_eq(t,
                                                                                                                            Mt(t1,
                                                                                                                               t2)),
                                                                                                                Tex_f2_g_and(Term(t1),
                                                                                                                             Term(t2)))))))
         \end
         \para where \ft i \end, \ft n \end, \ft t1 \end and \ft t2 \end are new 
         variables \it  (eigen-variables)  \end. 
  \end

rem 
  \para \bf  Structural induction on numeric terms.  \end Show that the 
  principle of structural induction over numeric terms is admissible in Peano 
  arithmetic. 
  \para \it  Remark.  \end Prove the claim for the special case in the following 
  theory. 
  \para \it  [CL] Hint.  \end Reduce structural induction on \ft t \end to 
  course of values induction with measure \ft |t| \end. Recall that the pair 
  size function \ft |x| \end, written as \it  |x|  \end, is defined in the 
  module \it  Standard  \end. 

theory Structural_induction_on_numeric_terms

pred A 'Tex2_g_appl_phi_sb'

axiom Base_case_vt
  A Vt(i)

axiom Base_case_ct
  A Ct(n)

axiom Induction_step_at
  A(t1) & A(t2) -> A At(t1,t2)

axiom Induction_step_mt
  A(t1) & A(t2) -> A Mt(t1,t2)

thm Conclusion
  Term(t) -> A(t)

end theory Structural_induction_on_numeric_terms

rem 
  \para \bf  [CL] Structural induction on numeric terms.  \end 
  \header* fun R 'Tex2_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'ind Term ; <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(Term,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal Tex_f2_g_imp(Term(t),R(t)),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R Vt(i),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_goal R Ct(n),
                                                                Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and(R(t1),
                                                                                                                            R(t2)),
                                                                                                               R At(t1,
                                                                                                                    t2)),
                                                                                  Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and(R(t1),
                                                                                                                            R(t2)),
                                                                                                               R Mt(t1,
                                                                                                                    t2))))))
         \end
         \para where \ft i \end, \ft n \end, \ft t1 \end and \ft t2 \end are new 
         variables \it  (eigen-variables)  \end. 
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(Tex_f2_g_x_sc(Term,t),a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal Tex_f2_g_imp(Term(t),R(t)),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R Vt(i),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_goal R Ct(n),
                                                                Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and(Tex_f2_g_forall(a,
                                                                                                                                            R(t1)),
                                                                                                                            Tex_f2_g_forall(a,
                                                                                                                                            R(t2))),
                                                                                                               R At(t1,
                                                                                                                    t2)),
                                                                                  Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and(Tex_f2_g_forall(a,
                                                                                                                                            R(t1)),
                                                                                                                            Tex_f2_g_forall(a,
                                                                                                                                            R(t2))),
                                                                                                               R Mt(t1,
                                                                                                                    t2))))))
         \end
         \para where \ft i \end, \ft n \end, \ft t1 \end and \ft t2 \end are new 
         variables \it  (eigen-variables)  \end. 
  \end

rem 
  \para \bf  [CL] Structural induction on numeric terms (2nd form).  \end 
  \header* fun R 'Tex2_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'ind* Term ; <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_inds Tex_f2_g_x_sc(Term,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal Tex_f2_g_imp(Term(t),R(t)),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R Vt(i),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_goal R Ct(n),
                                                                Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and3(Tex_f2_g_and3(Term(t1),
                                                                                                                                           R(t1)),
                                                                                                                             Tex_f2_g_and3(Term(t2),
                                                                                                                                           R(t2))),
                                                                                                               R At(t1,
                                                                                                                    t2)),
                                                                                  Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and3(Tex_f2_g_and3(Term(t1),
                                                                                                                                           R(t1)),
                                                                                                                             Tex_f2_g_and3(Term(t2),
                                                                                                                                           R(t2))),
                                                                                                               R Mt(t1,
                                                                                                                    t2))))))
         \end
         \para where \ft i \end, \ft n \end, \ft t1 \end and \ft t2 \end are new 
         variables \it  (eigen-variables)  \end. 
   \item \para \ft Tex_f1_g_x_inds Tex_f2_g_x_sc(Tex_f2_g_x_sc(Term,t),a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal Tex_f2_g_imp(Term(t),R(t)),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R Vt(i),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_goal R Ct(n),
                                                                Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and3(Tex_f2_g_and3(Term(t1),
                                                                                                                                           Tex_f2_g_forall(a,
                                                                                                                                                           R(t1))),
                                                                                                                             Tex_f2_g_and3(Term(t2),
                                                                                                                                           Tex_f2_g_forall(a,
                                                                                                                                                           R(t2)))),
                                                                                                               R At(t1,
                                                                                                                    t2)),
                                                                                  Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and3(Tex_f2_g_and3(Term(t1),
                                                                                                                                           Tex_f2_g_forall(a,
                                                                                                                                                           R(t1))),
                                                                                                                             Tex_f2_g_and3(Term(t2),
                                                                                                                                           Tex_f2_g_forall(a,
                                                                                                                                                           R(t2)))),
                                                                                                               R Mt(t1,
                                                                                                                    t2))))))
         \end
         \para where \ft i \end, \ft n \end, \ft t1 \end and \ft t2 \end are new 
         variables \it  (eigen-variables)  \end. 
  \end

rem 
  \para \bf  Subsection. Basic Operations and Predicates.  \end 

rem 
  \para \bf  Size of numeric terms.  \end 

fun Sz 'Tex_f1_nt_sz'
  Sz Vt(i) = 1
  Sz Ct(n) = 1
  Sz At(t1,t2) = Sz(t1)+Sz(t2)+1
  Sz Mt(t1,t2) = Sz(t1)+Sz(t2)+1

rem 
  \para \bf  Denotation of numeric terms.  \end 

fun/2 Den 'Tex_f2_nt_den'
  Den(t,v) = Foo

rem 
  \para \bf  Free variables.  \end 

fun Fv 'Tex_f1_nt_fv'
  Fv(t) = Foo

rem 
  \para \bf  Coincidence of assignments.  \end 

pred/3 Equiv 'Tex_p3_nt_equiv'
  Equiv(v1,v2,is) <-> \a i(i in is -> Sub(v1,i) = Sub(v2,i))

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Equiv(v1,v2,0)
  \end
  \eq* 
    Equiv(v1,v2,i,is) <-> Sub(v1,i) = Sub(v2,i) & Equiv(v1,v2,is)
  \end
  \para \it  [CL] Hint.  \end Use the pseudo-command \it  open  \end to force 
  opening the explicit definition of the predicates \ft Equiv(v1,v2,is) \end. 

thm Equiv_zero
  Equiv(v1,v2,0)

thm Equiv_pair
  Equiv(v1,v2,i,is) <-> Sub(v1,i) = Sub(v2,i) & Equiv(v1,v2,is)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Term(t) & Equiv(v1,v2,Fv(t)) -> Den(t,v1) = Den(t,v2)
  \end

thm Equiv_den_term
  Term(t) & Equiv(v1,v2,Fv(t)) -> Den(t,v1) = Den(t,v2)
proof  proved.

rem 
  \para \bf  Subsection. Postfix Machine.  \end 

rem 
  \para \bf  Instructions.  \end 

fun Vi 'Tex_f1_nt_vi'
  Vi(i) = 0,i

fun Ci 'Tex_f1_nt_ci'
  Ci(n) = 1,n

fun/0 Ai 'Tex_f0_nt_ai'
  Ai = 2,0

fun/0 Mi 'Tex_f0_nt_mi'
  Mi = 3,0

pred Instr 
  Instr Vi(i) <- N(i)
  Instr Ci(n) <- N(n)
  Instr(Ai)
  Instr(Mi)

rem 
  \para \bf  Programs.  \end 

pred Program 
  Program(p) <-> Poo

rem 
  \para \bf  Compilation.  \end 

fun Cmp 
  Cmp(t) = Foo

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Term(t) -> Program Cmp(t)
  \end

thm Cmp_program
  Term(t) -> Program Cmp(t)

rem 
  \para \bf  One-step evaluation.  \end 

fun/3 Run 
  Run(p,v,s) = Foo

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Term(t) -> Den(t,v) = Run(Cmp(t),v,0)
  \end

lemma Invariant_run
  Term(t) -> Run(Cmp(t)++p,v,s) = Run(p,v,Den(t,v),s)
proof  proved.

thm Den_run
  Term(t) -> Den(t,v) = Run(Cmp(t),v,0)
proof  proved.

rem 
  \para \bf  Subsection. Additional Problems.  \end 

rem 
  \para \bf  Terms with left associated addition.  \end 

pred Lassoc 
  Lassoc Vt(i)
  Lassoc Ct(n)
  Lassoc At(t,Vt(i)) <- Lassoc(t)
  Lassoc At(t,Ct(n)) <- Lassoc(t)
  Lassoc At(t,Mt(t1,t2)) <- Lassoc(t)
  Lassoc Mt(t1,t2)

rem 
  \para \bf  Rearranging terms into expressions with left associated addition. 
   \end 

fun T2l 'Tex_f1_f'
  T2l(t) = Foo

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Term(t) -> Term T2l(t)
  \end
  \eq* 
    Term(t) -> Lassoc T2l(t)
  \end
  \eq* 
    Term(t) -> Den(T2l(t),v) = Den(t,v)
  \end
  \eq* 
    Term(t) -> Sz T2l(t) = Sz(t)
  \end

thm T2l_term
  Term(t) -> Term T2l(t)

thm T2l_lassoc
  Term(t) -> Lassoc T2l(t)

thm T2l_den
  Term(t) -> Den(T2l(t),v) = Den(t,v)
proof  proved.

thm T2l_sz
  Term(t) -> Sz T2l(t) = Sz(t)

loc rem 
  ******************************************************************************
  ********************************* DEBUGGING **********************************
  ******************************************************************************

loc rem 
  \para Rearranging terms into expressions with left associated addition. 

loc fun/0 T1 
  T1 = At(Vt(1),At(Vt(2),Vt(3)))

loc fun/0 T2 
  T2 = At(At(Vt(1),Vt(2)),At(Vt(3),Vt(4)))

loc fun/0 T3 
  T3 = 
  At(At(Vt(1),At(Vt(2),At(Vt(3),Vt(4)))),At(Vt(5),At(Vt(6),At(Vt(7),Vt(8)))))

