mod Mauxb logic: 'cl'

incl Mtex

rem 
  \para \bf  Exponentiation of two.  \end 

fun Exp2 'Tex_f1_n_exp2'
  Exp2(0) = 1
  Exp2(x+1) = 2*Exp2(x)

thm Exp2_is_not_zero
  Exp2(x) != 0
proof 
 ind N; x @ 0; x
  proved
  proved..

thm Exp2_is_one
  Exp2(x) = 1 <-> x = 0
proof 
 case N; x @ 0; x1
  proved
  proved..

thm Exp2_gt_one
  Exp2(x) > 1 <-> x != 0
proof 
 case Trich; Exp2(x),1 @ x1,y; x1,y; x1,y
  use Exp2_is_not_zero; x proved.
  use Exp2_is_one.0; x proved.
  use Exp2_is_one.0; x proved...

thm Exp2_plus
  Exp2(x+y) = Exp2(x)*Exp2(y)
proof 
 ind N; x @ 0; x
  proved
  proved..

thm Exp2_minus
  x >= y -> Exp2(x-y) = Exp2(x)/Exp2(y)
proof 
 ind N; x; y @ 0; x
  proved
  case N; y @ 0; y1
   proved
   inst \a y(x >= y -> Exp2(x-y) = Exp2(x)/Exp2(y)); y1 proved....

thm Exp2_cancel_eq
  Exp2(x) = Exp2(y) <-> x = y
proof 
 ind N; x; y @ 0; x
  use Exp2_is_one.0; y proved.
  case N; y @ 0; y1
   proved
   inst \a y(Exp2(x) = Exp2(y) <-> x = y).0; y1 proved....

thm Exp2_cancel_le
  Exp2(x) <= Exp2(y) <-> x <= y
proof 
 ind N; x; y @ 0; x
  use Exp2_is_not_zero; y proved.
  case N; y @ 0; y1
   use Exp2_is_not_zero; x proved.
   inst \a y(Exp2(x) <= Exp2(y) <-> x <= y).0; y1 proved....

thm Exp2_cancel_lt
  Exp2(x) < Exp2(y) <-> x < y
proof 
 ind N; x; y @ 0; x
  use Exp2_gt_one.0; y proved.
  case N; y @ 0; y1
   use Exp2_is_not_zero; x proved.
   inst \a y(Exp2(x) < Exp2(y) <-> x < y).0; y1 proved....

