mod Ex06a logic: 'cl'

incl Mtex

incl Mauxa

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.20 
  \para* \it  Dátum:  \end utorok 20.3.2012 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/1112ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované 
  celočíselnej odmocnine a slovným úlohám. Zadanie sa skladá z týchto 
  súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície a vlastnosti 
         pomocných funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Downloadable lecture notes available through the web page of 
         the course. 
   \item \para \it  [2]  \end J. Komara and P. J. Voda. Metamathematics of 
         Computer Programming. 2001. 
  \end

rem 
  \para \bf  [CL] CL-TeX.  \end 

appldisp/2 Tex_f2_char_nef
  Infix(Arg(0),24,0,Subsup(Op('',Ent('NotEqual'),0),75,Op('*',0),None),Arg(1))

rem 
  \para \bf  [CL] Remark.  \end Note that the square function 
  \def 
    fun Sq 'Tex_f1_n_sq'
    Sq(x) = x*x
  \end
  \para is defined in the included module \it  Standard  \end. 

rem 
  \para \bf  Section. Case Study: Integer Square Root.  \end 

rem 
  \para \bf  Specification.  \end 
  \eq* 
    Sq Tex_f1_n_sqrt(x) <= x & x < Sq(Tex_f1_n_sqrt(x)+1)
  \end

rem 
  \para \bf  Top-down program by primitive recursion.  \end 

fun Sqrt1 'Tex_f1_n_sqrt'
  Sqrt1(0) = 0
  Sqrt1(x+1) = Sqrt1(x) <- x+1 < Sq(Sqrt1(x)+1)
  Sqrt1(x+1) = Sqrt1(x)+1 <- x+1 >= Sq(Sqrt1(x)+1)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Sq Sqrt1(x) <= x & x < Sq(Sqrt1(x)+1)
  \end

thm Spec_sqrt1
  Sq Sqrt1(x) <= x & x < Sq(Sqrt1(x)+1)

rem 
  \para \bf  Top-down program with assignment.  \end 

fun Sqrt2 'Tex_f1_n_sqrt'
  Sqrt2(0) = 0
  Sqrt2(x+1) = y <- Sqrt2(x) = y & x+1 < Sq(y+1)
  Sqrt2(x+1) = y+1 <- Sqrt2(x) = y & x+1 >= Sq(y+1)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Sq Sqrt2(x) <= x & x < Sq(Sqrt2(x)+1)
  \end

thm Spec_sqrt2
  Sq Sqrt2(x) <= x & x < Sq(Sqrt2(x)+1)

rem 
  \para \bf  Bottom-up program by backward recursion.  \end 

fun/2 F3 'Tex_f2_f'
  F3(x,y) = y <- x < Sq(y+1)
  F3(x,y) = F3(x,y+1) <- x >= Sq(y+1)

fun Sqrt3 'Tex_f1_n_sqrt'
  Sqrt3(x) = F3(x,0)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Sq Sqrt3(x) <= x & x < Sq(Sqrt3(x)+1)
  \end

thm Spec_sqrt3
  Sq Sqrt3(x) <= x & x < Sq(Sqrt3(x)+1)

rem 
  \para \bf  Bottom-up program with accumulator.  \end 

fun/3 F4 'Tex_f3_f'
  F4(x,y,s) = y <- s+2*y+1 = s1 & x < s1
  F4(x,y,s) = F4(x,y+1,s1) <- s+2*y+1 = s1 & x >= s1

fun Sqrt4 'Tex_f1_n_sqrt'
  Sqrt4(x) = F4(x,0,0)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Sq Sqrt4(x) <= x & x < Sq(Sqrt4(x)+1)
  \end

thm Spec_sqrt4
  Sq Sqrt4(x) <= x & x < Sq(Sqrt4(x)+1)

rem 
  \para \bf  Fast program by recursion on notation.  \end 

fun/2 Nef 'Tex_f2_char_nef'
  Nef(x,y) = 1 <- x != y
  Nef(x,y) = 0 <- x = y

fun Sqrt5 'Tex_f1_n_sqrt'
  Sqrt5(x) = Nef(z,0) <- x = 4*y+z & 0 <= z & z <= 3 & y = 0
  Sqrt5(x) = r <- 
    x = 4*y+z & 0 <= z & z <= 3 & y != 0 & 2*Sqrt5(y) = r & x < Sq(r+1)
  Sqrt5(x) = r+1 <- 
    x = 4*y+z & 0 <= z & z <= 3 & y != 0 & 2*Sqrt5(y) = r & x >= Sq(r+1)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Sq Sqrt5(x) <= x & x < Sq(Sqrt5(x)+1)
  \end
  \para \it  [CL] Hint.  \end Prove the property by complete induction. In the 
  induction step, start by using the following theorem 
  \eq Pary_case_analysis4
    \e y\e z(x = 4*y+z & z < 4)
  \end
  \para from the module \it  Maux*  \end. 

thm Spec_sqrt5
  Sq Sqrt5(x) <= x & x < Sq(Sqrt5(x)+1)

