mod Mlogicq

incl Mtexg

rem 
  \para \bf  Quantifier Tableaux.  \end 

rem 
  \para \bf  Formulas.  \end Syntax: 
  \items 
   \item \para Atomic formulas: \ft x = y \end, \ft R(x) \end. 
   \item \para Propositional connectives: \ft \t \end, \ft \f \end, \ft ~R \end. 
         \ft R & Q \end, \ft R \/ Q \end, \ft R -> Q \end, \ft R <-> Q \end. 
   \item \para Quantifiers: \ft \e yR \end, \ft \a yR \end. 
   \item \para Notational conventions: \ft x != y \end. 
  \end

rem 
  \para \bf  Tableau closure rules.  \end Syntax: 
  \eq* 
    'close [*] (<assumption> | <goal*>)'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_closeg(Tex_f0_g_tc) \end 
   \item \para \ft Tex_f1_g_x_close(Tex_f0_g_fc) \end 
   \item \para \ft Tex_f1_g_x_closeg(R) \end 
  \end

rem 
  \para \bf  Tableau expansion rules.  \end 
  \items 
   \item \para \it  Tableau 'flatten' rules.  \end Syntax: 
         \eq* 
           'flatten [*] (<assumption> | <goal*>)'
         \end
         \para Example(s): 
         \items 
          \item \para \ft Tex_f1_g_x_flatten Tex_f2_g_and(R,Q) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_assum Tex_f2_g_and(R,Q),R,
                                    Tex_f1_g_x_assum Tex2_sub(Tex_f0_g_and,1)),
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_assum Tex_f2_g_and(R,Q),Q,
                                    Tex_f1_g_x_assum Tex2_sub(Tex_f0_g_and,2))
                \end
          \item \para \ft Tex_f1_g_x_flatteng Tex_f2_g_or(R,Q) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_goal Tex_f2_g_or(R,Q),
                                    Tex_f1_g_x_goal(R),
                                    Tex_f1_g_x_goal Tex2_sub(Tex_f0_g_or,1)),
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_goal Tex_f2_g_or(R,Q),
                                    Tex_f1_g_x_goal(Q),
                                    Tex_f1_g_x_goal Tex2_sub(Tex_f0_g_or,2))
                \end
          \item \para \ft Tex_f1_g_x_flatteng Tex_f2_g_imp(R,Q) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_goal Tex_f2_g_imp(R,Q),R,
                                    Tex_f1_g_x_goal Tex2_sub(Tex_f0_g_imp,1)),
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_goal Tex_f2_g_imp(R,Q),
                                    Tex_f1_g_x_goal(Q),
                                    Tex_f1_g_x_goal Tex2_sub(Tex_f0_g_imp,2))
                \end
          \item \para \ft Tex_f1_g_x_flatten Tex_f2_g_iff(R,Q) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_assum Tex_f2_g_iff(R,Q),
                                    Tex_f2_g_imp(R,Q),
                                    Tex_f1_g_x_assum Tex2_sub(Tex_f0_g_iff,1)),
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_assum Tex_f2_g_iff(R,Q),
                                    Tex_f2_g_imp(Q,R),
                                    Tex_f1_g_x_assum Tex2_sub(Tex_f0_g_iff,2))
                \end
         \end
   \item \para \it  Tableau 'split' rules.  \end Syntax: 
         \eq* 
           'split [*] (<assumption> | <goal*>)'
         \end
         \para Example(s): 
         \items 
          \item \para \ft Tex_f1_g_x_splitg Tex_f2_g_and(R,Q) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_goal Tex_f2_g_and(R,Q),
                                    Tex_f2_g_x_branch(Tex_f1_g_x_goal(R),
                                                      Tex_f1_g_x_goal(Q)),
                                    Tex_f1_g_x_goal(Tex_f0_g_and))
                \end
          \item \para \ft Tex_f1_g_x_split Tex_f2_g_or(R,Q) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f2_g_or(R,Q),Tex_f2_g_x_branch(R,Q),
                                    Tex_f1_g_x_assum(Tex_f0_g_or))
                \end
          \item \para \ft Tex_f1_g_x_split Tex_f2_g_imp(R,Q) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f2_g_imp(R,Q),
                                    Tex_f2_g_x_branch(Tex_f1_g_x_goal(R),Q),
                                    Tex_f1_g_x_assum(Tex_f0_g_imp))
                \end
          \item \para \ft Tex_f1_g_x_splitg Tex_f2_g_iff(R,Q) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_goal Tex_f2_g_iff(R,Q),
                                    Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(R,
                                                                                   Q),
                                                      Tex_f1_g_x_goal Tex_f2_g_imp(Q,
                                                                                   R)),
                                    Tex_f1_g_x_goal(Tex_f0_g_iff))
                \end
         \end
   \item \para \it  Tableau inversion rules.  \end Syntax: 
         \eq* 
           'inv [*] (<assumption> | <goal*>)'
         \end
         \para Example(s): 
         \items 
          \item \para \ft Tex_f1_g_x_inv Tex_f1_g_not(R) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_assum Tex_f1_g_not(R),
                                    Tex_f1_g_x_goal(R),
                                    Tex_f1_g_x_assum(Tex_f0_g_not))
                \end
          \item \para \ft Tex_f1_g_x_invg Tex_f1_g_not(R) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_goal Tex_f1_g_not(R),
                                    Tex_f1_g_x_assum(R),
                                    Tex_f1_g_x_goal(Tex_f0_g_not))
                \end
         \end
   \item \para \it  Tableaux quantifier 'instantiation' rules.  \end Syntax: 
         \eq* 
           'inst [*] (<assumption> | <goal*>) ; <term>'
         \end
         \para Example(s): 
         \items 
          \item \para 
                \ft Tex_f1_g_x_inst Tex_f2_g_x_sc(Tex_f2_g_forall(x,R(x)),t) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_assum Tex_f2_g_forall(x,R(x)),
                                    Tex_f1_g_x_assum R(t),
                                    Tex_f1_g_x_assum(Tex_f0_g_forall))
                \end
          \item \para 
                \ft Tex_f1_g_x_instg Tex_f2_g_x_sc(Tex_f2_g_exists(x,R(x)),t) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_goal Tex_f2_g_exists(x,R(x)),
                                    Tex_f1_g_x_goal R(t),
                                    Tex_f1_g_x_goal(Tex_f0_g_exists))
                \end
         \end
   \item \para \it  Tableaux quantifier 'eigen-variable' rules.  \end Syntax: 
         \eq* 
           'eigen [*] (<assumption> | <goal*>) ; <eigen-variable>'
         \end
         \para Example(s): 
         \items 
          \item \para 
                \ft Tex_f1_g_x_eigeng Tex_f2_g_x_sc(Tex_f2_g_forall(x,R(x)),a) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_goal Tex_f2_g_forall(x,R(x)),
                                    Tex_f1_g_x_goal R(a),
                                    Tex_f1_g_x_goal(Tex_f0_g_forall))
                \end
                \para where \ft a \end is a new variable \it  (eigen-variable) 
                 \end 
          \item \para 
                \ft Tex_f1_g_x_eigen Tex_f2_g_x_sc(Tex_f2_g_exists(x,R(x)),a) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f1_g_x_assum Tex_f2_g_exists(x,R(x)),
                                    Tex_f1_g_x_assum R(a),
                                    Tex_f1_g_x_assum(Tex_f0_g_exists))
                \end
                \para where \ft a \end is a new variable \it  (eigen-variable) 
                 \end 
         \end
   \item \para \it  Tableau axiom rules.  \end Syntax: 
         \eq* 
           'use <axiom>'
         \end
         \para Example(s): 
         \items 
          \item \para \ft Tex_f1_g_x_use(R) \end 
                \eq* 
                  Tex_f3_g_x_nrule2(Tex_f0_g_x_nothing,Tex_f1_g_x_assum(R),
                                    Tex_p2_set_member(R,T))
                \end
                \para where \ft R \end is one of the axioms. 
         \end
  \end

rem 
  \para \bf  Tableau structural rules.  \end 
  \items 
   \item \para \it  Weakening.  \end Syntax: 
         \eq* 
           'weak [*] (<assumption> | <goal*>)'
         \end
         \para Example(s): 
         \items 
          \item \para \ft Tex_f1_g_x_weak(R) \end 
          \item \para \ft Tex_f1_g_x_weakg(R) \end 
         \end
  \end

